/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.NumberValue;

public interface MonetaryAmountFactory<T extends MonetaryAmount> {
    public Class<? extends MonetaryAmount> getAmountType();

    default public MonetaryAmountFactory<T> setCurrency(String currencyCode) {
        return this.setCurrency(Monetary.getCurrency(currencyCode, new String[0]));
    }

    public MonetaryAmountFactory<T> setCurrency(CurrencyUnit var1);

    public MonetaryAmountFactory<T> setNumber(double var1);

    public MonetaryAmountFactory<T> setNumber(long var1);

    public MonetaryAmountFactory<T> setNumber(Number var1);

    public NumberValue getMaxNumber();

    public NumberValue getMinNumber();

    public MonetaryAmountFactory<T> setContext(MonetaryContext var1);

    default public MonetaryAmountFactory<T> setAmount(MonetaryAmount amount) {
        this.setCurrency(amount.getCurrency());
        this.setNumber(amount.getNumber());
        this.setContext(amount.getContext());
        return this;
    }

    public T create();

    public MonetaryContext getDefaultMonetaryContext();

    default public MonetaryContext getMaximalMonetaryContext() {
        return this.getDefaultMonetaryContext();
    }
}

