/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.scp.ScpSourceStreamResolver;
import org.apache.sshd.common.scp.ScpTargetStreamResolver;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.io.DirectoryScanner;
import org.apache.sshd.common.util.io.IoUtils;

public interface ScpFileOpener {
    public static final String PROP_AUTO_SYNC_FILE_ON_WRITE = "scp-auto-sync-on-write";
    public static final boolean DEFAULT_AUTO_SYNC_FILE_ON_WRITE = true;

    default public Path resolveIncomingFilePath(Session session, Path localPath, String name, boolean preserve, Set<PosixFilePermission> permissions, ScpTimestamp time) throws IOException {
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        Boolean status = IoUtils.checkFileExists((Path)localPath, (LinkOption[])options);
        if (status == null) {
            throw new AccessDeniedException("Receive directory existence status cannot be determined: " + localPath);
        }
        Path file = null;
        if (status.booleanValue() && Files.isDirectory(localPath, options)) {
            String localName = name.replace('/', File.separatorChar);
            file = localPath.resolve(localName);
        } else if (!status.booleanValue()) {
            Path parent = localPath.getParent();
            status = IoUtils.checkFileExists((Path)parent, (LinkOption[])options);
            if (status == null) {
                throw new AccessDeniedException("Receive directory parent (" + parent + ") existence status cannot be determined for " + localPath);
            }
            if (status.booleanValue() && Files.isDirectory(parent, options)) {
                file = localPath;
            }
        }
        if (file == null) {
            throw new IOException("Cannot write to " + localPath);
        }
        status = IoUtils.checkFileExists(file, (LinkOption[])options);
        if (status == null) {
            throw new AccessDeniedException("Receive directory file existence status cannot be determined: " + file);
        }
        if (!status.booleanValue() || !Files.isDirectory(file, options)) {
            Files.createDirectory(file, new FileAttribute[0]);
        }
        if (preserve) {
            ScpFileOpener.updateFileProperties(file, permissions, time);
        }
        return file;
    }

    default public Iterable<Path> getMatchingFilesToSend(Session session, Path basedir, String pattern) throws IOException {
        DirectoryScanner ds = new DirectoryScanner(basedir, new String[]{pattern});
        return ds.scan();
    }

    default public boolean sendAsRegularFile(Session session, Path path, LinkOption ... options) throws IOException {
        return Files.isRegularFile(path, options);
    }

    default public boolean sendAsDirectory(Session session, Path path, LinkOption ... options) throws IOException {
        return Files.isDirectory(path, options);
    }

    default public DirectoryStream<Path> getLocalFolderChildren(Session session, Path path) throws IOException {
        return Files.newDirectoryStream(path);
    }

    default public BasicFileAttributes getLocalBasicFileAttributes(Session session, Path path, LinkOption ... options) throws IOException {
        BasicFileAttributeView view = Files.getFileAttributeView(path, BasicFileAttributeView.class, options);
        return view.readAttributes();
    }

    default public Set<PosixFilePermission> getLocalFilePermissions(Session session, Path path, LinkOption ... options) throws IOException {
        return IoUtils.getPermissions((Path)path, (LinkOption[])options);
    }

    default public Path resolveLocalPath(Session session, FileSystem fileSystem, String commandPath) throws IOException, InvalidPathException {
        String path = SelectorUtils.translateToLocalFileSystemPath((String)commandPath, (char)File.separatorChar, (FileSystem)fileSystem);
        Path lcl = fileSystem.getPath(path, new String[0]);
        Path abs = lcl.isAbsolute() ? lcl : lcl.toAbsolutePath();
        return abs.normalize();
    }

    default public Path resolveIncomingReceiveLocation(Session session, Path path, boolean recursive, boolean shouldBeDir, boolean preserve) throws IOException {
        if (!shouldBeDir) {
            return path;
        }
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        Boolean status = IoUtils.checkFileExists((Path)path, (LinkOption[])options);
        if (status == null) {
            throw new SshException("Target directory " + path + " is most like inaccessible");
        }
        if (!status.booleanValue()) {
            throw new SshException("Target directory " + path + " does not exist");
        }
        if (!Files.isDirectory(path, options)) {
            throw new SshException("Target directory " + path + " is not a directory");
        }
        return path;
    }

    default public Path resolveOutgoingFilePath(Session session, Path localPath, LinkOption ... options) throws IOException {
        Boolean status = IoUtils.checkFileExists((Path)localPath, (LinkOption[])options);
        if (status == null) {
            throw new AccessDeniedException("Send file existence status cannot be determined: " + localPath);
        }
        if (!status.booleanValue()) {
            throw new IOException(localPath + ": no such file or directory");
        }
        return localPath;
    }

    public InputStream openRead(Session var1, Path var2, long var3, Set<PosixFilePermission> var5, OpenOption ... var6) throws IOException;

    default public void closeRead(Session session, Path file, long size, Set<PosixFilePermission> permissions, InputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public ScpSourceStreamResolver createScpSourceStreamResolver(Session var1, Path var2) throws IOException;

    public OutputStream openWrite(Session var1, Path var2, long var3, Set<PosixFilePermission> var5, OpenOption ... var6) throws IOException;

    default public void closeWrite(Session session, Path file, long size, Set<PosixFilePermission> permissions, OutputStream os) throws IOException {
        if (os != null) {
            os.close();
        }
    }

    public ScpTargetStreamResolver createScpTargetStreamResolver(Session var1, Path var2) throws IOException;

    public static void updateFileProperties(Path file, Set<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        IoUtils.setPermissions((Path)file, perms);
        if (time != null) {
            BasicFileAttributeView view = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]);
            FileTime lastModified = FileTime.from(time.getLastModifiedTime(), TimeUnit.MILLISECONDS);
            FileTime lastAccess = FileTime.from(time.getLastAccessTime(), TimeUnit.MILLISECONDS);
            view.setTimes(lastModified, lastAccess, null);
        }
    }
}

