/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import javax.transaction.TransactionManager;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.transaction.ComponentTxData;
import org.apache.aries.transaction.TxInterceptorImpl;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationProcessor
implements BeanProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationProcessor.class);
    private final ComponentDefinitionRegistry cdr;
    private TransactionManager tm;
    private Coordinator coordinator;

    public AnnotationProcessor(ComponentDefinitionRegistry cdr, TransactionManager tm, Coordinator coordinator) {
        this.cdr = cdr;
        this.tm = tm;
        this.coordinator = coordinator;
    }

    public void beforeDestroy(Object arg0, String arg1) {
    }

    public void afterDestroy(Object arg0, String arg1) {
    }

    public Object beforeInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanData) {
        ComponentTxData txData = new ComponentTxData(bean.getClass());
        if (txData.isTransactional()) {
            LOGGER.debug("Adding transaction interceptor to bean {} with class {}.", (Object)beanName, bean.getClass());
            this.cdr.registerInterceptorWithComponent((ComponentMetadata)beanData, (Interceptor)new TxInterceptorImpl(this.tm, this.coordinator, txData));
        }
        return bean;
    }

    public Object afterInit(Object arg0, String arg1, BeanProcessor.BeanCreator arg2, BeanMetadata arg3) {
        return arg0;
    }
}

