/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public interface SftpSubsystemEnvironment
extends SessionHolder<ServerSession>,
ServerSessionHolder {
    public static final String SFTP_VERSION = "sftp-version";
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 6;
    public static final List<Integer> SUPPORTED_SFTP_VERSIONS = Collections.unmodifiableList(IntStream.rangeClosed(3, 6).boxed().collect(Collectors.toList()));
    public static final String ALL_SFTP_IMPL = GenericUtils.join(SUPPORTED_SFTP_VERSIONS, (char)',');

    default public ServerSession getSession() {
        return this.getServerSession();
    }

    public int getVersion();

    public SftpFileSystemAccessor getFileSystemAccessor();

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy();

    public Path getDefaultDirectory();
}

