/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.segments.DependentMetadata;
import org.apache.unomi.api.services.SegmentService;

@Command(scope="unomi", name="segment-remove", description="Remove segments in the Apache Unomi Context Server")
@Service
public class SegmentRemove
implements Action {
    @Reference
    SegmentService segmentService;
    @Argument(index=0, name="segmentId", description="The identifier for the segment", required=true, multiValued=false)
    String segmentIdentifier;
    @Argument(index=1, name="validate", description="Check if the segment is used in goals or other segments", required=false, multiValued=false)
    Boolean validate = true;

    public Object execute() throws Exception {
        DependentMetadata dependantMetadata = this.segmentService.removeSegmentDefinition(this.segmentIdentifier, this.validate.booleanValue());
        if (!this.validate.booleanValue() || dependantMetadata.getSegments().isEmpty() && dependantMetadata.getScorings().isEmpty()) {
            System.out.println("Segment " + this.segmentIdentifier + " successfully deleted");
        } else if (this.validate.booleanValue()) {
            System.out.print("Segment " + this.segmentIdentifier + " could not be deleted because of the following dependents:");
            if (!dependantMetadata.getScorings().isEmpty()) {
                System.out.print(" scoring:" + dependantMetadata.getScorings());
            }
            if (!dependantMetadata.getSegments().isEmpty()) {
                System.out.println(" segments:" + dependantMetadata.getSegments());
            }
        }
        return null;
    }
}

