/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.xcontent.XContentParser;

public class GlobalOperationPrivilege {
    private final String category;
    private final String operation;
    private final Map<String, Object> privilege;

    public GlobalOperationPrivilege(String category, String operation, Map<String, Object> privilege) {
        this.category = Objects.requireNonNull(category);
        this.operation = Objects.requireNonNull(operation);
        if (privilege == null || privilege.isEmpty()) {
            throw new IllegalArgumentException("privileges cannot be empty or null");
        }
        this.privilege = Collections.unmodifiableMap(privilege);
    }

    public String getCategory() {
        return this.category;
    }

    public String getOperation() {
        return this.operation;
    }

    public Map<String, Object> getRaw() {
        return this.privilege;
    }

    public static GlobalOperationPrivilege fromXContent(String category, String operation, XContentParser parser) throws IOException {
        assert (parser.currentToken().equals((Object)XContentParser.Token.FIELD_NAME));
        parser.nextToken();
        return new GlobalOperationPrivilege(category, operation, parser.map());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalOperationPrivilege)) {
            return false;
        }
        GlobalOperationPrivilege that = (GlobalOperationPrivilege)o;
        return this.category.equals(that.category) && this.operation.equals(that.operation) && this.privilege.equals(that.privilege);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.operation, this.privilege);
    }
}

