/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.SetPropertyProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,transformation")
@XmlRootElement(name="setProperty")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SetPropertyDefinition
extends NoOutputExpressionNode {
    @XmlAttribute(required=true)
    private String propertyName;

    public SetPropertyDefinition() {
    }

    public SetPropertyDefinition(String propertyName, ExpressionDefinition expression) {
        super(expression);
        this.setPropertyName(propertyName);
    }

    public SetPropertyDefinition(String propertyName, Expression expression) {
        super(expression);
        this.setPropertyName(propertyName);
    }

    public SetPropertyDefinition(String propertyName, String value) {
        super(ExpressionBuilder.constantExpression(value));
        this.setPropertyName(propertyName);
    }

    public String toString() {
        return "SetProperty[" + this.getPropertyName() + ", " + this.getExpression() + "]";
    }

    @Override
    public String getLabel() {
        return "setProperty[" + this.getPropertyName() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull(this.getPropertyName(), "propertyName", this);
        Expression expr = this.getExpression().createExpression(routeContext);
        Expression nameExpr = ExpressionBuilder.parseSimpleOrFallbackToConstantExpression(this.getPropertyName(), routeContext.getCamelContext());
        return new SetPropertyProcessor(nameExpr, expr);
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

