/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;

public interface MonetaryConversionsSingletonSpi {
    public Collection<String> getProviderNames();

    public List<String> getDefaultProviderChain();

    public ExchangeRateProvider getExchangeRateProvider(ConversionQuery var1);

    default public boolean isExchangeRateProviderAvailable(ConversionQuery conversionQuery) {
        try {
            return this.getExchangeRateProvider(conversionQuery) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean isConversionAvailable(ConversionQuery conversionQuery) {
        try {
            return this.getConversion(conversionQuery) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean isConversionAvailable(CurrencyUnit termCurrency, String ... providers) {
        return this.isConversionAvailable(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(providers)).build());
    }

    default public List<ExchangeRateProvider> getExchangeRateProviders(String ... providers) {
        ArrayList<ExchangeRateProvider> provInstances = new ArrayList<ExchangeRateProvider>();
        Collection<String> providerNames = Arrays.asList(providers);
        if (providerNames.isEmpty()) {
            providerNames = this.getProviderNames();
        }
        for (String provName : providerNames) {
            provInstances.add(Optional.ofNullable(this.getExchangeRateProvider(provName)).orElseThrow(() -> new MonetaryException("Unsupported conversion/rate provider: " + provName)));
        }
        return provInstances;
    }

    default public ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        return this.getExchangeRateProvider(((ConversionQueryBuilder)ConversionQueryBuilder.of().setProviderNames(providers)).build());
    }

    default public CurrencyConversion getConversion(ConversionQuery conversionQuery) {
        return this.getExchangeRateProvider(conversionQuery).getCurrencyConversion(Objects.requireNonNull(conversionQuery.getCurrency(), "Terminating Currency is required."));
    }

    default public CurrencyConversion getConversion(CurrencyUnit termCurrency, String ... providers) {
        return this.getConversion(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(providers)).build());
    }
}

