/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.utils.json.JSONParser;
import org.apache.felix.utils.repository.BaseRepository;
import org.apache.felix.utils.repository.UrlLoader;
import org.apache.felix.utils.resource.ResourceBuilder;
import org.apache.felix.utils.resource.ResourceImpl;
import org.osgi.framework.BundleException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class JsonRepository
extends BaseRepository {
    private final UrlLoader loader;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public JsonRepository(String url, long expiration) {
        this.loader = new UrlLoader(url, expiration){

            @Override
            protected boolean doRead(InputStream is) throws IOException {
                return JsonRepository.this.doRead(is);
            }
        };
    }

    @Override
    public List<Resource> getResources() {
        this.checkAndLoadCache();
        this.lock.readLock().lock();
        try {
            List<Resource> list = super.getResources();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        this.checkAndLoadCache();
        this.lock.readLock().lock();
        try {
            Map<Requirement, Collection<Capability>> map = super.findProviders(requirements);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void checkAndLoadCache() {
        this.loader.checkAndLoadCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRead(InputStream is) throws IOException {
        Map<String, Map<String, String>> metadatas = this.verify(new JSONParser(is).getParsed());
        this.lock.writeLock().lock();
        try {
            this.resources.clear();
            this.capSets.clear();
            for (Map.Entry<String, Map<String, String>> metadata : metadatas.entrySet()) {
                this.buildResource(metadata.getKey(), metadata.getValue());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void buildResource(String uri, Map<String, String> headerMap) throws IOException {
        try {
            ResourceImpl resource = ResourceBuilder.build(uri, headerMap);
            this.addResource(resource);
        }
        catch (BundleException e) {
            throw new IOException("Unable to read resource: " + uri, e);
        }
    }

    private Map<String, Map<String, String>> verify(Object value) {
        Map obj = (Map)Map.class.cast(value);
        for (Map.Entry entry : obj.entrySet()) {
            String.class.cast(entry.getKey());
            Map child = (Map)Map.class.cast(entry.getValue());
            for (Map.Entry ce : child.entrySet()) {
                String.class.cast(ce.getKey());
                String.class.cast(ce.getValue());
            }
        }
        return obj;
    }
}

