/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;

public class ConditionBuilder {
    private DefinitionsService definitionsService;

    public ConditionBuilder(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public CompoundCondition and(ConditionItem condition1, ConditionItem condition2) {
        return new CompoundCondition(condition1, condition2, "and");
    }

    public NotCondition not(ConditionItem subCondition) {
        return new NotCondition(subCondition);
    }

    public CompoundCondition or(ConditionItem condition1, ConditionItem condition2) {
        return new CompoundCondition(condition1, condition2, "or");
    }

    public NestedCondition nested(ConditionItem subCondition, String path) {
        return new NestedCondition(subCondition, path);
    }

    public PropertyCondition profileProperty(String propertyName) {
        return new PropertyCondition("profilePropertyCondition", propertyName, this.definitionsService);
    }

    public PropertyCondition property(String conditionTypeId, String propertyName) {
        return new PropertyCondition(conditionTypeId, propertyName, this.definitionsService);
    }

    public ConditionItem condition(String conditionTypeId) {
        return new ConditionItem(conditionTypeId, this.definitionsService);
    }

    public class PropertyCondition
    extends ComparisonCondition {
        PropertyCondition(String conditionTypeId, String propertyName, DefinitionsService definitionsService) {
            super(conditionTypeId, definitionsService);
            this.condition.setParameter("propertyName", propertyName);
        }
    }

    public class NotCondition
    extends ConditionItem {
        NotCondition(ConditionItem subCondition) {
            super("notCondition", subCondition.definitionsService);
            this.parameter("subCondition", (Object)subCondition.build());
        }
    }

    public class ConditionItem {
        protected Condition condition;
        private DefinitionsService definitionsService;

        ConditionItem(String conditionTypeId, DefinitionsService definitionsService) {
            this.definitionsService = definitionsService;
            this.condition = new Condition(this.definitionsService.getConditionType(conditionTypeId));
        }

        public Condition build() {
            return this.condition;
        }

        public ConditionItem parameter(String name, Object value) {
            this.condition.setParameter(name, value);
            return this;
        }

        public ConditionItem parameter(String name, Object ... values) {
            this.condition.setParameter(name, values != null ? Arrays.asList(values) : null);
            return this;
        }
    }

    public class NestedCondition
    extends ConditionItem {
        NestedCondition(ConditionItem subCondition, String path) {
            super("nestedCondition", subCondition.definitionsService);
            this.parameter("path", (Object)path);
            this.parameter("subCondition", (Object)subCondition.build());
        }
    }

    public class CompoundCondition
    extends ConditionItem {
        CompoundCondition(ConditionItem condition1, ConditionItem condition2, String operator) {
            super("booleanCondition", condition1.definitionsService);
            this.parameter("operator", (Object)operator);
            ArrayList<Condition> subConditions = new ArrayList<Condition>(2);
            subConditions.add(condition1.build());
            subConditions.add(condition2.build());
            this.parameter("subConditions", (Object)subConditions);
        }
    }

    public abstract class ComparisonCondition
    extends ConditionItem {
        ComparisonCondition(String conditionTypeId, DefinitionsService definitionsService) {
            super(conditionTypeId, definitionsService);
        }

        public ComparisonCondition all(String ... values) {
            return this.op("all").stringValues(values);
        }

        public ComparisonCondition all(Date ... values) {
            return this.op("all").dateValues(values);
        }

        public ComparisonCondition all(Integer ... values) {
            return this.op("all").integerValues(values);
        }

        public ComparisonCondition contains(String value) {
            return this.op("contains").stringValue(value);
        }

        public ComparisonCondition endsWith(String value) {
            return this.op("endsWith").stringValue(value);
        }

        public ComparisonCondition equalTo(String value) {
            return this.op("equals").stringValue(value);
        }

        public ComparisonCondition equalTo(Date value) {
            return this.op("equals").dateValue(value);
        }

        public ComparisonCondition equalTo(Integer value) {
            return this.op("equals").integerValue(value);
        }

        public ComparisonCondition equalTo(Double value) {
            return this.op("equals").doubleValue(value);
        }

        public ComparisonCondition exists() {
            return this.op("exists");
        }

        public ComparisonCondition greaterThan(Date value) {
            return this.op("greaterThan").dateValue(value);
        }

        public ComparisonCondition greaterThan(Integer value) {
            return this.op("greaterThan").integerValue(value);
        }

        public ComparisonCondition greaterThan(Double value) {
            return this.op("greaterThan").doubleValue(value);
        }

        public ComparisonCondition greaterThanOrEqualTo(Date value) {
            return this.op("greaterThanOrEqualTo").dateValue(value);
        }

        public ComparisonCondition greaterThanOrEqualTo(Integer value) {
            return this.op("greaterThanOrEqualTo").integerValue(value);
        }

        public ComparisonCondition greaterThanOrEqualTo(Double value) {
            return this.op("greaterThanOrEqualTo").doubleValue(value);
        }

        public ComparisonCondition in(String ... values) {
            return this.op("in").stringValues(values);
        }

        public ComparisonCondition inDateExpr(String ... values) {
            return this.op("in").dateExprValues(values);
        }

        public ComparisonCondition in(Date ... values) {
            return this.op("in").dateValues(values);
        }

        public ComparisonCondition isDay(Date value) {
            return this.op("isDay").dateValue(value);
        }

        public ComparisonCondition isDay(String expression) {
            return this.op("isDay").dateValueExpr(expression);
        }

        public ComparisonCondition isNotDay(Date value) {
            return this.op("isNotDay").dateValue(value);
        }

        public ComparisonCondition isNotDay(String expression) {
            return this.op("isNotDay").dateValueExpr(expression);
        }

        public ComparisonCondition in(Integer ... values) {
            return this.op("in").integerValues(values);
        }

        public ComparisonCondition in(Double ... values) {
            return this.op("in").doubleValues(values);
        }

        public ComparisonCondition lessThan(Date value) {
            return this.op("lessThan").dateValue(value);
        }

        public ComparisonCondition lessThan(Integer value) {
            return this.op("lessThan").integerValue(value);
        }

        public ComparisonCondition lessThan(Double value) {
            return this.op("lessThan").doubleValue(value);
        }

        public ComparisonCondition lessThanOrEqualTo(Date value) {
            return this.op("lessThanOrEqualTo").dateValue(value);
        }

        public ComparisonCondition lessThanOrEqualTo(Integer value) {
            return this.op("lessThanOrEqualTo").integerValue(value);
        }

        public ComparisonCondition between(Date lowerBound, Date upperBound) {
            return this.op("between").dateValues(lowerBound, upperBound);
        }

        public ComparisonCondition between(Integer lowerBound, Integer upperBound) {
            return this.op("between").integerValues(lowerBound, upperBound);
        }

        public ComparisonCondition matchesRegex(String value) {
            return this.op("matchesRegex").stringValue(value);
        }

        public ComparisonCondition missing() {
            return this.op("missing");
        }

        public ComparisonCondition notEqualTo(String value) {
            return this.op("notEquals").stringValue(value);
        }

        public ComparisonCondition notEqualTo(Date value) {
            return this.op("notEquals").dateValue(value);
        }

        public ComparisonCondition notEqualTo(Integer value) {
            return this.op("notEquals").integerValue(value);
        }

        public ComparisonCondition notEqualTo(Double value) {
            return this.op("notEquals").doubleValue(value);
        }

        public ComparisonCondition notIn(String ... values) {
            return this.op("notIn").stringValues(values);
        }

        public ComparisonCondition notIn(Date ... values) {
            return this.op("notIn").dateValues(values);
        }

        public ComparisonCondition notInDateExpr(String ... values) {
            return this.op("notIn").dateExprValues(values);
        }

        public ComparisonCondition notIn(Integer ... values) {
            return this.op("notIn").integerValues(values);
        }

        public ComparisonCondition notIn(Double ... values) {
            return this.op("notIn").doubleValues(values);
        }

        private ComparisonCondition op(String op) {
            return this.parameter("comparisonOperator", (Object)op);
        }

        @Override
        public ComparisonCondition parameter(String name, Object value) {
            return (ComparisonCondition)super.parameter(name, value);
        }

        @Override
        public ComparisonCondition parameter(String name, Object ... values) {
            return (ComparisonCondition)super.parameter(name, values);
        }

        public ComparisonCondition startsWith(String value) {
            return this.op("startsWith").stringValue(value);
        }

        private ComparisonCondition stringValue(String value) {
            return this.parameter("propertyValue", (Object)value);
        }

        private ComparisonCondition integerValue(Integer value) {
            return this.parameter("propertyValueInteger", (Object)value);
        }

        private ComparisonCondition doubleValue(Double value) {
            return this.parameter("propertyValueDouble", (Object)value);
        }

        private ComparisonCondition dateValue(Date value) {
            return this.parameter("propertyValueDate", (Object)value);
        }

        private ComparisonCondition dateValueExpr(String value) {
            return this.parameter("propertyValueDateExpr", (Object)value);
        }

        private ComparisonCondition stringValues(String ... values) {
            return this.parameter("propertyValues", (Object)(values != null ? Arrays.asList(values) : null));
        }

        private ComparisonCondition integerValues(Integer ... values) {
            return this.parameter("propertyValuesInteger", (Object)(values != null ? Arrays.asList(values) : null));
        }

        private ComparisonCondition doubleValues(Double ... values) {
            return this.parameter("propertyValuesDouble", (Object)(values != null ? Arrays.asList(values) : null));
        }

        private ComparisonCondition dateValues(Date ... values) {
            return this.parameter("propertyValuesDate", (Object)(values != null ? Arrays.asList(values) : null));
        }

        private ComparisonCondition dateExprValues(String ... values) {
            return this.parameter("propertyValuesDateExpr", (Object)(values != null ? Arrays.asList(values) : null));
        }
    }
}

