/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={HealthCheckConfig.class}, configurationPid={"org.apache.unomi.healthcheck"})
public class HealthCheckConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HealthCheckConfig.class.getName());
    public static final String CONFIG_ES_ADDRESSES = "esAddresses";
    public static final String CONFIG_ES_SSL_ENABLED = "esSSLEnabled";
    public static final String CONFIG_ES_LOGIN = "esLogin";
    public static final String CONFIG_ES_PASSWORD = "esPassword";
    public static final String CONFIG_TRUST_ALL_CERTIFICATES = "httpClient.trustAllCertificates";
    public static final String CONFIG_AUTH_REALM = "authentication.realm";
    public static final String ENABLED = "healthcheck.enabled";
    public static final String PROVIDERS = "healthcheck.providers";
    public static final String TIMEOUT = "healthcheck.timeout";
    private Map<String, String> config = new HashMap<String, String>();
    private boolean enabled = true;
    private List<String> enabledProviders = new ArrayList<String>();
    private int timeout = 400;

    @Activate
    @Modified
    public void modified(Map<String, String> config) {
        LOGGER.info("Updating healthcheck configuration, config size: {}", (Object)config.size());
        this.setConfig(config);
        this.setEnabled(config.getOrDefault(ENABLED, "true").equalsIgnoreCase("true"));
        this.setEnabledProviders(config.getOrDefault(PROVIDERS, "").isEmpty() ? new ArrayList<String>() : List.of(config.get(PROVIDERS).split(",")));
        this.setTimeout(Integer.parseInt(config.getOrDefault(TIMEOUT, "400")));
    }

    public String get(String configKey) {
        return this.config.get(configKey);
    }

    public int getSize() {
        return this.config.size();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getEnabledProviders() {
        return this.enabledProviders;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledProviders(List<String> enabledProviders) {
        this.enabledProviders = enabledProviders;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

