/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.utils.ping.internal.osgi;

import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Producer;
import org.apache.karaf.cellar.core.command.CommandStore;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.utils.ping.PingHandler;
import org.apache.karaf.cellar.utils.ping.PongHandler;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.service.cm.ConfigurationAdmin;

@Services(requires={@RequireService(value=ClusterManager.class), @RequireService(value=CommandStore.class), @RequireService(value=EventProducer.class), @RequireService(value=ConfigurationAdmin.class)}, provides={@ProvideService(value=EventHandler.class)})
public class Activator
extends BaseActivator {
    @Override
    public void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        ClusterManager clusterManager = this.getTrackedService(ClusterManager.class);
        if (clusterManager == null) {
            return;
        }
        EventProducer eventProducer = this.getTrackedService(EventProducer.class);
        if (eventProducer == null) {
            return;
        }
        CommandStore commandStore = this.getTrackedService(CommandStore.class);
        if (commandStore == null) {
            return;
        }
        PingHandler pingHandler = new PingHandler();
        pingHandler.setClusterManager(clusterManager);
        pingHandler.setConfigurationAdmin(configurationAdmin);
        pingHandler.setProducer((Producer)eventProducer);
        this.register(EventHandler.class, pingHandler);
        PongHandler pongHandler = new PongHandler();
        pongHandler.setCommandStore(commandStore);
        this.register(EventHandler.class, pongHandler);
    }

    @Override
    public void doStop() {
        super.doStop();
    }
}

