/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.support.TokenPairExpressionIterator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;

@Deprecated
public class TokenXMLPairExpressionIterator
extends TokenPairExpressionIterator {
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("xmlns(:\\w+|)=\\\"(.*?)\\\"");
    private static final String SCAN_TOKEN_REGEX = "(\\s+.*?|)>";
    private static final String SCAN_TOKEN_NS_PREFIX_REGEX = "(.{1,15}?:|)";
    protected final String inheritNamespaceToken;

    public TokenXMLPairExpressionIterator(String startToken, String endToken, String inheritNamespaceToken) {
        super(startToken, endToken, true);
        this.inheritNamespaceToken = inheritNamespaceToken;
    }

    @Override
    protected Iterator<?> createIterator(Exchange exchange, InputStream in, String charset) {
        String inherit;
        String end;
        String start = this.startToken;
        if (SimpleLanguage.hasSimpleFunction(start)) {
            start = SimpleLanguage.expression(start).evaluate(exchange, String.class);
        }
        if (SimpleLanguage.hasSimpleFunction(end = this.endToken)) {
            end = SimpleLanguage.expression(end).evaluate(exchange, String.class);
        }
        if ((inherit = this.inheritNamespaceToken) != null && SimpleLanguage.hasSimpleFunction(inherit)) {
            inherit = SimpleLanguage.expression(inherit).evaluate(exchange, String.class);
        }
        if (!start.startsWith("<") || !start.endsWith(">")) {
            throw new IllegalArgumentException("Start token must be a valid XML token, was: " + start);
        }
        if (!end.startsWith("<") || !end.endsWith(">")) {
            throw new IllegalArgumentException("End token must be a valid XML token, was: " + end);
        }
        if (!(inherit == null || inherit.startsWith("<") && inherit.endsWith(">"))) {
            throw new IllegalArgumentException("Namespace token must be a valid XML token, was: " + inherit);
        }
        XMLTokenPairIterator iterator = new XMLTokenPairIterator(start, end, inherit, in, charset);
        iterator.init();
        return iterator;
    }

    static class XMLTokenPairIterator
    extends TokenPairExpressionIterator.TokenPairIterator {
        private final Pattern startTokenPattern;
        private final String scanEndToken;
        private final String inheritNamespaceToken;
        private Pattern inheritNamespaceTokenPattern;
        private String rootTokenNamespaces;

        XMLTokenPairIterator(String startToken, String endToken, String inheritNamespaceToken, InputStream in, String charset) {
            super(startToken, endToken, true, in, charset);
            StringBuilder tokenSb = new StringBuilder("<").append(TokenXMLPairExpressionIterator.SCAN_TOKEN_NS_PREFIX_REGEX).append(startToken.substring(1, startToken.length() - 1)).append(TokenXMLPairExpressionIterator.SCAN_TOKEN_REGEX);
            this.startTokenPattern = Pattern.compile(tokenSb.toString());
            tokenSb = new StringBuilder("</").append(TokenXMLPairExpressionIterator.SCAN_TOKEN_NS_PREFIX_REGEX).append(endToken.substring(2, endToken.length() - 1)).append(TokenXMLPairExpressionIterator.SCAN_TOKEN_REGEX);
            this.scanEndToken = tokenSb.toString();
            this.inheritNamespaceToken = inheritNamespaceToken;
            if (inheritNamespaceToken != null) {
                tokenSb = new StringBuilder("<").append(TokenXMLPairExpressionIterator.SCAN_TOKEN_NS_PREFIX_REGEX).append(inheritNamespaceToken.substring(1, inheritNamespaceToken.length() - 1)).append(TokenXMLPairExpressionIterator.SCAN_TOKEN_REGEX);
                this.inheritNamespaceTokenPattern = Pattern.compile(tokenSb.toString(), 40);
            }
        }

        @Override
        void init() {
            this.scanner = new Scanner(this.in, this.charset, this.scanEndToken);
            this.image = this.scanner.hasNext() ? (String)this.next(true) : null;
        }

        @Override
        String getNext(boolean first) {
            Matcher matcher;
            String next = this.scanner.next();
            if (next == null) {
                return null;
            }
            if (first && this.inheritNamespaceToken != null) {
                this.rootTokenNamespaces = this.getNamespacesFromNamespaceToken(next);
            }
            if (!(matcher = this.startTokenPattern.matcher(next)).find()) {
                return null;
            }
            int index = matcher.start();
            next = next.substring(index);
            String tag = StringHelper.before(next, ">");
            StringBuilder endTagSb = new StringBuilder("</");
            int firstSpaceIndex = tag.indexOf(" ");
            if (firstSpaceIndex > 0) {
                endTagSb.append(tag.substring(1, firstSpaceIndex)).append(">");
            } else {
                endTagSb.append(tag.substring(1, tag.length())).append(">");
            }
            StringBuilder sb = new StringBuilder();
            if (this.inheritNamespaceToken != null && this.rootTokenNamespaces != null) {
                String text = StringHelper.after(next, ">");
                next = sb.append(tag).append(this.rootTokenNamespaces).append(">").append(text).append(endTagSb.toString()).toString();
            } else {
                next = sb.append(next).append(endTagSb.toString()).toString();
            }
            return next;
        }

        private String getNamespacesFromNamespaceToken(String text) {
            if (text == null) {
                return null;
            }
            Matcher mat = this.inheritNamespaceTokenPattern.matcher(text);
            if (!mat.find()) {
                return null;
            }
            text = mat.group(0);
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            Matcher matcher = NAMESPACE_PATTERN.matcher(text);
            while (matcher.find()) {
                String prefix = matcher.group(1);
                String url = matcher.group(2);
                prefix = ObjectHelper.isEmpty(prefix) ? "_DEFAULT_" : prefix.substring(1);
                namespaces.put(prefix, url);
            }
            if (namespaces.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : namespaces.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("_DEFAULT_".equals(key)) {
                    sb.append(" xmlns=\"").append(value).append("\"");
                    continue;
                }
                sb.append(" xmlns:").append(key).append("=\"").append(value).append("\"");
            }
            return sb.toString();
        }
    }
}

