/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath;

import antlr.CharBuffer;
import antlr.InputBuffer;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.werken.xpath.ContextSupport;
import com.werken.xpath.impl.Context;
import com.werken.xpath.impl.Expr;
import com.werken.xpath.parser.XPathLexer;
import com.werken.xpath.parser.XPathRecognizer;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class XPath {
    private String _xpath = "";
    private Expr _expr = null;

    public XPath(String xpath) {
        this._xpath = xpath;
        this.parse();
    }

    public List applyTo(ContextSupport contextSupport, List nodes) {
        return (List)this._expr.evaluate(new Context(nodes, contextSupport));
    }

    public List applyTo(ContextSupport contextSupport, Document doc) {
        return (List)this._expr.evaluate(new Context(doc, contextSupport));
    }

    public List applyTo(ContextSupport contextSupport, Element node) {
        return (List)this._expr.evaluate(new Context(node, contextSupport));
    }

    public List applyTo(List nodes) {
        return this.applyTo(ContextSupport.BASIC_CONTEXT_SUPPORT, nodes);
    }

    public List applyTo(Document doc) {
        return this.applyTo(ContextSupport.BASIC_CONTEXT_SUPPORT, doc);
    }

    public List applyTo(Element node) {
        return this.applyTo(ContextSupport.BASIC_CONTEXT_SUPPORT, node);
    }

    public String getString() {
        return this._xpath;
    }

    private void parse() {
        StringReader reader = new StringReader(this._xpath);
        CharBuffer buf = new CharBuffer((Reader)reader);
        XPathLexer lexer = new XPathLexer((InputBuffer)buf);
        XPathRecognizer recog = new XPathRecognizer(lexer);
        try {
            this._expr = recog.xpath();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
        catch (TokenStreamException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "[XPath: " + this._xpath + " " + this._expr + "]";
    }
}

