package PROP::Util;

use strict;
use base qw/Exporter/;

our @EXPORT = qw/table_exists drop_table/;

sub table_exists {
    my ($table_name) = @_;

    my $sth;

    eval {
	$sth = PROP::DBH->get_handle()->prepare('show tables');
	$sth->execute();
    };
    if($@) {
	my $msg = "problem querying table list";
	die $@->PROPAGATE($msg);
    }

    my $row;
    while($row = $sth->fetchrow_arrayref()) {
	return 1 if($row->[0] eq $table_name);
    }

    return 0;
}


sub drop_table {
    my ($table_name) = @_;

    return unless table_exists($table_name);

    eval {
	my $sth = PROP::DBH->get_handle()->prepare("drop table $table_name");
	$sth->execute();
    };
    if($@) {
	my $msg = "problem dropping table '$table_name': $@";
	die new PROP::Exception($msg);
    }
}

1;

=head1 Name

PROP::Util

=head1 Description

This class is a collection of static utility methods for performing
various tasks that are common to perhaps several different libraries,
but couldn't find a good home in any particular one of them.

=head1 Methods

=over

=item table_exists

 PROP::Util::table_exists($table_name);

This method takes a database handle and the name of a table.  It
returns a Boolean value, true if the table exists within the database,
and false if it does not.

=item drop_table

 PROP::Util::drop_table($table_name);

This method takes a database handle and the name of a table.  It drops
the table from the database if it exists.

=back

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
