use utf8;
use strict;

use open qw(:std :utf8);
use Test::More 'no_plan';
use lib 't/lib';

use TreePath;

#       /
#       |
#       A
#      / \
#     B   C1
#    /   / \
#   C   C2   E
#  / \
# D   E
#
# nodes source1 : /, A, B, C, D, E
# nodes source2 : C1, C2 (unsourced), E (second E with another source)
#

my $simpletree = {
                  'source1_1' => {
                          id => 1,
                          source => 'source1',
                          parent => '0',
                          name => '/'},
                  'source1_2' => {
                          id => 2,
                          source => 'source1',
                          parent => { 'source1_1' },
                          name => 'A'},
                  'source1_3' => {
                          id => 3,
                          source => 'source1',
                          parent => { 'source1_2' },
                          name => 'B'},
                  'source1_4' => {
                          id => 4,
                          source => 'source1',
                          parent => { 'source1_3' },
                          name => 'C'},
                  'source1_5' => {
                          id => 5,
                          source => 'source1',
                          parent => { 'source1_4' },
                          name => 'D'},
                  'source1_6' => {
                          id => 6,
                          source => 'source1',
                          parent => { 'source1_4' },
                          name => 'E'},
                  'source1_7' => {
                          id => 7,
                          source => 'source2',
                          parent => { 'source1_2' },
                          name => 'C1'},
                  'source1_8' => {
                          id => 8,
                          source => 'source2',
                          parent => { 'source1_7' },
                          name => 'C2',
                         },
                  'source1_9' => {
                          id => 9,
                          source => 'source2',
                          parent => { 'source1_7' },
                          name => 'E'},
                 };


ok( my $tp = TreePath->new(  conf  => $simpletree  ),
    "New TreePath ( conf => $simpletree)");

my $tree = $tp->tree;
isa_ok($tree, 'HASH');
my $root = $tp->root;
is($root,$tree->{source1_1}, 'retrieve root');
isa_ok($root, 'HASH', "root" );

# search --------------------------
ok( my $A = $tp->search( { name => 'A' } ), 'A found');
is($A->{source}, 'source1', 'source of A is source1');

is(@{$A->{children}}, 1, 'A has only one child with same source as him');

is(@{$A->{children_source2}}, 1, 'but  has also a son with source2');

ok( my $C1 = $tp->search( { name => 'C1', source => 'source2' } ), 'C1 found');
is(@{$C1->{children}}, 2, 'C1 has two children');
my $C2 = @{$C1->{children}}[0];
is($C2->{source}, 'source2', 'first child (C2) has source2 source');

is(scalar @{$A->{children}}, 1, 'A has again 1 child');
is(scalar @{$A->{children_source2}}, 1, 'but it have also a children_source2');


# add -----------------------------
is(scalar @{$C1->{children}}, 2, 'C1 has 2 children');
my $C3 = { name => 'C3', source => 'source2', id => 100};

ok( $C3 = $tp->add($C3, $C1), 'add C3 to C1' );

is( $C3->{parent}, $C1, 'C3 parent is C1');
is($C3->{source}, 'source2', 'C3 has source2 source');

my $C4 = { name => 'C4', source => 'source2', id => 101};
ok( $C4 = $tp->add($C4, $A), 'add C4 to A, source2 -> source1 is ok');


is(scalar @{$A->{children}}, 1, 'now A has again 1 child');
is(scalar @{$A->{children_source2}}, 2, 'but it have also two children_source2');


is(scalar @{$A->{children}}, 1, 'A has 1 child');
my $A2 = { name => 'A2', source => 'source1', id => 102};
ok( $A2 = $tp->add($A2, $A), 'add A2 to A, source1 -> source1 is ok');

is(scalar @{$A->{children}}, 2, 'now A has 2 children (B, A2)');

my $A3 = { name => 'A3', source => 'source1', id => 103};
ok( $A3 = $tp->add($A3, $C1), 'add A3 to C1, source1 -> source2 is also permit, there is no rules');


is(scalar @{$A->{children_source2}}, 2, 'A have two children_source2');
my $C5 = { name => 'C5', source => 'source2', id => 104};
ok($C5 = $tp->add($C5, $A), 'C5 added as a child of A with position=2');
is(scalar @{$A->{children_source2}}, 3, 'now A has 3 children_source2 (C1, C5, C4)');
