#!/usr/bin/perl -w

#

use Test;

use Nagios::Report ;


# Each element in this array is a single test. Storing them this way makes
# maintenance easy, and should be OK since perl should be pretty functional
# before these tests are run.


use constant RPT	=> sub {
							# Madness to make a constant of a code reference.

							# Having the debug data generated by a client callback makes then
							# using the shell to produce results _much_ harder.

							# A shell forked by `` will not know of any Perl subs in the parent,
							# so the constructor in the shell can't callback to the parent.
							# To get around this I have
							#   called the callback by hand in the parent
							#   interpolated its result as a string in a pseudo callback in the shell
							#   let the shell call the pseudo callback.
  $args = shift @_ ;
  $dat = join "\n", &from_data_handle(q<Test>) ;

  $cmd = qq[perl -Mblib -MNagios::Report -e 'sub bar { split /\\n/, qq($dat) }; \$x = Nagios::Report->new(q<dev_debug bar>, [q<Test>]); \$x->mkreport($args); \$x->debug_dump()'] ;

  `$cmd` ;
} ;

=begin comment


                          Test

HOST_NAME                 TIME_UP_SCHEDULE %_TIME_UP_SCHEDU %_KNOWN_TIME_UP_ TIME_UP_UNSCHEDU %_TIME_UP_UNSCHE %_KNOWN_TIME_UP_
                          TOTAL_TIME_UP    %_TOTAL_TIME_UP  %_KNOWN_TIME_UP  TIME_DOWN_SCHEDU %_TIME_DOWN_SCHE %_KNOWN_TIME_DOW
                          TIME_DOWN_UNSCHE %_TIME_DOWN_UNSC %_KNOWN_TIME_DOW TOTAL_TIME_DOWN  %_TOTAL_TIME_DOW %_KNOWN_TIME_DOW
                          TIME_UNREACHABLE %_TIME_UNREACHAB %_KNOWN_TIME_UNR TIME_UNREACHABLE %_TIME_UNREACHAB %_KNOWN_TIME_UNR
                          TOTAL_TIME_UNREA %_TOTAL_TIME_UNR %_KNOWN_TIME_UNR TIME_UNDETERMINE %_TIME_UNDETERMI TIME_UNDETERMINE
                          %_TIME_UNDETERMI TOTAL_TIME_UNDET %_TOTAL_TIME_UND AVAIL_URL        TREND_URL

16_Mort_St_Optus_router_P 0                0.000%           0.000%           2045127          100.000%         100.000%
                          2045127          100.000%         100.000%         0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0
                          0.000%           0                0.000%           http://nms/nagio http://nms/nagio

Adelaide_State_Office_DES 0                0.000%           0.000%           2045127          100.000%         100.000%
                          2045127          100.000%         100.000%         0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0
                          0.000%           0                0.000%           http://nms/nagio http://nms/nagio

Adelaide_State_Office_Opt 0                0.000%           0.000%           2045127          100.000%         100.000%
                          2045127          100.000%         100.000%         0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0.000%
                          0                0.000%           0.000%           0                0.000%           0
                          0.000%           0                0.000%           http://nms/nagio http://nms/nagio

Albany_DEST_router        0                0.000%           0.000%           2039937          99.746%          99.746%
                          2039937          99.746%          99.746%          0                0.000%           0.000%
                          290              0.014%           0.014%           290              0.014%           0.014%
                          0                0.000%           0.000%           4900             0.240%           0.240%
                          4900             0.240%           0.240%           0                0.000%           0
                          0.000%           0                0.000%           http://nms/nagio http://nms/nagio



=end comment

=cut




$tests = <<'EOTESTS' ;
# Scalar expression 
# 1==1,

$r = RPT->(''); $n = $r =~ m|\n|g ;				$n > 0 
								$r =~ /\n\s+Test\s*\n\n/
								$r =~ /^16_Mort.*?^Adelaide/ms
								$r =~ /^Adelaide_State_Office_Opt.*?^Albany/ms


$r = RPT->('[qw(HOST_NAME PERCENT_TOTAL_TIME_UP)]');		$r =~ /^HOST_NAME \s+ %_TOTAL_TIME_UP \s* $/xms
								$r =~ /16_Mort_St\w+ \s+ 100\.0+%/x

$r = RPT->('[qw(HOST_NAME)]');					$r =~ /^HOST_NAME      \s* $/xm
								$r =~ /^16_Mort_St_\w+ \s* $/xm
								$r =~ /^Adelaide_\w+   \s* $/xm

$r = RPT->('[qw(HOST_NAME PERCENT_TOTAL_TIME_UP)], undef, sub { %f = @_; package Nagios::Report; $b->[$f{HOST_NAME}] cmp $a->[$f{HOST_NAME}] }');
								$r =~ /^Albany.*?^Adelaid/sm

$r = RPT->('[qw(HOST_NAME PERCENT_TOTAL_TIME_UP)], sub { %F = @_ ; $F{HOST_NAME} =~ /^16_Mort_St/ }');
								$r =~ /^HOST_NAME.+\n^16_Mort_St.+\n/m

								# The alter subroutine _must_ return the list of fields added.
								# An alter callback that only changes existing fields should
								# return an empty list. Otherwise there will be a stray '1' in the
								# report.

$r = RPT->('[qw(HOST_NAME PERCENT_TOTAL_TIME_UP)], undef, undef, sub { my $F = shift @_; $F->{PERCENT_TOTAL_TIME_UP} =~ s/%//;  () }');
								$r =! m<\d+\.d+%>sg 

EOTESTS

@t = split /\n/, $tests ;
@tests = grep !( m<\s*#> or m<^\s*$> ), @t ;

plan tests => scalar(@tests) ;
# plan tests => scalar(@tests) + 1 ;


for ( @tests ) {

  $sub = eval "sub { $_ }" ;

  warn "sub { $_ } fails to compile: $@"
    if $@ ;

  ok $sub  ;

  1 ;
}

{ 
  my $data ; 

  sub from_data_handle {

    my $rep_period = shift @_ ;

    my @avail_rep = () ;

    local $/ = undef ;
    $data = <DATA> 
      unless $data ;

    my ($r) = $data =~ /^# $rep_period\n(.*?)^END_OF_FILE_MARKER/sm ;
  
    @avail_rep = split /\n/, $r ;

    @avail_rep ;

  }
}

__DATA__
# Test
HOST_NAME, TIME_UP_SCHEDULED, PERCENT_TIME_UP_SCHEDULED, PERCENT_KNOWN_TIME_UP_SCHEDULED, TIME_UP_UNSCHEDULED, PERCENT_TIME_UP_UNSCHEDULED, PERCENT_KNOWN_TIME_UP_UNSCHEDULED, TOTAL_TIME_UP, PERCENT_TOTAL_TIME_UP, PERCENT_KNOWN_TIME_UP, TIME_DOWN_SCHEDULED, PERCENT_TIME_DOWN_SCHEDULED, PERCENT_KNOWN_TIME_DOWN_SCHEDULED, TIME_DOWN_UNSCHEDULED, PERCENT_TIME_DOWN_UNSCHEDULED, PERCENT_KNOWN_TIME_DOWN_UNSCHEDULED, TOTAL_TIME_DOWN, PERCENT_TOTAL_TIME_DOWN, PERCENT_KNOWN_TIME_DOWN, TIME_UNREACHABLE_SCHEDULED, PERCENT_TIME_UNREACHABLE_SCHEDULED, PERCENT_KNOWN_TIME_UNREACHABLE_SCHEDULED, TIME_UNREACHABLE_UNSCHEDULED, PERCENT_TIME_UNREACHABLE_UNSCHEDULED, PERCENT_KNOWN_TIME_UNREACHABLE_UNSCHEDULED, TOTAL_TIME_UNREACHABLE, PERCENT_TOTAL_TIME_UNREACHABLE, PERCENT_KNOWN_TIME_UNREACHABLE, TIME_UNDETERMINED_NOT_RUNNING, PERCENT_TIME_UNDETERMINED_NOT_RUNNING, TIME_UNDETERMINED_NO_DATA, PERCENT_TIME_UNDETERMINED_NO_DATA, TOTAL_TIME_UNDETERMINED, PERCENT_TOTAL_TIME_UNDETERMINED
"16_Mort_St_Optus_router_PE_interface", 0, 0.000%, 0.000%, 2045127, 100.000%, 100.000%, 2045127, 100.000%, 100.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0, 0.000%, 0, 0.000%
"Adelaide_State_Office_DEST_router", 0, 0.000%, 0.000%, 2045127, 100.000%, 100.000%, 2045127, 100.000%, 100.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0, 0.000%, 0, 0.000%
"Adelaide_State_Office_Optus_router_PE_interface", 0, 0.000%, 0.000%, 2045127, 100.000%, 100.000%, 2045127, 100.000%, 100.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0.000%, 0, 0.000%, 0, 0.000%, 0, 0.000%
"Albany_DEST_router", 0, 0.000%, 0.000%, 2039937, 99.746%, 99.746%, 2039937, 99.746%, 99.746%, 0, 0.000%, 0.000%, 290, 0.014%, 0.014%, 290, 0.014%, 0.014%, 0, 0.000%, 0.000%, 4900, 0.240%, 0.240%, 4900, 0.240%, 0.240%, 0, 0.000%, 0, 0.000%, 0, 0.000%
END_OF_FILE_MARKER


