# Automatically generated by optdefs.pl - DO NOT EDIT! 


#
# Copyright (C) 2001  Daemon Consulting Inc.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package CGI::SpeedyCGI;

use strict;
use vars qw($VERSION);
$VERSION = '2.10';

## use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
## 
## require Exporter;
## require DynaLoader;
## require AutoLoader;
## 
## @ISA = qw(Exporter DynaLoader);
## # Items to export into callers namespace by default. Note: do not export
## # names by default without a very good reason. Use EXPORT_OK instead.
## # Do not simply export all your public functions/methods/constants.
## @EXPORT = qw(
## 	
## );

sub new { my $class = shift;
    bless {}, $class;
}

use vars qw($_shutdown_handler $_i_am_speedy %_opts $_opts_changed @_cleanup);

# Set a handler function to be called before shutting down the Perl process
sub set_shutdown_handler { my($self, $newh) = @_;
    my $oldh = $_shutdown_handler;
    $_shutdown_handler = $newh;
    $oldh;
}

# Return true if we are running under speedycgi, false otherwise.
sub i_am_speedy { defined($_i_am_speedy); }

# Set one of the speedycgi options.
sub setopt { my($self, $opt, $val) = @_;
    $opt = uc($opt);
    my $oval = $_opts{$opt};
    $_opts{$opt} = $val;
    if (!defined($oval) || $oval ne $val) {$_opts_changed = 1}
    $oval;
}

# Return one of the speedycgi options.
sub getopt { my($self, $opt) = @_;
    $_opts{uc($opt)};
}

# Register a function to be run after each request
sub register_cleanup { my($self, $func) = @_;
    push(@_cleanup, $func);
}

# Do the cleanup functions
sub _run_cleanup {
    while ($_ = shift @_cleanup) { &$_; }
}

## bootstrap CGI::SpeedyCGI $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;

__END__

=head1 NAME

CGI::SpeedyCGI - Speed up perl CGI scripts by running them persistently

=head1 SYNOPSIS

 #!/usr/bin/speedy

 ### Your CGI Script Here
 print "Content-type: text/html\n\nHello World!\n";

 ##
 ## Optionally, use the CGI::SpeedyCGI module for various things
 ##

 # Create a SpeedyCGI object
 use CGI::SpeedyCGI;
 my $sp = CGI::SpeedyCGI->new;

 # See if we are running under SpeedyCGI or not.
 print "Running under speedy=", $sp->i_am_speedy ? 'yes' : 'no', "\n";

 # Register a shutdown handler
 $sp->set_shutdown_handler(sub { do something here });

 # Register a cleanup handler
 $sp->register_cleanup(sub { do something here });

 # Set/get some SpeedyCGI options
 $sp->setopt('timeout', 30);
 print "maxruns=", $sp->getopt('maxruns'), "\n";


=head1 DESCRIPTION

SpeedyCGI is a way to run CGI perl scripts persistently, which usually
makes them run much more quickly.  A script can be converted
to SpeedyCGI by changing the interpreter line at the top of the script from:

    #!/usr/bin/perl

to

    #!/usr/bin/speedy

After the script is initially run, instead of exiting, SpeedyCGI keeps the
perl interpreter running.  During subsequent runs, this interpreter
is used to handle new requests instead of starting a new perl interpreter
for each execution.

SpeedyCGI conforms to the CGI specification, and normally does not work
inside the web server.  A very fast cgi-bin, written in C, is executed
for each request.  This fast cgi-bin then contacts the persistent Perl
process, which is usually already running, to do the work and return
the results.

Since the perl interpreter runs outside the web server, it can't cause
problems for the web server itself.  By default each perl script runs in
its own Unix process, so one program can't interfere with another.
Command line options can also be used to deal with programs that have memory
leaks or other problems that might keep them from otherwise running
persistently.

SpeedyCGI also provides an Apache module so that under the Apache web server,
scripts can be run without the overhead of doing a fork/exec for
each request.  With this module a small amount of frontend code is
run within the web server - the perl interpreters still run outside the server.


=head1 OPTIONS

=head2 Setting Option Values

SpeedyCGI options can be set in several ways:

=over

=item Command Line

The speedy command line is the same as for regular perl, with the
exception that SpeedyCGI specific options can be passed in after a "--".

For example the line:

	#!/usr/bin/speedy -w -- -t300

at the top of your script will set the perl option
"C<-w>" and will pass the "C<-t>" option to SpeedyCGI, setting the
Timeout value to 300 seconds.

=back

=over

=item Environment

Environment variables can be used to pass in options.  This can only be
done before the initial execution, not from within the script itself.
The name of the environment variable is always SPEEDY_ followed by the
option name in upper-case.  For example to set the speedy Timeout option, use
the environment variable named SPEEDY_TIMEOUT.

=back

=over

=item CGI::SpeedyCGI

The CGI::SpeedyCGI module provides the setopt method to set options from
within the perl script at runtime.  There is also a getopt method to retrieve
the current options.  See L<"METHODS"> below.

=back

=over

=item mod_speedycgi

If you are using the optional Apache module, SpeedyCGI options can be
set in the F<httpd.conf> file.  The name of the apache directive will always
be Speedy followed by the option name.  For example to set the speedy
Timeout option, use the apache directive SpeedyTimeout.

=back

=head2 Context

Not all options below are available in all contexts.  The context for
which each option is valid is listed on the "Context" line in the section
below.  There are three contexts:

=over

=item speedy

The command-line "speedy" program, used normally with #! at the top of
your script or from a shell prompt.

=back

=over

=item mod_speedycgi

The optional Apache mod_speedycgi module.

=back

=over

=item module

During perl execution via the CGI::SpeedyCGI module's getopt/setopt methods.

=back

=head2 Options Available

=over

=item BackendProg

    Command Line    : -p<string>
    Default Value   : "/usr/bin/speedy_backend"
    Context         : mod_speedycgi, speedy

    Description:

	Path to the speedy backend program.

=item BufsizGet

    Command Line    : -B<number>
    Default Value   : 8192
    Context         : speedy

    Description:

	Use <number> bytes for the buffer that
	receives data from the CGI script.

=item BufsizPost

    Command Line    : -b<number>
    Default Value   : 1024
    Context         : speedy

    Description:

	Use <number> bytes for the buffer that sends
	data to the CGI script.

=item Group

    Command Line    : -g<string>
    Default Value   : "none"
    Context         : mod_speedycgi, speedy

    Description:

	Allow a single perl interpreter to run
	multiple scripts. All scripts that are run
	with the same group name and by the same user
	will be run by the same group of perl
	interpreters. If the group name is "none"
	then grouping is disabled and each
	interpreter will run one script. Different
	group names allow scripts to be separated
	into different groups. Name is
	case-sensitive, and only the first
	12-characters are significant. Specifying an
	empty group name is the same as specifying
	the group name "default" - this allows just
	specifying "-g" on the command line to turn
	on grouping.

=item MaxBackends

    Command Line    : -M<number>
    Default Value   : 0 (no max)
    Context         : mod_speedycgi, speedy

    Description:

	If non-zero, limits the number of speedy
	backends running for this cgi script to
	<number>.

=item MaxRuns

    Command Line    : -r<number>
    Default Value   : 500
    Context         : mod_speedycgi, module, speedy

    Description:

	Once the perl interpreter has run <number>
	times, re-exec the backend process.  Zero
	indicates no maximum.  This option is useful
	for processes that tend to consume resources
	over time.

=item PerlArgs

    Command Line    : N/A
    Default Value   : ""
    Context         : mod_speedycgi

    Description:

	Command-line options to pass to the perl
	interpreter.

=item Timeout

    Command Line    : -t<number>
    Default Value   : 3600 (one hour)
    Context         : mod_speedycgi, module, speedy

    Description:

	If no new requests have been received after
	<number> seconds, exit the persistent perl
	interpreter.  Zero indicates no timeout.

=item TmpBase

    Command Line    : -T<string>
    Default Value   : "/tmp/speedy"
    Context         : mod_speedycgi, speedy

    Description:

	Use the given prefix for creating temporary
	files.	This must be a filename prefix, not a
	directory name.

=item Version

    Command Line    : -v
    Context         : speedy

    Description:

	Print the SpeedyCGI version and exit.


=back

=head1 METHODS

The following methods are available in the CGI::SpeedyCGI module.

=over

=item S<new >    

Create a new CGI::SpeedyCGI object.

    my $sp = CGI::SpeedyCGI->new;

=item register_cleanup($function_ref)

Register a function that will be called at the end of each request, after
your script finishes running, but before STDOUT and STDERR are closed.
Multiple functions can be added by calling the method more than once.
At the end of the request, each function will be called in the order
in which it was registered.

    $sp->register_cleanup(\&cleanup_func);

=item set_shutdown_handler($function_ref)

Register a function that will be called right before the perl interpreter
exits.  This is B<not> at the end of each request, it is when the perl
interpreter decides to exit completely due to a Timeout or reaching MaxRuns.

    $sp->set_shutdown_handler(sub {$dbh->logout});

=item i_am_speedy

Returns a boolean telling whether this script is running under SpeedyCGI
or not.  A CGI script can run under regular perl, or under SpeedyCGI.
This method allows the script to tell which environment it is in.

    $sp->i_am_speedy;

To make your script as portable as possible, you can use the following
test to make sure both the SpeedyCGI module is available and you are running
under SpeedyCGI:

    if (eval {require CGI::SpeedyCGI} && CGI::SpeedyCGI->i_am_speedy) {
	Do something SpeedyCGI specific here...

=item setopt($optname, $value)

Set one of the SpeedyCGI options given in L<"Options Available">.  Returns
the option's previous value.  $optname is case-insensitive.

    $sp->setopt('TIMEOUT', 300);

=item getopt($optname)

Return the current value of one of the SpeedyCGI options.  $optname
is case-insensitive.

    $sp->getopt('TIMEOUT');

=back

=head1 INSTALLATION

To install SpeedyCGI you will need to either download a binary package
for your OS, or compile SpeedyCGI from source code.  See L<"DOWNLOADING">
for information on where to obtain the source code and binaries.

=head2 Binary Installation

Once you have downloaded the binary package for your OS, you'll need to
install it using the normal package tools for your OS.  The commands to
do that are:

=over

=item Linux

 rpm -i <filename>

=item Solaris

 gunzip <filename>.gz
 pkgadd -d <filename>

=item BSD

 pkg_add <filename>

=back

If you are also installing the apache module you will have to configure
Apache as documented in L<"Apache Configuration">.

=head2 Source Code Installation

To compile SpeedyCGI you will need perl 5.004 or later, and a C
compiler, preferably the same one that your perl distribution was compiled
with.  SpeedyCGI is known to work under Solaris, Redhat Linux,
FreeBSD and OpenBSD.  There may be problems with other OSes or
other versions of Perl.  SpeedyCGI may not work with threaded perl -- as
of release 2.10, Linux and Solaris seem to work OK with threaded
perl, but FreeBSD does not.

=head2 Standard Install

To do a standard install from source code, execute the following:

    perl Makefile.PL
    make
    make test
    make install

This will install the speedy and speedy_backend binaries in the same
directory where perl was installed, and the SpeedyCGI.pm module in
the standard perl lib directory.  It will also attempt to install
the mod_speedycgi module if you have the command B<apxs> in your path.

=head2 Install in a Different Directory

To install in a different directory, change the first line in
L<"Standard Install"> to:

    perl Makefile.PL PREFIX=/somewhere

This will install the binaries in F</somewhere/bin> and the SpeedyCGI.pm
module under F</somewhere/lib>.

=head2 Apache Installation

To compile the optional apache mod_speedycgi module you must have the B<apxs>
command in your path.  Redhat includes this command with the "apache-devel"
RPM, though it may not work properly for installation.

If the apache installation fails:

=over

=item *

Copy the mod_speedycgi.so from the mod_speedycgi directory to wherever
your apache modules are stored (try F</usr/lib/apache>)

=back

=over

=item *

Edit your F<httpd.conf> (try F</etc/httpd/conf/httpd.conf>) and add the
following lines.  The path at the end of the LoadModule directive
may be different in your installation -- look at other LoadModules to see.

    LoadModule speedycgi_module modules/mod_speedycgi.so
    AddModule mod_speedycgi.c

=back

=head2 Apache Configuration

Once mod_speedycgi is installed, it has to be configured to be used
for your perl scripts.  There are two methods.

Warning!  The instructions below may compromise the security
of your web site.  The security risks associated with SpeedyCGI are
similar to those of regular CGI.  If you don't understand the security
implications of the changes below then don't make them.

=over

=item 1. Path Configuration

This is similar to the way F</cgi-bin> works - everything under this
path is handled by SpeedyCGI.  Add the following lines near the top of
your httpd.conf - this will cause all scripts in your cgi-bin directory
to be handled by SpeedyCGI when they are accessed as F</speedy/script-name>.

    Alias /speedy/ /home/httpd/cgi-bin/
    <Location /speedy>
	SetHandler speedycgi-script
	Options ExecCGI
	allow from all
    </Location>

=item 2. File Extension Configuration

This will make SpeedyCGI handle all files with a certain extension,
similar to the way .cgi files work.  Add the following lines near the top
of your httpd.conf file - this will set up the file extension ".speedy"
to be handled by SpeedyCGI.

    AddHandler speedycgi-script .speedy
    <Location />
	Options ExecCGI
    </Location>

=back

=head1 BUGS / TODO

Please report any bugs or requests for changes to speedycgi@newlug.org.
The current bugs / todo list can be found at
http://www.sourceforge.net/projects/speedycgi/.
Go to the Bug Tracking menu and select the group "bug" for bugs,
or the group "rfe" for the todo list.

=head1 FREQUENTLY ASKED QUESTIONS

=over

=item How does the speedy front end connect to the back end process?

Via a Unix socket in F</tmp>.  A queue is kept in a shared file in F</tmp>
that holds an entry for each process.  In that queue are the pids of the perl
processes waiting for connections.  The CGI frontend pulls a process out of
this queue, connects to its socket, sends over the environment and argv,
and then uses this socket for stdin/stdout to the perl process.

=back

=over

=item If another request comes in while a CGI is running, does the client
have to wait or is another process started?  Is there a way to set a limit
on how many processes get started? 

If another request comes while all the perl processes are busy, then
another perl process is started.  Just like in CGI there is normally
no limit on how many processes get started.  But, the processes are
only started when the load is so high that they're necessary.  If the
load goes down, the processes will die off due to inactivity, unless you
disable the timeout.

Starting in version 1.8.3 an option was added to limit the number
of perl backends running.  See B<MaxBackends> in L<"Options Available">
above.

=back

=over

=item How much of perl's state is kept when speedy starts another request?
Do globals keep their values?  Are destructors run after the request? 

Globals keep their values.  Nothing is destroyed after the request.
STDIN/STDOUT/STDERR are closed -- other files are not.  C<%ENV>, C<@ARGV>, and
C<%SIG> are the only globals changed between requests.

=back

=over

=item How can I make sure speedy restarts when I edit a perl library used
by the CGI? 

Do a touch on the main cgi file that is executed.
The mtime on the main file is checked each time the front-end runs.

=back

=over

=item Do I need to be root to install and/or run SpeedyCGI?

No, root is not required.

=back

=over

=item How can I determine if my perl app needs to be changed to work with
speedy?  Or is there no modification necessary?

You may have to make modifications.

Globals retain their values between runs, which can be good for keeping
persistent database handles for example, or bad if your code assumes they're
undefined.

Also, if you create global variables with "my", you shouldn't try to
reference those variables from within a subroutine - you should pass them
into the subroutine instead.  Or better yet just declare global variables
with "use vars" instead of "my" to avoid the problem altogether.

Here's a good explanation of the problem - it's for mod_perl, but the same
thing applies to speedycgi:

    http://perl.apache.org/faq/mod_perl_cgi.html#Variables_retain_their_value_fro

If all else fails you can disable persistence by setting MaxRuns to 1.
The only benefit of this over normal perl is that speedy will pre-compile
your script between requests.

=back

=over

=item How do I keep a persistent connect to a database?

Since globals retain their values between runs, the best way to do this
is to store the connection in a global variable, then check on each
run to see if that variable is already defined.

For example, if your code has an "open_db_connection" subroutine that returns
a database connection handle, you can use the code below to keep a persistent
connection:

    use vars qw($dbh);
    unless (defined($dbh)) {
    	$dbh = &open_db_connection;
    }

This code will store a persistent database connection handle in the global
variable "$dbh" and only initialize it the first time the code is run.
During subsequent runs, the existing connection is re-used.

You may also want to check the connection each time before using it, in case
it is not working for some reason.  So, assuming you have a subroutine named
"db_connection_ok" that returns true if the db connection is working, you
can use code like this:

    use vars qw($dbh);
    unless (defined($dbh) && &db_connection_ok($dbh)) {
	$dbh = &open_db_connection;
    }

=back

=head1 MAILING LIST

The mailing list address is speedycgi@newlug.org.  Subscribe by
sending a message to speedycgi-request@newlug.org with the word
"subscribe" in the body.

An archive of the mailing list is at http://newlug.org/mailArchive/speedycgi/
and mirrored at http://daemoninc.com/SpeedyCGI/mailArchive/

=head1 DOWNLOADING

=head2 Binaries

Binaries for many OSes can be found at:

    http://daemoninc.com/SpeedyCGI/CGI-SpeedyCGI/binaries

There are also some older debian packages available from:

    http://www.debian.org/Packages/stable/interpreters/speedy-cgi-perl.html
    http://www.debian.org/Packages/unstable/web/libapache-mod-speedycgi.html

The debian packages are not based on the latest version of SpeedyCGI.

=head2 Source Code

The standard source code distribution can be retrieved from any CPAN mirror
or from:

    http://daemoninc.com/SpeedyCGI/download.html
    http://www.cpan.org/modules/by-authors/id/H/HO/HORROCKS/

The latest development code can be obtained from the SourceForge
CVS repository using the following commands:

 cvs -d:pserver:anonymous@cvs.SpeedyCGI.sourceforge.net:/cvsroot/SpeedyCGI login 
 cvs -z3 -d:pserver:anonymous@cvs.SpeedyCGI.sourceforge.net:/cvsroot/SpeedyCGI co 2.x

Press Enter when prompted for a password.

=head1 AUTHOR

    Sam Horrocks
    Daemon Consulting Inc.
    http://daemoninc.com
    sam@daemoninc.com

=head1 SEE ALSO

perl(1), httpd(8), apxs(8).

=head1 TRANSLATIONS

=over

=item Japanese

http://member.nifty.ne.jp/hippo2000/perltips/CGI/SpeedyCGI.htm

=back

=head1 COPYRIGHT

Copyright (C) 2001  Daemon Consulting Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut

