# Generated by default/object.tt
package Paws::IoTWireless::LoRaWANDeviceProfile;
  use Moose;
  has ClassBTimeout => (is => 'ro', isa => 'Int');
  has ClassCTimeout => (is => 'ro', isa => 'Int');
  has FactoryPresetFreqsList => (is => 'ro', isa => 'ArrayRef[Int]');
  has MacVersion => (is => 'ro', isa => 'Str');
  has MaxDutyCycle => (is => 'ro', isa => 'Int');
  has MaxEirp => (is => 'ro', isa => 'Int');
  has PingSlotDr => (is => 'ro', isa => 'Int');
  has PingSlotFreq => (is => 'ro', isa => 'Int');
  has PingSlotPeriod => (is => 'ro', isa => 'Int');
  has RegParamsRevision => (is => 'ro', isa => 'Str');
  has RfRegion => (is => 'ro', isa => 'Str');
  has RxDataRate2 => (is => 'ro', isa => 'Int');
  has RxDelay1 => (is => 'ro', isa => 'Int');
  has RxDrOffset1 => (is => 'ro', isa => 'Int');
  has RxFreq2 => (is => 'ro', isa => 'Int');
  has Supports32BitFCnt => (is => 'ro', isa => 'Bool');
  has SupportsClassB => (is => 'ro', isa => 'Bool');
  has SupportsClassC => (is => 'ro', isa => 'Bool');
  has SupportsJoin => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::LoRaWANDeviceProfile

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::LoRaWANDeviceProfile object:

  $service_obj->Method(Att1 => { ClassBTimeout => $value, ..., SupportsJoin => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::LoRaWANDeviceProfile object:

  $result = $service_obj->Method(...);
  $result->Att1->ClassBTimeout

=head1 DESCRIPTION

LoRaWANDeviceProfile object.

=head1 ATTRIBUTES


=head2 ClassBTimeout => Int

The ClassBTimeout value.


=head2 ClassCTimeout => Int

The ClassCTimeout value.


=head2 FactoryPresetFreqsList => ArrayRef[Int]

The list of values that make up the FactoryPresetFreqs value.


=head2 MacVersion => Str

The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this
device profile.


=head2 MaxDutyCycle => Int

The MaxDutyCycle value.


=head2 MaxEirp => Int

The MaxEIRP value.


=head2 PingSlotDr => Int

The PingSlotDR value.


=head2 PingSlotFreq => Int

The PingSlotFreq value.


=head2 PingSlotPeriod => Int

The PingSlotPeriod value.


=head2 RegParamsRevision => Str

The version of regional parameters.


=head2 RfRegion => Str

The frequency band (RFRegion) value.


=head2 RxDataRate2 => Int

The RXDataRate2 value.


=head2 RxDelay1 => Int

The RXDelay1 value.


=head2 RxDrOffset1 => Int

The RXDROffset1 value.


=head2 RxFreq2 => Int

The RXFreq2 value.


=head2 Supports32BitFCnt => Bool

The Supports32BitFCnt value.


=head2 SupportsClassB => Bool

The SupportsClassB value.


=head2 SupportsClassC => Bool

The SupportsClassC value.


=head2 SupportsJoin => Bool

The SupportsJoin value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

