# Generated by default/object.tt
package Paws::CloudWatchEvents::Connection;
  use Moose;
  has AuthorizationType => (is => 'ro', isa => 'Str');
  has ConnectionArn => (is => 'ro', isa => 'Str');
  has ConnectionState => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastAuthorizedTime => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has StateReason => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::Connection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::Connection object:

  $service_obj->Method(Att1 => { AuthorizationType => $value, ..., StateReason => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::Connection object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationType

=head1 DESCRIPTION

Contains information about a connection.

=head1 ATTRIBUTES


=head2 AuthorizationType => Str

The authorization type specified for the connection.


=head2 ConnectionArn => Str

The ARN of the connection.


=head2 ConnectionState => Str

The state of the connection.


=head2 CreationTime => Str

A time stamp for the time that the connection was created.


=head2 LastAuthorizedTime => Str

A time stamp for the time that the connection was last authorized.


=head2 LastModifiedTime => Str

A time stamp for the time that the connection was last modified.


=head2 Name => Str

The name of the connection.


=head2 StateReason => Str

The reason that the connection is in the connection state.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

