# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableBillingModeSummary;
  use Moose;
  has BillingMode => (is => 'ro', isa => 'Str');
  has LastUpdateToPayPerRequestDateTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableBillingModeSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableBillingModeSummary object:

  $service_obj->Method(Att1 => { BillingMode => $value, ..., LastUpdateToPayPerRequestDateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableBillingModeSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BillingMode

=head1 DESCRIPTION

Provides information about the billing for read/write capacity on the
table.

=head1 ATTRIBUTES


=head2 BillingMode => Str

The method used to charge for read and write throughput and to manage
capacity.


=head2 LastUpdateToPayPerRequestDateTime => Str

If the billing mode is C<PAY_PER_REQUEST>, indicates when the billing
mode was set to that value.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

