#!inc/bin/testml-cpan


=>
  *grammar1.bootstrap-compile.yaml == *grammar2.bootstrap-compile.yaml
    :"+ (bootstrap compile)"

  *grammar1.compile.yaml == *grammar2.compile.yaml
    :"+ (pegex compile)"


=== Simple Test Case
--- grammar1
a: /x/
--- grammar2
a:
    /x/


=== Token Per Line
--- SKIP: TODO
--- grammar1
a: /b/
--- grammar2
a
:
/b/


=== And over Or Precedence
--- grammar1
a: b c | d
--- grammar2
a: ( b c ) | d


=== And/Or Precedence with joining
--- grammar1
a: b % c | d %% e
--- grammar2
a: ( b % c ) | ( d %% e )


=== And/Or Precedence with grouping
--- grammar1
a:
     b c
   | (
        d
      | e
      | f g h i
   )
--- grammar2
a: ( b c ) | ( d | e | ( f g h i ) )


=== Extra Leading Pipe
--- grammar1
a: | b | c
--- grammar2
a: b | c


=== Extra Leading Pipe w/ Parens
--- grammar1
a: (
  | b
  | c
)
--- grammar2
a: b | c


=== In-Line Comments
--- grammar1
a:  # test
    b c  # not d
    /q/  # skipping to q
    % e  # using e here...
    ;    # comment -> semicolon test
--- grammar2
a: b c /q/ % e


=== Dashes in names
--- grammar1
a-a: b-b+ c-c
b_b: c_c-c /d/
c-c_c: e
--- grammar2
a_a: b_b+ c_c
b-b: c-c_c /d/
c_c_c: e


=== Whitespace Tokens
--- grammar1
a: - b + c -
b: /- cat + dog -/
--- grammar2
a: _ b __ c _
b: /<_> cat <__> dog <_>/


=== Regex Combination
--- SKIP: TODO
--- grammar1: a: /b/ /c/
--- grammar2: a: /bc/


=== Separator Reduction a % b
--- grammar1
x: a % b
--- grammar2
x: a


=== Separator Reduction a %% b
--- grammar1
x: a %% b
--- grammar2
x: a b?


=== Separator Reduction a? % b
--- grammar1
x: a? % b
--- grammar2
x: a?


=== Separator Reduction a? %% b
--- grammar1
x: a? %% b
--- grammar2
x: a? b?


=== Separator Reduction a* % b
--- grammar1
x: a* % b
--- grammar2
x: (a -(b a)*)?


=== Separator Reduction a* %% b
--- grammar1
x: a* %% b
--- grammar2
x: (a -(b a)* b?)?


=== Separator Reduction a+ % b
--- grammar1
x: a+ % b
--- grammar2
x: a -(b a)*


=== Separator Reduction a+ %% b
--- grammar1
x: a+ %% b
--- grammar2
x: a -(b a)* b?


=== Separator Reduction <a>3 % b
--- grammar1
x: <a>3 % b
--- grammar2
x: a -(b a)2


=== Separator Reduction <a>3 %% b
--- grammar1
x: <a>3 %% b
--- grammar2
x: a -(b a)2 b?


=== Separator Reduction <a>3+ % b
--- grammar1
x: <a>3+ % b
--- grammar2
x: a -(b a)2+


=== Separator Reduction <a>3+ %% b
--- grammar1
x: <a>3+ %% b
--- grammar2
x: a -(b a)2+ b?


=== Separator Reduction <a>3-7 % b
--- grammar1
x: <a>3-7 % b
--- grammar2
x: a -(b a)2-6


=== Separator Reduction <a>3-7 %% b
--- grammar1
x: <a>3-7 %% b
--- grammar2
x: a -(b a)2-6 b?


=== Leading WS, mulitline regex
--- grammar1
a: /-
  'foo'
/
--- grammar2
a: /- 'foo'/


=== Leading WS, mulitline regex (part2)
--- grammar1
a: /-
  'foo'
/
--- grammar2
a: /-foo/


=== No parens around a regex to add modifiers
--- grammar1
a: ./ (b) /
--- grammar2
a: .(/ (b) /)
