package WebService::Chroma::Embeddings::OpenAI;

use Moo;
use OpenAI::API;

has ai => (
        is => 'ro',
        default => sub {
                OpenAI::API->new();
        }
);

sub get {
        my ($self, $data) = @_;

        my $res = $self->ai->embeddings(
                model => 'text-embedding-3-large',
                input => $data
        );

        my $embedding = $res->{data}->[0]->{embedding};

        if ($embedding && scalar @{$embedding}) {
                return $embedding;
        }

        die 'error retrieving embeddings';
}

1;
