# Generated by default/object.tt
package Paws::CloudFront::CachePolicyList;
  use Moose;
  has Items => (is => 'ro', isa => 'ArrayRef[Paws::CloudFront::CachePolicySummary]', request_name => 'CachePolicySummary', traits => ['NameInRequest']);
  has MaxItems => (is => 'ro', isa => 'Int', required => 1);
  has NextMarker => (is => 'ro', isa => 'Str');
  has Quantity => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::CachePolicyList

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::CachePolicyList object:

  $service_obj->Method(Att1 => { Items => $value, ..., Quantity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::CachePolicyList object:

  $result = $service_obj->Method(...);
  $result->Att1->Items

=head1 DESCRIPTION

A list of cache policies.

=head1 ATTRIBUTES


=head2 Items => ArrayRef[L<Paws::CloudFront::CachePolicySummary>]

Contains the cache policies in the list.


=head2 B<REQUIRED> MaxItems => Int

The maximum number of cache policies requested.


=head2 NextMarker => Str

If there are more items in the list than are in this response, this
element is present. It contains the value that you should use in the
C<Marker> field of a subsequent request to continue listing cache
policies where you left off.


=head2 B<REQUIRED> Quantity => Int

The total number of cache policies returned in the response.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

