use 5.006;
use ExtUtils::MakeMaker;
use ExtUtils::Constant qw (WriteConstants);
use Config;

# Fiddle with flags depending on platform.

my @flags;

if ($^O eq 'darwin') {
        push @flags,(
                LIBS => '-lGL -lGLU',
                LDDLFLAGS => $Config{lddlflags} . qq( -framework GLUT ),
                INC => '-FGLUT',
        );
} elsif ($^O eq 'irix') {
        push @flags,(
                LIBS => '-L/usr/freeware/lib32 '
                        . '-lglut -lGL -lGLU -lX11 -lXmu -lXi',
                INC => '-I/usr/freeware/include',
        );
} else {
        # Default configuration
        push @flags,(
                LIBS => '-lglut',
        );
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'OpenGL::Simple::GLUT',
    'VERSION_FROM'	=> 'GLUT.pm', # finds $VERSION
    'PREREQ_PM'		=> { ExtUtils::Constant => 0,
                        },
    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM => 'GLUT.pm', # retrieve abstract from module
       AUTHOR     => 'Jonathan Chin <jon-opengl-simple-glut@earth.li>') : ()
    ),
    @flags
);

WriteConstants(
	NAME => 'OpenGL::Simple::GLUT',
	NAMES => [qw(

		GLUT_RGBA GLUT_RGB GLUT_INDEX 
		GLUT_SINGLE GLUT_DOUBLE
		GLUT_ACCUM GLUT_ALPHA GLUT_DEPTH GLUT_STENCIL
		GLUT_MULTISAMPLE GLUT_STEREO GLUT_LUMINANCE

		GLUT_CURSOR_RIGHT_ARROW
		GLUT_CURSOR_LEFT_ARROW
		GLUT_CURSOR_INFO
		GLUT_CURSOR_DESTROY
		GLUT_CURSOR_HELP
		GLUT_CURSOR_CYCLE
		GLUT_CURSOR_SPRAY
		GLUT_CURSOR_WAIT
		GLUT_CURSOR_TEXT
		GLUT_CURSOR_CROSSHAIR
		GLUT_CURSOR_UP_DOWN
		GLUT_CURSOR_LEFT_RIGHT
		GLUT_CURSOR_TOP_SIDE
		GLUT_CURSOR_BOTTOM_SIDE
		GLUT_CURSOR_LEFT_SIDE
		GLUT_CURSOR_RIGHT_SIDE
		GLUT_CURSOR_TOP_LEFT_CORNER
		GLUT_CURSOR_TOP_RIGHT_CORNER
		GLUT_CURSOR_BOTTOM_RIGHT_CORNER
		GLUT_CURSOR_BOTTOM_LEFT_CORNER
		GLUT_CURSOR_FULL_CROSSHAIR
		GLUT_CURSOR_NONE
		GLUT_CURSOR_INHERIT

		GLUT_NORMAL GLUT_OVERLAY

		GLUT_WINDOW_X GLUT_WINDOW_Y
		GLUT_WINDOW_WIDTH GLUT_WINDOW_HEIGHT
		GLUT_WINDOW_BUFFER_SIZE
		GLUT_WINDOW_STENCIL_SIZE
		GLUT_WINDOW_DEPTH_SIZE
		GLUT_WINDOW_RED_SIZE GLUT_WINDOW_GREEN_SIZE
		GLUT_WINDOW_BLUE_SIZE GLUT_WINDOW_ALPHA_SIZE
		GLUT_WINDOW_ACCUM_RED_SIZE
		GLUT_WINDOW_ACCUM_GREEN_SIZE
		GLUT_WINDOW_ACCUM_BLUE_SIZE
		GLUT_WINDOW_ACCUM_ALPHA_SIZE
		GLUT_WINDOW_DOUBLEBUFFER
		GLUT_WINDOW_RGBA
		GLUT_WINDOW_PARENT
		GLUT_WINDOW_NUM_CHILDREN
		GLUT_WINDOW_COLORMAP_SIZE
		GLUT_WINDOW_NUM_SAMPLES
		GLUT_WINDOW_STEREO
		GLUT_WINDOW_CURSOR
		GLUT_SCREEN_WIDTH
		GLUT_SCREEN_HEIGHT
		GLUT_SCREEN_WIDTH_MM
		GLUT_SCREEN_HEIGHT_MM
		GLUT_MENU_NUM_ITEMS
		GLUT_DISPLAY_MODE_POSSIBLE
		GLUT_INIT_DISPLAY_MODE
		GLUT_INIT_WINDOW_X GLUT_INIT_WINDOW_Y
		GLUT_INIT_WINDOW_WIDTH GLUT_INIT_WINDOW_HEIGHT
		GLUT_ELAPSED_TIME

		GLUT_OVERLAY_POSSIBLE
		GLUT_LAYER_IN_USE
		GLUT_HAS_OVERLAY
		GLUT_TRANSPARENT_INDEX
		GLUT_NORMAL_DAMAGED
		GLUT_OVERLAY_DAMAGED

		GLUT_HAS_KEYBOARD
		GLUT_HAS_MOUSE
		GLUT_HAS_SPACEBALL
		GLUT_HAS_DIAL_AND_BUTTON_BOX
		GLUT_HAS_TABLET
		GLUT_NUM_MOUSE_BUTTONS
		GLUT_NUM_SPACEBALL_BUTTONS
		GLUT_NUM_BUTTON_BOX_BUTTONS
		GLUT_NUM_DIALS
		GLUT_NUM_TABLET_BUTTONS

		GLUT_ACTIVE_SHIFT
		GLUT_ACTIVE_CTRL
		GLUT_ACTIVE_ALT

		GLUT_LEFT_BUTTON GLUT_MIDDLE_BUTTON GLUT_RIGHT_BUTTON

		GLUT_KEY_F1 GLUT_KEY_F2 GLUT_KEY_F3
		GLUT_KEY_F4 GLUT_KEY_F5 GLUT_KEY_F6
		GLUT_KEY_F7 GLUT_KEY_F8 GLUT_KEY_F9
		GLUT_KEY_F10 GLUT_KEY_F11 GLUT_KEY_F12
		GLUT_KEY_LEFT GLUT_KEY_UP GLUT_KEY_RIGHT GLUT_KEY_DOWN
		GLUT_KEY_PAGE_UP GLUT_KEY_PAGE_DOWN 
		GLUT_KEY_HOME GLUT_KEY_END GLUT_KEY_INSERT

		GLUT_UP GLUT_DOWN
		GLUT_LEFT GLUT_ENTERED

                GLUT_MENU_NOT_IN_USE GLUT_MENU_IN_USE 

                GLUT_NOT_VISIBLE GLUT_VISIBLE 

                GLUT_HIDDEN GLUT_FULLY_RETAINED 
                GLUT_PARTIALLY_RETAINED GLUT_FULLY_COVERED 

                GLUT_RED GLUT_GREEN GLUT_BLUE 

                GLUT_STROKE_ROMAN GLUT_STROKE_MONO_ROMAN
                GLUT_BITMAP_9_BY_15 GLUT_BITMAP_8_BY_13
                GLUT_BITMAP_TIMES_ROMAN_10 GLUT_BITMAP_TIMES_ROMAN_24

	)]
);
