package File::Extension;

use strict;
use warnings FATAL => 'all';

# populated in BEGIN block
my %ext;


sub extplain {
  my $extension = lc(shift);

  # if provided like .nes
  $extension =~ s/^[.]?//;

  return $ext{$extension};
}

#< begin
BEGIN {
  use Exporter;
  use vars qw($VERSION @ISA @EXPORT_OK %EXPORT_TAGS);
  @ISA = qw(Exporter);

  $VERSION = '0.004';

  @EXPORT_OK = qw(extplain);

  %ext = (
    '!bt'          => 'BitTorrent Incomplete Download File',
    '!qb'          => 'qBittorrent Partial Download File',
    '!sync'        => 'BitTorrent Partially Synced File',
    '!ut'          => 'uTorrent Incomplete Download',
    '$$$'          => 'Temporary File',
    '$01'          => 'DOS Pipe File',
    '$db'          => 'dBASE Temporary File',
    '$er'          => 'GroupWise Database',
    '0'            => 'Shared Library Link File',
    '00'           => 'The Ur-Quan Masters Saved Game Slot 0 File',
    '000'          => 'Indexing Service Data File',
    '001'          => 'Fax File',
    '002'          => 'Split Archive Part 2 File',
    '003'          => 'Split Archive Part 3 File',
    '0cc'          => '0CC-FamiTracker Module',
    '0xe'          => 'F-Secure Renamed Virus File',
    '1'            => 'Unix Section 1 Man Page',
    '113'          => 'Iomega Backup File',
    '123'          => 'PCB123 Circuit Board Design',
    '123c'         => 'Autodesk 123C Drawing',
    '123d'         => 'Autodesk 123D Drawing',
    '123dx'        => '123D Design Model File',
    '12m'          => 'Lotus 1-2-3 SmartMaster File',
    '17t'          => '2017 StudioTax Return File',
    '1pe'          => 'TurboTax Form File',
    '1ph'          => 'TurboTax File',
    '1st'          => 'Readme File',
    '208'          => 'ASUS Notebook BIOS 208 Update File',
    '256'          => 'Descent 2 Color Palette File',
    '264'          => 'Ripped Video Data File',
    '2bp'          => 'Pocket PC Bitmap Image File',
    '2d'           => 'VersaCAD 2D Drawing File',
    '2fs'          => 'Puppy Linux Save State File',
    '2mg'          => 'Apple IIGS Disk Image',
    '2sf'          => 'Nintendo DS Sound File',
    '2sflib'       => 'Nintendo DS Audio Library File',
    '323'          => 'H.323 Internet Telephony File',
    '32x'          => 'Sega 32X ROM',
    '360'          => '360desktop Panorama File',
    '386'          => 'Windows Virtual Device Driver',
    '3d'           => 'Stereo CAD-3D Image File',
    '3d2'          => 'Stereo CAD-3D 2.0 Image File',
    '3d4'          => 'Stereo CAD-3D 2.0 Image File',
    '3da'          => '3D Assembly File',
    '3dc'          => '3DCrafter Scene File',
    '3dd'          => 'ArcGlobe Document',
    '3df'          => '3D Format',
    '3dl'          => 'Sierra LandDesigner 3D File',
    '3dm'          => 'Rhino 3D Model',
    '3dmdef'       => '3DMark Definition File',
    '3dmf'         => 'QuickDraw 3D Metafile',
    '3dmk'         => '123D Make Project File',
    '3don'         => 'Scrutinize 3D Mesh File',
    '3dp'          => '3DMark2011 SE Project File',
    '3dr'          => '3D Rad Project File',
    '3ds'          => 'Nintendo 3DS ROM',
    '3dsx'         => 'Homebrew Launcher File',
    '3dt'          => '3D Topicscape File',
    '3dv'          => '3D VRML World',
    '3dw'          => 'Studio Store Visualizer 3D Environment File',
    '3dx'          => 'Rhino 3D Model File',
    '3dxml'        => 'Dassault Systemes 3D XML File',
    '3dz'          => 'Nintendo 3DS ROM',
    '3fr'          => 'Hasselblad 3F RAW Image',
    '3fs'          => 'Puppy Linux Save State File',
    '3g2'          => '3GPP2 Multimedia File',
    '3ga'          => '3GPP Audio File',
    '3gp'          => '3GPP Multimedia File',
    '3gp2'         => '3GPP Multimedia File',
    '3gpa'         => '3GPP Multimedia File',
    '3gpp'         => '3GPP Media File',
    '3gpp2'        => '3GPP2 Multimedia File',
    '3me'          => 'TurboTax Form File',
    '3mf'          => '3D Manufacturing File',
    '3mm'          => '3D Movie Maker Movie Project',
    '3p2'          => '3GPP Multimedia File',
    '3pe'          => 'TurboTax 2008 Form File',
    '3w'           => 'XYZprinting Sliced Model File',
    '411'          => 'Mavica Thumbnail Image',
    '477'          => 'MNS Shape Definition Companion File',
    '4db'          => '4th Dimension Database Structure File',
    '4dd'          => '4th Dimension Database Data File',
    '4dl'          => '4th Dimension Database Log File',
    '4dv'          => '4D View Ultrasound File',
    '4fs'          => 'Puppy Linux Save State File',
    '4mp'          => '4-MP3 Database File',
    '4th'          => 'Forth Language File',
    '4ui'          => 'ForeUI Plot File',
    '555'          => 'Black & White Weather Settings File',
    '5vw'          => '5View Packet Capture File',
    '5xb'          => 'Line 6 POD HD500X Edit Bundle',
    '5xe'          => 'Line 6 POD HD500X Edit Preset File',
    '5xs'          => 'Line 6 POD HD500X Edit Setlist File',
    '602'          => 'Text602 Document',
    '60d'          => 'CCTV Video Clip',
    '669'          => 'UNIS Composer 669 Module',
    '68k'          => 'SEGA Mega Drive & Genesis Classics ROM File',
    '6cm'          => 'Six Channel Module',
    '73b'          => 'TI-73 Backup File',
    '73c'          => 'TI-73 Constant File',
    '73i'          => 'TI-73 Screenshot File',
    '73k'          => 'TI-73 Application',
    '73l'          => 'TI-73 Data List File',
    '73u'          => 'TI-73 Explorer Operating System File',
    '787'          => 'AVTECH CCTV Video File',
    '7z'           => '7-Zip Compressed File',
    '7z.001'       => '7-Zip Split Archive Part 1 File',
    '7z.002'       => '7-Zip Split Archive Part 2 File',
    '83p'          => 'TI-83 Calculator File',
    '890'          => 'Cavena Subtitles File',
    '89k'          => 'TI-89 Application',
    '8ba'          => 'Photoshop Plug-in',
    '8bc'          => 'Photoshop 5.0 Plug-in',
    '8be'          => 'PhotoDeluxe Plug-in',
    '8bf'          => 'Photoshop Filter Plug-in',
    '8bi'          => 'Photoshop Plug-in',
    '8bi8'         => 'Photoshop Plug-in',
    '8bl'          => 'Photoshop Plug-in',
    '8bs'          => 'Photoshop 5.0 Selection Plug-in',
    '8bx'          => 'PhotoDeluxe Plug-in',
    '8by'          => 'PhotoDeluxe Plug-in',
    '8ca'          => 'TI-84 Plus C Image Var Format',
    '8ci'          => 'TI-84 Plus C Pic Vars Format',
    '8ck'          => 'TI-84 Plus C Silver Edition Application File',
    '8cm'          => 'Eight Channel Module',
    '8cu'          => 'TI-84 Plus C Operating System File',
    '8ld'          => 'Overlord 2 Language File',
    '8li'          => 'Photoshop Scripting Plug-in',
    '8med'         => 'Amiga OctaMed Music File',
    '8pbs'         => 'Adobe Photoshop Macintosh File',
    '8st'          => '8start Launcher File',
    '8svx'         => 'Amiga 8-Bit Sound File',
    '8xg'          => 'TI-83/84 Plus Group File',
    '8xi'          => 'TI-83/84 Plus Picture File',
    '8xk'          => 'TI-83 Plus Application Upgrade File',
    '8xp'          => 'TI-83 Plus Calculator File',
    '8xs'          => 'TI-83/84 Plus String File',
    '8xu'          => 'TI-83 and TI-84 Plus Operating System File',
    '8xv'          => 'TI-83/84 Plus Variable File',
    '9.png'        => 'NinePatchDrawable Image',
    '^^^'          => 'Pervasive.SQL Database File',
    '__a'          => 'File Splitter & Joiner Encrypted File',
    '__b'          => 'File Splitter & Joiner Encrypted Archive File',
    '_doc'         => 'Renamed Microsoft Word Document',
    '_docx'        => 'Renamed Microsoft Word Open XML Document',
    '_eml'         => 'Windows Live Mail Email File',
    '_nws'         => 'Windows Live Mail Newsgroup Copy File',
    '_playmusicid' => 'Google Play Music ID File',
    '_sys.lfo'     => 'Adware File',
    '_xls'         => 'Renamed Microsoft Excel Spreadsheet',
    '_xlsx'        => 'Renamed Microsoft Excel Open XML Spreadsheet',
    'a'            => 'Static Library',
    'a00'          => 'ALZip Second Split Archive File',
    'a01'          => 'ALZip Third Split Archive File',
    'a02'          => 'ALZip Fourth Split Archive File',
    'a1wish'       => 'Audials Wishlist File',
    'a26'          => 'Atari 2600 ROM',
    'a2b'          => 'Adlib Tracker II Instrument Bank',
    'a2c'          => 'Alice Object File',
    'a2i'          => 'Adlib Tracker II Instrument File',
    'a2l'          => 'ASAP2 ECU Description File',
    'a2m'          => 'TS-AudioToMIDI Settings File',
    'a2p'          => 'Adlib Tracker II Pattern File',
    'a2t'          => 'Adlib Tracker II Tiny Module File',
    'a2theme'      => 'Aston 2 Theme File',
    'a2w'          => 'Adlib Tracker II Instrument Bank with',
    'a3d'          => 'Alternativa Player 3D Export File',
    'a3l'          => 'Authorware 3 Library',
    'a3m'          => 'Authorware 3 Macintosh File',
    'a3w'          => 'Authorware 3 Windows File',
    'a3x'          => 'Compiled AutoIt v3 Script',
    'a4l'          => 'Authorware 4 Library',
    'a4m'          => 'Authorware 4 Macintosh File',
    'a4p'          => 'A4Desk Pro Project File',
    'a4w'          => 'Authorware 4 Windows File',
    'a52'          => 'Dolby Digital Audio File',
    'a5l'          => 'Authorware 5 Library',
    'a5rpt'        => 'Alpha Five Project Report File',
    'a5w'          => 'Authorware 5 Windows File',
    'a5wcmp'       => 'Alpha Five Web Components File',
    'a65'          => 'Authorware 6.5 File',
    'a6p'          => 'Authorware 6 Program',
    'a78'          => 'Atari 7800 ROM',
    'a7d'          => 'Authorware 7 Model',
    'a7l'          => 'Authorware 7 Library',
    'a7p'          => 'Authorware 7 Project',
    'a7r'          => 'Authorware 7 Runtime File',
    'a8s'          => 'Anim8or Script',
    'aa'           => 'Generic CD Image',
    'aa3'          => 'ATRAC Audio File',
    'aac'          => 'Advanced Audio Coding File',
    'aae'          => 'Sidecar Image Edit File',
    'aaf'          => 'Advanced Authoring Format File',
    'aam'          => 'Authorware Map File',
    'aan'          => 'Pro Tools Elastic Audio Analysis File',
    'aao'          => 'Agenda At Once File',
    'aar'          => 'Android Archive',
    'aaui'         => 'Acrobat User Interface File',
    'aawdef'       => 'Ad-Aware Definitions File',
    'aax'          => 'Audible Enhanced Audiobook File',
    'aaxplugin'    => 'Avid Audio eXtension Plugin File',
    'ab'           => 'DNA Sequence File',
    'ab1'          => 'DNA Electropherogram File',
    'ab2'          => 'Print Shop Address Book File',
    'ab3'          => 'PhotoImpact 3 Album File',
    'aba'          => 'Avant Browser Add-on File',
    'abbu'         => 'Address Book Backup',
    'abc'          => 'Micrografx ABC FlowCharter 6 File',
    'abcd'         => 'AudioVisual Book Data File',
    'abcddb'       => 'Apple Address Book Contact List',
    'abcdp'        => 'Address Book CoreData Person File',
    'abdata'       => 'Adobe Bridge Data File',
    'abf'          => 'Adobe Binary Screen Font File',
    'abi'          => 'AbiWord Plug-in',
    'abk'          => 'Arena Opening Book File',
    'abkprj'       => 'Ashampoo Backup Project',
    'abm'          => 'Music Album',
    'abp'          => 'AVS Barcode Profile',
    'abr'          => 'Adobe Photoshop Brushes File',
    'abs'          => 'AB SuDoKu Saved Game',
    'abt'          => 'Annotated Braille Text File',
    'abu'          => 'Asus App Backup File',
    'abu1'         => 'ASUS Backup File',
    'abw'          => 'AbiWord Document',
    'abx'          => 'WordPerfect Address Book',
    'aby'          => 'AOL Address Book File',
    'ac$'          => 'AutoCAD Temporary File',
    'ac'           => 'AC3D 3D File',
    'ac3'          => 'Audio Codec 3 File',
    'ac5'          => 'ArtCut 5 Document',
    'ac6'          => 'ArtCut 6 Document',
    'aca'          => 'Agent Character Animation File',
    'acb'          => 'ADX Audio Package File',
    'acbl'         => 'Adobe Color Book Legacy File',
    'acc'          => 'GEM Accessory File',
    'accda'        => 'Access Add-in File',
    'accdb'        => 'Access 2007 Database File',
    'accdc'        => 'Microsoft Access Signed Package',
    'accde'        => 'Access Execute Only Database',
    'accdr'        => 'Access Runtime Application',
    'accdt'        => 'Microsoft Access Database Template',
    'accdu'        => 'Access Add-in File',
    'accdw'        => 'Microsoft Access Database Link File',
    'accft'        => 'Microsoft Access Data Type Template',
    'accountpictu' => 'E\'-MS        Windows 8 Account Picture File',
    'acd'          => 'RSLogix 5000 Program',
    'acd-bak'      => 'MAGIX ACID Project Backup File',
    'acd-zip'      => 'Sony ACID Project With Embedded Media File',
    'ace'          => 'WinAce Compressed File',
    'acelive'      => 'Acelive Broadcast File',
    'acf'          => 'Adobe Photoshop Custom Filter File',
    'acfm'         => 'Adobe Composite Font Metrics File',
    'acg'          => 'Agent Preview File',
    'acid'         => 'ACID Encrypted File',
    'acl'          => 'AutoCorrect List File',
    'acm'          => 'Interplay Audio File',
    'aco'          => 'Adobe Photoshop Color Swatch File',
    'acorn'        => 'Acorn Image',
    'acp'          => 'aacPlus Audio File',
    'acq'          => 'AcqKnowledge Data Graph File',
    'acr'          => 'American College of Radiology File',
    'acrobatsecur' => 'T\'YSETTINGS  Adobe Acrobat Security Settings File',
    'acrodata'     => 'Acrobat Data File',
    'acroplugin'   => 'Adobe Acrobat Plug-in',
    'acs'          => 'Agent Character File',
    'acs2'         => 'AIMP Skin File',
    'acs3'         => 'AIMP Skin File',
    'acsm'         => 'Adobe Content Server Message File',
    'act'          => 'DS Game Maker Action File',
    'actc'         => 'Action(s) Collection File',
    'action'       => 'Automator Action',
    'actm'         => 'AutoCAD Action Macro File',
    'actx'         => 'DS Game Maker Action Description File',
    'acv'          => 'Photoshop Curves File',
    'acw'          => 'Windows Accessibility Wizard File',
    'acww'         => 'Animal Crossing Wild World Pattern File',
    'acx'          => 'Atari ST Program',
    'acz'          => 'AppCraft Project',
    'ad'           => 'After Dark Screensaver',
    'ada'          => 'Ada Source Code',
    'adadownload'  => 'Adobe Download Assistant Partial Download',
    'adb'          => 'Now Contact Address Book Template',
    'adblock'      => 'Alpha Five Library Temporary File',
    'adc'          => 'Scanstudio 16 Color Image',
    'adcp'         => 'Adobe Device Central Project File',
    'add'          => 'Dynamics AX Developer Documentation File',
    'addin'        => 'Visual Studio Add-in Definition File',
    'addism'       => 'Addism Data File',
    'addon'        => 'CFS Console Add-on File',
    'ade'          => 'Access Project Extension',
    'adf'          => 'ARIS Express Document',
    'adg'          => 'Ableton Device Group',
    'adi'          => 'AutoCAD Device-Independent Binary Plotter',
    'adicht'       => 'LabChart Data File',
    'adidat'       => 'ADInstruments Simple Data File',
    'adif'         => 'Amateur Data Interchange Format',
    'adm'          => 'Portfolio Admin-Level Access Flag',
    'adml'         => 'Group Policy Language-Specific',
    'admx'         => 'Group Policy Administrative Template File',
    'adn'          => 'Access Blank Project Template',
    'ado'          => 'Adobe Photoshop Duotone Options File',
    'adobebridge'  => 'Adobe Bridge URL FIle',
    'adoc'         => 'AsciiDoc File',
    'adox'         => 'ActivDox Document',
    'adp'          => 'Access Project',
    'adpp'         => 'Adobe Device Profile Package',
    'adr'          => 'Opera Bookmarks File',
    'ads'          => 'Ada Specification File',
    'adt'          => 'AutoCAD Audit Log',
    'adts'         => 'Audio Data Transport Stream File',
    'adu'          => 'Addict User Dictionary File',
    'adv'          => 'Audio Driver File',
    'advs'         => 'Adobe Device Central Device Set',
    'adx'          => 'ADX Audio File',
    'adz'          => 'Compressed Amiga Disk File',
    'aea'          => 'Ae Timer Alarm Document',
    'aec'          => 'Cinema 4D After Effects Composition',
    'aecache'      => 'After Effects Cache File',
    'aecap'        => 'After Effects Text Template',
    'aegraphic'    => 'Adobe After Effects Graphic',
    'aep'          => 'Activ E-Book Project',
    'aepkey'       => 'Advanced Encryption Package Key File',
    'aepx'         => 'After Effects XML Project',
    'aes'          => 'ooVoo Log File',
    'aet'          => 'After Effects Project Template',
    'aetx'         => 'After Effects XML Project Template',
    'aex'          => 'After Effects Plug-in',
    'af2'          => 'Micrografx ABC FlowCharter 2 File',
    'af3'          => 'Micrografx ABC FlowCharter 3/4 File',
    'afc'          => 'Mass Effect 2 Audio File',
    'afd'          => 'AFF Disk Image Part File',
    'afdesign'     => 'Affinity Design Document',
    'afe'          => 'Avid File Exchange File',
    'aff'          => 'Spellcheck Dictionary Description File',
    'afi'          => 'AOMEI Backupper File Backup File',
    'afm'          => 'AFF Metadata File',
    'afp'          => 'Advanced Function Presentation File',
    'afphoto'      => 'Affinity Photo Document',
    'afploc'       => 'Apple Filing Protocol Location',
    'afs'          => 'STAAD.foundation Project File',
    'aft'          => 'Ancestry.com Family Tree Database',
    'afx'          => 'Auto FX PhotoGraphic Edges Image',
    'afzplug'      => 'AfterShot Pro Plugin Archive',
    'agb'          => 'Game Boy Advance ROM',
    'agd'          => 'Agile Advantage E-mail Attachment',
    'age3rec'      => 'Age of Empires 3 Recording',
    'age3sav'      => 'Age of Empires 3 Save File',
    'age3scn'      => 'Age of Empires 3 Scenario File',
    'age3xrec'     => 'Age of Empires 3: The WarChiefs Recording',
    'age3xsav'     => 'Age of Empires 3: The WarChiefs Save File',
    'age3yrec'     => 'Age of Empires 3: The Asian Dynasties',
    'age3ysav'     => 'Age of Empires 3: The Asian Dynasties Save',
    'agg'          => 'AggFlow 6 Project',
    'aggr'         => 'Adobe Captivate Aggregate File',
    'agi'          => 'Asterisk Gateway Interface File',
    'agif'         => 'Active GIF Creator Project',
    'aglib'        => 'Adobe Lightroom Library',
    'agm'          => 'DTS Multi-channel Pro Packer File',
    'agmodule'     => 'Adobe Lightroom Module',
    'agp'          => 'ArtGem Project File',
    'agr'          => 'Ableton Groove File',
    'agtemplate'   => 'Adobe Lightroom Template',
    'agtoolkit'    => 'Adobe Lightroom Toolkit',
    'agx'          => 'AGT Game File',
    'ahd'          => 'Dynamics AX Online Help Data File',
    'ahi'          => 'Dynamics AX Online Help Index File',
    'ahk'          => 'AutoHotkey Script',
    'ahl'          => 'eMule Metadata File',
    'ahs'          => 'Adobe Halftone Screen File',
    'ahu'          => 'Adobe Photoshop HSL File',
    'ahx'          => 'WinAHX Tracker Module',
    'ai'           => 'Battlefield 2 Artificial Intelligence File',
    'aia'          => 'MIT App Inventor Source Code File',
    'aic'          => 'Advanced Image Coding File',
    'aidl'         => 'Android Interface Definition Language File',
    'aif'          => 'Symbian Application Information File',
    'aifb'         => 'AIF Builder Project File',
    'aifc'         => 'Compressed Audio Interchange File',
    'aiff'         => 'Audio Interchange File Format',
    'aim'          => 'AOL Instant Messenger Launch File',
    'aiml'         => 'Artificial Intelligence Markup Language',
    'aimppl'       => 'AIMP Playlist File',
    'ain'          => 'AIN Compressed File Archive',
    'aip'          => 'Actual Installer Project',
    'air'          => 'M.U.G.E.N. Animation File',
    'ais'          => 'Velvet Studio Instrument',
    'ait'          => 'Adobe Illustrator Template',
    'aiu'          => 'Advanced Installer Updates Configuration',
    'aiv'          => 'AIVault Data File',
    'aix'          => 'AIX Audio File',
    'ajp'          => 'CCTV Video File',
    'akp'          => 'Akai Sampler File',
    'al'           => 'A-Law Compressed Sound Format',
    'alac'         => 'ALAC Encoded Audio File',
    'alaw'         => 'A-Law Compressed Sound Format',
    'alb'          => 'Alpha Five Library',
    'albm'         => 'HP Photo Printing Software Album File',
    'album'        => 'GLC_Player Album File',
    'alc'          => 'Dynamics AX Label Description File',
    'ald'          => 'Dynamics AX Application Label Data File',
    'aldf'         => 'Aldfaer Genealogy File',
    'ale'          => 'Avid Log Exchange File',
    'alf'          => 'Alf Interactive Test',
    'alg'          => 'AlgoBox Algorithm File',
    'ali'          => 'RoboHelp Alias File',
    'all'          => 'Java RMI Policy File',
    'alm'          => 'Alpha Five Library',
    'alp'          => 'AnyLogic Project File',
    'alr'          => 'ADRIFT Language Resource File',
    'als'          => 'Ableton Live Set File',
    'alt'          => 'Dynamics AX Temporary File',
    'alv'          => 'Adobe Photoshop Levels File',
    'alx'          => 'Alpha Five Library Index File',
    'alz'          => 'ALZip Archive',
    'am'           => 'Anark Media File',
    'am1'          => 'Adventure Maker',
    'am4'          => 'AutoPlay Media Studio 4 Project File',
    'am5'          => 'AutoPlay Media Studio 5 Project File',
    'am6'          => 'AutoPlay Media Studio 6 Project',
    'am7'          => 'AutoPlay Media Studio 7 Project',
    'amb'          => 'AIMMS Model File',
    'amc'          => 'Ant Movie Catalog File',
    'amf'          => 'Advanced Module File',
    'amfm'         => 'Adobe Multiple Font Metrics File',
    'amgp'         => 'antimicro Profile File',
    'aml'          => 'Abstract Markup Language',
    'amm'          => 'All My Movies Database File',
    'amp'          => 'Adobe Photoshop Curves Map File',
    'amr'          => 'Adaptive Multi-Rate Codec File',
    'ams'          => 'Velvet Studio Module',
    'amsorm'       => 'OnLine Ringman Auction Client File',
    'amu'          => 'PictureGear Studio Photo Album File',
    'amv'          => 'Anime Music Video File',
    'amx'          => 'AMX Mod Plugin File',
    'amxd'         => 'Ableton Max Patch File',
    'amxx'         => 'AMX Mod X Plugin File',
    'amz'          => 'Amazon MP3 Downloader File',
    'an'           => 'Adobe Edge Animate Project File',
    'an1'          => 'Street Atlas USA Draw File',
    'an2'          => 'Croc Legend of the Gobbos Animation File',
    'an8'          => 'Vector NTI DNA File',
    'ane'          => 'Adobe AIR Native Extension',
    'ang'          => 'Anghami Audio File',
    'anh'          => 'Project ROME File',
    'ani'          => 'Windows Animated Cursor',
    'anim'         => 'Antibody Animation File',
    'anime'        => 'Anime Studio Document',
    'animeaction'  => 'Anime Studio Action Document',
    'animebrush'   => 'Anime Studio Brush Document',
    'animeexport'  => 'Anime Studio Export Profile Document',
    'animeproj'    => 'Anime Studio Document Data File',
    'animestyle'   => 'Anime Studio Style Document',
    'animset'      => 'FaceFX Animation Set File',
    'animset_inga' => 'E\'FaceFX In-Game Animation Set File',
    'anjuta'       => 'Anjuta IDE Project File',
    'anm'          => '3D Animation File',
    'anme'         => 'Anime Studio Document',
    'ann'          => 'Lingvo Dictionary Annotation File',
    'annot'        => 'Adobe Digital Editions Annotations File',
    'ans'          => 'HotDocs Binary Answer File',
    'ansym'        => 'Adobe Edge Animate Library File',
    'antispam5'    => 'Personal AntiSpam Settings File',
    'antmpl'       => 'Adobe Edge Animate Template File',
    'anx'          => 'Annodex Exchange Format File',
    'any'          => 'AnyRail Layout Plan',
    'ao'           => 'ActionOutline Outline File',
    'aob'          => 'DVD-Audio Audio Object File',
    'aod'          => 'Dynamics AX Object Data File',
    'aof'          => 'Artlantis Object File',
    'aoi'          => 'Dynamics AX Application Object Index File',
    'aois'         => 'CFS Console Add-on Installer Settings File',
    'aol'          => 'America Online File',
    'aom'          => 'After Effects Output Module',
    'aos'          => 'ARCHOS PCtablet Firmware File',
    'ap'           => 'ArtPro File',
    'ap_'          => 'ADT Android Developer Package',
    'apa'          => 'RSView Development Project Archive',
    'apalbum'      => 'Aperture Album File',
    'apd'          => 'Eclipse Plugin Descriptor File',
    'ape'          => 'AVS Plugin Effects File',
    'apf'          => 'Sony Ericsson Firmware Acoustics File',
    'aph'          => 'Ability Album File',
    'api'          => 'Adobe Photoshop Inks File',
    'apk'          => 'Android Package File',
    'apkg'         => 'Exported Anki Flashcard Deck',
    'apl'          => 'ACDSee Plugin File',
    'aplg'         => 'Audials Plug-in',
    'aplibrary'    => 'Aperture Library',
    'aplp'         => 'Audials Plug-in Package',
    'apm'          => 'Aldus Placeable Metafile Image',
    'apng'         => 'Animated Portable Network Graphic',
    'apnx'         => 'Amazon Page Number Index File',
    'app'          => 'Symbian OS Application',
    'appcache'     => 'HTML5 Cache Manifest File',
    'appdownload'  => 'Mac App Store Partially Downloaded App',
    'appex'        => 'OS X Application and System Extension File',
    'applescript'  => 'AppleScript File',
    'applet'       => 'Eclipse Java Applet Policy File',
    'application'  => 'ClickOnce Deployment Manifest File',
    'appref-ms'    => 'Microsoft Application Reference File',
    'appup'        => 'Erlang Application Upgrade File',
    'appx'         => 'Windows 8 App Package',
    'appxsym'      => 'Windows 8 App Package Symbols File',
    'appxupload'   => 'Windows 8 App Upload Package',
    'apr'          => 'Apadana Project File',
    'aps'          => 'Greeting Card Studio Project File',
    'apt'          => 'Almost Plain Text File',
    'apx'          => 'Ability Photopaint Studio Image',
    'apxl'         => 'Keynote Presentation Data File',
    'apz'          => 'Autoplay Media Studio Exported Project',
    'aqm'          => 'AlpineQuest Map File',
    'aqt'          => 'AQTitle Subtitles File',
    'ar'           => 'Midtown Madness Data File',
    'ara'          => 'Archivaldo Resource Archive',
    'arc'          => 'Nintendo Archive File',
    'arc.lh'       => 'Nintendo Archive File',
    'arch00'       => 'F.E.A.R. Game Archive',
    'archiver'     => 'Archiver Compressed File Archive',
    'arcut'        => 'Prelude Rough Cut File',
    'ard'          => 'ArtiosCAD Workspace File',
    'arduboy'      => 'Arduboy Game Package',
    'arena'        => 'Quake 3 Engine Arena File',
    'arf'          => 'WebEx Advanced Recording File',
    'arff'         => 'Attribute-Relation File Format',
    'arg'          => 'AutoCAD Profile',
    'arh'          => 'ArheoStratigraf Project File',
    'ari'          => 'ARI Compressed File Archive',
    'aria'         => 'Chipsounds Sound File',
    'aria2'        => 'aria2 Control File',
    'ariax'        => 'Chipsounds XML Sound File',
    'arj'          => 'ARJ Compressed File Archive',
    'ark'          => 'PowerDesk Pro Archive',
    'arl'          => 'AOL Organizer File',
    'arn'          => 'Autoruns Data File',
    'aro'          => 'SteelArrow Web Application File',
    'arp'          => 'Advanced RAR Password Recovery Setup',
    'arpack'       => 'ArtRage Package',
    'arr'          => 'MultiMedia Fusion Array File',
    'ars'          => 'Carmageddon Saved Game',
    'arsc'         => 'Android Package Resource File',
    'arscript'     => 'ArtRage Script',
    'art'          => 'Artifacts Artifact File',
    'artb'         => 'Artboard Document',
    'article'      => 'Twixl Publisher Article',
    'artproj'      => 'Artifacts Project',
    'artwork'      => 'ArtStudio Image',
    'arw'          => 'ArtStudio Image',
    'arx'          => 'AutoCAD Runtime Extension File',
    'arxml'        => 'AUTOSAR XML File',
    'as'           => 'AppleSingle File',
    'as2'          => 'ActivStudio Resource Pack',
    'as2proj'      => 'FlashDevelop ActionScript 2 Project File',
    'as3proj'      => 'FlashDevelop ActionScript 3 Project File',
    'as4'          => 'askSam Backup File',
    'asa'          => 'ASP Configuration File',
    'asar'         => 'Electron Archive',
    'asat'         => 'Assemble SAT 3D Model File',
    'asax'         => 'ASP.NET Server Application File',
    'asb'          => 'Alphacam Stone VB Macro File',
    'asc'          => 'Autodesk ASCII Export File',
    'ascii'        => 'ASCII Text File',
    'ascs'         => 'ActionScript Communication Server File',
    'ascx'         => 'ASP.NET User Control File',
    'asd'          => 'Ableton Live Sample Analysis File',
    'asdb'         => 'Asphyre Sphinx Archive File',
    'ase'          => 'Aseprite Sprite File',
    'asec'         => 'Android Secure Application File',
    'asef'         => 'Adobe Swatch Exchange File',
    'aseprite'     => 'Aseprite Sprite File',
    'asf'          => 'Advanced Systems Format File',
    'ash'          => 'Nintendo Wii System Menu File',
    'ashbak'       => 'Ashampoo Backup Archive',
    'ashdisc'      => 'Ashampoo Burning Studio Image',
    'ashprj'       => 'Ashampoo Burning Studio Project',
    'ashx'         => 'ASP.NET Web Handler File',
    'asi'          => 'Grand Theft Auto Mod Library',
    'ask'          => 'Ableton Live Skin File',
    'asl'          => 'Photoshop Style',
    'asm'          => 'Pro/ENGINEER Assembly File',
    'asmx'         => 'ASP.NET Web Service File',
    'asnd'         => 'Adobe Sound Document',
    'asp'          => 'Adobe Color Separation Setup File',
    'aspx'         => 'Active Server Page Extended File',
    'asr'          => 'Adobe Photoshop Scratch File',
    'ass'          => 'Splinter Cell Blacklist Game Data File',
    'asset'        => 'Unity Asset File',
    'assetproj'    => 'Camtasia Studio Asset Information File',
    'assets'       => 'Unity Asset File',
    'asstrm'       => 'Splinter Cell Blacklist Game Data File',
    'ast'          => 'Ability Spreadsheet Template',
    'asv'          => 'Adobe Photoshop Selective Color File',
    'asvf'         => 'Asphyre Sphinx Archive File',
    'asvx'         => 'Finale Auto-save File',
    'asw'          => 'ACDSee Slideshow Wizard File',
    'aswcs'        => 'Avast! Compressed Skin File',
    'asws'         => 'Avast! Skin File',
    'asx'          => 'Alpha Five Library Temporary Index File',
    'asy'          => 'LTspice Symbol File',
    'at3'          => 'ATRAC3 Audio File',
    'at5'          => 'Lowrance Map File',
    'atahd'        => 'ATA Hard Drive Flag File',
    'atc'          => 'AutoCAD Tool Catalog File',
    'ate'          => 'Office Accounting Compressed Backup File',
    'atf'          => 'Photoshop Transfer Function File',
    'ath'          => 'Alienware AlienFX Theme File',
    'ati'          => 'Office Accounting Updated Company File',
    'atl'          => 'Artlantis 3D Scene File',
    'atm'          => 'PSP Game Audio File',
    'atn'          => 'Photoshop Actions File',
    'atom'         => 'Atom Syndication Format',
    'atomsvc'      => 'Atom Service Document',
    'atr'          => 'Atari Disk Image',
    'atrac'        => 'Sony ATRAC Audio File',
    'ats'          => 'Advanced ETL Transformation Script',
    'atsofts'      => 'LetEncrypt Encrypted File',
    'att'          => 'Alphacam Lathe Tool File',
    'attr'         => 'iPhoto Attributes File',
    'atx'          => 'Animation Master Plugin File',
    'aty'          => 'Association Type Placeholder',
    'atz'          => 'Atomic Time Zone File',
    'au'           => 'Audacity Audio File',
    'au3'          => 'AutoIt v3 Script',
    'aud'          => 'Video Game Compressed Audio File',
    'audionote'    => 'AudioNote File',
    'aup'          => 'Audacity Project File',
    'aur'          => 'Aurora Timetable File',
    'aurora'       => 'Aurora Ransomware Encrypted File',
    'aut'          => 'AutoIt Script File',
    'automaticdes' => 'I\'NATIONS-MS Windows Jump List File',
    'autoplay'     => 'AutoPlay Media Studio Project File',
    'autosave'     => 'Fusion Auto-save File',
    'autosave.cdp' => 'Sony CD Architect Project Autosave File',
    'aux'          => 'Auxiliary File',
    'auz'          => 'Ableton Authorization File',
    'av'           => 'Final Draft AV Script',
    'av3'          => 'Arbitrator Video Surveillance File',
    'ava'          => 'AvaaBook eBook',
    'avastlic'     => 'Avast! License File',
    'avastsounds'  => 'Avast! Soundpack File',
    'avatar'       => 'Google Talk Avatar File',
    'avb'          => 'Microsoft Comic Chat Character',
    'avc'          => 'Avid Media Composer Script',
    'avchd'        => 'High Definition Video File',
    'avd'          => 'Movie Edit Pro Video Information File',
    'ave'          => 'Avigilon Native Video Export File',
    'avenirproj'   => 'StoryMill Project',
    'avery'        => 'Avery Design & Print Label File',
    'avgdx'        => 'AVG Diagnostics File',
    'avhd'         => 'Hyper-V SnapShot File',
    'avhdx'        => 'Automatic Virtual Hard Drive File',
    'avi'          => 'Audio Video Interleave File',
    'avj'          => 'AntiVir Job File',
    'avl'          => 'AntiVir Status Report File',
    'avm'          => 'Anime Music Video',
    'avp'          => 'AntiVir Profile',
    'avr'          => 'Audio Visual Research File',
    'avro'         => 'Avro Data File',
    'avs'          => 'Adobe Photoshop Variations File',
    'avv'          => 'Avid Volume Bin File',
    'avx'          => 'Avid Plugin File',
    'aw'           => 'Answer Wizard File',
    'awb'          => 'ADX Audio Package File2',
    'awbr'         => 'WriteOnline WordBar File',
    'awc'          => 'Emulex AWC Firmware Update File',
    'awcav'        => 'ActiveWorlds Custom Avatar File',
    'awd'          => 'Award BIOS Update File',
    'awdb'         => 'Access Walker Database File',
    'awg'          => 'Ability Draw Document',
    'awk'          => 'AWK Script',
    'awkw'         => 'Awkwords Word Generator File',
    'awlive'       => 'Active Webcam Video File',
    'awm'          => 'AllWebMenus Project File',
    'awp'          => 'Ability Write Template',
    'aws'          => 'AutoCAD Work Space File',
    'awt'          => 'AbiWord Template',
    'aww'          => 'Ability Write Document',
    'ax'           => 'DirectShow Filter',
    'axa'          => 'Annodex Audio File',
    'axd'          => 'ASP.NET Web Handler File',
    'axe'          => 'Annotated XML Example File',
    'axm'          => 'AXMEDIS Object',
    'axp'          => 'CDBurnerXP Audio Compilation File',
    'axt'          => 'Microsoft AutoRoute Template',
    'axv'          => 'Annodex Video File',
    'axx'          => 'AxCrypt Encrypted File',
    'ay'           => 'AY Chiptune File',
    'az!'          => 'Vuze Partial Download File',
    'azf'          => 'AirZip FileSECURE File',
    'azs'          => 'AirZip FileSECURE File',
    'azw'          => 'Amazon Kindle eBook File',
    'azw1'         => 'Amazon Topaz eBook',
    'azw2'         => 'Kindle Active Content App File',
    'azw3'         => 'Amazon KF8 eBook File',
    'azw3f'        => 'Amazon eBook Metadata File',
    'azw4'         => 'Amazon Print Replica eBook',
    'azz'          => 'AZZ Cardfile Database File',
    'azzx'         => 'Uncompressed AZZ Cardfile Data File',
    'b'            => 'BuRg3r Definition File',
    'b1'           => 'B1 Compressed Archive',
    'b2a'          => 'Btoa Encoded File',
    'b3d'          => 'Blitz3D Entity Model File',
    'b4s'          => 'Winamp Playlist File',
    'b5i'          => 'BlindWrite 5 Disk Image',
    'b5t'          => 'BlindWrite 5 Disc Track Information File',
    'b64'          => 'Base64 MIME-Encoded File',
    'b6i'          => 'BlindWrite 6 Disc Image',
    'b6t'          => 'BlindWrite 6 Track Information File',
    'b6z'          => 'B6Z Archive',
    'ba'           => 'Scifer External Header Archive',
    'ba2'          => 'Bethesda Softworks Archive',
    'ba6'          => 'TaxAct 2016 Tax Return Backup File',
    'ba7'          => 'TaxAct 2016 Tax Return Backup File',
    'ba_'          => 'Renamed BAT File',
    'bac'          => 'Backup File',
    'backup'       => 'Android Backup File',
    'backupdb'     => 'Time Machine Backup Folder',
    'bad'          => 'Exchange Badmail File',
    'bafl'         => 'BurnAware File List',
    'bak'          => 'MobileTrans Backup File',
    'bak1'         => 'Starbound Backup File',
    'bak2'         => 'Starbound Backup File',
    'bak3'         => 'Starbound Backup File',
    'bakx'         => 'Finale Backup File',
    'bak~'         => 'AbiWord Auto-Saved Document',
    'band'         => 'GarageBand Project File',
    'bap'          => 'Blaze Audio Wave Information File',
    'bar'          => 'Brew MP Binary Application Resource File',
    'bas'          => 'BASIC Source Code File',
    'baserproj'    => 'DNA Baser Project File',
    'basex'        => 'BaseX Data File',
    'bash_history' => 'Bash History File',
    'bash_profile' => 'Bash Interactive Login Shell File',
    'bashrc'       => 'Bash Non-Interactive Login Shell File',
    'bat'          => 'DOS Batch File',
    'bau'          => 'Apache OpenOffice AutoText File',
    'bav'          => 'AVG AntiVirus The Bat! Plugin File',
    'bay'          => 'Casio RAW Image',
    'bb'           => 'Blitz Source Code File',
    'bb3'          => 'BlasterBall 3 Level File Support',
    'bbb'          => 'BlackBerry Mobile Phone Backup File',
    'bbc'          => 'BBC BASIC Data File',
    'bbcd'         => 'BobCAD-CAM Document',
    'bbl'          => 'BibTeX Generated Bibliography File',
    'bblm'         => 'BBEdit Language Module',
    'bbproject'    => 'BBEdit Project File',
    'bbprojectd'   => 'BBEdit Project Document',
    'bbs'          => 'Bulletin Board System Text',
    'bbz'          => 'BerryBuzz Backup File',
    'bc!'          => 'BitComet Incomplete File',
    'bc'           => 'Adobe Bridge Cache File',
    'bc5b'         => 'Ransomware Encrypted File',
    'bcc'          => 'Calendar Creator File',
    'bcd'          => 'RealView Debugger Board Chip Definition',
    'bcf'          => 'Business Card Designer Pro File',
    'bci'          => 'Belarc Advisor Report File',
    'bck'          => 'VMX Backup File',
    'bckp'         => 'Ad-Aware Quarantined File',
    'bcl'          => 'Illumina Base Call File',
    'bcm'          => 'Adobe Bridge Cache File',
    'bcmx'         => 'Business Contact Manager Customization',
    'bcp'          => 'Batch Compiler Preset File',
    'bcs'          => 'Sonic Foundry Batch Converter Script',
    'bcstm'        => 'BCSTM Audio Stream File',
    'bct'          => 'Adobe Bridge Thumbnail Cache File',
    'bdae'         => 'Gameloft Game Data File',
    'bdb'          => 'Microsoft Works Database Backup File',
    'bdc'          => 'West Point Bridge Designer Design File',
    'bdd'          => 'CARA Sound Radiation Data File',
    'bdf'          => 'MIDAS BDF Disk Image File',
    'bdic'         => 'Chrome Dictionary File',
    'bdl'          => 'CoCreate Bundle File',
    'bdm'          => 'AVCHD Information File',
    'bdmv'         => 'Blu-ray Disc Movie Information File',
    'bdoc'         => 'Binary DigiDoc Signature File',
    'bdp'          => 'Exchange Diagnostic Message',
    'bdr'          => 'Publisher Borders File',
    'bdsproj'      => 'Borland Developer Studio Project',
    'bdt2'         => 'BEEDOCS Timeline 3D 2 Document',
    'bdt3'         => 'BEEDOCS Timeline 3D 3 Document',
    'beam'         => 'Compiled Erlang File',
    'bean'         => 'Bean Rich Text Document',
    'bed'          => 'UCSC BED Annotation Track File',
    'bejeweled2de' => 'U\'XESAVEDGAME Bejeweled 2 Deluxe Saved Game',
    'bet'          => 'BETA Source File',
    'bf'           => 'CryoBF Game Data File',
    'bfa'          => 'Blowfish Encrypted File',
    'bfc'          => 'Windows Briefcase File',
    'bff'          => 'Backup File Format',
    'bfg'          => 'Big Fish Games Application File',
    'bfm'          => 'Terminal Reality Model File',
    'bfs'          => 'FlatOut Game Data File',
    'bfstm'        => 'BFSTM Audio Stream File',
    'bfx'          => 'Bitware Fax Document',
    'bgi'          => 'BgInfo Configuration File',
    'bgl'          => 'Babylon Glossary File',
    'bgt'          => 'Graphics Accounts Data File',
    'bgz'          => 'Blood Frontier Map File',
    'bh'           => 'BlakHole Archive',
    'bho'          => 'Behold Organize File',
    'bhx'          => 'BinHex Encoded File',
    'bib'          => 'Bibliography Document',
    'bibtex'       => 'BibTeX Bibliography Database',
    'bic'          => 'Neverwinter Nights Character File',
    'bidule'       => 'Bidule Layout File',
    'bif'          => 'Get Backup Project File',
    'bifx'         => 'Get Backup Project',
    'big'          => 'Electronic Arts Game Data File',
    'bik'          => 'Video Game Movie File',
    'bil'          => 'ESRI BIL File',
    'bim'          => 'Bytessence InstallMaker Document',
    'bimx'         => 'BIM Explorer File',
    'bin'          => 'Nintendo Wii Data File',
    'binary'       => 'PC Building Simulator Save File',
    'binarycookie' => ' \'Safari Cookies File',
    'bio'          => 'Fallout 2 Character Biography File',
    'bionix'       => 'BioniX Wallpaper Playlist File',
    'bip'          => 'Dharma Ransomware Encrypted File',
    'biq'          => 'Civilization 3 Scenario File',
    'bit'          => 'FinalCrypt Encrypted Data File',
    'bitpim'       => 'BitPim Configuration File',
    'bix'          => 'Kodicom Video File',
    'biz'          => 'Broderbund Business Card File',
    'bjo'          => 'TabRite Tablature File',
    'bk'           => 'FrameMaker Book File',
    'bk1'          => 'Windows Indexing Service File',
    'bk2'          => 'Windows Indexing Service Data File',
    'bkc'          => 'Backup4all Backup Catalog',
    'bkf'          => 'Windows Backup Utility File',
    'bkk'          => 'BookBuddi eBook File',
    'bkmk'         => 'Yummy FTP Bookmark File',
    'bkp'          => 'Zapback Backup File',
    'bks'          => 'Microsoft Works Spreadsheet Backup File',
    'bkup'         => 'Backup File',
    'bkz'          => 'BaKoMa TeX Installation Module',
    'blackhawkstr' => 'K\'ER2         Blackhawk Striker 2 Saved Game',
    'blasterball3' => 'A\'VEDGAME     BlasterBall 3 Saved Game',
    'blb'          => 'Interactive Fiction Package Game File',
    'bld'          => 'Skyscraper Simulator Building Script',
    'blend'        => 'Blender 3D Data File',
    'blend1'       => 'Blender Document Backup File',
    'blend2'       => 'Blender Document Backup 2 File',
    'blf'          => 'MasterWorks Working File',
    'blg'          => 'BibTeX Log File',
    'bli'          => 'Thomson Speedtouch Firmware File',
    'blk'          => 'BLK360 Data File',
    'blkrt'        => 'Block Artist Image File',
    'bln'          => 'Golden Software Blanking File',
    'blob'         => 'Valve Steam Archive',
    'blockplt'     => 'LEGO MINDSTORMS NXT Block Palette File',
    'blogthis'     => 'Windows Live Writer Data File',
    'blorb'        => 'Interactive Fiction Package Game File',
    'blp'          => 'Speedy Eggbert Game Data File',
    'bls'          => 'Blockland Saved Game File',
    'blt'          => 'AIM Buddy List',
    'blu'          => 'FileMaker Pro Runtime Extension',
    'bluebutton'   => 'VA Blue Button Data File',
    'bluej'        => 'BlueJ Package File',
    'blw'          => 'Adobe Photoshop Black and White Presets',
    'blz'          => 'Compressed Bitmap Image',
    'bm2'          => 'Boardmaker Interactive Board File',
    'bm3'          => 'Sony Ericsson Backup File',
    'bmc'          => 'Embroidery Image File',
    'bmd'          => 'GameCube 3D Model File',
    'bme'          => 'BeatMania 7-Key Song File',
    'bmf'          => 'FloorPlan File',
    'bmg'          => 'Nintendo DS On-Screen Text File',
    'bmi'          => '3ds Max Plug-in',
    'bmk'          => 'BillMinder Backup File',
    'bml'          => 'Braille 2000 Braille File',
    'bmml'         => 'Balsamiq Mockups Markup Language File',
    'bmp'          => 'Bitmap Image File',
    'bmq'          => 'Re-Volt Mipmap File',
    'bms'          => 'BIOWRAP Multi-Layer Security File',
    'bmx'          => 'Siemens Mobile Animations File',
    'bmz'          => 'Compressed Bitmap Image',
    'bna'          => 'Barna Word Processor Document',
    'bnd'          => 'DB2 CLI Bind File',
    'bndl'         => 'Game Data Bundle File',
    'bng'          => 'The Bingo Maker Card File',
    'bnk'          => 'ExamView Question Bank File',
    'bnp'          => 'Sony Camcorder Video Data File',
    'bns'          => 'Portal Bonus Map Script',
    'bnz'          => 'The Bingo Maker Card Template File',
    'bo2'          => 'Minecraft BO2 Object File',
    'bo3'          => 'Minecraft BO3 Object File',
    'boc'          => 'EasyWord Big Document',
    'bok'          => 'ProStores Dynamic Web Page',
    'bom'          => 'Mac OS X Bill of Materials File',
    'bonk'         => 'Bonk Audio File',
    'boo'          => 'Booasm Compressed Archive',
    'book'         => 'Budget In Brief Book File',
    'bookexport'   => 'BookSmart Backup Book File',
    'booktemplate' => 'BookSmart Template',
    'bookwormdelu' => 'E\'SAVEDGAME   Bookworm Deluxe Saved Game',
    'boot'         => 'InstallShield Boot File',
    'bootskin'     => 'Stardock Bootskin File',
    'bos'          => 'Build Options Specification File',
    'box'          => 'CARA Loudspeaker Design File',
    'bp2'          => 'AutoCAD Batch Plot File',
    'bp3'          => 'AutoCAD Batch Plot File',
    'bpa'          => 'StorageSync Backup Archive',
    'bpb'          => 'PowerDesigner Business Process Backup',
    'bpd'          => 'Binary Printer Description File',
    'bpdx'         => 'Business Plan Pro Document',
    'bpf'          => 'Baan ERP Document',
    'bpg'          => 'BPG Image',
    'bphys'        => 'Blender Cache File',
    'bpj'          => 'Boxsim Simulation Project',
    'bpk'          => 'Nero SecurDisc Public Key File',
    'bpl'          => 'Bore Plan Log',
    'bplx'         => 'Bore Plan XML File',
    'bpm'          => 'PowerDesigner Business Process Model',
    'bpmc'         => 'Bizagi Process Modeler Collaboration',
    'bpn'          => 'ArchiCAD Project Backup File',
    'bpnueb'       => 'PNU eBook File',
    'bpr'          => 'Borland C++Builder Project File',
    'bps'          => 'Works Document Backup',
    'bpw'          => 'Bitmap World File',
    'bpz'          => 'Easy Blue Print Symbol Library',
    'bqy'          => 'Brio Query File',
    'br'           => 'Brotli Compressed File',
    'br3'          => 'Bryce 3 Scene File',
    'br4'          => 'Bryce 4 Scene File',
    'br5'          => 'Bryce 5 Scene File',
    'br6'          => 'Bryce 6 Scene File',
    'br7'          => 'Bryce 7 Scene File',
    'brain'        => 'PersonalBrain Mind Map File',
    'brd'          => 'KiCad PCB Design File',
    'breff'        => 'Wii Effect Controls File',
    'breft'        => 'Wii Effects File',
    'brf'          => 'Braille Ready Format File',
    'brg'          => 'Age of Mythology Model File',
    'bri'          => 'Bryce Plug-in File',
    'bridgecache'  => 'Adobe Bridge Cache Export File',
    'brk'          => 'Brooktrout Fax Document',
    'brl'          => 'MicroBraille File',
    'brlyt'        => 'Wii Textures and Material Lists File',
    'brm'          => 'Bryce Plug-in File',
    'brmdl'        => 'Wii BRMDL Model File',
    'brn'          => 'Gabriel Knight Barn File',
    'bro'          => 'Bryce Plug-in',
    'browser'      => 'ASP.NET Browser Definition File',
    'brr'          => 'SNES Sample File',
    'brres'        => 'Wii BRRES Resource Package',
    'brs'          => 'RoboHelp Browse Sequence File',
    'brsar'        => 'Wii BRSAR Audio Archive',
    'brstm'        => 'BRSTM Audio Stream File',
    'brt'          => 'Bryce Textures File',
    'brtex'        => 'Wii BRTEX Texture File',
    'brushcategor' => ' \'Painter Brush Category File',
    'brushlibrary' => 'Painter Brush Library',
    'brushvariant' => 'Painter Brush Variant File',
    'brv'          => 'Brick Rigs Vehicle File',
    'brw'          => 'Calyx Point Borrower File',
    'brx'          => 'Beam Report Document',
    'bs1'          => 'VirtualBus Vehicle Configuration File',
    'bs2'          => 'BASIC Stamp 2 Code File',
    'bs4'          => 'Mikogo Session Video Recording',
    'bs7'          => 'Windows 7 Boot Updater Skin',
    'bsa'          => 'Bethesda Softworks Archive',
    'bsb'          => 'BioShock Saved Game File',
    'bsc'          => 'Visual Studio Source Browser Information',
    'bsd'          => 'BSDL File',
    'bsdiff'       => 'BSDiff Patch File',
    'bsdl'         => 'Boundary Scan Description Language File',
    'bsf'          => 'Blu-ray AVC Video File',
    'bsg'          => 'Besiege Machine File',
    'bsh'          => 'BeanShell Script',
    'bsk'          => 'Bryce Skies File',
    'bsp'          => 'Quake Engine Game Map File',
    'bss'          => 'Resident Evil Background Images File',
    'bst'          => 'BibTeX Style Document',
    'bsw'          => 'StruWalker 3D Model',
    'bswx'         => 'BIMReview 3D Model',
    'bsxc'         => 'BimSens Component Configuration File',
    'bsxp'         => 'BimSens Project Configuration File',
    'bt!'          => 'BitSpirit Incomplete Download File',
    'bt'           => 'Binary Terrain File',
    'btapp'        => 'uTorrent App',
    'btd'          => 'Business-in-a-Box Document',
    'btf'          => 'NationsBank Check Images',
    'bti'          => 'Nintendo Texture File',
    'btif'         => 'NationsBank Check Image File',
    'btinstall'    => 'uTorrent Installer File',
    'btm'          => '4DOS Batch File',
    'btn'          => 'AutoPlay Media Studio Button File',
    'bto'          => 'Bryce Tree File',
    'btoa'         => 'Binary-to-ASCII Encoded File',
    'btr'          => 'Btrieve Database File',
    'btsearch'     => 'BitTorrent Search Engine File',
    'btw'          => 'BarTender Label',
    'bu'           => 'Samsung CCTV Video File',
    'bud'          => 'Binary Printer Description File',
    'buf'          => 'Buffer File',
    'buildpath'    => 'Eclipse Build Path File',
    'buildsetting' => 'Twixl Publisher Builder Build Setting',
    'bul'          => 'I4 Bullseye Data File',
    'bun'          => 'Cakewalk Bundle File',
    'bundle'       => 'Game Data Bundle File',
    'bup'          => 'McAfee Quarantined File',
    'bur'          => 'BuRg3r Source Code File',
    'bus'          => 'VirtualBus Board Parameters File',
    'bvd'          => 'Bitdefender Vault File',
    'bvh'          => 'Biovision Hierarchy Animation File',
    'bvp'          => 'VodaHost BlueVoda Project File',
    'bvr'          => 'Blue Iris Video',
    'bw'           => 'Black and White SGI Image File',
    'bwa'          => 'Bookworm Adventures Player File',
    'bwf'          => 'Broadcast Wave File',
    'bwg'          => 'BrainWave Generator Audio File',
    'bwi'          => 'BlindWrite CD/DVD Disc Image',
    'bwp'          => 'BuRg3r Web Page',
    'bws'          => 'BlindWrite Sub Code File',
    'bwt'          => 'BlindWrite 4 Track Information FIle',
    'bww'          => 'Bagpipe Player File',
    'bwz'          => 'WinImage Batch Configuration File',
    'bxl'          => 'Accelerated Designs PCB Library File',
    'bxx'          => 'BS Contact Parameter File',
    'bytes'        => 'Binary Text Asset Data File',
    'byu'          => 'Brigham Young University Movie File',
    'bz'           => 'Bzip Compressed File',
    'bz2'          => 'Bzip2 Compressed File',
    'bza'          => 'IZArc BGA Archive',
    'bzabw'        => 'Compressed AbiWord Document',
    'bzip'         => 'Bzip Compressed Archive',
    'bzip2'        => 'Bzip2 Compressed Archive',
    'bzplug'       => 'AfterShot Pro Plugin Bundle',
    'bzw'          => 'BZFlag World File',
    'c'            => 'Lite-C Script',
    'c00'          => 'WinAce Split Archive File',
    'c01'          => 'Typhoon Wave Audio File',
    'c02'          => 'WinAce Split Archive Part 1 File',
    'c10'          => 'WinAce Split Archive Part 10',
    'c2d'          => 'WinOnCD Disc Image',
    'c2r'          => 'Windows Media Center Click-To-Record File',
    'c2u'          => 'Texas Instruments CBL 2 OS File',
    'c32'          => 'Syslinux COM32 Module',
    'c3d'          => 'C3D Model File',
    'c3z'          => 'OpenQwaq 3D Model File',
    'c4'           => 'JEDMICS Image File',
    'c4d'          => 'Cinema 4D Model File',
    'c4k'          => 'Clonk Key File',
    'c4p'          => 'CrossOver Software Installer File',
    'ca'           => 'Initial Telnet Cache',
    'caa'          => 'Chinese Academic Article Link File',
    'cab'          => 'Windows Cabinet File',
    'cache'        => 'Cache File',
    'caction'      => 'Automator Converter Action',
    'cad'          => 'Autodesk QuickCAD File',
    'cadc'         => 'Corpatla Data Container File',
    'cadoc'        => 'Clicker App Document',
    'caf'          => 'CryENGINE Character Animation File',
    'caff'         => 'Core Audio File',
    'cag'          => 'ClipArt Gallery Package',
    'caj'          => 'Chinese Academic Journal File',
    'cal'          => 'CryENGINE Character Animation List',
    'calb'         => 'Coolect Album File',
    'calca'        => 'Calca Document',
    'calibre'      => 'Calibre Device Data File',
    'cals'         => 'CALS Raster Graphic File',
    'cam'          => 'CASIO Digital Camera Picture File',
    'camerror'     => 'Camtasia Studio Error File',
    'camm'         => 'espresso Mind Map Document',
    'camp'         => 'WCS Color Appearance Model Profile File',
    'camproj'      => 'Camtasia Studio Project',
    'camrec'       => 'Camtasia Studio Screen Recording',
    'camv'         => 'Camtasia Video File',
    'can'          => 'Canon Navigator Fax Document',
    'cannedsearch' => 'Apple Predefined Search',
    'cap'          => 'ASUS BIOS Update File',
    'caproj'       => 'Construct Project File',
    'capt'         => 'Capito Data File',
    'capx'         => 'Capella CapXML File',
    'car'          => 'CAR Archive',
    'carc'         => 'Nintendo DS Compressed Archive File',
    'cas'          => 'Total War Model File',
    'case'         => 'SlipCover Case Template',
    'cat'          => 'Advanced Disk Catalog Database',
    'cat4d'        => 'Cinema 4D Catalog',
    'catdrawing'   => 'CATIA V5 Drawing',
    'catpart'      => 'CATIA V5 Part File',
    'catproduct'   => 'CATIA V5 Assembly File',
    'cav'          => 'Comodo Virus Definitions File',
    'cawr'         => 'Espresso workreport Document',
    'cb7'          => 'Comic Book 7-Zip Archive',
    'cba'          => 'CryENGINE Resource Compiler Settings File',
    'cbc'          => 'Comic Book Collection',
    'cbds'         => 'Comic Book DS File',
    'cbf'          => 'ChessBase Game Information File',
    'cbg'          => 'CyberGauge Data File',
    'cbh'          => 'ChessBase Database Header File',
    'cbk'          => 'Backup Configuration File',
    'cbl'          => 'COBOL Source Code File',
    'cbmap'        => 'Containment Breach Map File',
    'cboard'       => 'Final Cut Pro Color Board Preset',
    'cbp'          => 'Code::Blocks Project File',
    'cbr'          => 'Comic Book RAR Archive',
    'cbs'          => 'Code Breaker PS2 Save File',
    'cbt'          => 'Computer Based Training File',
    'cbu'          => 'Comodo Backup File',
    'cbv'          => 'ChessBase Database File',
    'cbxml'        => 'CodeBox Library',
    'cbz'          => 'ChessBase Encrypted Database Archive',
    'cc'           => 'C++ Source Code File',
    'cca'          => 'cc:Mail Archive File',
    'ccb'          => 'CopperCube 3D Scene',
    'ccbjs'        => 'CopperCube JavaScript File',
    'ccc'          => 'Dev-C++ Code Completion Cache',
    'ccd'          => 'CloneCD Disc Image',
    'ccf'          => 'CryptLoad Container File',
    'ccgame'       => 'XNA Creators Club Game Package',
    'cch'          => 'Corel Chart File',
    'ccip'         => 'Curse Client Install Package',
    'ccld'         => 'Construction Clouds Data File',
    'ccn'          => 'Compressed Multimedia Fusion File',
    'ccp'          => 'RIB Import Converter Profile',
    'ccr'          => 'ASTM Continuity of Care Record',
    'ccs'          => 'CCS Script File',
    'ccscc'        => 'ClearCase Source Control Info File',
    'cct'          => 'Director Protected Cast Resource',
    'ccx'          => 'Corel Clipart File',
    'cd'           => 'CD-i OptImage',
    'cd2'          => 'Click\'N Design 3D File',
    'cd5'          => 'Chasys Draw Image File',
    'cda'          => 'CD Audio Track Shortcut',
    'cdb'          => 'CardScan Contacts Database',
    'cdc'          => 'AutoCAD DesignCenter Preview Cache File',
    'cdd'          => 'ConceptDraw PRO Document',
    'cdda'         => 'CD Digital Audio File',
    'cddx'         => 'Circuit Diagram Document',
    'cddz'         => 'ConceptDraw PRO Document',
    'cdf'          => 'Channel Definition Format',
    'cdf-ms'       => 'ClickOnce Compiled Manifest File',
    'cdg'          => 'Compact Disc Plus Graphics Image',
    'cdi'          => 'INTEX Output File',
    'cdl'          => 'ConceptDraw PRO Library File',
    'cdlx'         => 'ConceptDraw PRO XML Library File',
    'cdm'          => 'Conceptual Data Model File',
    'cdml'         => 'Creately Diagram File',
    'cdmm'         => 'ConceptDraw MINDMAP Document',
    'cdmp'         => 'WCS Device Model Profile',
    'cdmt'         => 'ConceptDraw MINDMAP Template',
    'cdmtz'        => 'Compressed ConceptDraw MINDMAP Template',
    'cdmz'         => 'Compressed ConceptDraw MINDMAP Document',
    'cdo'          => 'Crescendo Music Notation File',
    'cdoc'         => 'Encrypted DigiDoc File',
    'cdp'          => 'Sony CD Architect Project',
    'cdp2'         => 'Trainz Classics Content Dispatcher Pack 2',
    'cdpx'         => 'ConceptDraw PROJECT XML File',
    'cdpz'         => 'ConceptDraw PROJECT Document',
    'cdr'          => 'Crash Data Retrieval Data File',
    'cds'          => 'ConceptDraw SlideShow',
    'cdsx'         => 'ConceptDraw PRO XML SlideShow File',
    'cdt'          => 'CD-Text File',
    'cdtx'         => 'ConceptDraw PRO XML Template',
    'cdw'          => 'KOMPAS Document',
    'cdx'          => 'Alpha Five Table Index File',
    'cdxml'        => 'Cmdlet Definition XML File',
    'cdz'          => 'Compressed CD Image File',
    'ce'           => 'ComputerEyes Image',
    'ceb'          => 'Apabi eBook File',
    'cebx'         => 'Apabi XML eBook File',
    'ced'          => 'JVC Camera Video Data File',
    'cedprj'       => 'Ashampoo CoverEditor Project',
    'cef'          => 'Class Action Gradebook Elementary File',
    'cel'          => 'FLIC Animation',
    'cell'         => 'Thinkfree Office NEO Cell Workbook',
    'celtx'        => 'Celtx Project File',
    'celx'         => 'Celestia Script',
    'cem'          => 'Children of the Nile Model File',
    'cenon'        => 'Cenon Project',
    'cenon~'       => 'Cenon Backup File',
    'cer'          => 'Internet Security Certificate',
    'cerber'       => 'Cerber Ransomware Encrypted File',
    'cerber2'      => 'Cerber2 Ransomware Encrypted File',
    'cerber3'      => 'Cerber Ransomware Virus File',
    'certsigningr' => 'Q\'UEST    Apple Developer Signing Certificate Request',
    'cetrainer'    => 'Cheat Engine Trainer File',
    'cex'          => 'SolidWorks Enterprise PDM Vault Export File',
    'cf'           => 'Sendmail Configuration File',
    'cf2'          => 'Common File Format File',
    'cfa'          => 'ComProbe Analyzer Capture File',
    'cfb'          => 'Compound Binary File',
    'cfc'          => 'ColdFusion Component File',
    'cff'          => 'Common File Format',
    'cfg'          => 'Celestia Configuration File',
    'cfge'         => 'Jewel Quest Configuration File',
    'cfl'          => 'IMVU Product File',
    'cfm'          => 'ColdFusion Markup File',
    'cfml'         => 'ColdFusion Markup Language File',
    'cfr'          => 'Cross Fire Replay File',
    'cfs'          => 'CFS Console File',
    'cfx'          => 'Flow-Cal Data File',
    'cfxr'         => 'Cocoa Sfxr File',
    'cg'           => 'Cg Program',
    'cg3'          => 'Cabri 3D Document',
    'cga'          => 'Crytek Geometry Animation File',
    'cgf'          => 'Crytek Geometry Format File',
    'cgfx'         => 'CgFX Shader File',
    'cgi'          => 'Common Gateway Interface Script',
    'cgm'          => 'Computer Graphics Metafile',
    'cgp'          => 'PixelCryptor Encrypted File',
    'cgr'          => 'Quest3D Channel Group File',
    'cgrp'         => 'Pro Tools Clip Group File',
    'cgz'          => 'Cube Map File',
    'ch3'          => 'Harvard Graphics DOS Chart File',
    'cha'          => 'Character Layout File',
    'chai'         => 'Chaimera Artwork File',
    'chait'        => 'Chaimera Artwork Template',
    'cham'         => 'Compiled HAM File',
    'charset'      => 'Character Set',
    'chart'        => 'Guitar Rhythm Chart File',
    'chat'         => 'IRC Chat Configuration File',
    'chc'          => 'HCFR Colormeter Data File',
    'chd'          => 'MAME Hard Disk Image',
    'chef'         => 'Chef Source Code File',
    'chesstitanss' => 'V\'E-MS    Microsoft Chess Titans Saved Game',
    'chg'          => 'Quicken Online Data File',
    'chk'          => 'Netgear Router Firmware File',
    'chksplit'     => 'Archiver Split Checksum File',
    'chl'          => 'WinFast PVR2 Channel List',
    'chm'          => 'Compiled HTML Help File',
    'chml'         => 'Chameleon Encrypted Database File',
    'chn'          => 'Ethnograph Data',
    'chord'        => 'Song Chords File',
    'chr'          => 'Borland Character Set File',
    'chr0'         => 'Wii Model Animation File',
    'chrparams'    => 'CryENGINE Character Parameters File',
    'chs'          => 'Windows Chinese Noise-Word List File',
    'cht'          => 'Windows Chinese Traditional Noise-Word List',
    'chunk001'     => 'File Splitter Split Archive Part 1',
    'chv'          => 'ChView Interactive Star Map File',
    'chw'          => 'Compiled Help Index File',
    'chx'          => 'AutoCAD Standards Check File',
    'ci'           => 'PolySpace Preprocessed Code File',
    'cia'          => 'CTR Importable Archive',
    'cib'          => 'Luminaire Data File',
    'cid'          => 'Navigator Chart Image Description File',
    'cidb'         => 'iTunes CD Information File',
    'cif'          => 'Easy CD Creator Disk Image',
    'cil'          => 'Clip Gallery Packaged File',
    'cimg'         => 'CImg Image File',
    'cin'          => 'Kodak Cineon Bitmap File',
    'cine'         => 'Phantom Digital Video File',
    'cip'          => 'Cavena Subtitles File',
    'circ'         => 'Logisim Circuit File',
    'circuit'      => 'KTechlab Circuit Design File',
    'cis'          => 'CheckInbox Settings File',
    'ciso'         => 'Compact ISO File',
    'cit'          => 'Intergraph Bitmap Image File',
    'civ5map'      => 'Civilization 5 Map',
    'civ5mod'      => 'Civilization 5 Mod File',
    'civ5save'     => 'Civilization 5 Saved Game',
    'civ5sln'      => 'Civilization 5 Solution File',
    'ck9'          => 'Cook\'n Cookbook Backup File',
    'ckb'          => 'Cricket Audio Bank File',
    'ckbx'         => 'Cricket Audio XML Bank Description File',
    'ckd'          => 'Kubotek Design Container',
    'ckf'          => 'Casio Keyboard File',
    'ckp'          => 'SQL Server Checkpoint File',
    'ckt'          => 'CircuitMaker File',
    'cl'           => 'Cursor Library',
    'cl2'          => 'HY-TEK Meet Results File',
    'cl2arc'       => 'Comic Life 2 Document Archive',
    'cl2doc'       => 'Comic Life 2 Document',
    'cl2lyt'       => 'Comic Life 2 Layout File',
    'cl2tpl'       => 'Comic Life 2 Template',
    'cl4'          => 'Easy CD Creator 4 Project File',
    'cl5'          => 'Easy CD Creator 5 Saved Project',
    'clarify'      => 'Clarify Document',
    'class'        => 'Java Class File',
    'classlist'    => 'SMART Notebook Class List File',
    'clb'          => 'ICQ Contact List',
    'cld'          => 'ClamAV Virus Definitions File',
    'cleo'         => 'CLEO Grand Theft Auto Mod File',
    'clg'          => 'Collage Maker Project File',
    'cli'          => 'Grand Theft Auto Clip Data File',
    'clip'         => 'Grand Theft Auto 5 Clip',
    'clips'        => 'Coda Clips File',
    'clix'         => 'CLIX Command File',
    'clk'          => 'ClickView Video File',
    'clkb'         => 'Clicker Books File',
    'clkbd'        => 'Clicker Board Set',
    'clkc'         => 'Clicker Connect Set File',
    'clkd'         => 'Clicker Docs File',
    'clkk'         => 'Clicker Keyboard',
    'clkm'         => 'Clicker Matching Set File',
    'clkp'         => 'Clicker Object Palette File',
    'clks'         => 'Clicker Sentences File',
    'clkt'         => 'Clicker Template',
    'clktk'        => 'Clicker Talk Set File',
    'clkv'         => 'Clicker Communicator Vocabulary Set File',
    'clkw'         => 'Clicker Word Bank',
    'clkx'         => 'Clicker Grid Set',
    'clm'          => 'GenePattern CEL Descriptor File',
    'clp'          => 'Clipper Compiler Instructions File',
    'clpi'         => 'Blu-ray Clip Information File',
    'clr'          => 'Vue Color Maps File',
    'clr0'         => 'Wii Color Swapping Animation File',
    'cls'          => 'Program Class File',
    'clt'          => 'VisualBoyAdvance Cheat List File',
    'clw'          => 'Visual C++ ClassWizard File',
    'clx'          => 'Ceelox SecureMail Secure Message',
    'cm'           => 'Cable Modem Configuration File',
    'cm0013'       => 'Samsung Smart TV Index File',
    'cm10'         => 'CaseMap 10 Case File',
    'cm2'          => 'Poser Camera Set File',
    'cm5'          => 'Clone Manager File',
    'cma'          => 'OCaml Library',
    'cmake'        => 'CMake File',
    'cmap'         => 'The Escapists Custom Prison Map File',
    'cmate'        => 'ControllerMate File',
    'cmbl'         => 'Logger Pro Data File',
    'cmd'          => 'M.U.G.E.N. Character Commands File',
    'cme'          => 'Command Multimedia Evidence File',
    'cmf'          => 'Connected Backup File',
    'cml'          => 'Crazy Machines Lab File',
    'cmm'          => 'Corel Multimedia Manager Album',
    'cmmp'         => 'Camtasia MenuMaker Project',
    'cmmtheme'     => 'CleanMyMac Theme File',
    'cmmtpl'       => 'Camtasia MenuMaker Template',
    'cmo'          => 'ASUS BIOS File',
    'cmod'         => 'Celestia Model',
    'cmp'          => 'Generic CADD Component File',
    'cmpkg'        => 'craftersmine Package',
    'cmproj'       => 'Camtasia Project File',
    'cmr'          => 'U.S. Sectional Chart Map File',
    'cmrec'        => 'Camtasia Recording',
    'cms'          => 'Content Management System',
    'cmv'          => 'CorelMOVE Animation',
    'cmx'          => 'Corel Metafile Exchange Image File',
    'cmz'          => 'Compressed Poser Camera Set File',
    'cn1'          => 'CNR Modem Initialization Data File',
    'cna'          => 'Catena Project File',
    'cnc'          => 'CNC Machine Tool Path',
    'cnd'          => 'Melco Condensed Embroidery File',
    'cndx'         => 'Avery DesignPro for Mac Label File',
    'cnf'          => 'Telnet Configuration File',
    'cng'          => 'CryptoNG Encrypted Archive',
    'cnm'          => 'NoteMap Outline File',
    'cns'          => 'M.U.G.E.N. Character States File',
    'cnt'          => 'Help Contents File',
    'cnv'          => 'Canvas 6-8 Drawing File',
    'cob'          => 'COBOL Source Code File',
    'cod'          => 'Atlantis Word Processor Encrypted Document',
    'codaplugin'   => 'Coda Plug-in',
    'codasite'     => 'Coda Site File',
    'cof'          => 'MPLAB COFF File',
    'coffee'       => 'CoffeeScript JavaScript File',
    'col'          => 'Capture One Session File',
    'collab'       => 'Blackboard Collaborate Session File',
    'collection'   => 'Adobe Bridge Collection File',
    'colorpicker'  => 'Color Picker Plugin',
    'colourscheme' => 'Speedy Browser Colour Scheme File',
    'colz'         => 'Adobe Collage File',
    'com'          => 'DOS Command File',
    'comfycakessa' => 'E\'-MS     Comfy Cakes Saved Game',
    'comic'        => 'Comic Life Comic',
    'comicdoc'     => 'Comic Life Document',
    'comiclife'    => 'Comic Life Document',
    'command'      => 'Terminal Command File',
    'comp'         => 'Fusion Composition File',
    'compiled'     => 'Compiled Game Resource File',
    'component'    => 'Mac OS X System Component',
    'compositefon' => ' \'Windows Composite Font File',
    'compositionm' => 'D\'EL      Invantive Composition Data Model File',
    'compositiont' => 'M\'PLATE   Invantive Composition Template',
    'comppkg.haup' => 'W\'ERK.RAR Hauptwerk Component Package',
    'comppkg_haup' => 'W\'ERK_RAR Hauptwerk Component Package',
    'compressed'   => 'WordCompress Compacted Web File',
    'con'          => 'COW System Settings File',
    'conf'         => 'Generic Configuration File',
    'config'       => 'Configuration File',
    'configprofil' => ' \'Apple Configuration Profile',
    'conform'      => 'Conformalizer Change List File',
    'consis'       => 'Sciral Consistency Document',
    'contact'      => 'Windows Contact File',
    'contour'      => 'Contour Screenplay File',
    'controls'     => 'OpenBVE Keyboard Shortcuts File',
    'copreset'     => 'Capture One Preset File',
    'copy'         => 'Sony Ericsson Protected Content File',
    'cor'          => 'Trimble Corrected SSF File',
    'cos'          => 'Creatures CAOS File',
    'cos2'         => 'Pinnacle Studio Cache File',
    'cosessiondb'  => 'Capture One Session File',
    'costyle'      => 'Capture One Style File',
    'course'       => 'Super Mario ReMaker Course File',
    'cov'          => 'Fax Cover Page File',
    'coverage'     => 'Visual Studio Code Coverage Report',
    'cox'          => 'Click & Create Extension',
    'cp'           => 'Captivate Source File',
    'cp3'          => 'Grand Prix 3 Cockpit Shape File',
    'cp9'          => 'ChoicePoint Encrypted File',
    'cpa'          => 'CADSTAR PCB Archive File',
    'cpaa'         => 'Captivate Shared Action File',
    'cpb'          => 'Comicino Studio Project File',
    'cpbitmap'     => 'iOS Wallpaper Image',
    'cpc'          => 'CPC Compressed Image File',
    'cpd'          => 'Compressed PhotoDefiner Image File',
    'cpdx'         => 'Adobe Captivate Storyboard Project',
    'cpe'          => 'Fax Cover Page File',
    'cpf'          => 'Cab Provisioning Format File',
    'cpg'          => 'Cool Page Project File',
    'cpgz'         => 'Compressed CPIO Archive',
    'cph'          => 'Corel Print House File',
    'cphd'         => 'CloudChan Pre-processed Hypertext Document',
    'cpi'          => 'Codepage Information File',
    'cpio'         => 'Unix CPIO Archive',
    'cpk'          => 'CRI Middleware Package',
    'cpl'          => 'Windows Control Panel Item',
    'cpmz'         => 'Miradi/ConPro Project File',
    'cpn'          => 'Grim Dawn Default Character File',
    'cpp'          => 'C++ Source Code File',
    'cpq'          => 'Compaq OEM Disc Configuration File',
    'cpr'          => 'CPC Plus Cartridge',
    'cps'          => 'The Powder Toy Save File',
    'cpt'          => 'Pocket Slides Presentation',
    'cptl'         => 'Adobe Captivate Project Template File',
    'cptm'         => 'Captivate Theme File',
    'cptx'         => 'Adobe Captivate Project File',
    'cpu'          => 'Virtual CPU File',
    'cpvc'         => 'Adobe Captivate Video Composition',
    'cpx'          => 'Rise of Rome Campaign File',
    'cpy'          => 'eCopy Desktop File',
    'cr2'          => 'Poser Character Rigging File',
    'cr3'          => 'Canon Raw 3 Image File',
    'craft'        => 'KSP Spacecraft File',
    'cram'         => 'Compressed Alignment File',
    'crash'        => 'Mac OS X Crash Log File',
    'crashed'      => 'AbiWord Crash-Saved Document',
    'crc'          => 'Total Commander Checksum File',
    'crd'          => 'Guitar Tabs',
    'crdownload'   => 'Chrome Partially Downloaded File',
    'crds'         => 'Windows CardSpace Backup File',
    'crec'         => 'Lync Video File',
    'crev'         => 'Adobe Captivate Commentable SWF File',
    'crf'          => 'Cal3D Binary Materials File',
    'crl'          => 'Certificate Revocation List File',
    'crop'         => 'Crick Software Options File',
    'crp'          => 'Cities: Skylines Colossal Raw Asset Package',
    'crs'          => 'StepMania Course File',
    'crt'          => 'Security Certificate',
    'crtr'         => 'MultiAd Creator Pro Document',
    'crtx'         => 'Office 2007 Chart Template File',
    'crv'          => 'VCarve Pro Design File',
    'crw'          => 'Canon Raw CIFF Image File',
    'crwl'         => 'Windows Crawl File',
    'crx'          => 'Chrome Extension',
    'cry'          => 'CryENGINE Map File',
    'crypt'        => 'CryptXXX Ransomware Encrypted File',
    'crypt12'      => 'WhatsApp Encrypted Database File',
    'crypt5'       => 'WhatsApp Encrypted Database File',
    'crypt6'       => 'WhatsApp Encrypted Database File',
    'crypt7'       => 'WhatsApp Encrypted Database File',
    'crypt8'       => 'WhatsApp Encrypted Database File',
    'crypt9'       => 'WhatsApp Encrypted Database File',
    'crypted'      => 'WinOptimizer Encrypted File',
    'cryptra'      => 'Cryptra Encrypted File',
    'crysisjmsf'   => 'Crysis Saved Game',
    'crysispsf'    => 'Crysis Warhead Saved Game',
    'crz'          => 'Compressed Poser Character Rigging File',
    'cs'           => 'CLEO Custom Script',
    'cs1'          => 'CaptureShop 1-shot Raw Image',
    'csa'          => 'PNA Code Calset File',
    'csaplan'      => 'SPSS Analysis Plan File',
    'csd'          => 'Steam Game Data Backup File',
    'csf'          => 'Cal3D Binary Skeleton File',
    'csg'          => 'CounterSketch Design Project',
    'csh'          => 'Cubase Waveform File',
    'cshtml'       => 'ASP.NET Razor Web Page',
    'csi'          => 'EdLog Program Data File',
    'cskin'        => 'CD Art Display Skin File',
    'csl'          => 'CineStyle Color Lookup File',
    'csm'          => 'Steam Game Backup File',
    'csn'          => 'Adobe Code Snippet Document',
    'cso'          => 'Compiled Shader Object File',
    'csp'          => 'Concept Server Page',
    'csplan'       => 'SPSS Sampling Plan File',
    'csproj'       => 'Visual Studio C# Project',
    'csr'          => 'Certificate Signing Request File',
    'css'          => 'Cascading Style Sheet',
    'cst'          => 'Gary Gadget Plug-in',
    'csutil'       => 'ColorSync Utility Folder',
    'csv'          => 'Comma Separated Values File',
    'csx'          => 'Visual C# Script',
    'csy'          => 'Canvas Symbol File',
    'ct'           => 'Scitex Continuous Tone File',
    'ctb'          => 'Cherrytree SQLite Document',
    'ctbodyfittin' => ' \'CrazyTalk Animator Actor Fitting File',
    'ctc'          => 'Visual Studio Command Table Configuration',
    'ctd'          => 'Cherrytree XML Document',
    'ctf'          => 'PSP Custom Theme File',
    'ctg'          => 'Canon Digital Camera Catalog File',
    'ctl'          => 'StepMania SMZIP Package Description File',
    'ctm'          => 'Star Wars Republic Commando Map File',
    'cto'          => 'Visual Studio Binary Command Table Output',
    'ctp'          => 'CrazyTalk Project File',
    'ctproject'    => 'CrazyTalk Animator Project File',
    'cts'          => 'CrazyTalk Script File',
    'ctsym'        => 'Visual Studio Command Table Output File',
    'ctt'          => 'Messenger Contact List',
    'ctv'          => 'Citavi Project',
    'ctv3'         => 'Citavi 3 Project File',
    'ctx'          => 'Cherrytree Password-protected SQLite Document',
    'ctxt'         => 'BlueJ Context File',
    'cty'          => 'SimCity City File',
    'ctz'          => 'Cherrytree Password-protected XML Document',
    'cu'           => 'CUDA Source Code File',
    'cub'          => 'Gaussian Cube File',
    'cube'         => 'Gaussian Cube File',
    'cue'          => 'CDRWIN Cue Sheet',
    'cui'          => 'Autodesk Custom Workspace File',
    'cuix'         => 'AutoCAD Custom User Interface File',
    'cul'          => 'Windows Cursor Library',
    'cur'          => 'Windows Cursor',
    'cursorfx'     => 'CursorFX Theme File',
    'curxptheme'   => 'CursorXP Theme File',
    'cus'          => 'AutoCAD Custom Dictionary File',
    'customdestin' => 'T\'IONS-MS Windows 7 Jump List File',
    'cut'          => 'Dr. Halo Bitmap Image File',
    'cv'           => 'CodeView Data File',
    'cv5'          => 'Canvas 5 Drawing File',
    'cva'          => 'Canvas Sequence Set',
    'cvc'          => 'cVideo',
    'cvd'          => 'Bitdefender Virus Definition File',
    'cvf'          => 'CPU-Z Validation File',
    'cvg'          => 'Calamus Vector Graphic File',
    'cvi'          => 'CassiniVision Map Image File',
    'cvn'          => 'CineVision Encoding Session',
    'cvr'          => 'Microsoft Crash Report File',
    'cvs'          => 'Canvas 3 Drawing File',
    'cvsrc'        => 'CVS Command File',
    'cvt'          => 'Canvas External Tool File',
    'cvw'          => 'CaseView Document',
    'cvx'          => 'Canvas Drawing File',
    'cw'           => 'CardWorks Template',
    'cwb'          => 'Cakewalk Bundle',
    'cwd'          => 'Nonogram Puzzle File',
    'cwf'          => 'CorelDRAW Workspace File',
    'cwk'          => 'ClarisWorks Document',
    'cwp'          => 'Cakewalk SONAR Project',
    'cws'          => 'Claris Works Template',
    'cwt'          => 'ClarisWorks Texture File',
    'cww'          => 'Crossword Weaver Puzzle File',
    'cwy'          => 'ChordWizard Style',
    'cwz'          => 'Circuit Wizard File',
    'cx3'          => 'CMS Recorded Video File',
    'cx5'          => 'Clone Manager XML File',
    'cxa'          => 'FMAT Listmode File',
    'cxarchive'    => 'CrossOver Bottle Archive',
    'cxd'          => 'SimplePCI Data Document',
    'cxf'          => 'Coordinates Export Format',
    'cxi'          => 'FMAT RAW Image',
    'cxp'          => 'FMAT Assay File',
    'cxr'          => 'FMAT Plate Results File',
    'cxt'          => 'CX-Programmer Project Text File',
    'cxx'          => 'C++ Source Code File',
    'cyberducklic' => 'N\'SE      Cyberduck Donation Key',
    'cyberduckpro' => 'I\'LE      Cyberduck Connection Profile',
    'cyi'          => 'Clustify Input File',
    'cyo'          => 'Clustify Output File',
    'cyp'          => 'Home Designer Pro Project File',
    'cys'          => 'Clustify Summary File',
    'cyw'          => 'Rbot.CYW Worm File',
    'czd'          => 'CAD Zone Drawing',
    'czi'          => 'Carl Zeiss Image Data File',
    'czip'         => 'ZipGenius CryptoZip File',
    'czp'          => 'ClozePro Archive',
    'd$$'          => 'AGT Game Encrypted Message File',
    'd'            => 'Source Dependency File',
    'd00'          => 'OPL2 FM Audio File',
    'd01'          => 'OPL2 FM Audio File',
    'd2s'          => 'Diablo 2 Save File',
    'd2v'          => 'DVD2AVI File',
    'd3d'          => 'Game Maker 3D File',
    'd3dbsp'       => 'Call of Duty Map File',
    'd3md'         => 'DART Metadata File',
    'd3v'          => 'Datel Video File',
    'd64'          => 'Commodore 64 Disk Image',
    'd88'          => 'Toshiba Pasopia 7 Disk File',
    'da0'          => 'Windows Registry Backup File',
    'da1'          => 'AGT Game Data File',
    'da2'          => 'AGT Game Data File',
    'da3'          => 'AGT Game Data File',
    'da4'          => 'AGT Game Data File',
    'da5'          => 'AGT Game Data File',
    'da6'          => 'AGT Game Data File',
    'daa'          => 'PowerISO Direct-Access-Archive',
    'dabriefcase'  => 'RemObjects Data Abstract File Briefcase',
    'daconfig'     => 'RemObjects Data Abstract Configuration File',
    'daconnection' => ' \'RemObjects Data Abstract Connections File',
    'dacpac'       => 'SQL Server Data Tier Application Package',
    'dad'          => 'IMS200 Video Record File',
    'dadiagrams'   => 'RemObjects Data Abstract Data Diagrams File',
    'dae'          => 'Digital Asset Exchange File',
    'daf'          => 'Digital Anchor File',
    'dal'          => 'DVD-lab Project File',
    'dam'          => 'DAME Project',
    'dao'          => 'Disk at Once CD/DVD Image',
    'dap'          => 'Diet Analysis Profile',
    'dar'          => 'DVD Architect Project',
    'dart'         => 'Dart Source Code File',
    'das'          => 'DeltaMaster Analysis Session',
    'daschema'     => 'RemObjects Data Abstract Schema File',
    'dash'         => 'Dashlane Profile',
    'dat'          => 'Nonimmigrant Visa Application Data File',
    'dat_mcr'      => 'Minecraft Level.dat Backup File',
    'dat_new'      => 'Minecraft World Level File',
    'dat_old'      => 'Minecraft Level.dat Backup File',
    'data'         => 'Analysis Studio Offline Data File',
    'dav'          => 'DVR365 Video File',
    'dax'          => 'PSP Compressed ISO Disc Image',
    'day'          => 'Day of the Zombie Map File',
    'daz'          => 'DAZ Studio 3D Scene',
    'dazip'        => 'Dragon Age: Origins Game File',
    'db'           => 'QQ Account Database File',
    'db-'          => 'Norton Nprotect Database File',
    'db-journal'   => 'SQLite Rollback Journal File',
    'db-shm'       => 'SQLite Database Shared Memory File',
    'db-wal'       => 'SQLite Database Write-Ahead Log File',
    'db.crypt'     => 'WhatsApp Encrypted Database File',
    'db.crypt12'   => 'WhatsApp Encrypted Database File',
    'db.crypt8'    => 'WhatsApp Encrypted Database File',
    'db.jou'       => 'Patran Journal File',
    'db1'          => 'Tekla Structures Model File',
    'db2'          => 'Samsung CCTV Video Information File',
    'db3'          => 'SQLite Database File',
    'dba'          => 'CryENGINE Animation Database File',
    'dbb'          => 'Skype User Information File',
    'dbc'          => 'DAZ Brick Camera File',
    'dbd'          => 'DemoShield Project',
    'dbf'          => 'FoxPro Table',
    'dbg'          => 'Visual FoxPro Debugger Configuration File',
    'dbgsym'       => 'Debug Symbols File',
    'dbk'          => 'dBASE Database Backup',
    'dbl'          => 'DAZ Brick Light File',
    'dbm'          => 'DAZ Brick Material File',
    'dbml'         => 'Visual Studio OR Design File',
    'dbo'          => 'DarkBASIC Object',
    'dbpro'        => 'DarkBASIC Professional Project File',
    'dbproj'       => 'Visual Studio Database Project File',
    'dbq'          => 'AutoCAD Query Set',
    'dbr'          => 'DeepBurner Disc Project',
    'dbs'          => 'GAMBIT Mesh File',
    'dbt'          => 'Database Text File',
    'dbv'          => 'Database Variable Field',
    'dbx'          => 'Dropbox Encrypted Database File',
    'dc'           => 'DesignCAD Design File',
    'dc1'          => 'Bloomba E-mail Message',
    'dc2'          => 'DevCad Cam Pro Document',
    'dc3'          => 'DesignCAD 3D ASCII Drawing',
    'dc4'          => 'ViaThinkSoft (De)Coder 4 File',
    'dca'          => 'DisplayWrite Document',
    'dcb'          => 'Concordance Database File',
    'dcd'          => 'DisCryptor Encrypted Database',
    'dce'          => 'DriveCam Video File',
    'dcf'          => 'Disk Copy Fast Disk Image File',
    'dck'          => 'Resolume Deck File',
    'dcl'          => 'DumpSec Report File',
    'dcm'          => 'DiskCatalogMaker Catalog File',
    'dcmd'         => 'DiskCatalogMaker Thumbnail-Enabled Catalog',
    'dcmf'         => 'DiskCatalogMaker Catalog',
    'dco'          => 'Safetica Free Encrypted Virtual Disk Archive',
    'dcover'       => 'Disc Cover File',
    'dcp'          => 'Delphi Compiled Package',
    'dcpf'         => 'Disc Copier Project File',
    'dcpr'         => 'Adobe DNG Camera Profile Recipe File',
    'dcproj'       => 'Dashcode Project',
    'dcr'          => 'Delphi Component Resource File',
    'dcs'          => 'Desktop Color Separation File',
    'dcst'         => 'Adobe InDesign Document Presets File',
    'dct'          => 'DeSmuME ROM Cheats File',
    'dctmp'        => 'DC++ Partially Downloaded File',
    'dcu'          => 'Delphi Compiled Unit',
    'dcuil'        => 'Delphi .NET Compiled Unit File',
    'dcx'          => 'Zsoft Multi-Page Paintbrush File',
    'dd'           => 'DiskDoubler Archive',
    'ddat'         => 'DivX Temporary Video File',
    'ddb'          => 'Device Dependent Bitmap',
    'ddc'          => 'DivX Descriptor File',
    'ddcx'         => 'DivX Descriptor 2 File',
    'ddd'          => 'Alpha Five Data Dictionary File',
    'dde'          => 'Lingvo Dictionary Error Log File',
    'ddf'          => 'Diamond Directive File',
    'ddl'          => 'Data Definition Language File',
    'ddm'          => 'Alpha Five Data Dictionary Memo File',
    'ddoc'         => 'DigiDoc Signature File',
    'ddp'          => 'Delphi Diagram Portfolio File',
    'ddrw'         => 'ClarisDraw Drawing',
    'dds'          => 'DirectDraw Surface',
    'ddt'          => 'Jill of the Jungle Music File',
    'ddx'          => 'Alpha Five Data Dictionary Index File',
    'de'           => 'DrawExpress Diagram File',
    'deb'          => 'Debian Software Package',
    'dec'          => 'Magic: The Gathering Online Deck File',
    'decrypt'      => 'Decrypted Microsoft ESD File',
    'ded'          => 'Dr. Engrave Document',
    'def'          => 'IOBit Malware Fighter Definitions File',
    'defs'         => 'BlueJ Settings File',
    'deft'         => 'Juice Grinder Defaults File',
    'dek'          => 'Eavesdropper Batch File',
    'dem'          => 'Digital Elevation Model',
    'demo'         => 'Pokémon Type Wild Data File',
    'deos'         => 'Driver Easy Offline Scan File',
    'dep'          => 'Windows Dependency File',
    'depend'       => 'Code::Blocks Dependencies File',
    'deproj'       => 'Disketch Project File',
    'der'          => 'DER Certificate File',
    'des'          => 'QuickBooks Forms Template',
    'desc'         => 'Battlefield 2 Map Description File',
    'design'       => 'Microsoft Expression Design Drawing',
    'desklink'     => 'Desktop Shortcut',
    'deskthemepac' => ' \'Windows 8 Desktop Theme Pack File',
    'desktop'      => 'Desktop Entry File',
    'det'          => 'Sage ACT! 5 Email Message',
    'dev'          => 'Dev-C++ Project File',
    'developerpro' => 'I\'LE  Xcode Developer Profile',
    'develve'      => 'Develve Data File',
    'deviceids'    => 'Device Identification FIle',
    'deviceinfo'   => 'Device Record',
    'devicemetada' => 'A\'-MS Device Metadata Package',
    'devicesalt'   => 'NOOK Device Salt File',
    'dewf'         => 'SoundEdit Recorded Instrument',
    'dex'          => 'Excel Spreadsheet',
    'df1'          => 'Omnis Native Datafile',
    'df2'          => 'Defractor 2 Instrument',
    'dfc'          => 'DeSmuME Firmware Configuration File',
    'dff'          => 'DSD Audio File',
    'dfg'          => 'Data Flask Grid File',
    'dfk'          => 'Dark Flow Project File',
    'dfm'          => 'Midas ViewPoint Display Form',
    'dfont'        => 'Mac OS X Data Fork Font',
    'dfp'          => 'Fusion Plugin File',
    'dfproj'       => 'DVD Flick Project',
    'dfs'          => 'BrainSuite Surface File',
    'dft'          => 'eJuice Me Up Default Settings File',
    'dfti'         => 'FlexiWrite Document',
    'dfu'          => 'LaTeX Font Encoding File',
    'dfx'          => 'Drafix CAD File',
    'dgb'          => 'FlashCAD Drawing Database',
    'dgc'          => 'TurboTax Tax Form',
    'dge'          => 'Enterprise Test Server Declaration Generator File',
    'dgk'          => 'Delcam 3D Model File',
    'dgml'         => 'Visual Studio Directed Graph Document',
    'dgn'          => 'MicroStation Design File',
    'dgs'          => '3D Screen Creator Scene File',
    'dgsl'         => 'Visual Shader Graph File',
    'dgt'          => 'DST Thumbnail File',
    'dhcd'         => 'DHCD Computing Application Data File',
    'dhs'          => 'HyperSnap Drawing',
    'dht'          => 'GAUSS Data Set Header File',
    'dhtml'        => 'Dynamic HTML file',
    'dia'          => 'Do It Again Task File',
    'diagcab'      => 'Troubleshooting Pack Cabinet File',
    'diagcfg'      => 'Troubleshooting Pack Configuration File',
    'diagpkg'      => 'Troubleshooting Pack File',
    'diagsession'  => 'Diagnostics Session File',
    'dib'          => 'Device Independent Bitmap File',
    'dic'          => 'DICOM Image',
    'dicom'        => 'DICOM Image File',
    'dicproof'     => 'Microsoft Dictionary Proofing File',
    'dict'         => 'Dictionary File',
    'dif'          => 'Digital Interface Format',
    'diff'         => 'Patch File',
    'dig'          => 'Sound Designer Audio File',
    'dii'          => 'Summation Batch Load File',
    'dim'          => 'DIME File',
    'dimax'        => 'DiMAX Firmware Image File',
    'dime'         => 'Direct Internet Message Encapsulation File',
    'dinfo'        => 'DivX Temporary Video Info File',
    'dip'          => 'DipTrace Printed Circuit Board File',
    'dir'          => 'Adobe Director Movie',
    'directory'    => 'KDE Folder View Properties File',
    'dis'          => 'DisSharp Project File',
    'disabled'     => 'Spybot - Search & Destroy Disabled File',
    'disc'         => 'Toast Document',
    'disco'        => 'DISCO Discovery Document',
    'discomap'     => 'DISCO Discovery Output File',
    'disk'         => 'Linux Virtual Hard Disk',
    'diskdefines'  => 'Linux LiveCD Information File',
    'dist'         => 'Mac OS X Distribution Script',
    'dit'          => 'Active Directory Information Tree File',
    'dita'         => 'DITA Document',
    'ditamap'      => 'DITA Topic Map File',
    'ditaval'      => 'DITA Conditions File',
    'div'          => 'DIVA-GIS Project File',
    'diva'         => 'Project DIVA Song File',
    'divx'         => 'DivX-Encoded Movie File',
    'dix'          => 'DIVA-GIS Export File',
    'diy'          => 'My Drivers Backup Setup File',
    'diz'          => 'Description in Zip File',
    'dja'          => 'Dundjinni Module File',
    'djm'          => 'Dynojet Map File',
    'djr'          => 'Ringtone Media Studio DJ Ringtone Project',
    'djv'          => 'DjVu Image',
    'djvu'         => 'DjVu Image',
    'dke'          => 'DriveLock FDE Disk Key File',
    'dkt'          => 'DiGiTIAL THUNDER Drum Kit File',
    'dl'           => 'Dynamic Library',
    'dl_'          => 'Compressed DLL File',
    'dlc'          => 'DIALux Light Control File',
    'dld'          => 'EdLog Compiled Program',
    'dlg'          => 'Dialogue File',
    'dlis'         => 'DLIS Well Log Data File',
    'dll'          => 'DLL Dynamic Web Page',
    'dlm'          => 'Akamai Download Manager File',
    'dlo'          => '3ds Max Plug-in',
    'dlr'          => 'finalRender Plugin',
    'dls'          => 'Downloadable Sounds File',
    'dlt'          => 'DELTA Binary Dataset File',
    'dltemp'       => 'UC Browser Temporary Download File',
    'dlu'          => '3ds Max Utility Plug-in File',
    'dlv'          => 'CATIA 4 Export File',
    'dlx'          => 'Renamed DLL File',
    'dm'           => 'DRM Delivery Message',
    'dm1'          => 'ER/Studio Data Model File',
    'dm2'          => 'Quake 2 Demo File',
    'dm3'          => 'Quake 3 Demo File',
    'dm_68'        => 'Quake 3 Demo File',
    'dm_82'        => 'Wolfenstein 1.00 Demo Movie File',
    'dm_83'        => 'Wolfenstein 1.02 Demo Movie File',
    'dm_84'        => 'Wolfenstein 2.06 Demo Movie File',
    'dmb'          => 'Digital Multimedia Broadcasting File',
    'dmc'          => 'Medical Manager Script',
    'dmd'          => 'SQL Developer Data Modeler File',
    'dmf'          => 'Geosystem Digitals Map File',
    'dmg'          => 'Mac OS X Disk Image',
    'dmgpart'      => 'Mac OS X Disk Image Part',
    'dmi'          => 'BYOND Dream Maker Icon File',
    'dml'          => 'DynaScript File',
    'dmm'          => 'iMindQ Mind Map File',
    'dmmx'         => 'iMindQ XML Map Bundle',
    'dmo'          => 'Cube 2: Sauerbraten Demo File',
    'dmp'          => 'Windows Memory Dump',
    'dmpr'         => 'Direct Mail Project File',
    'dmr'          => 'BrainVoyager Diffusion Weighted Project File',
    'dms'          => 'Dream Maker Script',
    'dmsa'         => 'Music Disc Creator Project File',
    'dmsd'         => 'Roxio MyDVD Project',
    'dmsd3d'       => 'Roxio MyDVD 3D Project',
    'dmse'         => 'Sound Editor Project File',
    'dmsk'         => 'DivX Temporary Video Data File',
    'dmsm'         => 'VideoWave Movie Project File',
    'dmsm3d'       => 'VideoWave 3D Movie Project File',
    'dmsp'         => 'PhotoSuite Project File',
    'dmss'         => 'VideoWave SlideShow Project File',
    'dmt'          => 'DeLorme Transfer File',
    'dmtemplate'   => 'Direct Mail Template',
    'dmx'          => 'Source Filmmaker Project File',
    'dmx-info'     => 'DriverMax Driver Information File',
    'dn1'          => 'Duke Nukem 1 Game Data File',
    'dn2'          => 'Duke Nukem Episode 2 Game File',
    'dn3'          => 'Duke Nukem Episode 3 Game File',
    'dna'          => 'GenePool DNA File',
    'dnc'          => 'Dance Database File',
    'dne'          => 'Netica Text File',
    'dnf'          => 'Duke Nukem Forever Map File',
    'dng'          => 'Virtual Dongle Image',
    'dnh'          => 'Danmakufu Script',
    'dnl'          => 'DNAML eBook File',
    'dns'          => 'Duke Nukem Forever Save File',
    'do'           => 'Java Servlet',
    'dob'          => 'Visual Basic UserDocument',
    'doc#'         => 'LibreOffice Document Lock File',
    'doc'          => 'WordPad Document',
    'dochtml'      => 'Microsoft Word HTML Document',
    'dockzip'      => 'ObjectDock File',
    'docm'         => 'Word Open XML Macro-Enabled Document',
    'docmhtml'     => 'Microsoft Word MIME HTML Document',
    'docset'       => 'Doxygen Document Set File',
    'docx'         => 'Microsoft Word Open XML Document',
    'docxml'       => 'Microsoft Word XML Document',
    'docz'         => 'ThinkFree Online Note Document',
    'dok'          => 'DesktopOK Icons Layout File',
    'dol'          => 'GameCube Executable File',
    'dolphinview'  => 'Dolphin Folder View Settings File',
    'done'         => 'Marker File',
    'dot'          => 'Graphviz Graph File',
    'dothtml'      => 'Microsoft Word HTML Document Template',
    'dotm'         => 'Word Open XML Macro-Enabled Document Template',
    'dotx'         => 'Word Open XML Document Template',
    'dov'          => 'Temp File',
    'download'     => 'Partially Downloaded File',
    'downloadhost' => 'MSN Download Settings File',
    'downloading'  => 'Pando Incomplete Download File',
    'dox'          => 'MultiMate Document',
    'dp1'          => 'DataPower Database File',
    'dpa'          => 'DrawPlus Animation File',
    'dpb'          => 'FaxMaster Document',
    'dpd'          => 'Ovation Pro File',
    'dpf'          => 'Dargon Package',
    'dpg'          => 'Nintendo DS Movie File',
    'dpk'          => 'Delphi Package',
    'dpkw'         => 'Delphi Package',
    'dpl'          => 'Delphi Package Library',
    'dpm'          => 'Pro Tools Plugin File',
    'dpn'          => 'Depiction Data File',
    'dpp'          => 'DrawPlus Drawing File',
    'dpr'          => 'Digital InterPlot File',
    'dproj'        => 'Delphi Project',
    'dps'          => 'DivX Player 2 Skin File',
    'dpt'          => 'Kingsoft Presentation Template',
    'dpv'          => 'Siemens NX Drafting Standard File',
    'dpx'          => 'DrawPlus Template',
    'dqy'          => 'Excel Query File',
    'dr'           => 'My Dark Diary Backup File',
    'dr5'          => 'Dramatica Story Expert Project',
    'dra'          => 'Scriptor Script File',
    'drawing'      => 'Artboard Drawing',
    'drawit'       => 'DrawIt Drawing',
    'drc'          => 'DRM Rights Object',
    'dream'        => 'Dream Animated Wallpaper File',
    'dres'         => 'Delphi Compiled Resource File',
    'drf'          => 'Delphi Resource File',
    'drg'          => 'AllyCAD Drawing File',
    'drl'          => 'Gerber Drill Rack File',
    'drm'          => 'Deus Ex Data File',
    'drmx'         => 'Drumlin Fully Secure PDF File',
    'drmz'         => 'Drumlin Fully Secure Mobile PDF File',
    'dropbox'      => 'Dropbox Shared Folder Tracker',
    'drpm'         => 'Delta RPM File',
    'drscan'       => 'Data Rescue Scans File',
    'dru'          => 'EAGLE Design Rules File',
    'drv'          => 'Device Driver',
    'drw'          => 'Personal Designer Drawing File',
    'drwdot'       => 'SolidWorks Drawing Template',
    'drz'          => 'Draz Paint File',
    'ds'           => 'TWAIN Data Source',
    'ds2'          => 'Olympus DSS Pro Audio File',
    'ds_store'     => 'Mac OS X Folder Settings File',
    'dsa'          => 'DAZ Studio 3+ Script',
    'dsb'          => 'Orchida Embroidery File',
    'dsc'          => 'Text Description File',
    'dsd'          => 'DAZ Studio Object Morph File',
    'dse'          => 'DAZ Studio Encrypted Script',
    'dset'         => 'Kratos Dataset File',
    'dsf'          => 'Designer File',
    'dsg'          => 'Decker Saved Game',
    'dsgm'         => 'DS Game Maker Project',
    'dsi'          => 'Double-Precision Spectral Image',
    'dsk'          => 'Simple IDs Database',
    'dskin'        => 'DockX Skin',
    'dsl'          => 'Lingvo Dictionary File',
    'dsm'          => 'Digital Sound Module',
    'dsn'          => 'OrCAD Design File',
    'dso'          => 'DAZ Studio Object File',
    'dsp'          => 'Dynamic Studio Professional Module',
    'dspl'         => 'Modern Warfare 3 Dedicated Server Playlist',
    'dsr'          => 'Modern Warfare 3 Dedicated Server Recipe File',
    'dss'          => 'DiskStation Backup Configuration File',
    'dst'          => 'DeSmuME Save State',
    'dstudio'      => 'DownloadStudio Incomplete Download',
    'dsv'          => 'DAZ Studio UV Mapping File',
    'dsw'          => 'Visual C++ 6 Workspace File',
    'dsx'          => 'DAZ Studio XML File',
    'dsy'          => 'Besta Video File',
    'dsym'         => 'Xcode Debug Symbols File',
    'dsz'          => 'Orchida (OES) Embroidery File',
    'dt'           => 'Drum Station Machine State File',
    'dt0'          => 'DTED Level 0 File',
    'dt1'          => 'DTED Level 1 File',
    'dt2'          => 'DTED Level 2 File',
    'dt_'          => 'Macintosh Data Fork',
    'dta'          => 'Chain Engineering Database',
    'dtapart'      => 'DownThemAll! Partially Downloaded File',
    'dtd'          => 'Design Tools Draw File',
    'dtf'          => 'Domino Temporary File',
    'dthumb'       => 'Android Data Thumbnail',
    'dtl'          => 'Now Contact Detail Template',
    'dtm'          => 'Dolphin TAS Movie',
    'dtp'          => 'dotTrace Profile File',
    'dtr'          => 'DATroniC Data Recording',
    'dts'          => 'DTS Encoded Audio File',
    'dtsconfig'    => 'SSIS Package Configuration File',
    'dtshd'        => 'DTS-HD Master Audio File',
    'dtsx'         => 'DTS Settings File',
    'dtw'          => 'Desktop Wallpaper',
    'dtx'          => 'Documented LaTeX File',
    'duc'          => 'Action Replay Max DS Save File',
    'duck'         => 'Cyberduck Bookmark',
    'duf'          => 'DAZ User File',
    'dump'         => 'Google BreakPad Crash Log File',
    'dun'          => 'Dial Up Network File',
    'dupeguru'     => 'dupeGuru Duplicate File List',
    'dus'          => 'Readiris Font Dictionary',
    'dv'           => 'Digital Video File',
    'dv-avi'       => 'Microsoft DV-AVI Video File',
    'dv2'          => 'Divinity 2 Data File',
    'dv4'          => 'Bosch Security Systems CCTV Video File',
    'dvb'          => 'AutoCAD VBA Project File',
    'dvc'          => 'IDRISI Vector Definition File',
    'dvd'          => 'DOS Device Driver',
    'dvdmedia'     => 'RipIt DVD Package',
    'dvdproj'      => 'iDVD Project File',
    'dvdr'         => 'DVD/CD-R Master Image',
    'dvds'         => 'DVDStyler Project File',
    'dvf'          => 'Sony Digital Voice File',
    'dvg'          => 'Graphic Works Vector Graphic',
    'dvi'          => 'Device Independent Format File',
    'dvl'          => 'Dalim Virtual Library File',
    'dvo'          => 'Cook\'n Cookbook File',
    'dvr'          => 'Microsoft Recorded TV Show',
    'dvr-ms'       => 'Microsoft Digital Video Recording',
    'dvtcolorthem' => ' \'Xcode Color Theme File',
    'dvtplugin'    => 'Xcode DVT Plug-in',
    'dvx'          => 'DivX Video File',
    'dw'           => 'David Whittaker Audio File',
    'dwa'          => 'Digital Waveform Archiver Audio File',
    'dwc'          => 'Emulex DWC Firmware Update File',
    'dwd'          => 'DiamondWare Digital Audio File',
    'dwdoc'        => 'DrawWell Document',
    'dwf'          => 'Design Web Format File',
    'dwfx'         => 'Design Web Format XPS File',
    'dwg'          => 'AutoCAD Drawing Database File',
    'dwi'          => 'Dance With Intensity Song File',
    'dwl'          => 'TurboCAD Drawing Lock File',
    'dwl2'         => 'AutoCAD Drawing Lock File',
    'dwlibrary'    => 'Paperless Document Library',
    'dwn'          => 'Firmware Update File',
    'dwp'          => 'Darwin Pond Save File',
    'dws'          => 'Dyalog Workspace File',
    'dwt'          => 'AutoCAD Drawing Template',
    'dwz'          => 'DVD MovieFactory Project File',
    'dx'           => 'DEC WPS Plus File',
    'dxb'          => 'Duxbury Braille File',
    'dxe'          => 'AutoCAD Data Extraction Template',
    'dxf'          => 'Drawing Exchange Format File',
    'dxl'          => 'Rational DOORS Script',
    'dxls'         => 'DashXL Skin Set File',
    'dxp'          => 'Duxbury Print File',
    'dxr'          => 'Protected Macromedia Director Movie',
    'dxs'          => 'Deus Ex Saved Game',
    'dxx'          => 'AutoCAD Drawing Interchange Attribute File',
    'dyc'          => 'Xerox Printer Driver Configuration File',
    'dylib'        => 'Mach-O Dynamic Library',
    'dz'           => 'Land of the Dead Level File',
    'dzip'         => 'The Witcher 2 Game Archive',
    'dzm'          => 'DirectorZone Menu Template',
    'dzp'          => 'DirectorZone Particle Effect File',
    'dzt'          => 'DirectorZone Title File',
    'e00'          => 'ArcInfo Coverage Export File',
    'e01'          => 'EnCase Image File',
    'e2gm'         => 'Pangea Enigmo 2 Custom Game File',
    'e2p'          => 'PonyProg Device File',
    'e4a'          => 'Encrypt4all Archive',
    'e57'          => 'LIDAR Point Cloud Data File',
    'e_e'          => 'Renamed EXE File',
    'ea'           => 'Kindle End Actions File',
    'eal'          => 'Kindle End Actions File',
    'eap'          => 'Adobe Photoshop Exposure File',
    'ear'          => 'Eyemail Audio Recording',
    'eas'          => 'RSLogix Symbol File',
    'easm'         => 'eDrawings Assembly File',
    'eaz'          => 'ArcGIS Explorer Add-in File',
    'eba'          => 'Emergence BASIC Source Code File',
    'ebd'          => 'Windows EBD System File',
    'ebk'          => 'eBook Pro eBook File',
    'ebm'          => 'Embla Recording',
    'ebn'          => 'Philips Firmware Update File',
    'ebs'          => 'E-Run 1.x Script',
    'ebs2'         => 'E-Run 2.0 Script File',
    'ebuild'       => 'Portage eBuild Script',
    'ec0'          => 'MetroCount Traffic Data File',
    'ec3'          => 'EPSON Print CD File',
    'ec4'          => 'EPSON Print CD File',
    'ecc'          => 'dvdisaster Error Correction File',
    'ecd'          => 'Encrypted Cryptee Document',
    'ece'          => 'Escenic Dynamic Web Page',
    'ecf'          => 'SageCRM Component File',
    'ecfg'         => 'ArcGIS Component Configuration File',
    'ecl'          => 'Touhou Stage Script',
    'ecm'          => 'ECM Disc Image',
    'eco'          => 'ECCO Database File',
    'ecp'          => 'EasyC Project File',
    'ecs'          => 'Sony Ericsson Phone Backup File',
    'ect'          => 'Yozo Office Chart Template File',
    'ecw'          => 'EclipseCrossword Word List File',
    'ecx'          => 'ECCO Corrupted Database File',
    'eda'          => 'Ensoniq ASR Disk Image',
    'edat'         => 'Sony Encrypted Data File',
    'edat2'        => 'E-DataAid 2.0 File',
    'edb'          => 'Exchange Information Store Database',
    'edc'          => 'Kryptel Lite Encrypted File',
    'eddx'         => 'Edraw XML FIle',
    'ede'          => 'Ensoniq EPS Disk Image',
    'edf'          => 'Estimator Data File',
    'edfx'         => 'Estimator.NET Estimate File',
    'edg'          => 'Edge Diagrammer File',
    'edge'         => 'Adobe Edge Project File',
    'edi'          => 'Electronic Data Interchange File',
    'edj'          => 'Enlightenment Theme File',
    'edk'          => 'Ensoniq KT Disk Image',
    'edl'          => 'Edit Decision List File',
    'edm'          => 'Adobe Extension Data Markup Language File',
    'edml'         => 'Adobe Extension Data Markup Language Document',
    'edmx'         => 'ADO.NET Entity Data Model Designer File',
    'edn'          => 'Adobe eBook Activation File',
    'edoc'         => 'Electronically Certified Document',
    'edq'          => 'Ensoniq SQ1/SQ2/KS32 Disk Image',
    'edrw'         => 'SolidWorks eDrawings File',
    'edrwx'        => 'XPS Drawing Document',
    'eds'          => 'Ensoniq SQ-80 Disk Image',
    'edv'          => 'Ensoniq VFX-SD Disk Image',
    'edx'          => 'Edraw XML FIle',
    'edxz'         => 'Edraw Compressed XML FIle',
    'edz'          => 'EPLAN Electric P8 Data Archive Zipped File',
    'eek'          => 'Arachne Network-Enabled Script',
    'eep'          => 'EEPROM Data File',
    'eepf'         => 'EmuOS Exchangeable Packet File',
    'ef'           => 'Diploma Exam File',
    'ef2'          => 'Internet Download Manager Export File',
    'efa'          => 'Ensoniq ASR File',
    'efe'          => 'Ensoniq EPS File',
    'efi'          => 'Extensible Firmware Interface File',
    'efires'       => 'EFI Image File',
    'efk'          => 'Ensoniq KT File',
    'efl'          => 'External Format Language File',
    'efp'          => 'Exchange Forms Designer Template',
    'efq'          => 'Ensoniq SQ1/SQ2/KS-32 File',
    'efr'          => 'Encryptafile Private Key File',
    'efs'          => 'Ensoniq SQ-80 File',
    'eft'          => 'Logitech Lighting Effect File',
    'eftx'         => 'Office 2007 Theme Effect File',
    'efu'          => 'Encryptafile Public Key File',
    'efv'          => 'Ensoniq VFX-SD File',
    'efw'          => 'Renamed Zip or Executable File',
    'efx'          => 'Jedi Knight Effects File',
    'egc'          => 'EximiousSoft GIF Creator Document',
    'egg'          => 'ALZip Archive',
    'eglib'        => 'Adobe Edge Animate Library File',
    'egm'          => 'Enigmo Custom Game File',
    'egp'          => 'Easy Grade Pro Gradebook File',
    'egt'          => 'EagleGet Temporary File',
    'eham'         => 'ExtraHAM Executable File',
    'ehi'          => 'HTTP Injector Config File',
    'eio'          => 'Yozo Office File',
    'eip'          => 'Enhanced Image Package File',
    'eit'          => 'Yozo Office Template File',
    'eix'          => 'Metin2 Game Data File',
    'ek6'          => 'Generation 6 Pokémon Save File',
    'ekb'          => 'ZMC Visual Tablet Data',
    'ekx'          => 'Encrypted 3DS Pokémon Save File',
    'el'           => 'Emacs Lisp Code File',
    'el4'          => 'Easy-PhotoPrint EX Calendar File',
    'elc'          => 'Emacs Compiled Lisp File',
    'eld'          => 'Eulumdat Formatted Luminaire Data File',
    'elf'          => 'Nintendo Wii Game File',
    'elm'          => 'Eternal Lands Map File',
    'els'          => 'EasyLanguage Storage File',
    'em'           => 'Encore Menu Template',
    'email'        => 'Outlook Express Email Message',
    'emb'          => 'Everest Embedded Bank File',
    'embl'         => 'EMBL Sequence Data File',
    'embr'         => 'Spatial Geodatabase File',
    'emc'          => 'Striata Reader Encrypted Document',
    'emd'          => 'ABT Extended Module',
    'emerald'      => 'Emerald Theme',
    'emf'          => 'Jasspa MicroEmacs Macro File',
    'eml'          => 'E-Mail Message',
    'emlx'         => 'Mail Message',
    'emlxpart'     => 'Mail Message Attachment',
    'emm'          => 'MindMaple Map',
    'emmt'         => 'MindMaple Map Template',
    'emp'          => 'eMusic Music Download File',
    'emrg'         => 'E-Merge 1.x Data File',
    'emrg2'        => 'E-Merge 2.0 Data File',
    'emulecollect' => 'O\'N   eMule Data File',
    'emx'          => 'eMusic Download File',
    'emy'          => 'eMelody Ringtone File',
    'emz'          => 'Windows Compressed Enhanced Metafile',
    'enc'          => 'Cabal Online Data File',
    'enex'         => 'Evernote Archive',
    'enf'          => 'EndNote Filter File',
    'eng'          => 'Chess Engine',
    'enl'          => 'EndNote Library',
    'enlx'         => 'Archived EndNote Library',
    'enml'         => 'Evernote for Android Note',
    'enp'          => 'EndNote Preferences File',
    'enq'          => 'EndNote Search Options File',
    'ens'          => 'EndNote Style File',
    'ent'          => 'External Entity',
    'entitlements' => 'Mac App Sandboxing Entitlements File',
    'env'          => 'WordPerfect Environment',
    'enw'          => 'EndNote Import File',
    'enx'          => 'eDataSecurity Management Encrypted File',
    'enz'          => 'EndNote Connection File',
    'eop'          => 'EveryonePiano Music Score File',
    'eot'          => 'Embedded OpenType Font',
    'ep'           => 'Pencil Document',
    'epc'          => 'Doctor Who Game Data File',
    'epf'          => 'EAGLE Project',
    'epi'          => 'EclipsePackager2000 Compressed File',
    'epibrw'       => 'Web File Location',
    'epim'         => 'EssentialPIM Database File',
    'epk'          => 'LG Firmware Package',
    'epk2'         => 'E-Prime 2.0 Package File',
    'epp'          => 'Efficient PPC Project File',
    'epr'          => 'Photoshop AME Preset File',
    'eprt'         => 'eDrawings File',
    'eps'          => 'Encapsulated PostScript File',
    'epsf'         => 'Encapsulated PostScript Format File',
    'epub'         => 'Open eBook File',
    'epw'          => 'EnergyPlus Weather Data File',
    'eqf'          => 'Winamp Equalizer Preset File',
    'eql'          => 'Embedded SQL File',
    'eqn'          => 'WordPerfect Equation',
    'eqp'          => 'MathType Preferences',
    'er1'          => 'ERWin Entity Relationship Diagram',
    'erb'          => 'Braille Music Reader File',
    'erd'          => 'Engineering Research Division Data File',
    'erf'          => 'Epson RAW File',
    'erg'          => 'CompuTrainer Workout File',
    'erl'          => 'GameGuard Error Log File',
    'erp'          => 'Encarta Researcher File',
    'err'          => 'AutoCAD Error Log File',
    'ers'          => 'ER Mapper Data File',
    'ersx'         => 'Eraser Task List File',
    'es'           => 'SageCRM Script File',
    'es2'          => 'E-Studio 2.0 Experiment File',
    'esb'          => 'Es-Builder Book File',
    'esc'          => 'EasySignCut Pro Project',
    'escape'       => 'Prison Architect Escape Mode Save File',
    'escopy'       => 'ES Explorer Temporary File',
    'esd'          => 'Windows Electronic Software Download File',
    'ese'          => 'Millions Email Generator Email List File',
    'esf'          => 'Password Manager Container File',
    'esg'          => 'Enigmo Saved Game File',
    'esh'          => 'Extended Shell Batch File',
    'eslock'       => 'ES File Explorer File Manager Encrypted File',
    'esm'          => 'Fallout 3 Master File',
    'esp'          => 'ACD/Labs Dataset',
    'esproj'       => 'Espresso Project File',
    'esps'         => 'ESPS Sampled Data File',
    'esq'          => 'Embroidery Sequence File',
    'ess'          => 'EasySpreadsheet Spreadsheet',
    'est'          => 'Construction Cost Estimate File',
    'est_uax'      => 'Spanish Unreal Audio Package',
    'esx'          => 'Xactimate Insurance Claims Estimate',
    'et'           => 'Easiteach Lesson File',
    'eta'          => 'Google Earth Placemark File',
    'etd'          => 'Adobe Reader EBX Transfer Data File',
    'ete'          => 'Exam Testing Engine File',
    'etf'          => 'ENIGMA Transportable File',
    'etff'         => 'Encrypt4all Theme File',
    'etl'          => 'Microsoft Event Trace Log File',
    'etng'         => 'Easiteach Next Generation Document',
    'ett'          => 'Kingsoft Spreadsheets Template',
    'etx'          => 'Structure Enhanced Text (Setext) File',
    'euc'          => 'Extended Unix Code File',
    'euf'          => 'Private Character Editor File',
    'eui'          => 'Ensoniq EPS Compacted Disk Image',
    'eum'          => 'Enterprise User Monitor Configuration File',
    'ev'           => 'Echoview File',
    'ev3'          => 'Everlock Options File',
    'ev3p'         => 'LEGO MINDSTORMS EV3 Program',
    'ev3s'         => 'LEGO MINDSTORMS EV3 Shared File',
    'event'        => 'Corel Cataloged Folder File',
    'evo'          => 'SeeVogh Player Video Recording',
    'evp'          => 'Talisman Online Game Data File',
    'evr'          => 'Enhanced Variable Rate Audio File',
    'evrc'         => 'Enhanced Variable Rate Codec File',
    'evt'          => 'Windows Event Viewer Log File',
    'evtx'         => 'Windows 7 Event Log File',
    'evx'          => 'SeeVogh Player Remote Recording',
    'evy'          => 'Envoy File',
    'ewb'          => 'Electronics Workbench Circuit Design File',
    'ewd'          => 'EasyWOOD Design File',
    'ewl'          => 'EclipseCrossword Word List File',
    'ewnet'        => 'Ultiboard Netlist File',
    'ewp'          => 'Ewisoft Website Project File',
    'ewprj'        => 'Ultiboard Layout Project',
    'ews'          => 'EasyWorship Schedule File',
    'eww'          => 'Embedded Workbench Workspace',
    'ex'           => 'Euphoria Source Code',
    'ex01'         => 'EnCase Evidence Image File',
    'ex4'          => 'MetaTrader 4 Program File',
    'ex5'          => 'MetaTrader 5 Program File',
    'ex_'          => 'Renamed Windows Executable File',
    'example'      => 'Example Configuration File',
    'exb'          => 'CAXA Draft',
    'exc'          => 'Black & White Zone File',
    'exd'          => 'Control Information Cache File',
    'exe'          => 'PortableApps.com Application',
    'exe1'         => 'Renamed EXE File',
    'exe4j'        => 'Exe4j Configuration File',
    'exif'         => 'Exchangeable Image Information File',
    'exl'          => 'JSDAI Inclusion or Exclusion List',
    'exm'          => 'Boson Exam File',
    'exo'          => 'YouTube Video Chunk File',
    'exopc'        => 'ExoPC Application',
    'exp'          => 'Bernina Embroidery File',
    'exportedfavo' => 'I\'TES Transmit Exported Favorites File',
    'exportedui'   => 'Microsoft Office Exported UI Customization File',
    'expressionma' => ' \'Cubase Expression Map File',
    'exr'          => 'OpenEXR Image',
    'exs'          => 'Blades of Exile Scenario',
    'ext'          => 'Norton Commander Extension',
    'extr'         => 'COW App Extractor File',
    'extra'        => 'Google BreakPad Crash Log Extra File',
    'exv'          => 'Adobe Extension Script',
    'exw'          => 'Euphoria Source code File',
    'exx'          => 'IBM Linkway MsgPut File',
    'eyb'          => 'Microsoft Encarta Yearbook Update File',
    'eye'          => 'Eyemail Video Recording File',
    'eyetv'        => 'EyeTV Recording File',
    'eyetvp'       => 'EyeTV Recording Metadata File',
    'eyetvsched'   => 'EyeTV Schedule File',
    'ezc'          => 'AutoCAD Ecscad Components Backup File',
    'ezdraw'       => 'EazyDraw Graphic',
    'ezlog'        => 'Skype Extras Manager Log File',
    'ezp'          => 'AutoCAD Ecscad Project Backup File',
    'ezs'          => 'EZ-R Stats Batch Script',
    'ezt'          => 'EZT Malicious Worm File',
    'ezw'          => 'easyOFFER Real Estate Form File',
    'f'            => 'Freeze Compressed File',
    'f04'          => 'Nastran Execution Summary File',
    'f06'          => 'Nastran Output File',
    'f2k'          => 'Fortran Source Code File',
    'f2r'          => 'Farandoyle Linear Module File',
    'f32'          => 'Raw 32-Bit Audio File',
    'f3d'          => 'Fusion 3D Design',
    'f3f'          => 'Crazy Machines Font File',
    'f3r'          => 'Farandoyle Blocked Module File',
    'f3z'          => 'Fusion 360 Shared Project Archive',
    'f4a'          => 'Adobe Flash Protected Audio File',
    'f4f'          => 'Flash Video Fragment',
    'f4m'          => 'Adobe Flash Media Manifest File',
    'f4p'          => 'Adobe Flash Protected Media File',
    'f4v'          => 'Flash MP4 Video File',
    'f64'          => 'Raw 64-Bit Audio File',
    'f90'          => 'Fortran 90 Source Code File',
    'f95'          => 'Fortran 95 Source Code File',
    'fa'           => 'FASTA Formatted Sequence File',
    'fac'          => 'FACE Image File',
    'face'         => 'FACE Graphic File',
    'facefx'       => 'FaceFX Actor File',
    'facefx_ingam' => ' \'FaceFX In-Game Actor File',
    'fadein'       => 'Fade In Document',
    'fadein.templ' => 'T\'E  Fade In Template',
    'fal'          => 'Bitmap Graphic Header Information',
    'familyfile'   => 'Reunion Family File',
    'fan'          => 'Finale Font Annotation File',
    'faq'          => 'Frequently Asked Questions Document',
    'far'          => 'FARO Zone File',
    'fas'          => 'QuickSilver Fast Save Lisp File',
    'fasta'        => 'FASTA Sequence File',
    'fat'          => 'Zinf Theme File',
    'favoritemeta' => 'A\'TA Transmit Favorites Data File',
    'fax'          => 'Fax Document',
    'fb!'          => 'FlashGet Incomplete Download File',
    'fb2'          => 'FictionBook 2.0 File',
    'fb2k-compone' => 'T\'Foobar2000 Component Install File',
    'fbc'          => 'Family Tree Maker for DOS Backup File',
    'fbf'          => 'Free Backup Fix Backup File',
    'fbk'          => 'AutoCAD Civil 3D Field Book File',
    'fbl'          => 'iGO Map File',
    'fbm'          => 'Fuzzy Bitmap Image',
    'fbp'          => 'wxFormBuilder Project',
    'fbp7'         => 'FinalBuilder 7 Project',
    'fbq'          => 'Trine 2 Data File',
    'fbr'          => 'Mercury Screen Recording',
    'fbrb'         => 'Battlefield Bad Company 2 Data File',
    'fbt'          => 'ABBYY FineReader Document Options File',
    'fbu'          => 'FEBE Firefox Backup File',
    'fbw'          => 'HP Recovery Manager Backup File',
    'fbx'          => 'Autodesk FBX Interchange File',
    'fbz'          => 'FlashBack Screen Recorder Movie',
    'fbz7'         => 'Compressed FinalBuilder 7 Project',
    'fc'           => 'FirstClass Settings File',
    'fc1'          => 'FCEUX Save State File',
    'fc2'          => 'Poser Face Pose File',
    'fc2map'       => 'Far Cry 2 User Map',
    'fcarch'       => 'Final Cut Pro Archive',
    'fcc'          => 'Forms Credential Collector File',
    'fcd'          => 'FastCAD DOS Drawing',
    'fcdt'         => 'FormsCentral Design Template',
    'fce'          => 'Need for Speed Mesh File',
    'fcf'          => 'Final Draft Converter File',
    'fcgi'         => 'FastCGI File',
    'fcl'          => 'ForeUI Custom Library File',
    'fcm'          => 'fCraft World File',
    'fcp'          => 'Phantasy Star Online 2 Female Cast File',
    'fcpbundle'    => 'Final Cut Pro Library',
    'fcpevent'     => 'Final Cut Pro Event File',
    'fcpproject'   => 'Final Cut Pro Project File',
    'fcproject'    => 'Final Cut Pro X Project File',
    'fcpxdest'     => 'Final Cut Pro Share Destination File',
    'fcpxml'       => 'Final Cut Pro XML File',
    'fcs'          => 'First Choice Spreadsheet',
    'fcstd'        => 'FreeCAD Document',
    'fct'          => 'FolderClone Task List',
    'fcw'          => 'FastCAD Windows Drawing',
    'fcz'          => 'Compressed Poser Face Pose File',
    'fd'           => 'DataFlex Data File',
    'fd2'          => 'PictureMate Borders File',
    'fda'          => 'Dawn of War Audio File',
    'fdb'          => 'Microsoft Dynamics NAV Database File',
    'fdc'          => 'AutoCAD Field Catalog File',
    'fdd'          => 'FormDocs Document',
    'fdf'          => 'Origin Fitting Function Definition File',
    'fdi'          => 'Amiga Disk Image',
    'fdm'          => 'Exchange Forms Designer Form Message',
    'fdp'          => 'MySafe Encrypted Data',
    'fdr'          => 'Windows Error Report File',
    'fds'          => 'Nintendo FDS ROM',
    'fdt'          => 'Impromptu Function Description Table File',
    'fdx'          => 'Food Data Exchange File',
    'fdxt'         => 'Final Draft 8 Template',
    'fe_launch'    => 'FCS Express Launch File',
    'fea'          => 'AFDKO Feature Definitions File',
    'feature'      => 'SharePoint Feature File',
    'feedback'     => 'Expression SketchFlow Feedback File',
    'fes'          => 'Fileless Occurrence Placeholder',
    'fetchmirror'  => 'Fetch Mirror Document',
    'fetchshortcu' => 'S\'Fetch Shortcut List FIle',
    'fev'          => 'FLAMES Environment Variable File',
    'fey'          => 'FCS Express Layout File',
    'ff'           => 'Call of Duty 4 Fast File',
    'ffa'          => 'Find Fast Status File',
    'ffd'          => 'FATE Saved Game',
    'fff'          => 'MAGGI Face File',
    'ffil'         => 'Mac Font Suitcase',
    'ffindex'      => 'FFmpegSource2 Media Index',
    'ffl'          => 'Fetion Emoticons Package',
    'ffm'          => 'FFmpeg Stream File',
    'ffo'          => 'Adobe Photoshop File Information File',
    'ffs'          => 'FME Desktop Feature Store File',
    'fft'          => 'Final Form Text File',
    'ffu'          => 'Full Flash Update Image File',
    'ffwp'         => 'FormsForWeb Packet',
    'ffx'          => 'Microsoft Find Fast Index',
    'fg'           => 'FaceGen Project File',
    'fg3'          => 'FX Graph 3 File',
    'fgc'          => 'Greeting Card Factory Card File',
    'fgd'          => 'Forge Game Data File',
    'fgl'          => 'Fifth Generation Language Source File',
    'fgs'          => 'Fig Figure Settings File',
    'fh'           => 'Symantec Backup Exec File',
    'fh10'         => 'FreeHand 10 Drawing File',
    'fh11'         => 'FreeHand 11 Drawing File',
    'fh3'          => 'FreeHand 3 Drawing File',
    'fh4'          => 'FreeHand 4 Drawing File',
    'fh5'          => 'FreeHand 5 Drawing File',
    'fh6'          => 'FreeHand 6 Drawing File',
    'fh7'          => 'FreeHand 7 Drawing File',
    'fh8'          => 'FreeHand 8 Drawing File',
    'fh9'          => 'FreeHand 9 Drawing File',
    'fhc'          => 'FHC Data File',
    'fhd'          => 'FreeHand Drawing File',
    'fhf'          => 'Free Hide Folder Backup File',
    'fic'          => 'WinDev Hyper File Database',
    'fid'          => 'Microsoft Catalog Indexing Service File',
    'fif'          => 'Fractal Image File',
    'fig'          => 'MATLAB Figure File',
    'fil'          => 'Symbian Application Logo File',
    'fila'         => 'Aleph One Replay File',
    'file'         => 'Generic Windows File',
    'filebolt'     => 'Filebolt Encrypted File',
    'film'         => 'Filmkey Player Media File',
    'film_cpk'     => 'Sega FILM Multimedia File',
    'filters'      => 'Visual C++ Project Filters File',
    'fimpp'        => 'FiM++ Source Code File',
    'fingnet'      => 'Overlook Fing Saved Network File',
    'firm'         => 'Boot9Strap 3DS Firmware File',
    'fit'          => 'Garmin Activity File',
    'fits'         => 'Flexible Image Transport System File',
    'fkb'          => 'Flipkart eBook File',
    'fky'          => 'FoxPro Macro',
    'fl'           => 'Freelancer Saved Game File',
    'fl1'          => 'Lenovo BIOS Update File',
    'fl3'          => 'Flash 3D File',
    'fla'          => 'Adobe Animate Animation',
    'flac'         => 'Free Lossless Audio Codec File',
    'flam3'        => 'Fractal Flames File',
    'flame'        => 'Fractal Flames File',
    'flash'        => 'Frictional Games Flashback File',
    'flb'          => 'FileMaker Pro Label File',
    'flc'          => 'FLIC Animation',
    'fld'          => 'YSFLIGHT Field File',
    'flexolibrary' => 'Final Cut Pro Library Database',
    'flf'          => 'Microsoft Dynamics NAV License File',
    'flg'          => 'Puppy Linux Partition Flag File',
    'flh'          => 'FLIC Animation File',
    'fli'          => 'FLIC Animation',
    'flic'         => 'FLIC Animation',
    'flif'         => 'Free Lossless Image Format File',
    'flipchart'    => 'ActivInspire Flipchart File',
    'flk'          => 'AccountEdge Company Lock File',
    'flka'         => 'Folder Lock Portable Locker File',
    'flkb'         => 'Folder Lock Basic Locker File',
    'fll'          => 'FoxPro Dynamic-Link Library',
    'flm'          => 'FL Studio Mobile Song File',
    'flo'          => 'Automate Flowchart File',
    'flow'         => 'Expression SketchFlow Data File',
    'flowchart'    => 'PureFlow Flowchart',
    'flowmaplibra' => 'Y\'Painter Flowmap Library',
    'flp'          => 'Flash Project',
    'flr'          => 'Flare Decompiled ActionScript File',
    'fls'          => 'ArcView GIS Windows Help Supporting File',
    'flst'         => 'Adobe InDesign Flattener Presets File',
    'flt'          => 'Vue Filters File',
    'flv'          => 'Animate Video File',
    'flw'          => 'Kivio Flow Chart',
    'flwa'         => 'Folder Lock Wallet File',
    'flx'          => 'FLIC Animation',
    'fm'           => 'FileMaker Database',
    'fm3'          => 'Lotus 1-2-3 Spreadsheet Format File',
    'fm5'          => 'FileMaker 5 Database',
    'fmat'         => 'FMAT Runfile',
    'fmc'          => 'FormConnect Form File',
    'fme'          => 'FME Mapping File',
    'fmelic'       => 'FME License File',
    'fmi'          => 'FME Include File',
    'fml'          => 'WWE RAW Character File',
    'fmod'         => 'Adobe Illustrator Flattening Module',
    'fmp'          => 'FileMaker Pro Database',
    'fmp12'        => 'FileMaker Pro 12 Database',
    'fmplugin'     => 'FileMaker Plug-in',
    'fmpsl'        => 'FileMaker Pro 12 Snapshot Link',
    'fmt'          => 'WinRAR Format File',
    'fmv'          => 'Frame Vector Metafile',
    'fmw'          => 'FME Workbench File',
    'fmx'          => 'FileMaker Plug-in',
    'fmz'          => 'Form•Z Project File',
    'fnbk'         => 'Food Network Recipe Manager Data File',
    'fnc'          => 'Frogans Player Network Certificate',
    'fnd'          => 'Windows Saved Search',
    'fnlf'         => 'Scarlett Plug-in Suite License File',
    'fnm'          => 'Fannie Mae 1003 Data File',
    'fnrecipes'    => 'Food Network Recipe File',
    'fnt'          => 'Windows Font File',
    'fnta'         => 'Aleph One Font File',
    'fo'           => 'XSL-FO Form',
    'fob'          => 'Dynamics NAV Object Container File',
    'fodp'         => 'OpenDocument Flat XML Presentation',
    'fods'         => 'OpenDocument Flat XML Spreadsheet',
    'fodt'         => 'OpenDocument Flat XML Document',
    'fol'          => 'PFS First Choice Database File',
    'folio'        => 'Adobe Folio File',
    'folx'         => 'Folx Download File',
    'fomod'        => 'Fallout Mod Archive',
    'fon'          => 'Generic Font File',
    'fop'          => 'InfoZoom Protected Data File',
    'for'          => 'Fortran 77 Source File',
    'forge'        => 'Assassin\'s Creed Game Data File',
    'form'         => 'PreForm Job File',
    'forth'        => 'Forth Language File',
    'fos'          => 'Fallout 3 Saved Game',
    'fot'          => 'Font Resource File',
    'fota'         => 'Firmware Over-the-Air File',
    'fountain'     => 'Fountain Script File',
    'fox'          => 'Furcadia Art File',
    'fp'           => 'FinePrint File',
    'fp3'          => 'FileMaker Pro 3 Database',
    'fp4'          => 'FileMaker Pro 4 Database',
    'fp5'          => 'FileMaker Pro 5 Database',
    'fp7'          => 'FileMaker Pro 7+ Database',
    'fp8'          => 'FP8 (= Fast PAQ8) Compressed File',
    'fpa'          => 'Front Panel Encrypted Order File',
    'fpbf'         => 'Mac OS X Burn Folder',
    'fpd'          => 'Front Panel Designer Project',
    'fpdx'         => 'Utilius Fairplay Project',
    'fpe'          => 'Free PDF Editor Document',
    'fpenc'        => 'FileProtect Encrypted File',
    'fpf'          => 'IKEA Home Planner File',
    'fpfv'         => 'File Protected From Virus',
    'fpg'          => 'Fenix Graphics Collection File',
    'fpi'          => 'Foxit Reader Plugin',
    'fpid'         => 'FPS Creator AI Wizard Data File',
    'fpj'          => 'CryENGINE Facial Editor Project File',
    'fpk'          => 'JetForm FormFlow File',
    'fpm'          => 'FPS Creator Map File',
    'fpmb'         => 'FPS Creator Mab Buffer File',
    'fpmo'         => 'FPS Creator Map Overlay File',
    'fpop'         => 'Spider-Man: Shattered Dimensions Saved Game',
    'fpos'         => 'Photo Pos Pro Image',
    'fpp'          => 'Flow Chart Visual Programming Language Project',
    'fppx'         => 'Microsoft Fresh Paint Painting File',
    'fpr'          => 'Humanize Preset File',
    'fps'          => 'FPS Creator Segment File',
    'fpsl'         => 'FileMaker Pro Snapshot Link',
    'fpsx'         => 'Nokia Firmware Format File',
    'fpt'          => 'Alpha Five Table Memo File',
    'fpx'          => 'FlashPix Bitmap Image File',
    'fqc'          => 'FAQ Creator File',
    'fr3'          => 'FastReport Form File',
    'frames'       => 'xScope Frames File',
    'frameset'     => 'Frame Painter for LGS Frame Set File',
    'framework'    => 'Mac OS X Application Framework',
    'frc'          => 'Mandelbrot Explorer Color Settings File',
    'frd'          => 'Frequency Response Data File',
    'frdoc'        => 'FineReader Document',
    'freecellsave' => 'M\'S  Microsoft FreeCell Saved Game',
    'freeway'      => 'Freeway Document',
    'frf'          => 'Free Report Form File',
    'frg'          => 'Sound Forge Pro Project File',
    'frj'          => 'FreeForm-J Project File',
    'frk'          => 'Macintosh Resource or Data Fork',
    'frl'          => 'Electronic Form Loader File',
    'frm'          => 'Fallout Graphics File',
    'fro'          => 'dBASE IV Compiled Report',
    'frr'          => 'Mandelbrot Explorer Fractal Region Settings File',
    'frs'          => 'Flash Renamer Script',
    'frt'          => 'FoxPro Report Memo',
    'frw'          => 'RollerCoaster Tycoon 3 Fireworks Effects File',
    'frx'          => 'FoxPro Report',
    'fry'          => 'fryrender Scene File',
    'frz'          => 'Locked FormFlow File',
    'fs'           => 'Mac OS X File System Plug-in',
    'fs2'          => 'FreeSpace 2 Saved Mission File',
    'fsa'          => 'Fragment Analysis Data File',
    'fsb'          => 'Form•Z Compiled Script',
    'fsc'          => 'FL Studio Score File',
    'fsd'          => 'Flowsheet Document',
    'fsg'          => 'FreeCol Saved Game File',
    'fsh'          => 'Fragment Shader File',
    'fsi'          => 'Visual F# Signature File',
    'fsif'         => 'MyLabel Designer Deluxe Data File',
    'fsl'          => 'Form•Z Script',
    'fsm'          => 'Splitty Master Split File',
    'fsproj'       => 'FireStarter Project File',
    'fsq'          => 'CryENGINE Facial Editor Sequence File',
    'fss'          => 'Splitty Data Split File',
    'fssave'       => 'Flight Simulator Save File',
    'fsscript'     => 'Visual F# Script',
    'fst'          => 'FL Studio State File',
    'fstab'        => 'File Systems Table File',
    'fsx'          => 'Visual F# Script File',
    'ft'           => 'Edgecam Feature Template',
    'ft10'         => 'FreeHand 10 Drawing Template',
    'ft11'         => 'FreeHand 11 Drawing Template',
    'ft7'          => 'FreeHand 7 Drawing Template',
    'ft8'          => 'FreeHand 8 Template',
    'ft9'          => 'FreeHand 9 Drawing Template',
    'ftc'          => 'Dream League Soccer Asset File',
    'ftf'          => 'FlashTool Firmware File',
    'ftg'          => 'Full Text Group',
    'fth'          => 'Foobar2000 Theme File',
    'fti'          => 'FamiTracker Instrument File',
    'ftil'         => 'e-Hastakshar Contract Note',
    'ftl'          => 'Faster Than Light Mod File',
    'ftm'          => 'Family Tree Maker for DOS File',
    'ftmb'         => 'Family Tree Maker Backup File',
    'ftmx'         => 'Finale Template File',
    'ftn'          => 'Flowton Diagram File',
    'ftp'          => 'FlashFXP XML File',
    'ftploc'       => 'FTP Location',
    'ftpquota'     => 'Ftpquota File',
    'fts'          => 'Full Text Search',
    'ftw'          => 'Family Tree Maker File',
    'fuk'          => 'Postal 2 Map File',
    'ful'          => 'Microsoft Backup File List',
    'fun'          => 'Cubify Invention File',
    'fuz'          => 'Bethesda Softworks Voice File',
    'fvp'          => 'File Viewer Plus Batch Presets File',
    'fvt'          => 'FAST Search & Transfer Video File',
    'fw'           => 'Firmware Update File',
    'fwaction'     => 'Freeway Action File',
    'fwactionb'    => 'Freeway Action Bundle File',
    'fwbackup'     => 'Freeway Backup',
    'fwd'          => 'RollerCoaster Tycoon 3 Fireworks Display File',
    'fwdict'       => 'Freeway User Dictionary File',
    'fwdn'         => 'fWriter Document',
    'fwp'          => 'Microsoft Expression Web Package',
    'fwt'          => 'FacetWin Configuration File',
    'fwtb'         => 'Freeway Template Bundle',
    'fwtemplate'   => 'Freeway Template',
    'fwtemplateb'  => 'Freeway Template Bundle',
    'fx'           => 'ReadyBoot Trace File',
    'fxa'          => 'OC3 Entertainment FaceFX Actor File',
    'fxb'          => 'FX Bank File',
    'fxc'          => 'FilePackager Configuration',
    'fxcproj'      => 'FX Composer Project File',
    'fxf'          => 'BigFix Action File',
    'fxg'          => 'FX Graph File',
    'fxl'          => 'CryENGINE Facial Expression Library',
    'fxm'          => 'WinFax Document',
    'fxml'         => 'FXML Source Code File',
    'fxp'          => 'FX Preset File',
    'fxpl'         => 'Adobe Flash FXP Library',
    'fxs'          => 'messiahStudio Scene File',
    'fxt'          => 'Finale Plug-in',
    'fz'           => 'Fritzing Project File',
    'fza'          => 'Form•Z Autosave File',
    'fzb'          => 'Casio FZ-1 Bank Dump',
    'fzbz'         => 'Fritzing Bundled Bin File',
    'fzf'          => 'Casio FZ-1 Full Dump',
    'fzip'         => 'Foxit Reader Add-on',
    'fzm'          => 'Fritzing Module File',
    'fzp'          => 'Form•Z Plug-in',
    'fzpz'         => 'Fritzing Bundled Part File',
    'fzv'          => 'Casio FZ-1 Voice Dump',
    'fzz'          => 'Fritzing Shareable Project File',
    'g'            => 'BRL-CAD Geometry File',
    'g2m'          => 'GoToMeeting Recording File',
    'g3'           => 'CCITT Group 3 Fax Image',
    'g3a'          => 'Casio Prizm Add-in File',
    'g3d'          => 'GOM 3D File',
    'g3x'          => 'RealFlight Content File',
    'g41'          => 'Commodore 1541 Disk Image',
    'g64'          => 'Genetec Video File',
    'g64x'         => 'Genetec Video File',
    'g721'         => 'G.721 Audio File',
    'g723'         => 'G.723 Audio File',
    'g726'         => 'G.726 Audio File',
    'ga3'          => 'Graphical Analysis 3 Document',
    'gadgeprj'     => 'Gadge It Project',
    'gadget'       => 'Windows Gadget',
    'gal'          => 'GenePix Array List File',
    'galaxy'       => 'Blizzard Galaxy File',
    'gallery'      => 'SMART Notebook Gallery File',
    'gallerycolle' => 'T\'ION SMART Notebook Gallery Collection File',
    'galleryitem'  => 'SMART Notebook Gallery Item File',
    'gam'          => 'Saved Game File',
    'game'         => 'Apple Chess Saved Game',
    'gamedata'     => 'Sandlot Game Data File',
    'gameproj'     => 'GameSalad Project File',
    'gan'          => 'GanttProject Project File',
    'gar'          => 'Farming Simulator Game Archive File',
    'gau'          => 'Flight Simulator Gauge File',
    'gb'           => 'GenBank Data File',
    'gb1'          => 'Game Maker Backup File',
    'gb2'          => 'Game Maker Backup File',
    'gba'          => 'Game Boy Advance ROM',
    'gbap'         => 'GLBasic Project File',
    'gbas'         => 'GLBasic Source File',
    'gbaskin'      => 'Game Boy Advance Controller Skin File',
    'gbc'          => 'Game Boy Color ROM',
    'gbcskin'      => 'Game Boy Color Controller Skin File',
    'gbi'          => 'gBurner Project File',
    'gbk'          => 'GenBank Data File',
    'gbl'          => 'Gerber Bottom Layer Data File',
    'gblorb'       => 'Glulx Blorb Game File',
    'gbm'          => 'Gameboy Map File',
    'gbo'          => 'Gerber Bottom Overlay Data File',
    'gbp'          => 'Gerber Bottom Solder Paste Data File',
    'gbproj'       => 'GarageBand Project',
    'gbr'          => 'Gameboy Tileset File',
    'gbs'          => 'Generic Build Support Metadata File',
    'gbx'          => 'Gerber PCB File',
    'gc'           => 'Galactic Conquest Saved Game',
    'gca'          => 'GCA File Archive',
    'gcd'          => 'Fallout 2 Character Profile File',
    'gcdp'         => 'Greeting Card Studio Design Project',
    'gcf'          => 'Game Cache File',
    'gcg'          => 'GCG DNA Sequence File',
    'gch'          => 'Precompiled Header File',
    'gci'          => 'GameCube Save File',
    'gcm'          => 'GameCube ROM',
    'gcode'        => 'G-Code 3D Printer File',
    'gcproj'       => 'Genome Compiler Project',
    'gcs'          => 'GameCube SharkSave File',
    'gcsx'         => 'Microsoft Office SmartArt Color File',
    'gct'          => 'Ocarina Cheat Code Manager File',
    'gcw'          => 'Microsoft Mathematics Worksheet',
    'gcx'          => 'Grapher Graph File',
    'gcz'          => 'Compressed GameCube/Wii ROM',
    'gdb'          => 'InterBase Database File',
    'gdbtable'     => 'Geodatabase Table File',
    'gdcb'         => 'GandCrab Ransomware Encrypted File',
    'gdf'          => 'GUESS Graph Data Format File',
    'gdfmakerproj' => 'C\'T   GDF Editor Project File',
    'gdg'          => 'GDevelop Project File',
    'gdg.autosave' => 'GDevelop Project Autosave File',
    'gdi'          => 'Dreamcast Gigabyte Disc Image',
    'gdiagramstyl' => ' \'OmniGraffle Diagram Style File',
    'gdoc'         => 'Google Drive Document',
    'gdocx'        => 'Google Drive Document',
    'gdr'          => 'Symbian OS Font File',
    'gdraw'        => 'Google Drive Drawing',
    'gdrive'       => 'Gizmo Virtual Drive File',
    'gds'          => 'Graphic Data System File',
    'gdt'          => 'gretl Datafile',
    'gdtb'         => 'gretl Binary Datafile',
    'gdw'          => 'Jaws Unleashed Data File',
    'ged'          => 'Game Editor Project File',
    'gedata'       => 'Qlucore Data File',
    'gedcom'       => 'GEDCOM Genealogy File',
    'gem'          => 'GEM Metafile',
    'gemspec'      => 'Gem Specification File',
    'gen'          => 'ArcView ARC/INFO UnGenerate file',
    'genbank'      => 'GenBank Data File',
    'generictest'  => 'Visual Studio Generic Test File',
    'genome'       => 'Cell Lab Design File',
    'geo'          => 'TruTops Geometry File',
    'geojson'      => 'GeoJSON File',
    'gexf'         => 'Graph Exchange XML Format File',
    'gf'           => 'METAFONT Bitmap File',
    'gfar'         => 'Greenfoot Archive',
    'gfb'          => 'GIFBlast Compressed Image File',
    'gfe'          => 'Glarysoft Encrypted File',
    'gfi'          => 'GIFI File',
    'gfie'         => 'Greenfish Icon Editor Pro Graphic',
    'gform'        => 'Google Drive Form',
    'gfp'          => 'GreenForce-Player Protected Media File',
    'gfs'          => 'Glarysoft Split File',
    'gfw'          => 'GIF World File',
    'gfx'          => 'GFx Scaleform File',
    'gg'           => 'Sega Game Gear ROM',
    'ggb'          => 'GeoGebra Document',
    'ggr'          => 'GIMP Gradient File',
    'ghb'          => 'Lego Ghost Path File',
    'gho'          => 'Norton Ghost Backup File',
    'ghs'          => 'Norton Ghost Image Segment',
    'gi'           => 'Global Image',
    'gid'          => 'Windows Help Global Index File',
    'gif'          => 'Graphical Interchange Format File',
    'gifv'         => 'GIF Video File',
    'gig'          => 'Tascam GigaSampler File',
    'gih'          => 'GIMP Image Hose File',
    'gim'          => 'PlayStation Portable Image File',
    'gin'          => 'GEMS Engine Control Unit File',
    'ginspect_prj' => 'GOM Inspect Project File',
    'gio'          => 'Nyquist MIDI File',
    'gis'          => 'CFS Console Game Installer Settings File',
    'gitattribute' => ' \'Git Attributes File',
    'gitignore'    => 'Git Ignore File',
    'gitkeep'      => 'Git Keep File',
    'gjd'          => 'The 7th Guest Media File',
    'gkh'          => 'Ensoniq EPS Family Disk Image',
    'gks'          => 'Graphics Kernel System File',
    'gl'           => 'GRASP Animation',
    'gla'          => 'Ghoul 2 Animation File',
    'glade'        => 'Glade Project File',
    'glb'          => 'Glulx Blorb Game File',
    'gld'          => 'Ground Loop Design Work File',
    'glf'          => 'Space Engine Shader File',
    'glif'         => 'Glyph Interchange Format File',
    'glink'        => 'Google Drive External File Shortcut',
    'glksave'      => 'Zoom Game Save Package',
    'glm'          => 'Ghoul 2 Model File',
    'glo'          => 'RoboHelp Glossary File',
    'global'       => 'Global Makefile',
    'glox'         => 'Microsoft Office SmartArt Graphics Layout File',
    'gls'          => 'Sothink SWF Easy Shape File',
    'gltf'         => 'GL Transmission Format File',
    'gly'          => 'Word Glossary File',
    'gm'           => 'Transport Tycoon Music File',
    'gm6'          => 'GameMaker 6 Project File',
    'gm81'         => 'Game Maker 8.1 Project File',
    'gma'          => 'Garry\'s Mod Addon File',
    'gmap'         => 'Google Drive My Map',
    'gmbck'        => 'Game Maker Background Image File',
    'gmbl'         => 'Logger Lite Document',
    'gmc'          => 'Game Music Creator Sound File',
    'gmd'          => 'GroupMail Message',
    'gme'          => 'DexDrive Game Card File',
    'gmf'          => 'Geology Multi-File',
    'gmk'          => 'Game Maker Project File',
    'gml'          => 'Gerber Mill Layer File',
    'gmmod'        => 'Game Maker 3D Model File',
    'gmmp'         => 'WCS Gamut Map Model Profile',
    'gmo'          => 'GNU Machine Object File',
    'gmp'          => 'Global Mapper Package File',
    'gmres'        => 'GameMaker Resource File',
    'gms'          => 'Gesture and Motion Signal File',
    'gmspr'        => 'Game Maker Sprite File',
    'gmt'          => 'rFactor Model File',
    'gmv'          => 'Gens Game Recording',
    'gmw'          => 'Global Mapper Workspace File',
    'gmx'          => 'GameMaker File',
    'gmz'          => 'Compressed GameMaker File',
    'gne'          => 'Flickr Web Page',
    'gnm'          => 'Gnumeric Spreadsheet',
    'gno'          => 'GenoPro Genealogy Tree File',
    'gnp'          => 'GenePool Save File',
    'gnumakefile'  => 'GNU Makefile',
    'gnumeric'     => 'Gnumeric Spreadsheet',
    'gnutar'       => 'GNU Tar Archive',
    'go'           => 'Go Source Code File',
    'god'          => 'Populous II Player Progress File',
    'gofin'        => 'DRUKI Gofin Form File',
    'gom'          => 'GOM Media File',
    'goomod'       => 'World of Goo Add-on',
    'gorm'         => 'Gorm Interface Resource File',
    'gp3'          => 'Guitar Pro 3 File',
    'gp4'          => 'CCITT Group 4 Fax File',
    'gp5'          => 'Guitar Pro 5 Tablature File',
    'gpbank'       => 'Guitar Pro Sound Bank File',
    'gpd'          => 'Gamer Profile Data File',
    'gpe'          => 'GP2X Video Game',
    'gpf'          => 'Grant Agreement Preparation Form',
    'gpg'          => 'GNU Privacy Guard Public Keyring',
    'gpi'          => 'Gerber Photoplotter Information File',
    'gpj'          => 'jGRASP Project File',
    'gpk'          => 'WaveLab Audio Peak File',
    'gpn'          => 'GlidePlan Map Document',
    'gpp'          => 'Guitar Practiced Perfectly 2 Data File',
    'gpr'          => 'Babylon Glossary Builder Project File',
    'gprx'         => 'Geoxa Project File',
    'gps'          => 'Survey Pro Coordinate File',
    'gpscan'       => 'GrandPerspective Scan File',
    'gpu'          => 'GP2X Utility Program',
    'gpx'          => 'Guitar Pro 6 Document',
    'gqsx'         => 'Microsoft Office SmartArt Styles File',
    'gr2'          => 'Granny 3D File',
    'gra'          => 'Microsoft Graph File',
    'grade'        => 'GradeStat Document',
    'gradientlibr' => 'R\'Y   Painter Gradient Library',
    'gradients'    => 'Painter Gradation Library',
    'gradle'       => 'Gradle Script',
    'graffle'      => 'OmniGraffle Drawing',
    'graphml'      => 'GraphML File',
    'graphmlz'     => 'Zip Compressed GraphML File',
    'grasp'        => 'GRASP Animation',
    'grb'          => 'GRIB Meteorological Data File',
    'grd'          => 'Surfer Grid File',
    'grdb'         => 'Gramps Database File',
    'greenfoot'    => 'Greenfoot Project Archive',
    'grf'          => 'Generic Graph File',
    'grib'         => 'Gridded Binary File',
    'grib2'        => 'GRIB2 Meteorological Data File',
    'grind'        => 'Juice Grinder Recipe File',
    'grindx'       => 'Juice Grinder Recipe File',
    'grk'          => 'Gradekeeper Class Gradebook File',
    'grl'          => 'Windows Update Status File',
    'grn'          => 'Granny 3D File',
    'gro'          => 'Allegro MIDI File',
    'grob'         => 'Graphic Object Bitmap File',
    'groove'       => 'ACID Groove File',
    'groovy'       => 'Groovy Source Code File',
    'group'        => 'Windows Contacts Group File',
    'groupproj'    => 'Delphi Project Group File',
    'growlregdict' => 'Growl Temp File',
    'growlticket'  => 'Growl Notification File',
    'grp'          => 'Ken Silverman\'s Build Engine Group File',
    'grr'          => 'Gradekeeper Class Roster File',
    'grt'          => 'Grapher Template',
    'grv'          => 'Office Groove File',
    'gry'          => 'Grayscale Image',
    'gs'           => 'Geosoft Script',
    'gs-bck'       => 'Genius Scan Backup File',
    'gs0'          => 'Sega Genesis Emulator Quick Slot 0 Save File',
    'gs3'          => 'GameStarter File',
    'gsb'          => 'Golden Software Boundary File',
    'gsba'         => 'Game Save Backup Archive',
    'gsc'          => 'Call of Duty Game Script',
    'gsd'          => 'Graphtec Vector Graphics File',
    'gsf'          => 'Game Boy Advance Sound File',
    'gsflib'       => 'Game Boy Advance Song Library',
    'gsheet'       => 'Google Drive Spreadsheet',
    'gsi'          => 'Golden Software Interchange File',
    'gslides'      => 'Google Drive Presentation',
    'gsm'          => 'US Robotics GSM Audio File',
    'gsp'          => 'Silhouette Studio SD Card Document',
    'gsproj'       => 'GameSalad Windows Project File',
    'gsr'          => 'Golden Software Reference File',
    'gsr2'         => 'Golden Software Reference File',
    'gst'          => 'MapInfo Geoset File',
    'gstencil'     => 'OmniGraffle Stencil',
    'gsx'          => 'Sega Genesis Emulator Saved State File',
    'gszip'        => 'GameSalad Marketplace Asset File',
    'gta'          => 'Microsoft Groove Tool Archive',
    'gtable'       => 'Google Drive Fusion Table',
    'gtar'         => 'GNU Tar Archive',
    'gtemplate'    => 'OmniGraffle Template',
    'gthr'         => 'Gather Log File',
    'gtkrc'        => 'GTK+ Theme File',
    'gtl'          => 'Gerber Top Layer Data File',
    'gtm'          => 'GPS TrackMaker Data File',
    'gto'          => 'Gerber Top Overlay Data File',
    'gtp'          => 'Gerber Top Solder Paste Data File',
    'gts'          => 'Gerber Top Solder Mask Data File',
    'gtworld'      => 'Growtopia World File',
    'gui'          => 'Dr.extplain Project File',
    'guides'       => 'xScope Guides File',
    'gv'           => 'Graphviz DOT File',
    'gvdesign'     => 'Gravit Designer File',
    'gvi'          => 'Google Video File',
    'gvimrc'       => 'GVim Runtime Configuration File',
    'gvp'          => 'Google Video Pointer',
    'gvsp'         => 'Geocortex Viewer for Silverlight Project',
    'gvswatch'     => 'Gravit Designer Swatch File',
    'gvy'          => 'Groovy Source Code File',
    'gwb'          => 'Interwrite Presentation File',
    'gwd'          => 'Gear Watchface Design File',
    'gwi'          => 'GroupWise Database Shortcut File',
    'gwk'          => 'GraphiCode PCB Job File',
    'gwp'          => 'Greetings Workshop Project File',
    'gws'          => 'Geosoft Workspace File',
    'gxc'          => 'General CADD Pro Component',
    'gxd'          => 'General CADD Pro Drawing',
    'gxf'          => 'General CADD Pro Font File',
    'gxh'          => 'General CADD Pro Hatch Pattern File',
    'gxk'          => 'Galaxkey Secured File',
    'gxl'          => 'Graph Exchange Language File',
    'gxm'          => 'General CADD Pro Macro File',
    'gxt'          => 'Grand Theft Auto Text File',
    'gym'          => 'Sega Genesis Sound File',
    'gz'           => 'Gnu Zipped Archive',
    'gz2'          => 'Misnamed BZ2 File',
    'gza'          => 'IZArc BGA Archive File',
    'gzi'          => 'Unix Gzip File',
    'gzip'         => 'Gnu Zipped File',
    'gzquar'       => 'Bitdefender Antivirus Quarantine File',
    'h'            => 'C/C++/Objective-C Header File',
    'h0'           => 'Movie Edit Pro Waveform Information File',
    'h10'          => 'At Home Canada 2010 Tax Return',
    'h11'          => 'At Home Canada 2011 Tax Return',
    'h12'          => 'At Home Canada 2012 Tax Return',
    'h13'          => 'H&R Block Canada 2013 Tax Return',
    'h14'          => 'H&R Block Canada 2014 Tax Return',
    'h15'          => 'H&R Block Canada 2015 Tax Return',
    'h16'          => 'H&R Block Canada 2016 Tax Return',
    'h17'          => 'H&R Block Canada 2017 Tax Return',
    'h1q'          => 'Microsoft Help Merged Query Index File',
    'h1s'          => 'Windows Assistance Platform Help File',
    'h264'         => 'H.264 Encoded Video File',
    'h2o'          => 'H2OMAP Master Project',
    'h2p'          => 'Zebra2 Preset',
    'h2w'          => 'H2testw File',
    'h3b'          => 'Line 6 POD HD300 Edit Bundle',
    'h3e'          => 'Line 6 POD HD300 Edit Preset File',
    'h3m'          => 'Heroes 3 Map File',
    'h4'           => 'Hierarchical Data Format File',
    'h4b'          => 'Line 6 POD HD400 Edit Bundle',
    'h4e'          => 'Line 6 POD HD400 Edit Preset File',
    'h4r'          => 'Heroes of Might and Magic IV Data File',
    'h5'           => 'Hierarchical Data Format 5 File',
    'h5b'          => 'Line 6 POD HD500 Edit Bundle',
    'h5e'          => 'Line 6 POD HD500 Edit Preset File',
    'h5m'          => 'Heroes of Might and Magic V Map',
    'h5s'          => 'Line 6 POD HD500 Edit Setlist File',
    'h5u'          => 'Heroes of Might and Magic V Mod File',
    'h6x'          => 'Soft6502 Trainer/Simulator Hex File',
    'h77t'         => 'MGD77T Header File',
    'ha'           => 'HA Compressed Archive',
    'haas'         => 'Everfine LED Lamp Test Results File',
    'hal'          => 'HotDocs Answer Library',
    'ham'          => 'HAM Executable File',
    'haml'         => 'Haml Source Code File',
    'han'          => 'Amazon Kindle eBook Data File',
    'handlebars'   => 'Handlebars Template',
    'has'          => 'Haskell Script',
    'hat'          => 'A Hat in Time Save File',
    'hbb'          => 'Line 6 POD HD Edit Bundle',
    'hbc'          => 'HyperBac Compressed Archive',
    'hbc2'         => 'HyperBac Compressed File Archive',
    'hbe'          => 'HyperBac Compressed and Encrypted Archive',
    'hbk'          => 'Mathcad Handbook File',
    'hbs'          => 'Line 6 POD HD Edit Setlist File',
    'hbx'          => 'BinHex Encoded File',
    'hc'           => 'VeraCrypt Container File',
    'hca'          => 'High Compression Audio File',
    'hcc'          => 'HydroCAD Prefab Chamber Data File',
    'hcd'          => 'Samsung Android Firmware File',
    'hcdt'         => 'Thinkfree Office NEO Cell Template',
    'hce'          => 'HydroCAD Hydrograph Data File',
    'hcf'          => 'Compact Ham Library',
    'hci'          => 'HydroCAD IDF Data File',
    'hcl'          => 'HotDocs Clause Archive',
    'hcp'          => 'HydroCAD Project File',
    'hcr'          => 'Half-Fold Card File',
    'hcu'          => 'Hydrograph Units Definitons File',
    'hcx'          => 'ChartXL Chart',
    'hcxs'         => 'Canadian Product Incident Report Form',
    'hd2'          => 'Poser Hand Pose File',
    'hd3d'         => 'Home Design 3D Project',
    'hda'          => 'HotDocs Auto-Assemble File',
    'hdb'          => 'HansaWorld Database File',
    'hdd'          => 'Parallels Desktop Hard Disk File',
    'hdf'          => 'Hierarchical Data Format File',
    'hdi'          => 'HotDocs Auto-Install File',
    'hdk'          => 'HotDocs Registration File',
    'hdl'          => 'HotDocs Library File',
    'hdm'          => 'HDML File',
    'hdml'         => 'Handheld Device Markup Language File',
    'hdmov'        => 'QuickTime HD Movie File',
    'hdmp'         => 'Windows Heap Dump',
    'hdp'          => 'MAGIX Hard Disk Project Audio File',
    'hdpmx'        => 'HotDocs Publisher Mapping XML File',
    'hdr'          => 'ESRI BIL Header File',
    'hdrp'         => 'HDRtist Pro Document',
    'hds'          => 'Parallels Desktop Hard Disk File',
    'hdt'          => 'Photoshop HDR Toning Preset File',
    'hdumx'        => 'HotDocs User Mapping XML File',
    'hdv'          => 'High Definition Video Format',
    'hdx'          => 'Delphi MultiHelp Index File',
    'hdz'          => 'Compressed Poser Hand Pose File',
    'he'           => 'Humongous Entertainment Game Archive',
    'he0'          => 'Humongous Entertainment Game Archive',
    'he1'          => 'Humongous Entertainment Game Archive',
    'he2'          => 'Humongous Entertainment Game Archive',
    'he4'          => 'Humongous Entertainment Sound Archive',
    'heartssave-m' => ' \'Microsoft Hearts Save File',
    'heic'         => 'High Efficiency Image Format',
    'heif'         => 'High Efficiency Image Format',
    'help'         => 'Mac OS X Help Book',
    'helpindex'    => 'Help Index Document',
    'hevc'         => 'High Efficiency Video Coding File',
    'hex'          => 'BinHex Encoded File',
    'hf'           => 'HF Image',
    'hfd'          => 'HotDocs Form Document',
    'hfs'          => 'HFS Disk Image File',
    'hft'          => 'HotDocs Form Template',
    'hfv'          => 'HFS Disk Image',
    'hgl'          => 'HP Graphics Language File',
    'hgt'          => 'SRTM Elevation Data File',
    'hh'           => 'C++ Header File',
    'hhc'          => 'HTML Help Table of Contents',
    'hhh'          => 'Power C Precompiled Header File',
    'hhk'          => 'HTML Help Index',
    'hhp'          => 'HTML Help Workshop Project',
    'hhsl'         => 'Hockey High Score List File',
    'hht'          => 'Help and Support Center HHT File',
    'hi'           => 'MacMAME High Scores File',
    'hid'          => 'KeepSafe File',
    'hid2'         => 'KeepSafe File',
    'hif'          => 'Quicken Online File',
    'hin'          => 'HyperChem Input File',
    'hip'          => 'Houdini Project File',
    'hipnc'        => 'Houdini Apprentice File',
    'his'          => 'FindinSite Database Definition File',
    'hit'          => 'The Sims Sound File',
    'hiv'          => 'Windows Registry Hive File',
    'hjt'          => 'TreePad 6 Database File',
    'hkdb'         => 'Apple iTunes Library File',
    'hki'          => 'WinHKI Archive',
    'hki1'         => 'WinHKI HKI1 Archive',
    'hki2'         => 'WinHKI HKI2 Archive',
    'hki3'         => 'WinHKI HKI3 Archive',
    'hkm'          => 'Havok Movie File',
    'hl'           => 'HeuristicLab Storage File',
    'hlb'          => 'VMS / VAX Help Library',
    'hlp'          => 'Windows Help File',
    'hlsl'         => 'High Level Shader Language File',
    'hlx'          => 'ATI Radeon Video Driver Support File',
    'hm3'          => 'Help & Manual 3 Project',
    'hma'          => 'Sony HI-MD Audio File',
    'hme'          => 'Windows Mobile Theme File',
    'hmi'          => 'HMI Audio File',
    'hmk'          => 'Hallmark Card Studio File',
    'hml'          => 'HostMonitor TestList File',
    'hmp'          => 'Worms Height Map File',
    'hms'          => 'HostMonitor Script File',
    'hmt'          => 'HighMAT File',
    'hmx'          => 'Help & Manual 4 Project',
    'hmxp'         => 'Help & Manual XML Project',
    'hmxz'         => 'Help & Manual Compressed Project',
    'hof'          => 'OMSI Map Parameter File',
    'hog'          => 'Descent Mission File',
    'hol'          => 'Outlook Holidays File',
    'honmod'       => 'HON Modification Manager File',
    'hot'          => 'The Sims Sound File',
    'how2'         => 'Visma Performit Player Configuration File',
    'hpd'          => 'HotDocs PDF Document',
    'hpf'          => 'HP9100A Program File',
    'hpg'          => 'HPGL Plot File',
    'hpgl'         => 'HP Graphics Language Plotter File',
    'hpi'          => 'Hemera Photo Objects Image File',
    'hpj'          => 'Help Project File',
    'hpk'          => 'HPack Compressed Archive',
    'hpkg'         => 'Haiku Package File',
    'hpl'          => 'HP-GL Plotter File',
    'hpp'          => 'Haluha Pearls File',
    'hpr'          => 'Internal RoboHelp File',
    'hps'          => 'GameCube Audio File',
    'hpt'          => 'HotDocs PDF Template',
    'hqm'          => 'Hardcore Questing Mode Data File',
    'hqx'          => 'BinHex 4.0 Encoded File',
    'hr'           => 'TRS-80 Image',
    'hr2'          => 'Poser Hair File',
    'hrf'          => 'Hitachi Raster Format File',
    'hrl'          => 'Erlang Header File',
    'hrz'          => 'Compressed Poser Hair File',
    'hs'           => 'LaserTank High Scores File',
    'hs2'          => 'HyperRESEARCH 2 Study File',
    'hsb'          => 'HALion Sound Bank File',
    'hsc'          => 'Aspen HYSYS Simulation File',
    'hsdt'         => 'Thinkfree Office NEO Show Template',
    'hsf'          => 'HOOPS Stream Format File',
    'hsh'          => 'Windows Catalog Search Index File',
    'hsk'          => 'Huskey Truss & Building Supply Import File',
    'hst'          => 'History File',
    'ht'           => 'HyperTerminal Session File',
    'hta'          => 'HTML Application',
    'htaccess'     => 'Apache HTACCESS File',
    'htb'          => 'Audacity Help File',
    'htc'          => 'HTML Component File',
    'htg'          => 'HackTheGame Mission Pack',
    'htm'          => 'Hypertext Markup Language File',
    'html'         => 'Hypertext Markup Language File',
    'html0'        => 'Book Designer File',
    'htmlz'        => 'Zipped HTML eBook',
    'htpasswd'     => 'Apache HTACCESS File',
    'htt'          => 'Hypertext Template File',
    'htx'          => 'HTML Extension File',
    'htxt'         => 'Hanvon eBook File',
    'htz4'         => 'HyperMaker 4 Publication',
    'htz5'         => 'HyperMaker 5 Publication',
    'huh'          => 'HydroCAD Unit Hydrograph Definitions File',
    'hum'          => 'OMSI Human Configuration File',
    'hus'          => 'Husqvarna Embroidery File',
    'hvc'          => 'HotDocs Variable Collection File',
    'hvif'         => 'Haiku Vector Icon File',
    'hvpl'         => 'iTunes Visual Plug-in File',
    'hwd'          => 'Hedgewars Demo File',
    'hwdt'         => 'Thinkfree Office NEO Word Template',
    'hwmap'        => 'Hedgewars Drawn Map File',
    'hwp'          => 'Hangul (Korean) Text Document',
    'hws'          => 'Hedgewars Saved Game',
    'hxa'          => 'Microsoft Help 2 Attribute Definition File',
    'hxc'          => 'Microsoft Help 2 Collection Definition File',
    'hxe'          => 'Microsoft Help 2 Sample Definition File',
    'hxk'          => 'Microsoft Help 2 Index File',
    'hxm'          => 'Descent 2 Resource Modification',
    'hxn'          => 'Hexagon Model File',
    'hxs'          => 'Help 2 Compiled Help File',
    'hxt'          => 'Microsoft Help 2 Table of Contents File',
    'hxx'          => 'C++ Source Code Header File',
    'hydra'        => 'Hydra Image Filter Program File',
    'hyp'          => 'HYPER Compressed Archive',
    'hype'         => 'Hype Document',
    'hyperesource' => ' \'Hype Resources Folder',
    'hypesymbol'   => 'Hype Symbol File',
    'hypetemplate' => 'Hype Document Template',
    'hyv'          => 'Team Manager Meet Event File',
    'hz'           => 'Chinese (Hanzi) Text',
    'i'            => 'INTERCAL Source File',
    'i00'          => 'DVD Shrink Part 1 File',
    'i01'          => 'DVD Shrink Part 2 File',
    'i02'          => 'DVD Shrink Part 3 File',
    'i3d'          => 'Houdini Image 3D File',
    'i3pack'       => 'Point Blank Game Data File',
    'i5z'          => 'IUCLID 5 Import/Export File',
    'iaa'          => 'INTUS Audio Archive',
    'iadaction'    => 'iAd Producer Plugin Action Template',
    'iadclass'     => 'iAd Producer Plugin Class Description File',
    'iadcomponent' => 'iAd Producer Plugin Component File',
    'iadpage'      => 'iAd Producer Plugin Page Template',
    'iadplug'      => 'iAd Producer Plugin',
    'iadproj'      => 'iAd Producer Project',
    'iadstyle'     => 'iAd Producer Plugin Style Template',
    'iaf'          => 'Outlook Internet Account File',
    'iam'          => 'Inventor Assembly File',
    'ias'          => 'Intermodulation Analysis System File',
    'ib'           => 'InterBase Database',
    'ib2'          => 'IncrediBots 2 Saved Challenge File',
    'ib3'          => 'IncrediBots 3 Saved Challenge File',
    'iba'          => 'Lectra Clothing Design Pieces File',
    'ibatemplate'  => 'iBooks Author Document Template',
    'ibb'          => 'ImgBurn Project File',
    'ibcd'         => 'InstantBingoCard Document',
    'ibch'         => 'IncrediBots Challenge File',
    'ibg'          => 'ImgBurn Graph File',
    'ibk'          => 'IncrediMail Account Backup File',
    'ibooks'       => 'Multi-Touch iBook',
    'ibp'          => 'IsoBuster Managed Image Information File',
    'ibplugin'     => 'Interface Builder Plug-in',
    'ibq'          => 'IsoBuster Managed Image File',
    'ibre'         => 'IncrediBots Replay File',
    'ibro'         => 'IncrediBots Robot File',
    'ibt'          => 'Texture and Model File',
    'ic1'          => 'Low Resolution Imagic Graphics File',
    'ic2'          => 'Medium Resolution Imagic Graphics File',
    'ic3'          => 'High Resolution Imagic Graphics File',
    'ic3d'         => 'IC3D Scene File',
    'ica'          => 'Image Object Content Architecture File',
    'ical'         => 'iCalendar File',
    'icalendar'    => 'iCalendar File',
    'icalevent'    => 'iCal Event File',
    'icaltodo'     => 'iCal To Do File',
    'icap'         => 'InCopy Package File',
    'icb'          => 'Targa ICB Bitmap Image',
    'icbu'         => 'Calendar Backup File',
    'icc'          => 'ICC Profile',
    'icd'          => 'IronCAD 3D Drawing File',
    'ice'          => 'ICE File Archive',
    'icf'          => 'Zoom Router Configuration File',
    'icg'          => 'Image Comparer Gallery File',
    'ichat'        => 'iChat Saved Chat Log',
    'icl'          => 'Windows Icon Library File',
    'icm'          => 'Image Color Matching Profile',
    'icma'         => 'InCopy Assignment File',
    'icml'         => 'InCopy Document',
    'icmod'        => 'Inner Core Minecraft PE Mod File',
    'icmt'         => 'InCopy Template',
    'icn'          => 'Windows Icon File',
    'icns'         => 'Mac OS X Icon Resource File',
    'ico'          => 'Icon File',
    'icon'         => 'Icon Image File',
    'iconpackage'  => 'IconPackager Theme File',
    'iconset'      => 'Mac OS X Icon Set Folder',
    'icontainer'   => 'CandyBar iContainer File',
    'icpr'         => 'IconUtils Project File',
    'icr'          => 'Image Comparer Results File',
    'ics'          => 'IronCAD 3D Drawing File',
    'icst'         => 'InCopy Document Preset File',
    'icursorfx'    => 'iCursor Effect File',
    'id'           => 'Lotus Notes User ID File',
    'id2'          => 'Windows Live Messenger Emoticon File',
    'id3tag'       => 'MP3 Skype Recorder Temporary File',
    'idap'         => 'Adobe InDesign Assignment Package',
    'idb'          => 'IDA Database File',
    'idc'          => 'Internet Database Connector File',
    'iddx'         => 'Static Default File',
    'ide'          => 'GTA Item Definition File',
    'idea'         => 'Tresor IDEA Encrypted File',
    'ideplugin'    => 'Xcode IDE Plug-in',
    'idf'          => 'MIDI Instrument Definition File',
    'idi'          => 'EVA Controller Event Log',
    'idl'          => 'Interface Definition Language File',
    'idlk'         => 'Adobe InDesign Lock File',
    'idml'         => 'Adobe InDesign Markup Language File',
    'idms'         => 'Adobe InDesign Snippet',
    'idpk'         => 'Adobe InDesign Package for GoLive File',
    'idpp'         => 'Adobe InDesign Preflight Profile',
    'idt'          => 'Windows Installer Database Text Archive File',
    'idv'          => 'Inventor Design View File',
    'idw'          => 'Inventor Drawing',
    'idx'          => 'Navigation POI File',
    'idx0'         => 'Runescape Cache Index File',
    'idx255'       => 'Runescape Cache File',
    'ies'          => 'IES Photometric Data File',
    'if'           => 'Procedimientos-Uno IFWin Project File',
    'ifaith'       => 'iFaith SHSH File',
    'ifc'          => 'Industry Foundation Classes File',
    'ifcxml'       => 'Industry Foundation Classes XML File',
    'ifczip'       => 'Compessed IFC File',
    'ifd'          => 'InForm Document',
    'iff'          => 'Interchange File Format',
    'ifiction'     => 'iFiction Metadata File',
    'ifl'          => '3ds Max Image File List',
    'ifm'          => 'Informed Form Data Document',
    'ifo'          => 'DVD-Video Disc Information File',
    'ifp'          => 'GTA Animation File',
    'ifs'          => 'InfoSlips Package',
    'ifw'          => 'INTUS Firmware File',
    'igc'          => 'Anime List Builder Input File',
    'iges'         => 'IGES File',
    'igg'          => 'SuiteProfiler Color Map File',
    'igi'          => 'Indigo Image File',
    'igm'          => 'Indigo Renderer Material File',
    'igma'         => 'INTUS Graph Mask Archive',
    'ign'          => 'RoboHelp Ignore List File',
    'igp'          => 'Igor Published Music Notation File',
    'igq'          => 'Indigo Queue File',
    'igr'          => 'Quest3D Channel Group Layout File',
    'igs'          => 'Indigo Renderer Scene File',
    'igt'          => 'iGrafx Document Template',
    'igx'          => 'iGrafx Document',
    'ihw'          => 'IN-HEH Timeline Workspace',
    'ihx'          => 'IN-HEH Timeline Database',
    'ii'           => 'IconWorkshop Extended Information File',
    'iif'          => 'Intuit Interchange Format File',
    'iil'          => 'CleanSweep Installation Log',
    'iim'          => 'iMacro Macro File',
    'iip'          => 'ThinAnywhere Configuration File',
    'iiq'          => 'Phase One RAW Image',
    'iit'          => 'Install Creator Project File',
    'iix'          => 'Translation Memory Index File',
    'ik'           => 'CryENGINE IK Animation File',
    'ikf'          => 'INTUS Keyboard File',
    'ikmp'         => 'IK Multimedia Preset FIle',
    'ilbm'         => 'Interleaved Bitmap Image',
    'ildoc'        => 'QuickSilver Document',
    'ilg'          => 'InstallScript Log File',
    'ilk'          => 'Incremental Linking File',
    'ilogicvb'     => 'iLogic VB File',
    'im4p'         => 'IMG4 Payload File',
    'ima'          => 'Disk Image',
    'image'        => 'OpenQwaq Image',
    'imageportfol' => 'O\'LIBRARY Painter Image Portfolio Library',
    'imapmbox'     => 'IMAP Mailbox',
    'imd'          => 'ImageDisk Disk Image File',
    'ime'          => 'Windows Input Method Editor File',
    'imf'          => 'Id Music File',
    'img'          => 'GEM Image',
    'img3'         => 'iPhone IMG3 File',
    'imga'         => 'Aleph One Image File',
    'imi'          => 'Magellan Map File',
    'imj'          => 'JFIF Bitmap Image',
    'iml'          => 'ACT! Internet Mail Message',
    'imm'          => 'iMindMap Map File',
    'immodules'    => 'GTK+ Module File',
    'imovieevent'  => 'iMovie Event File',
    'imovielibrar' => ' \'iMovie Library File',
    'imoviemobile' => 'iOS iMovie Project File',
    'imovieproj'   => 'iMovie Project File',
    'imovieprojec' => ' \'iMovie Project',
    'imp'          => 'Improv Spreadsheet',
    'imr'          => 'Impromptu Report File',
    'imt'          => 'My Time Data File',
    'imtx'         => 'iMindMap Template File',
    'imx'          => 'iMindMap Map File',
    'imy'          => 'iMelody Ringtone File',
    'imz'          => 'WinImage Compressed Disk Image',
    'in'           => 'Spyware File',
    'inc'          => 'Include File',
    'inca'         => 'InCopy CS3 Assignment File',
    'incd'         => 'InCopy Document',
    'incp'         => 'InCopy CS3 Package File',
    'inct'         => 'InCopy Template',
    'incx'         => 'InCopy CS3 Interchange File',
    'ind'          => 'Adobe InDesign Document',
    'indb'         => 'Adobe InDesign Book File',
    'indd'         => 'Adobe InDesign Document',
    'indesignplug' => 'N\'Adobe InDesign Plug-in',
    'indk'         => 'Adobe Shortcut Set File',
    'indl'         => 'Adobe InDesign Library',
    'indp'         => 'Adobe InDesign CS3 Package File',
    'inds'         => 'Adobe InDesign Snippet File',
    'indt'         => 'Adobe InDesign Template',
    'inetloc'      => 'Internet Location',
    'inf'          => 'Setup Information File',
    'inf_loc'      => 'Windows Driver Information Cache File',
    'info'         => 'Texinfo Document',
    'infopathxml'  => 'Microsoft InfoPath Form',
    'inform'       => 'Inform Project',
    'ing'          => 'MasterCook Ingredients File',
    'ini'          => 'Finale Preferences File',
    'injb'         => 'InDesign Job Bag File',
    'ink'          => 'Pocket PC Handwritten Note',
    'inl'          => 'C++ Inline File',
    'inlk'         => 'Adobe InDesign Lock File',
    'inlx'         => 'Adobe InDesign Interchange Library',
    'inm'          => 'FaxMaster Document',
    'inms'         => 'Adobe InDesign Menu Set File',
    'ino'          => 'Arduino Sketch File',
    'inp'          => 'Urdu InPage Document',
    'inprogress'   => 'Time Machine Backup Progress File',
    'ins'          => 'AGT Game Instruction File',
    'int'          => 'Intellivision Game ROM File',
    'internetconn' => 'C\'T       Apple Internet Connect Document',
    'inv'          => 'INVedit File',
    'inx'          => 'Inkscape Extension Descriptor File',
    'iobit'        => 'Advanced SystemCare Rollback File',
    'ion'          => 'File Description File',
    'ioplist'      => 'Mac OS X IOPLIST File',
    'ip'           => 'IconPackager Theme File',
    'ipa'          => 'iOS Application',
    'ipalias'      => 'iPhoto Alias File',
    'ipcc'         => 'iPhone Carrier Bundle',
    'ipch'         => 'Intellisense Precompiled Header File',
    'ipd'          => 'BlackBerry Backup File',
    'ipf'          => 'OS/2 Help File',
    'ipg'          => 'iPod Game File',
    'iphoto'       => 'iPhoto Library File',
    'iphotoprojec' => ' \'iPhoto Print Project',
    'ipick'        => 'iPick Football Image',
    'ipj'          => 'Inventor Project File',
    'ipk'          => 'Itsy Package',
    'ipl'          => 'GTA Item Placement File',
    'iplb'         => 'iPhoto Library Archive Document',
    'ipmeta'       => 'Apple iPhoto Metadata File',
    'ipn'          => 'Inventor Presentation File',
    'ipod'         => 'Rockbox Firmware File',
    'ipp'          => 'Inline Guard Macro File',
    'ipr'          => 'iProcrastinate Data File',
    'iproject'     => 'iClone Project File',
    'ips'          => 'Internal Patching System Patch File',
    'ipspot'       => 'iPhoto Spot File',
    'ipsw'         => 'iPod and iPhone Software Update File',
    'ipt'          => 'Inventor Part File',
    'iptheme'      => 'IconPackager Raw Theme File',
    'ipx'          => 'IPIX Image',
    'ipynb'        => 'Jupyter Notebook',
    'iq4'          => 'IQ4E Controller Strategy File',
    'iqy'          => 'Internet Query',
    'ircp'         => 'SpeedGrade IRIDAS Composite File',
    'irf'          => 'CCTV DVR H.264 Video File',
    'irock'        => 'intelliRock Sensor Data File',
    'iros'         => 'Adobe Save For Web Settings File',
    'irp'          => 'Internet Researcher Project File',
    'irr'          => 'Brewer Lamp File',
    'irrmesh'      => 'Irrlicht Static Mesh File',
    'irs'          => 'Adobe Save For Web Settings',
    'irx'          => 'Brewer Irradiation File',
    'is1'          => 'Synergy/DE Data Index File',
    'is2'          => 'Thermal Image Data File',
    'isale'        => 'iSale Auction',
    'isaletemplat' => ' \'iSale Template',
    'isallic'      => 'iSale License File',
    'isc'          => 'Xilinx Device Configuration File',
    'isd'          => 'Flexera InstallShield Dialog Box File',
    'ise'          => 'Xilinx ISE Project',
    'isf'          => 'Inspiration Flowchart Document',
    'ish'          => 'ISH Compressed Archive',
    'ish1'         => 'Animation-ish Wiggledoodle-ish Document',
    'ish2'         => 'Animation-ish FlipBook-ish Document',
    'ish3'         => 'Animation-ish Advanced-ish Document',
    'ism'          => 'InstallShield Project File',
    'isma'         => 'IIS Smooth Streaming Audio File',
    'ismc'         => 'Smooth Streaming Client Manifest File',
    'ismclip'      => 'iStopMotion Animation Clip',
    'ismv'         => 'IIS Smooth Streaming Video File',
    'isn'          => 'Installer Source File',
    'iso'          => 'PlayStation 2 ROM File',
    'isoz'         => 'Compressed Arbortext IsoDraw Illustration',
    'isp'          => 'IIS Internet Service Provider Settings',
    'ispc'         => 'Image Surfer Pro Collection File',
    'isr'          => 'GoMoku Game File',
    'iss'          => 'Inno Setup Script',
    'ist'          => 'Inspiration Template',
    'isu'          => 'InstallShield Uninstaller Script',
    'isx'          => 'SimulationX Project',
    'isz'          => 'Zipped ISO Disk Image',
    'it'           => 'Impulse Tracker Module',
    'ita'          => 'VTech InnoTab Application File',
    'itc'          => 'iTunes Cover Flow Data File',
    'itc2'         => 'iTunes Cover Flow Data File 2',
    'itdb'         => 'iTunes Database File',
    'ite'          => 'iTunes Extras File',
    'itemdata-ms'  => 'Windows 8 Start Screen Item Data File',
    'ithmb'        => 'iPod and iPhone Photo Thumbnails File',
    'iti'          => 'InterActual Skin File',
    'itk'          => 'ScummVM Game Data File',
    'itl'          => 'iTunes Library File',
    'itlp'         => 'iTunes LP Album File',
    'itls'         => 'iTunes Live Stream URL',
    'itm'          => 'iThink Model File',
    'itms'         => 'iTunes Music Store Link File',
    'itmsp'        => 'iTunes Store Package',
    'itn'          => 'TomTom Navigator Itinerary File',
    'itpc'         => 'iTunes Podcast Link File',
    'itr'          => 'Icy Tower Replay File',
    'its'          => 'Internet Document Set',
    'itt'          => 'IconTweaker Theme File',
    'itw'          => 'InTouch With Database File',
    'itx'          => 'ITX Form Template',
    'iup'          => 'Fritz Update File',
    'ius'          => 'InfoTMIC Firmware Update File',
    'iv'           => 'Open Inventor Scene Graph File',
    'iv2i'         => 'Norton Ghost Incremental Virtual Volume Image',
    'iva'          => 'Dementia.4207 Virus File',
    'ivc'          => 'InteliSea Vessel Configuration File',
    'ivd'          => 'Bitdefender Incremental Virus Definitions',
    'ive'          => 'OpenSceneGraph Binary File',
    'ivf'          => 'Indeo Video Format File',
    'ivr'          => 'Image Worlds File',
    'ivs'          => 'Internet Streaming Video',
    'ivt'          => 'International Volleyball 2006 Data File',
    'ivue'         => 'Live Picture IVUE Image',
    'iw'           => 'Chain Engineering Database File',
    'iwa'          => 'iWork Archive File',
    'iwb'          => 'IWBasic Source Code File',
    'iwd'          => 'Call of Duty Game Data File',
    'iwdgt'        => 'iWeb Widget File',
    'iwi'          => 'Infinity Ward Texture File',
    'iws'          => 'InstallWatch Scan File',
    'iwxdata'      => 'iWorx Data File',
    'iwz'          => 'InstallShield Express 2 Project File',
    'ix'           => 'dtSearch Index File',
    'ix2'          => 'WordPerfect Address Book File',
    'ixa'          => 'Ulead Disc Image format',
    'ixb'          => 'Ulead Disc Image',
    'ize'          => 'IZArc Archive',
    'izz'          => 'Isadora Media Control Project',
    'izzy'         => 'Isadora Project',
    'j'            => 'JAR Archive',
    'j01'          => 'Akeeba Multi-part Backup Archive',
    'j2c'          => 'JPEG 2000 Code Stream',
    'j2i'          => 'Jazz 2 Internet Link File',
    'j2k'          => 'JPEG 2000 Image',
    'j2l'          => 'Jazz Jackrabbit 2 Level File',
    'j3o'          => 'jMonkeyEngine 3D Scene',
    'j6i'          => 'Ricoh Camera Image File',
    'ja'           => 'Jet Archive',
    'jac'          => 'JaStaCry Encrypted File',
    'jad'          => 'Java Application Descriptor File',
    'jag'          => 'Jagex Data File',
    'jam'          => 'Line 6 Device Recording',
    'jap'          => 'Japanese Nintendo 64 Game ROM',
    'jar'          => 'Java Archive File',
    'jar.pack'     => 'Pack200 Packed Jar File',
    'jarvis'       => 'Jarvis Subscriber File',
    'jas'          => 'Paint Shop Pro Compressed Graphic',
    'jasper'       => 'JasperReports Data File',
    'jav'          => 'Java Source File',
    'java'         => 'Java Source Code File',
    'jb2'          => 'JBIG2 Image',
    'jbc'          => 'Jam STAPL Byte-Code File',
    'jbeam'        => 'BeamNG Vehicle Definition Format',
    'jbf'          => 'Paint Shop Pro Browser Cache File',
    'jbg'          => 'Joint Bi-level Image Group File',
    'jbi'          => 'Motoman Robot Job File',
    'jbig'         => 'Joint Bi-level Image Group File',
    'jbig2'        => 'JBIG2',
    'jbk'          => 'Juno Backup File',
    'jbmp'         => 'JAmes OS Bitmap Image',
    'jbr'          => 'Paint Shop Pro Brushes File',
    'jc!'          => 'FlashGet Incomplete Download',
    'jc'           => 'FlashGet Partial Download',
    'jceks'        => 'JCEKS Keystore File',
    'jcl'          => 'JCloze File',
    'jclic'        => 'JClic Project File',
    'jcp'          => 'JCreator Project File',
    'jcr'          => 'Nonogram Puzzle File',
    'jcrypt'       => 'JCRYPT File',
    'jcw'          => 'JCross File',
    'jcz'          => 'Liquid Motion Animation',
    'jdat'         => 'J&ASoft Data File',
    'jdb'          => 'Symantec Endpoint Protection Update File',
    'jdc'          => 'JDownloader Links File',
    'jdf'          => 'Adobe Acrobat Job Definition File',
    'jdp'          => 'BlackBerry JDE Application Project',
    'jdr'          => 'IROAD Dash Cam Video File',
    'jed'          => 'Xilinx JEDEC Programming File',
    'jef'          => 'Janome Embroidery Format',
    'jet'          => 'JET Database File',
    'jfi'          => 'JPEG File Interchange Image',
    'jfif'         => 'JPEG File Interchange Format',
    'jg4'          => 'BigJig Jigsaw Puzzle',
    'jgcscs'       => 'EditPad Custom Syntax Coloring Scheme File',
    'jgw'          => 'JPEG World File',
    'jgz'          => 'Gzipped Javascript File',
    'jhtml'        => 'Java HTML Web Page',
    'jia'          => 'Digital Photo Navigator Album',
    'jic'          => 'JTAG Indirect Configuration File',
    'jif'          => 'JPEG Image File',
    'jiff'         => 'JPEG Image File Format',
    'jigsaw'       => 'Jigsaw Explorer Save File',
    'jis'          => 'Japanese Industry Standard Text',
    'jkb'          => 'Jedi Knight Bot File',
    'jkm'          => 'JAWS Key Map File',
    'jks'          => 'Java Keystore File',
    'jl'           => 'Julia Source Code File',
    'jlr'          => 'Juliar Source Code File',
    'jmc'          => 'JM-Crypt Encrypted File',
    'jmce'         => 'JM-Crypt Encrypted File',
    'jmck'         => 'JM-Crypt Key File',
    'jmcp'         => 'JM-Crypt Encrypted File',
    'jmcr'         => 'JM-Crypt Encrypted File',
    'jmcx'         => 'JM-Crypt Encrypted File',
    'jmf'          => 'Jackhammer Project',
    'jmp'          => 'JMP Data File',
    'jms'          => 'Masher Project',
    'jmt'          => 'JMatch File',
    'jmv'          => 'Jnes Movie File',
    'jmx'          => 'JMix File',
    'jng'          => 'JPEG Network Graphic',
    'jnilib'       => 'JNI Library',
    'jnlp'         => 'Java Web Start File',
    'jnp'          => 'Java Web Start File',
    'jnr'          => 'JoinNet Recording File',
    'jnt'          => 'Windows Journal File',
    'jnx'          => 'BirdsEye JNX Raster Map',
    'jo'           => 'jo Audio File',
    'jo-7z'        => 'jo Audio File',
    'job'          => 'MetaCAM Nest Job File',
    'joboptions'   => 'Adobe Joboptions File',
    'joe'          => 'JOE Document',
    'joined'       => 'HJ-Split Data File',
    'joy'          => 'CryENGINE Facial Editor Joystick File',
    'jp1'          => 'Japanese (Romaji) Text File',
    'jp2'          => 'JPEG 2000 Core Image File',
    'jpa'          => 'Akeeba Backup Archive',
    'jpc'          => 'JPEG 2000 Code Stream File',
    'jpd'          => 'Joint PhotoDefiner Image',
    'jpe'          => 'JPEG Image',
    'jpeg'         => 'JPEG Image',
    'jpf'          => 'JPEG 2000 Image',
    'jpg'          => 'JPEG Image',
    'jpg-large'    => 'Large JPEG Image',
    'jpg2'         => 'JPEG 2000 Image',
    'jpgw'         => 'JPEG World File',
    'jph'          => 'JProbe Memory Snapshot',
    'jpn'          => 'Windows Japanese Noise-Word List File',
    'jpr'          => 'Fugawi Projection File',
    'jps'          => 'Akeeba Backup Archive',
    'jpw'          => 'World File for JPEG',
    'jpx'          => 'JBuilder Project',
    'jqz'          => 'JQuiz File',
    'jrc'          => 'PCjr Cartridge ROM File',
    'jrprint'      => 'JasperReports Print File',
    'jrs'          => 'Exchange Reserve Transaction Log File',
    'jrtf'         => 'JAmes OS Rich Text File',
    'jrxml'        => 'JasperReports Layout File',
    'jrz'          => 'PSP Game Data File',
    'js'           => 'JScript Executable Script',
    'jsd'          => 'HP JetSuite Document',
    'jsda'         => 'Jazer Data File',
    'jse'          => 'JScript Encoded File',
    'jsf'          => 'Project64 Joystick File',
    'jsfl'         => 'Animate JSFL Script File',
    'jsh'          => 'Jsh Script',
    'jsl'          => 'Corel PaintShop Pro Shape Library',
    'json'         => 'JavaScript Object Notation File',
    'jsonlz4'      => 'Compressed Firefox Bookmarks Backup File',
    'jsp'          => 'Java Server Page',
    'jspa'         => 'Java Servlet Alias',
    'jspf'         => 'JSON Playlist File',
    'jspx'         => 'XML Java Server Page',
    'jss'          => 'JavaScript Style Sheet File',
    'jst'          => 'JavaServer Page Document',
    'jsx'          => 'ExtendScript Script File',
    'jsxbin'       => 'Binary ExtendScript Script File',
    'jsxinc'       => 'ExtendScript Included Script File',
    'jt'           => 'JT Open CAD File',
    'jtbackup'     => 'Just Type Backup File',
    'jtd'          => 'JustSystems Ichitaro Document',
    'jtf'          => 'JPEG Tagged Interchange Format',
    'jtp'          => 'Windows Journal Template',
    'jts'          => 'Cyberlink AVCHD Video File',
    'jtv'          => 'JRiver TV File',
    'jtx'          => 'Jrju Text File',
    'jude'         => 'JUDE Project File',
    'jvs'          => 'JavaScript Proxy Autoconfig File',
    'jvsg'         => 'Video Surveillance Project',
    'jvsgz'        => 'Compressed Video Surveillance Project',
    'jwl'          => 'Roxio Jewel Case File',
    'jws'          => 'Java Workspace Settings File',
    'jxr'          => 'JPEG XR Image',
    'k25'          => 'Kurzweil K2500 File',
    'k26'          => 'Kurzweil K2600 File',
    'k2s'          => 'Kaiser 2 Saved Game',
    'k3b'          => 'K3b Disk Burning Project File',
    'k3g'          => '3GP Mobile Phone Video File',
    'kag'          => 'King Arthur\'s Gold Map File',
    'kal'          => 'Kratos Vision Data File',
    'kap'          => 'BSB Chart Image File',
    'kar'          => 'Karel Function Dictionary',
    'kb'           => 'C++ Keyboard Script',
    'kb2'          => 'Kleo Backup File',
    'kbd'          => '3ds Max Keyboard Shortcuts File',
    'kbits'        => 'Bits\'N\'Picas Bitmap Font File',
    'kbs'          => 'Keyboard Script File',
    'kcl'          => 'NIntendo Collision File',
    'kct'          => 'Keyman Developer Customization Source File',
    'kdb'          => 'Keypass Database File',
    'kdbx'         => 'KeePass Password Database',
    'kdc'          => 'Kodak Photo-Enhancer File',
    'kde'          => 'KryptoStorage Container File',
    'kdenlive'     => 'Kdenlive Project File',
    'kdevdlg'      => 'KDevelop Dialog Box File',
    'kdevelop'     => 'KDevelop Project Data File',
    'kdevprj'      => 'KDevelop Project File',
    'kdi'          => 'KD Player Skin Image File',
    'kdk'          => 'Kodak Proprietary Decimated TIFF File',
    'kdmp'         => 'Windows Crash Dump File',
    'kds'          => 'KD Player Skin File',
    'kdz'          => 'Kaspersky Virus Bases File',
    'keb'          => 'Kaspersky Virus Bases File',
    'kelgfile'     => 'Best Free Keylogger Log File',
    'kes'          => 'Kurzweil 3000 Document',
    'kexi'         => 'Kexi Database',
    'kexic'        => 'Kexi Database Connection File',
    'kexis'        => 'Kexi Database Shortcut File',
    'kext'         => 'Mac OS X Kernel Extension',
    'key'          => 'Keyboard Definition File',
    'key-tef'      => 'Keynote iCloud Presentation',
    'keychain'     => 'Mac OS X Keychain File',
    'keystore'     => 'Java Keystore File',
    'keytab'       => 'Kerberos Keytab File',
    'kf2'          => 'Max Payne Resource File',
    'kfm'          => 'Gamebryo 3D Model File',
    'kfn'          => 'KaraFun Karaoke File',
    'kfs'          => 'Max Payne Model File',
    'kfx'          => 'Kofax Image File',
    'kgb'          => 'KGB Archive File',
    'kgtemp'       => 'KuGou Temporary Cache File',
    'khd'          => 'Dynamics AX Kernel Help Data File',
    'khi'          => 'Dynamics AX Kernel Help Index File',
    'kic'          => 'Kodak Compressed Image File',
    'kid'          => 'Kidspiration Document',
    'kin'          => 'Kinetic Music Project',
    'kismac'       => 'KisMAC Webservice File',
    'kit'          => 'Battery Drum Kit File',
    'kix'          => 'KiXtart Script File',
    'kkk'          => 'KKK Ransomware Encrypted File',
    'klg'          => 'KOFIA Log',
    'klq'          => 'Kaspersky Quarantine File',
    'kma'          => 'Correlate Archive File',
    'kmc'          => 'Kinemac Animation File',
    'kmcobj'       => 'Kinemac Sprite Object',
    'kml'          => 'Keyhole Markup Language File',
    'kmm'          => 'K-Meleon Macro Module',
    'kmp'          => 'Mario Kart Wii Course Description File',
    'kmr'          => 'KnowledgeMill Link File',
    'kms'          => 'Correlate Solutions File',
    'kmv'          => 'Mobile DJ Video File',
    'kmy'          => 'KMyMoney Data File',
    'kmz'          => 'Google Earth Placemark File',
    'kno'          => 'DigIN Serialized Break Model',
    'knt'          => 'KeyNote Note File',
    'ko'           => 'Linux Kernel Module File',
    'kodak'        => 'Kodak Photo CD File',
    'kodu'         => 'Kodu Game File',
    'kon'          => 'Yahoo! Widget XML File',
    'koob'         => 'Koob E-Book File',
    'kor'          => 'Windows Korean Noise-Words List File',
    'koz'          => 'Bell Music File',
    'kpf'          => 'Komodo Project File',
    'kpg'          => 'Kai\'s Power Goo Graphic',
    'kpl'          => 'Kazaa Playlist File',
    'kpp'          => 'Kid Pix Presentation',
    'kpr'          => 'KPresenter Presentation',
    'kps'          => 'Keyman Developer Package Source File',
    'kpx'          => 'Kid Pix Picture',
    'kpz'          => 'Komodo Template File',
    'krab'         => 'GandCrab V4 Ransomware Encrypted File',
    'krc'          => 'Mouse and Key Recorder Macro File',
    'krz'          => 'Kurzweil K2000 File',
    'ks'           => 'Kickstart File',
    'ksc'          => 'Korg Trinity/Triton Script File',
    'ksd'          => 'KeepSafe File',
    'ksf'          => 'KMPlayer Skin File',
    'ksh'          => 'Unix Korn Shell Script',
    'ksm'          => 'Pfaff Embroidery Design File',
    'kt'           => 'Kotlin Source Code File',
    'kt2'          => 'Battery 2 Drum Kit File',
    'kt3'          => 'Battery 3 Drum Kit File',
    'kth'          => 'Keynote Theme',
    'ktn'          => 'KTooN Animation Project File',
    'ktp'          => 'Kinetic Project Template',
    'ktz'          => 'Kahootz Project File',
    'kuip'         => 'Kingsoft Office Personalization File',
    'kv'           => 'Kivy Language File',
    'kv6'          => 'Ken\'s Voxlap 6 Model File',
    'kvk'          => 'Keyman On-Screen Keyboard File',
    'kvtml'        => 'KWordQuiz File',
    'kwd'          => 'KWord Document',
    'kwm'          => 'WebMoney Key File',
    'kwreplay'     => 'Command & Conquer 3 Replay File',
    'kx'           => 'KiXtart Tokenized Script File',
    'kxx'          => 'Keyman Developer Encrypted Keyboard File',
    'kyb'          => 'Keyboard Layout',
    'kyr'          => 'Lotus Domino Key Ring File',
    'kys'          => 'Adobe Photoshop Keyboard Shortcuts File',
    'kz'           => 'KuaiZip Compressed File',
    'm'            => 'PC-98 Game Music File',
    'm12'          => 'Schiller medilog ECG Raw Data File',
    'm15'          => 'MPEG Video',
    'm1a'          => 'MPEG-1 Audio File',
    'm1pg'         => 'iFinish Video Clip',
    'm1v'          => 'MPEG-1 Video File',
    'm2'           => 'PC-98 Game Music File',
    'm21'          => 'AXMEDIS MPEG-21 File',
    'm2a'          => 'MPEG-1 Layer 2 Audio File',
    'm2p'          => 'Maxthon 2 Browser Plugin File',
    'm2s'          => 'Maxthon 2 Browser Skin File',
    'm2t'          => 'HDV Video File',
    'm2ts'         => 'Blu-ray BDAV Video File',
    'm2v'          => 'MPEG-2 Video',
    'm3'           => 'Blizzard MDX3 Model File',
    'm3d'          => 'DIALux 3D Object File',
    'm3g'          => 'Mobile 3D Graphics Program',
    'm3p'          => 'Mach3 Plugin File',
    'm3u'          => 'Media Playlist File',
    'm3u8'         => 'UTF-8 M3U Playlist File',
    'm4'           => 'Macro Processor Library',
    'm4a'          => 'MPEG-4 Audio File',
    'm4b'          => 'MPEG-4 Audio Book File',
    'm4e'          => 'MPEG-4 Video File',
    'm4p'          => 'iTunes Music Store Audio File',
    'm4r'          => 'iPhone Ringtone File',
    'm4u'          => 'MPEG-4 Playlist',
    'm4v'          => 'iTunes Video File',
    'm5p'          => 'MachFive Preset File',
    'm75'          => 'MPEG Video',
    'm77t'         => 'MGD77T Data File',
    'ma'           => 'Maya Project File',
    'ma1'          => 'Monarch Audio File',
    'mab'          => 'Mozilla Address Book',
    'mac'          => 'Application Macro File',
    'macbin'       => 'Macbinary Encoded File',
    'mad'          => 'Access Module Shortcut',
    'mae'          => 'My Avatar Editor Character File',
    'maf'          => 'Microsoft Access Form',
    'maff'         => 'Mozilla Archive Format File',
    'mag'          => 'Magic Circuit Layout File',
    'magik'        => 'Magik Source Code File',
    'magiwol'      => 'MagiWOL File',
    'mahjongtitan' => 'S\'AVE-MS Mahjong Titans Saved Game',
    'mai'          => 'Microsoft Mail File',
    'mailhost'     => 'MSN Mailhost Settings File',
    'mailplanelic' => 'N\'SE     Mailplane License File',
    'mailstatione' => 'Y\'Apple Mail Stationery File',
    'mailtoloc'    => 'Mail Internet Location File',
    'mak'          => 'Makefile',
    'make'         => 'Drush Makefile',
    'makefile'     => 'Makefile',
    'makerbot'     => 'MakerBot Print File',
    'mako'         => 'Mako Template',
    'mal'          => 'MadAppLauncher Configuration File',
    'mam'          => 'Microsoft Access Macro',
    'man'          => 'Unix Manual',
    'mani'         => 'Mine-imator Project File',
    'manifest'     => 'Steam Manifest File',
    'manm'         => 'Vietcong Game Data File',
    'map'          => 'Mapjects Server Webparts File',
    'mapimail'     => 'Send To Mail Recipient',
    'maplet'       => 'Maplet World File',
    'mapsdata'     => 'iOS Maps Data File',
    'mapx'         => 'Mapjects Client Webparts File',
    'maq'          => 'Microsoft Access Query',
    'mar'          => 'Mariner Calc Spreadsheet',
    'markdn'       => 'Markdown File',
    'markdown'     => 'Markdown Documentation File',
    'mars'         => 'Adobe MARS File',
    'marshal'      => 'Marshal Data Migration Model File',
    'mart'         => 'MartView eBook File',
    'mas'          => 'MEGA Alignment Sequence File',
    'mask'         => 'SpeedGrade Color Mask File',
    'masseffectpr' => 'F\'ILE    Mass Effect Player Profile',
    'masseffectsa' => 'E\'Mass Effect Saved Game',
    'master'       => 'ASP.NET Master Page',
    'mat'          => 'V-Ray Materials File',
    'material'     => 'Rigs of Rods Texture Reference File',
    'mato'         => 'Atomic Combat Saved Game',
    'mau'          => 'Media Attachment Unit',
    'mav'          => 'Access View File',
    'maw'          => 'Access Data Access Page',
    'max'          => 'Action Replay Max Save File',
    'maxc'         => '3ds Max Container File',
    'maz'          => 'Hover! Maze File',
    'mb'           => 'Kodak EasyShare Data File',
    'mbb'          => 'ManaBook Book File',
    'mbbk'         => 'ManaBook Book Kit File',
    'mbd'          => 'Multimedia Builder Project File',
    'mbf'          => 'Microsoft Money Backup File',
    'mbg'          => 'Microsoft Mailbag',
    'mbi'          => 'Multi-Bootable Information File',
    'mbk'          => 'dBASE IV Multiple Index Backup File',
    'mbl'          => 'Logger Pro Data File',
    'mbm'          => 'Kerbal Space Program Texture File',
    'mbn'          => 'Multi Boot Image',
    'mbox'         => 'E-mail Mailbox File',
    'mbp'          => 'MediaShow Burning Project File',
    'mbr'          => 'Master Boot Record File',
    'mbs'          => 'Opera Mailbox File',
    'mbsa'         => 'Microsoft Baseline Security Analyzer File',
    'mbt'          => 'Blue Card Manager Merit Badge Template File',
    'mbw'          => 'MBRWizard Archive',
    'mbx'          => 'Outlook Express Mailbox',
    'mc1'          => 'MedCalc Data File',
    'mc2'          => 'MasterCook 5 Cookbook File',
    'mc5'          => 'Poser 5 Material File',
    'mc6'          => 'Poser Material Collection File',
    'mc9'          => 'Mastercam 9 Geometry File',
    'mca'          => 'Minecraft \'Anvil\' Map File',
    'mcaddon'      => 'Minecraft Pack Addon File',
    'mcat'         => 'Adobe Lightroom CC Catalog File',
    'mcd'          => 'MiniCAD Design File',
    'mcdx'         => 'Mathcad Prime Document',
    'mcf'          => 'Watchtower Library Font File',
    'mcfi'         => 'Maya Initial Fluid Cache File',
    'mcfp'         => 'Maya Fluid Cache Playback File',
    'mcfunction'   => 'Minecraft Commands Function File',
    'mcgame'       => 'Minecraft Game Backup File',
    'mci'          => 'Media Control Interface File',
    'mcif'         => 'MacroMolecular Crystallographic Information',
    'mcl'          => 'Windows Media Center Link File',
    'mclevel'      => 'Minecraft Map File',
    'mcmac'        => 'MasterCook Mac Document',
    'mcmeta'       => 'Minecraft Animation File',
    'mco'          => 'Live Messenger Winks File',
    'mcolor'       => 'Mine-imator Interface Color File',
    'mcp'          => 'Megacubo Package',
    'mcpack'       => 'Minecraft Resource Pack File',
    'mcr'          => 'Tecplot Macro',
    'mcrp'         => 'MobyExplorer Encrypted File',
    'mcs'          => 'Mathcad Image',
    'mcserver'     => 'Minecraft Server File',
    'mcsp'         => 'My Craft Studio Project File',
    'mcsx'         => 'My Craft Studio Professional File',
    'mct'          => 'Windows Live Messenger Data File',
    'mctemplate'   => 'Minecraft World Template',
    'mcusw'        => 'Nokia Firmware File',
    'mcw'          => 'MacWrite II Document',
    'mcworld'      => 'Minecraft World Backup File',
    'mcx'          => 'MICRO CADAM-X/6000 Model Data File',
    'mcxe'         => 'MedicinesComplete Data File',
    'mcz'          => 'Compressed Poser Material File',
    'md'           => 'MDCD Compressed Archive',
    'md0'          => 'Adobe Photoshop Metadata Cache File',
    'md1'          => 'Alcohol Disk Image Segment 2',
    'md2'          => 'Alcohol Disk Image Segment 2',
    'md3'          => 'Quake 3 3D Model',
    'md5'          => 'MD5 Checksum File',
    'md5.txt'      => 'Message Digest 5 Hash File',
    'md5anim'      => 'id Tech 4 Model Animation File',
    'md5camera'    => 'id Tech 4 Model Camera File',
    'md5mesh'      => 'id Tech 4 3D Mesh File',
    'md8'          => 'GarageCUBE Modul8 Project',
    'mda'          => 'Access Add-in',
    'mdb'          => 'Avid Media Database',
    'mdbackup'     => 'iPhone Data Backup File',
    'mdbhtml'      => 'Microsoft Access Database HTML File',
    'mdc'          => 'MidiCo Karaoke Audio File',
    'mdd'          => 'MDict Resource File',
    'mddata'       => 'iPhone Backup File',
    'mddbs'        => 'Manic Digger Database',
    'mde'          => 'ArchiCAD Educational Version Module File',
    'mdex'         => 'MIRCaM Data EXchange File',
    'mdf'          => 'Translation Memory Data Find File',
    'mdi'          => 'Microsoft Document Imaging File',
    'mdimporter'   => 'Metadata Importer',
    'mdinfo'       => 'iPhone Backup Information File',
    'mdj'          => 'StarUML Model File',
    'mdl'          => 'Luigi\'s Mansion 3D Model File',
    'mdl0'         => 'Wii Model File',
    'mdm'          => 'Mario Dash Map File',
    'mdmp'         => 'Windows Minidump',
    'mdn'          => 'Blank Access Database Template',
    'mdown'        => 'Markdown File',
    'mdp'          => 'Visual C++ 5 Workspace File',
    'mdq'          => 'Transformation Extender Database Definition',
    'mdr'          => 'ModPlug Compressed Module',
    'mds'          => 'TestComplete Project File',
    'mdsx'         => 'MEGA Saved Session',
    'mdt'          => 'Microsoft Access Data File',
    'mdw'          => 'Access Workgroup File',
    'mdx'          => 'MDict Dictionary File',
    'mdz'          => 'Access Wizard Template',
    'mdzip'        => 'MagicDraw Project Archive',
    'me'           => 'Temporary Delete Me File',
    'me2mod'       => 'Mass Effect 2 Modification File',
    'meb'          => 'PRO100 3D Interior Catalog Element',
    'med'          => 'RSView Development Project',
    'mef'          => 'Mamiya RAW Image',
    'meg'          => 'MEGA Data File',
    'mega'         => 'Megacubo XML Metafile',
    'mel'          => 'Maya Embedded Language File',
    'mell'         => 'Mellel Word Processing File',
    'mellel'       => 'Mellel Word Processing Document',
    'mem'          => 'Macro Editor Macro',
    'menc'         => 'Windows Mobile Encrypted File',
    'menu'         => 'Quake 3 Engine Menu File',
    'meo'          => 'MEO Encrypted Archive',
    'mer'          => 'RSView Development Runtime File',
    'merlin2'      => 'Merlin Project File',
    'merlinlicens' => ' \'Merlin License File',
    'mesh'         => '3D Mesh Model',
    'met'          => 'Presentation Manager Metafile',
    'meta'         => 'RealPlayer Metafile',
    'metadata_nev' => 'R\'_INDEX Spotlight Never Index File',
    'mex'          => 'Macro Express File',
    'mf'           => 'Panda Multifile',
    'mf4'          => 'ASAM Measurement Data Format File',
    'mfa'          => 'MobileFrame App File',
    'mfcribbon-ms' => 'MFC Ribbon Definition XML File',
    'mfd'          => 'Music Finder Database',
    'mfe'          => 'MobileFrame Enterprise Data File',
    'mfil'         => 'Blizzard Software Update File',
    'mfl'          => 'ModFit LT Analysis Report File',
    'mfo'          => 'MobileFrame Object File',
    'mfp'          => 'Macromedia FlashPaper Document',
    'mfs'          => 'MetFS Encrypted File System',
    'mft'          => 'Kaspersky File Table',
    'mfu'          => 'MobileFrame Update File',
    'mfv'          => 'MobileFrame Device Pack File',
    'mfw'          => 'Mamiya Camera Raw File',
    'mfx'          => 'Multimedia Fusion Extension',
    'mga'          => 'Manga Document',
    'mgc'          => 'MGCSoft Equation Illustrator File',
    'mgcb'         => 'Equation Illustrator Project File',
    'mgd77'        => 'MGD77 Data File',
    'mgdatabase'   => 'MacGourmet Deluxe Database File',
    'mgf'          => 'Materials and Geometry Format',
    'mgk'          => 'ImageMagick Configuration File',
    'mgl'          => 'Age of Empires 2 Replay File',
    'mgm'          => 'MGCSoft Equation Illustrator Macro',
    'mgmf'         => 'MindGenius Map File',
    'mgmt'         => 'MindGenius 2-3 Template',
    'mgmx'         => 'MindGenius XML Map File',
    'mgo'          => 'MacGourmet Recipe File',
    'mgourmet'     => 'MacGourmet Deluxe Document',
    'mgourmet3'    => 'MacGourmet Deluxe 3 Document',
    'mgourmet4'    => 'MacGourmet Deluxe 4 Document',
    'mgs'          => 'MGCSoft Vector Shapes File',
    'mgspot'       => 'MacGourmet Spotlight MetaData File',
    'mgt'          => 'Musicnotes Guitar Guru Song File',
    'mgtheme'      => 'MacGourmet Theme File',
    'mgtx'         => 'MindGenius XML Template File',
    'mgv'          => 'Yamaha MegaVoice File',
    'mgx'          => 'Rise of Nations Saved Game',
    'mhp'          => 'Maths Helper Plus File',
    'mhs'          => 'Xilinx XPS Hardware Specification File',
    'mht'          => 'MHTML Web Archive',
    'mhtml'        => 'MIME HTML File',
    'mi4'          => 'Audio Player Firmware File',
    'mic'          => 'Image Composer File',
    'mid'          => 'MapInfo Data File',
    'midi'         => 'MIDI File',
    'mif'          => 'Management Information Format',
    'miff'         => 'Magick Image File',
    'mig'          => 'Windows Migration Backup File',
    'migratedapli' => 'R\'ARY    Migrated Aperture Library',
    'migratedphot' => 'L\'IBRARY Migrated Photo Library',
    'mii'          => 'Wii Virtual Avatar File',
    'milk'         => 'MilkDrop Winamp Plugin Preset',
    'mim'          => 'Multi-Purpose Internet Mail Message File',
    'mime'         => 'Multi-Purpose Internet Mail Extension',
    'min'          => 'Pokemon Mini File',
    'mind'         => 'MindMeister Map File',
    'mindnode'     => 'MindNode Document',
    'mine'         => 'Minecraft Map File',
    'minesweepers' => 'V\'E-MS   Minesweeper Saved Game',
    'mini2sf'      => 'Nintendo DS Sound Information File',
    'minigsf'      => 'Game Boy Advance Song File',
    'minincsf'     => 'NCSF Nintendo DS Audio File',
    'minipsf'      => 'Miniature PlayStation Sound Format File',
    'minipsf2'     => 'Miniature PlayStation Sound Format File',
    'miniso'       => 'Mini Image Destination File',
    'miniusf'      => 'Nintendo 64 Song File',
    'mint'         => 'Linux Mint Installer File',
    'mio'          => 'WarioWare D.I.Y. Microgame File',
    'mip'          => 'Multiple Image Print File',
    'mir'          => 'Mini-Image Ripper Disc Image',
    'mis'          => 'Marble Blast Gold Mission File',
    'mission'      => 'Vega Strike Mission File',
    'mit'          => 'MineEdit Inventory Template File',
    'mix'          => 'MotoGP Game File',
    'mj2'          => 'Motion JPEG 2000 Video Clip',
    'mjbooktempla' => 'E\'MacJournal Book Template',
    'mjd'          => 'Adobe Acrobat MIME Encoded Job Definition File',
    'mjdoc'        => 'MacJournal Document',
    'mjk'          => 'Question File',
    'mjp'          => 'MJPEG Video File',
    'mjpeg'        => 'Motion JPEG Video File',
    'mjpg'         => 'Motion JPEG Video File',
    'mjs'          => 'Node.js ES Module File',
    'mk'           => 'Makefile',
    'mk3d'         => 'Matroska 3D Video File',
    'mk4'          => 'Schiller medilog ECG Raw Data File',
    'mka'          => 'Matroska Audio File',
    'mkd'          => 'Markdown Documentation File',
    'mks'          => 'Matroska Elementary Stream File',
    'mkv'          => 'Matroska Video File',
    'ml'           => 'ML Source Code File',
    'mlb'          => 'Visual FoxPro Library',
    'mlc'          => 'MobaLiveCD File',
    'mlk'          => 'MasterCook Look File',
    'mll'          => 'Maya Plugin',
    'mlm'          => 'MolMeccano File',
    'mlp'          => 'Meridian Lossless Packing Audio File',
    'mlpkginstall' => 'Support Package Installer File',
    'mls'          => 'CrystalPlayer Playlist',
    'mlx'          => 'MATLAB Live Script',
    'mm'           => 'NeXtMidas Macro File',
    'mm6'          => 'Might and Magic 6 Saved Game',
    'mm7'          => 'Might and Magic 7 Saved Game',
    'mm8'          => 'Might and Magic 8 Saved Game',
    'mma'          => 'Master Album Maker Photo Album File',
    'mmap'         => 'MindManager Map File',
    'mmat'         => 'MindManager Map Template',
    'mmc'          => 'Microsoft Media Catalog',
    'mmcollection' => 'Mail Manager Collection File',
    'mmdc'         => 'MediaMonkey Device Configuration File',
    'mme'          => 'Multi-Purpose Internet Mail',
    'mmf'          => 'Microsoft Message File',
    'mmg'          => 'Model Master 3 Axis Flat File',
    'mmip'         => 'MediaMonkey Installation Package',
    'mml'          => 'Microsoft Clip Organizer File',
    'mmlp'         => 'Music Macro Language Project',
    'mmm'          => 'MiraMon Maps File',
    'mmo'          => 'Memory Map Overlay File',
    'mmp'          => 'LMMS Project File',
    'mmpz'         => 'LMMS Project File',
    'mms'          => 'Transformation Extender Map Source File',
    'mmu'          => 'myPM Merge Data File',
    'mmv'          => 'MicroMV Video File',
    'mmw'          => 'Microsoft Clip Organizer Media Catalog File',
    'mmz'          => 'MiraMon Compressed Map File',
    'mnc'          => 'AutoCAD Compiled Menu File',
    'mng'          => 'Yamaha PSR Disk Manager File',
    'mnh'          => 'Master Navigator Header File',
    'mnk'          => 'My Notes Keeper Notebook',
    'mnl'          => 'AutoCAD Menu LISP File',
    'mnm'          => 'Character Studio Marker Name File',
    'mno'          => 'Macromedia Design Note',
    'mnr'          => 'AutoCAD Menu Resource File',
    'mns'          => 'AutoCAD Interface Settings File',
    'mnt'          => 'FoxPro Menu Memo',
    'mnu'          => 'Adobe Photoshop Menu Customization File',
    'mnv'          => 'PlayStation Movie File',
    'mnx'          => 'FoxPro Menu',
    'mny'          => 'Microsoft Money File',
    'mo'           => 'Machine Object File',
    'mo3'          => 'MO3 Audio File',
    'mob'          => 'MOBTV Video File',
    'mobi'         => 'Mobipocket eBook',
    'mobileconfig' => 'Apple Mobile Configuration File',
    'mobileprovis' => 'O\'N      Xcode Mobile Provisioning Profile',
    'mobirise'     => 'Mobirise Project File',
    'mod'          => 'Femap Model',
    'modd'         => 'Sony Video Analysis File',
    'mode'         => 'Ninja Kiwi Game Data File',
    'mode1v3'      => 'Xcode Project Data File',
    'mode2v3'      => 'Xcode Project Data File',
    'model'        => 'CATIA 3D Model FIle',
    'modfem'       => 'Femap Model',
    'modpkg'       => 'Minecraft Pocket Manager File',
    'module'       => 'Drupal Module File',
    'moef'         => 'Apple Motion Effect Project Template',
    'mof'          => 'Managed Object Format File',
    'moff'         => 'Sony Video Data File',
    'mogg'         => 'Multitrack Ogg File',
    'mogrt'        => 'Adobe Motion Graphics Template',
    'moho'         => 'Moho Animation Project',
    'mohoaction'   => 'Moho Action Document',
    'mohobrush'    => 'Moho Action Document',
    'mohoexport'   => 'Moho Export Profile Document',
    'mohoproj'     => 'Moho Document Data File',
    'mohostyle'    => 'Moho Style Document',
    'moi'          => 'MOI Video File',
    'mol'          => 'MDL Molfile',
    'mom'          => 'Managed Object Model',
    'momma'        => 'Offspring Fling Replay File',
    'money'        => 'Money Data File',
    'moneywell'    => 'MoneyWell Account File',
    'montage'      => 'Montage Screenplay File',
    'moov'         => 'Apple QuickTime Movie',
    'mos'          => 'Leaf Camera RAW File',
    'mosaic'       => 'MacOSaiX Mosaic File',
    'mot'          => 'LightWave Motion File',
    'moti'         => 'Apple Motion Title Project Template',
    'motn'         => 'Apple Motion Generator Project Template',
    'motr'         => 'Apple Motion Transition Project Template',
    'mou'          => 'WinMount Compressed File',
    'mov'          => 'Apple QuickTime Movie',
    'movie'        => 'Payday Movie File',
    'mox'          => 'ExtendSim Simulation Software Model',
    'moz'          => 'Mozilla Cache File',
    'mp'           => 'LaTeX MetaPost File',
    'mp1'          => 'MPEG-1 Layer 1 Audio File',
    'mp10'         => 'Multisim 10 Project File',
    'mp11'         => 'Multisim 11 Project File',
    'mp12'         => 'Multisim 12 Project',
    'mp13'         => 'Multisim 13 Project',
    'mp14'         => 'Multisim 14 Project',
    'mp2'          => 'Heroes of Might and Magic II Map File',
    'mp21'         => 'AXMEDIS MPEG-21 Object',
    'mp2m'         => 'Max Payne 2 Mod File',
    'mp2s'         => 'Max Payne 2 Saved Game',
    'mp2v'         => 'MPEG-2 Video File',
    'mp3'          => 'MP3 Audio File',
    'mp4'          => 'MPEG-4 Video File',
    'mp4.infovid'  => 'Parrot AR Drone and Gyro Flyer Video',
    'mp4v'         => 'MPEG-4 Video',
    'mp7'          => 'Multisim 7 Project File',
    'mp8'          => 'Multisim 8 Project',
    'mp9'          => 'Multisim 9 Project File',
    'mp_'          => 'Mobile Phone Sound File',
    'mpa'          => 'MPEG-2 Audio File',
    'mpb'          => 'MyPhoneExplorer Backup File',
    'mpc'          => 'Musepack Compressed Audio File',
    'mpcpl'        => 'Media Player Classic Playlist',
    'mpd'          => 'File List Creator Playlist',
    'mpdconf'      => 'Music Player Daemon File',
    'mpdp'         => 'MixPad Project File',
    'mpe'          => 'MPEG Movie File',
    'mpeg'         => 'MPEG Movie',
    'mpeg1'        => 'MPEG-1 Video File',
    'mpeg2'        => 'MPEG-2 Video File',
    'mpeg4'        => 'MPEG-4 File',
    'mpf'          => 'MainActor Project File',
    'mpg'          => 'MPEG Video File',
    'mpg2'         => 'MPEG-2 Video File',
    'mpg4'         => 'MPEG-4 Video File',
    'mpga'         => 'MPEG-1 Layer 3 Audio File',
    'mpgindex'     => 'Adobe MPEG Index File',
    'mph'          => 'Photostory Deluxe Project',
    'mpi'          => 'InstallJammer Project File',
    'mpj'          => 'Minitab Project File',
    'mpk'          => 'Project64 Memory Pack File',
    'mpkg'         => 'Meta Package File',
    'mpkt'         => 'MOPEKS Trial File',
    'mpl'          => 'MPL2 Subtitles File',
    'mpls'         => 'Blu-ray Movie Playlist File',
    'mpm'          => 'Max Payne Modfication File',
    'mpo'          => 'Multi Picture Object File',
    'mpp'          => 'MobileFrame Project Publisher File',
    'mppz'         => 'MagicPlot Project File',
    'mpq'          => 'Blizzard Mo\'PaQ File',
    'mpqe'         => 'Blizzard Encrypted Mo\'PaQ File',
    'mpr'          => 'Direct Mail Project File',
    'mproj'        => 'Mine-imator Project',
    'mps'          => 'Max Payne Saved Game',
    'mpsub'        => 'MPlayer Subtitles File',
    'mpt'          => 'Microsoft Project Template',
    'mpu'          => 'MPEG Layer 3 Audio File',
    'mpv'          => 'MPEG Elementary Stream Video File',
    'mpv2'         => 'MPEG-2 Video Stream',
    'mpw'          => 'Microsoft Project Workspace File',
    'mpws'         => 'MathPiper Worksheet',
    'mpx'          => 'FoxPro Compiled Menu Program',
    'mpz'          => 'Red Eclipse Map File',
    'mpzip'        => 'Multisim Pack File',
    'mq4'          => 'MQL4 Source Code File',
    'mq5'          => 'MQL5 Source Code File',
    'mqh'          => 'MetaTrader Include File',
    'mqo'          => 'Metasequoia Document',
    'mqv'          => 'Sony Movie Format File',
    'mrb'          => 'Multiple Resolution Bitmap File',
    'mrc'          => 'mIRC Script File',
    'mrf'          => 'Mouse Recorder File',
    'mrg'          => 'MySQL Merge File',
    'mrimg'        => 'Macrium Reflect Disk Image',
    'mrk'          => 'DPOF Auto Print Order File',
    'mrml'         => '3D Slicer Scene Description File',
    'mrp'          => 'Mobile Application File',
    'mrs'          => 'GunZ Game Data File',
    'mrsn'         => 'Mersenne Source Code File',
    'mrt'          => 'Stimulsoft Report File',
    'mrw'          => 'Minolta Raw Image File',
    'mrxs'         => 'MIRAX Virtual Slide File',
    'mry'          => 'Tomboy Industrees Memory File',
    'ms'           => 'Maxwell Script',
    'ms-tnef'      => 'MS Transport Neutral Encapsulation Format',
    'ms1'          => 'VirtualBus Map File',
    'ms10'         => 'Multisim 10 Circuit Design File',
    'ms11'         => 'Multisim 11 Circuit Design File',
    'ms12'         => 'Multisim 12 Circuit Design File',
    'ms13'         => 'Multisim 13 Circuit Design File',
    'ms14'         => 'Multisim 14 Circuit Design File',
    'ms3d'         => 'MilkShape 3D Model',
    'ms7'          => 'Multisim 7 Circuit Design File',
    'ms8'          => 'Multisim 8 Circuit Design File',
    'ms9'          => 'Multisim 9 Circuit Design File',
    'msb'          => 'Oracle Binary Message File',
    'msbt'         => 'Nintendo Wii Galaxy Dialogue File',
    'msc'          => 'MuseScore Composition File',
    'msct'         => 'MOPEKS Script File',
    'mscx'         => 'MuseScore Music Score File',
    'mscz'         => 'MuseScore Compressed Score File',
    'msd'          => 'Map Service Definition File',
    'msdvd'        => 'Windows DVD Maker Project File',
    'mse'          => 'MediaShow Slideshow Project File',
    'msf'          => 'Blue Card Manager Merit Badge Mastersheet File',
    'msg'          => 'Fallout Message File',
    'msh'          => 'Visual Communicator Project File',
    'msh1xml'      => 'Monad Display Configuration File',
    'msha'         => 'Microsoft Help Asset File',
    'mshc'         => 'Microsoft Help Container File',
    'mshi'         => 'Microsoft Help Index File',
    'msi'          => 'Windows Installer Package',
    'msif'         => 'MyLabel Designer Deluxe Data File',
    'msim'         => 'mSecure Password Manager Backup File',
    'msk'          => 'Paint Shop Pro Mask File',
    'mskn'         => 'MediaMonkey Skin File',
    'msl'          => 'Magick Scripting Language File',
    'msm'          => 'Multisim Circuit Design File',
    'msmpl_all'    => 'Korg microSAMPLER Backup File',
    'msmpl_bank'   => 'Korg microSAMPLER Bank Data File',
    'msn'          => 'Host Blocking File',
    'mso'          => 'Microsoft Office Macro Reference File',
    'msp'          => 'ClarisWorks Dictionary File',
    'mspx'         => 'Microsoft ASP.NET Web Page',
    'msrcincident' => 'Windows Remote Assistance Invitation File',
    'mss'          => 'MyScreenSaver Builder File',
    'msstyle'      => 'Windows XP Unsigned Style',
    'msstyles'     => 'Windows XP Style',
    'mst'          => 'Corel Presentations Master Template File',
    'msu'          => 'Windows Vista Update Package',
    'msv'          => 'Memory Stick Voice File',
    'msw'          => 'Painter Color Mixer Swatches File',
    'mswmm'        => 'Windows Movie Maker Project',
    'mt2'          => 'MadTracker 2 Module',
    'mt2s'         => 'MPEG-2 Transport Stream File',
    'mt9'          => 'MT9 Audio File',
    'mta'          => 'Samsung AllShare Metadata File',
    'mtc'          => 'Make the Cut! Project',
    'mtd'          => 'Musicnotes Digital Sheet Music File',
    'mte'          => 'MadTracker 2 Envelope',
    'mtf'          => 'Mortality Table File',
    'mtff'         => 'MadgeTech Data Logger Report',
    'mth'          => 'Derive Math File',
    'mthd'         => 'MOPEKS Method File',
    'mti'          => 'MadTracker Instrument',
    'mtl'          => 'OBJ Material File',
    'mtm'          => 'Macrofocus TreeMap File',
    'mtp'          => 'MadTracker 2 Pattern',
    'mtq'          => 'Mustaq Data File',
    'mts'          => 'MEGA Tree Session File',
    'mtt'          => 'MetadataTouch Template',
    'mtv'          => 'MTV Video Format File',
    'mtw'          => 'Minitab Worksheet File',
    'mtx'          => 'MetaStream Scene File',
    'mtxt'         => 'MOPEKS Text File',
    'mtz'          => 'Compressed MetaStream Scene File',
    'mu'           => 'Kerbal Space Program Mesh File',
    'mu3'          => 'Myriad Packed Musical Score',
    'mud'          => 'Textease Multi User Database',
    'muf'          => 'Alpha Five License File',
    'mui'          => 'Myriad User Instrument File',
    'mui_cccd5ae0' => 'Hid User Library',
    'mul'          => 'Deus Ex: HR Multiplexed Audio File',
    'mulib'        => 'Muse Library File',
    'mum'          => 'MATLAB Unit Operation Model File',
    'mup'          => 'Music Publisher Score',
    'mus'          => 'Doom Music File',
    'musa'         => 'Aleph One Music File',
    'muse'         => 'Adobe Muse Website Project',
    'musx'         => 'Finale Notation File',
    'mux'          => 'Myriad Stand-Alone Music Score',
    'muz'          => 'MUZ Audio File',
    'mv'           => 'MivaScript File',
    'mv_'          => 'Movie Edit Pro Movie Backup File',
    'mvb'          => 'Multimedia Viewer Book Source File',
    'mvc'          => 'Movie Collector Catalog',
    'mvd'          => 'MindView OS X Document',
    'mvdx'         => 'MindView Windows Document',
    'mve'          => 'Infinity Engine Movie File',
    'mvex'         => 'Muvee autoProducer 6 Project File',
    'mvg'          => 'Magick Vector Graphics File',
    'mvi'          => 'AutoCAD Movie Command File',
    'mvm'          => 'Photostory Deluxe Slideshow',
    'mvp'          => 'MoviePlus Project File',
    'mvr'          => 'IBM HotMedia Multimedia File',
    'mvs'          => 'Microchip Verification Specification File',
    'mvtx'         => 'MindView Template',
    'mvx'          => 'Multimedia Fusion Movement Extension',
    'mvy'          => 'Video easy Project File',
    'mw'           => 'MacWrite Text Document',
    'mwand'        => 'GarageBand MagicMentor Template',
    'mwb'          => 'MySQL Workbench Document',
    'mwd'          => 'Mariner Write Document',
    'mwf'          => 'Translation Memory Word Find File',
    'mwl'          => 'XMS Print Layout File',
    'mwlic'        => 'MoneyWell License File',
    'mwm'          => 'Space Engineers 3D Model File',
    'mwp'          => 'Lotus Word Pro SmartMaster File',
    'mwps'         => 'Need for Speed: Most Wanted Car Attributes',
    'mws'          => 'MWave DSP Synth Instrument Extract',
    'mwx'          => 'MicroWorlds EX File',
    'mx'           => 'Mathematica Serialized Package File',
    'mx2'          => 'Heroes of Might and Magic II Expansion Map',
    'mx3'          => 'Mixcraft 3 Audio Project',
    'mx4'          => 'Mixcraft 4 Audio Project',
    'mx5'          => 'Mixcraft 5 Audio Project',
    'mx5template'  => 'Mixcraft 5 Audio Project Template',
    'mxad'         => 'Mandelbrot Explorer All Data File',
    'mxaddon'      => 'Maxthon Add-On File',
    'mxc2'         => 'MAGIX Cache File',
    'mxcs'         => 'Mandelbrot Explorer Color Scheme File',
    'mxd'          => 'ArcGIS Map Document',
    'mxdic'        => 'Maxthon Dictionary File',
    'mxe'          => 'Macro Express Playable Macro',
    'mxf'          => 'Maxis Font File',
    'mxfr'         => 'Mandelbrot Explorer Fractal Region File',
    'mxg'          => 'Miinoto Exchangeable Group File',
    'mxi'          => 'Adobe Extension Information File',
    'mxl'          => 'Compressed MusicXML File',
    'mxliff'       => 'Memsource XLIFF Localization File',
    'mxm'          => 'Maxwell Material File',
    'mxmf'         => 'Mobile XMF Ringtone File',
    'mxml'         => 'Flex MXML Component',
    'mxn'          => 'Miinoto Exchangeable Note File',
    'mxp'          => 'Adobe Extension Package',
    'mxs'          => 'Painter Color Mixer Pad File',
    'mxskin'       => 'Maxthon Skin File',
    'mxt'          => 'ArcGIS Map Template',
    'mxv'          => 'MAGIX Video File',
    'myapp'        => 'Visual Studio Application XML File',
    'mycolors'     => 'Stardock MyColors Theme File',
    'myd'          => 'Everfine Photomoetric Results File',
    'mydocs'       => 'Send To My Documents',
    'myi'          => 'MySQL MyISAM Index File',
    'myl'          => 'MyLogo Maker Image',
    'mynotesbacku' => ' \'Keep My Notes Backup',
    'myo'          => 'AccountEdge Company File',
    'myr'          => 'Myriad Music File',
    'mys'          => 'Vineyard Captured Video File',
    'mzp'          => 'Mozart Percussion File',
    'mzz'          => 'Microsoft .NET Download Package',
    'n'            => 'Neko Bytecode File',
    'n-gage'       => 'N-Gage Application',
    'n2'           => 'Nitrous Minecraft GLSL Shader File',
    'n3d'          => 'Super 3D Noah\'s Ark Data File',
    'n3pmesh'      => 'Knight Online 3D Mesh File',
    'n3r'          => 'Panasonic Security System Video File',
    'n64'          => 'Nintendo 64 Emulator ROM File',
    'na2'          => 'Netscape Address Book File',
    'naac'         => 'Namco AAC File',
    'nam'          => 'Aqua3D Network File',
    'nap'          => 'NAP Metafile',
    'nar'          => 'Nexon game archive',
    'narc'         => 'Nintendo DS Archive File',
    'narrative'    => 'Narrator Document',
    'nas'          => 'Nastran Input File',
    'natvis'       => 'Natvis VC++ Debugger Visualization File',
    'nav'          => 'MSN Application Extension File',
    'nav2'         => 'WinAVI Temporary Navigation File',
    'naz'          => 'Total Overdose Game Data File',
    'nb'           => 'Nota Bene File',
    'nb0'          => 'Device Boot Loader Image',
    'nb7'          => 'NovaBACKUP Output File',
    'nba'          => 'Nero BackItUp Archive',
    'nbak'         => 'Neat Backup File',
    'nbc'          => 'Next Byte Codes Source Code File',
    'nbd'          => 'Data Backup Data File',
    'nbe'          => 'Nessus Report File',
    'nbf'          => 'Backup Now Archive',
    'nbh'          => 'ROM Update Utility Image File',
    'nbi'          => 'Nero BackItUp Information File',
    'nbk'          => 'SMART Notebook File',
    'nbm'          => 'NetBeans Module',
    'nbp'          => 'NeoBook Plugin File',
    'nbs'          => 'NTI Backup Set',
    'nbt'          => 'Minecraft Named Binary Tag File',
    'nbu'          => 'Nokia Phone Backup File',
    'nc'           => 'mcrypt Encrypted File',
    'nc1'          => 'Mastercam Numerical Control File',
    'nca'          => 'Nintendo Content Archive',
    'ncb'          => 'Visual C++ IntelliSense Database',
    'ncd'          => 'NTI CD-Maker Disc Image',
    'ncf'          => 'No Cache File',
    'ncfg'         => 'ArcGIS Explorer Configuration File',
    'ncgr'         => 'Nintendo DS Title Graphics File',
    'nch'          => 'Outlook Express Folder File',
    'nclr'         => 'Nintendo DS Color Palette File',
    'nco'          => 'Nero BackItUp File',
    'ncor'         => 'Adobe Encore Project File',
    'ncorx'        => 'Adobe Encore Project',
    'ncr'          => 'NCR Image',
    'ncss'         => 'NCSS Dataset File',
    'nct'          => 'Nero CoverDesigner Template',
    'ncw'          => 'Nero CoverDesigner Wizard File',
    'ncx'          => 'EPUB Navigation Control XML File',
    'nd'           => 'QuickBooks Network Data File',
    'nd5'          => 'Renamed NDS File',
    'nda'          => 'Nero Backup File',
    'ndb'          => 'ClamAV Extended Signature File',
    'ndc'          => 'Personal Communications Settings File',
    'ndf'          => 'SQL Server Secondary Database File',
    'ndif'         => 'Apple New Disk Image Format File',
    'ndk'          => 'Lotus Notes Design Elements File',
    'ndl'          => 'Lotus Notes Doclink File',
    'ndoc'         => 'Naver Word',
    'nds'          => 'Nero DiscSpan Compilation File',
    'ndx'          => 'Neat 5 Archive File',
    'ned'          => 'OMNeT++ Network Description File',
    'nef'          => 'Nikon Electronic Format RAW Image',
    'neko'         => 'Neko Source Code File',
    'neo'          => 'NeoChrome Bitmap Image',
    'neosave'      => 'Neopets Save File',
    'nes'          => 'Nintendo (NES) ROM File',
    'nessus'       => 'Nessus Network Security Scanner File',
    'net'          => 'FileMaker Networking Module',
    'neta'         => 'Netica Binary File',
    'netspd'       => 'NetSpot Survey Project File',
    'netspm'       => 'NetSpot Map File',
    'networkconne' => 'T\'Apple Network Connect Document',
    'neu'          => 'Pro/ENGINEER Neutral File',
    'new'          => 'New G-Suite File',
    'nex'          => 'Navigator Extension',
    'nexe'         => 'Chrome Native Client Executable',
    'nfa'          => 'Netflix Audio File',
    'nfb'          => 'Nokia Phone Backup File',
    'nfc'          => 'Nokia Phone Backup Copy File',
    'nff'          => 'Neutral File Format',
    'nfi'          => 'Dreambox Disc Image',
    'nfl'          => 'Nokia Flash Lite Package',
    'nfm'          => 'Delphi .NET Form File',
    'nfo'          => 'Folio Views Infobase File',
    'nfs'          => 'Netflix Subtitle File',
    'nfs11save'    => 'Need for Speed: Hot Pursuit Save File',
    'nftr'         => 'Nintendo DS Font Type File',
    'nfv'          => 'Netflix Video File',
    'ngage'        => 'N-Gage Game File',
    'ngc'          => 'NeoGeo Pocket Color ROM',
    'ngd'          => 'Xilinx Netlist File',
    'ngloss'       => 'Nisus Writer Glossary',
    'ngp'          => 'NeoGeo Pocket ROM',
    'ngrr'         => 'Guitar Rig Preset',
    'ngs'          => 'Steins;Gate Game File',
    'ngt'          => 'Noni GPSPlot Track File',
    'nib'          => 'Interface Builder User Interface File',
    'nick'         => 'Outlook 2000 Nickname File',
    'nif'          => 'Gamebryo Model File',
    'nim'          => 'Nim Source Code File',
    'nitf'         => 'National Imagery Transmission Format File',
    'njb'          => 'Nikon Photo Index File',
    'nji'          => 'Nero Job Information File',
    'njx'          => 'NJStar Document',
    'nk'           => 'NUKE Script',
    'nk2'          => 'Outlook 2002 Nickname File',
    'nkb'          => 'Kontakt Audio Bank',
    'nkc'          => 'Kontakt Library Data File',
    'nki'          => 'KONTAKT Instrument File',
    'nkm'          => 'Mario Kart DS Track Data File',
    'nkp'          => 'Kontakt Presets File',
    'nks'          => 'Kontakt Monolith Container',
    'nkx'          => 'Kontakt Monolith Container File',
    'nl'           => 'Natron Layout File',
    'nl2script'    => 'NoLimits 2 Script File',
    'nlelem'       => 'NoLimits Track Element File',
    'nlm'          => 'Nokia Logo File',
    'nlogo'        => 'NetLogo Model File',
    'nlogo3d'      => 'NetLogo 3D Model File',
    'nlpx'         => 'NoLimits Package',
    'nls'          => 'NetLogo Source File',
    'nltrack'      => 'NoLimits Roller Coaster Track File',
    'nlvm'         => 'NoLimits Virtual Machine File',
    'nm'           => 'Space Engine Nebula Model File',
    'nm2'          => 'Navitel Map File',
    'nm3'          => 'Navitel 5 Map File',
    'nma'          => 'NMEA Data File',
    'nmap'         => 'NaviComputer Map File',
    'nmbtemplate'  => 'Numbers Spreadsheet Template',
    'nmc'          => 'ArcGIS Explorer Map Content File',
    'nmea'         => 'NMEA Data File',
    'nmf'          => 'ArcGIS Explorer Map File',
    'nmind'        => 'NovaMind Mind Map File',
    'nml'          => 'NSMB Editor Exported Level File',
    'nmm'          => 'Samsung Memo File',
    'nmp'          => 'NewsMaker Project File',
    'nmsv'         => 'Native Instruments Massive Sound File',
    'nn'           => 'Nero CD File List',
    'nni'          => 'ANNI Neural Network Investing File',
    'nnp'          => 'ANNI Neural Network Portfolio File',
    'nnt'          => 'Eudora Address Book File',
    'nod'          => 'NetObjects Fusion File',
    'nol'          => 'Nokia Operator Logo File',
    'nomedia'      => 'Android No Media File',
    'nop'          => 'WangReal Engine Game Data Archive',
    'not'          => 'Finale Note File',
    'note'         => 'Notability Note File',
    'notebook'     => 'SMART Notebook File',
    'notes'        => 'Memento Notes File',
    'now'          => 'Readme File',
    'noy'          => 'NOY Backup File',
    'nozzlelibrar' => ' \'Painter Nozzle Library',
    'np'           => 'Portfolio NetPublish File',
    'np4'          => 'NetPoint 4 Schedule File',
    'npa'          => 'Steins;Gate Archive',
    'npf'          => 'NTI Partition File',
    'npfx'         => 'Norton Internet Security Firewall Settings File',
    'npk'          => 'MikroTik Software Package',
    'npl'          => 'Cubase Library File',
    'npp'          => 'Art Explosion Publisher Pro Document',
    'npr'          => 'Nuendo Project File',
    'nps'          => 'Natron Node Presets File',
    'npt'          => 'NetPoint Schedule File',
    'npy'          => 'Python NumPy Array File',
    'nqc'          => 'Not Quite C Source Code File',
    'nra'          => 'Nero Audio Compilation',
    'nrb'          => 'Nero CD-ROM Boot Compilation',
    'nrbak'        => 'NeatReceipts Backup File',
    'nrc'          => 'Nero Disc Compilation File',
    'nrd'          => 'Nero DVD-Video Compilation File',
    'nrf'          => 'Neat Document Folder File',
    'nrg'          => 'Nero CD/DVD Image File',
    'nri'          => 'Nero ISO CD Compilation File',
    'nrl'          => 'Autonomy Interwoven Link File',
    'nrm'          => 'Nero Mixed Mode CD Compilation',
    'nrmlib'       => 'Neat Cabinet File',
    'nro'          => 'Nintendo Switch Executable File',
    'nrs'          => 'NovaBACKUP Restore Script',
    'nrt'          => 'Neat Contact File',
    'nru'          => 'Nero UDF CD-ROM Compilation',
    'nrw'          => 'Nikon Raw Image File',
    'nrx'          => 'Neat Receipt Folder File',
    'ns1'          => 'Nestopia Save State',
    'ns2'          => 'Lotus Notes 2 Database',
    'ns3'          => 'Lotus Notes 3 Database',
    'ns4'          => 'Lotus Notes 4 Database',
    'nsa'          => 'Nullsoft Streaming Audio File',
    'nsbca'        => 'Nintendo DS Model Animation File',
    'nsbmd'        => 'Nintendo DS Model File',
    'nsbta'        => 'Nintendo DS Texture Animation File',
    'nsbtx'        => 'Nintendo DS Model Texture File',
    'nsbva'        => 'Nintendo DS Visibility Animation File',
    'nscr'         => 'Nintendo DS Title Screen File',
    'nsf'          => 'NES Sound Format File',
    'nsh'          => 'NSIS Header File',
    'nsi'          => 'NSIS Script',
    'nsl'          => 'nsL Script',
    'nsp'          => 'Nintendo Switch Package',
    'nsq'          => 'NScheduler Data File',
    'nsr'          => 'Nessus Security Report File',
    'nss'          => 'Magentic Screensaver File',
    'nst'          => 'NoiseTracker Module',
    'nsv'          => 'Nullsoft Streaming Video File',
    'nsx'          => 'AppStudio Project',
    'nt'           => 'theWord New Testament Text Module',
    'ntc'          => 'Camera Control Pro Custom Curves File',
    'ntf'          => 'MediaFACE II CD Label File',
    'ntfs'         => 'NTFS Partition File',
    'nth'          => 'Nokia Series 40 Theme File',
    'ntn'          => 'NOTION Song File',
    'ntp'          => 'Natron Project File',
    'ntrk'         => 'Pacific FIghters Online Track File',
    'nts'          => 'Lotus Notes Traveler Server Config File',
    'ntx'          => 'Clipper Index File',
    'nud'          => 'Now Up-To-Date Calendar File',
    'numbers'      => 'Numbers Spreadsheet File',
    'numbers-tef'  => 'Numbers iCloud Document',
    'nup'          => 'Smart Security Update File',
    'nupkg'        => 'NetUpdate Package',
    'nuproj'       => 'NuGet Build Project',
    'nus3bank'     => 'Super Smash Bros. Audio Bank File',
    'nuspec'       => 'NuGet Specification File',
    'nut'          => 'NUT Video File',
    'nuv'          => 'NuppelVideo File',
    'nv'           => 'NewViews Database File',
    'nv2'          => 'Navionics Chart File',
    'nva'          => 'NVA Document',
    'nvc'          => 'Nikon Vignette Correction File',
    'nvdl'         => 'NVDL Script',
    'nvf'          => 'Creative Labs NVF Audio File',
    'nvi'          => 'NVIDIA Driver File',
    'nvl'          => 'UniChem Results File',
    'nvm'          => 'PlayStation 2 BIOS Configuration File',
    'nvp'          => 'NVivo for Windows Project',
    'nvram'        => 'VMware NVRAM File',
    'nvv'          => 'NVIDIA Vertex Shader File',
    'nw'           => 'Node-Webkit App Package',
    'nwbak'        => 'NeatWorks Backup File',
    'nwc'          => 'Navisworks Cache File',
    'nwcab'        => 'Neat Cabinet File',
    'nwcp'         => 'Nisus Clipboard Document',
    'nwctxt'       => 'NoteWorthy Composer Text File',
    'nwd'          => 'Navisworks Document',
    'nwdb'         => 'Neat Database File',
    'nwelicense'   => 'Nisus License',
    'nwf'          => 'Navisworks File Set',
    'nwm'          => 'Nisus Macro',
    'nwo'          => 'NWChem Output File',
    'nwp'          => 'Navisworks Presenter Material Palette File',
    'nws'          => 'Windows Live Mail Newsgroup File',
    'nwv'          => 'Dragon NaturallySpeaking User Archive',
    'nxc'          => 'Not eXactly C Source Code File',
    'nxg'          => 'eSite Builder NXG Web Page',
    'nxl'          => 'Nextlabs Encrypted Data File',
    'ny'           => 'Audacity Nyquist Plug-in',
    'nyf'          => 'myBase Database File',
    'nz'           => 'NanoZip Compressed File',
    'nzb'          => 'NewzBin Usenet Index File',
    'o'            => 'Compiled Object File',
    'oab'          => 'Offline Address Book',
    'oam'          => 'Adobe Edge Animate Widget File',
    'oar'          => 'OpenSimulator Archive',
    'oat'          => 'Android Optimized Application File',
    'ob!'          => 'Orbit Downloader Incomplete Download',
    'ob2'          => 'Oberon-2 Source Code File',
    'obb'          => 'Android Opaque Binary Blob File',
    'obd'          => 'Office Binder Document',
    'obf'          => 'OsmAnd Offline Map File',
    'obi'          => 'Outlook RSS Subscription File',
    'obj'          => 'Relocatable Object Code',
    'obk'          => 'Backup File',
    'obml'         => 'Opera Mini Saved Web Page',
    'obml15'       => 'Opera Mini Saved Web Page',
    'obml16'       => 'Opera Mini Saved Web Page',
    'obp'          => 'Bryce Object File',
    'obt'          => 'Openbox Theme File',
    'obw'          => 'Superior Drummer Sounds File',
    'obz'          => 'Compressed 3D Object File',
    'oc3'          => 'openCanvas 3 Event File',
    'oc4'          => 'openCanvas 4 Event File',
    'oc5'          => 'openCanvas 5 Event File',
    'oca'          => 'Custom Control Library Type File',
    'occ'          => 'Oceanic DataPool File',
    'ocd'          => 'OCAD Map File',
    'oce'          => 'Open Catalog Extension Connection File',
    'oci'          => 'openCanvas Image',
    'ocimf'        => 'OCIMF HVPQ File',
    'ocr'          => 'Subtitle Workshop OCR Script',
    'oct'          => 'Radiance Octree File',
    'octest'       => 'Xcode Objective-C Unit Test Bundle',
    'ocx'          => 'ActiveX Control',
    'od'           => 'Mascopt Graph Request File',
    'odb'          => 'ABAQUS Database',
    'odc'          => 'OpenDocument Chart File',
    'odex'         => 'Optimized Dalvik Executable',
    'odf'          => 'Battlezone Object Definition File',
    'odg'          => 'OpenDocument Graphic File',
    'odi'          => 'OpenDocument Image',
    'odif'         => 'Open Document Interchange Format',
    'odin'         => 'Locky Ransomware Encrypted File',
    'odl'          => 'Object Description Language File',
    'odm'          => 'OpenDocument Master Document',
    'odo'          => 'Online Operating System Write Document',
    'odp'          => 'OpenDocument Presentation',
    'ods'          => 'Outlook Express 5 Mailbox',
    'odt'          => 'Origin Dialog Theme File',
    'odttf'        => 'Obfuscated OpenType Font',
    'odx'          => 'BizTalk Server Orchestration File',
    'oeaccount'    => 'Windows Mail Account File',
    'oeb'          => 'Open eBook File',
    'oebzip'       => 'Zipped Open eBook File',
    'oem'          => 'OEMEdit Save File',
    'oex'          => 'Opera Extension',
    'ofc'          => 'Open Financial Connectivity File',
    'off'          => 'Object File Format',
    'officeui'     => 'Microsoft Office UI Customization File',
    'ofl'          => 'Ots File List',
    'ofm'          => 'OmniForm Form',
    'ofp'          => 'Origin Function Plot Theme File',
    'ofr'          => 'SMS Offer Manager File',
    'oft'          => 'Outlook File Template',
    'ofx'          => 'Open Financial Exchange File',
    'oga'          => 'Ogg Vorbis Audio File',
    'ogf'          => 'S.T.A.L.K.E.R. Model File',
    'ogg'          => 'Origin Graph File',
    'oggu'         => 'Origin Unicode Graph File',
    'ogm'          => 'Origin Matrix File',
    'ogmu'         => 'Origin Unicode Matrix File',
    'ognc'         => 'Dynamic Web Page',
    'ogs'          => 'Origons Movie Data File',
    'ogv'          => 'Ogg Video File',
    'ogw'          => 'Origin Workbook File',
    'ogwu'         => 'Origin Unicode Workbook File',
    'ogx'          => 'Ogg Vorbis Multiplexed Media File',
    'ogz'          => 'Cube 2 Map File',
    'oif'          => 'Origin Import Filter File',
    'ois'          => 'Origin Analyses Theme File',
    'oiv'          => 'OpenIV Mod Package File',
    'okt'          => 'Oktalyzer Module',
    'ol'           => 'Valve Hammer Object Layout File',
    'ola'          => 'Online Access File',
    'olb'          => 'OrCAD Symbol Library File',
    'old'          => 'Backup File',
    'olk'          => 'Outlook Address Book File',
    'olk14categor' => ' \'Outlook Category File',
    'olk14contact' => 'Outlook Contact File',
    'olk14event'   => 'Outlook Calendar Event File',
    'olk14group'   => 'Outlook Group File',
    'olk14mailacc' => 'U\'NT Outlook Mail Account File',
    'olk14message' => 'Outlook Message File',
    'olk14msgatta' => 'H\'Outlook 2011 Email Message Attachment File',
    'olk14msgsour' => 'E\'Outlook Email Message Data File',
    'olk14note'    => 'Outlook Note File',
    'olk14pref'    => 'Outlook Preferences File',
    'olk14signatu' => 'E\'Outlook Signature File',
    'olk14task'    => 'Outlook Task File',
    'olk15msgatta' => 'H\'Outlook 2016 Email Message Attachment File',
    'oll'          => 'TrialDirector Object Load List',
    'olm'          => 'Mac Outlook Database File',
    'olp'          => 'Office Live Package',
    'olt'          => 'Orbit Downloads List',
    'oma'          => 'Sony OpenMG Music File',
    'omcs'         => 'Office Manager Access File',
    'omf'          => 'OMF Interchange Image File',
    'omg'          => 'OpenMG Audio File',
    'omo'          => 'OMake Object File',
    'omod'         => 'Oblivion Mod Archive',
    'omp'          => 'OpenMind Windows Document',
    'oms'          => 'HP Printer Substrate Presets Package File',
    'omx'          => 'OtsAV Media Library Information File',
    'ond'          => 'Lotus Notes Encapsulated Memo File',
    'one'          => 'OneNote Document',
    'onepkg'       => 'Microsoft OneNote Package File',
    'onetoc'       => 'Microsoft OneNote Table of Contents File',
    'onetoc2'      => 'Microsoft OneNote Table of Contents File',
    'ont'          => 'theWord Bible Text Module',
    'ontx'         => 'theWord Encrypted Bible Text Module',
    'oo3'          => 'OmniOutliner 3 File',
    'oo3template'  => 'OmniOutliner Template',
    'ook'          => 'Arachne Batch Script',
    'op'           => 'OpenPAT Report',
    'op2'          => 'Nastran Output File',
    'op4'          => 'Nastran Output File',
    'opal'         => 'Microsoft Office User Settings File',
    'opax'         => 'Microsoft Office User Settings File',
    'opd'          => 'Durango Document',
    'opdownload'   => 'Opera Partially Downloaded File',
    'opeico'       => 'Opeico Text File',
    'openbsd'      => 'OpenBSD Readme File',
    'opf'          => 'FlipViewer FlipBook File',
    'opj'          => 'Origin Project',
    'opju'         => 'Origin Unicode Project',
    'opk'          => 'GCW Zero Open Package',
    'oplc'         => 'Nokia Operator Logo File',
    'opml'         => 'Outline Processor Markup Language File',
    'ops'          => 'Office Profile Settings File',
    'opt'          => 'AGT Game Data File',
    'options'      => 'SE-SOFT Configuration File',
    'opts'         => 'Linux Configuration Options File',
    'opus'         => 'Opus Audio File',
    'opx'          => 'FlipAlbum Photo Album File',
    'oqy'          => 'Excel OLAP Query File',
    'or2'          => 'Lotus Organizer 2 File',
    'or3'          => 'IBM Lotus Organizer 97 File',
    'or4'          => 'IBM Lotus Organizer 97 GS File',
    'or5'          => 'Lotus Organizer 5 File',
    'or6'          => 'Lotus Organizer 6 File',
    'ora'          => 'OpenRaster Image File',
    'orb'          => 'Original eBook Reader File',
    'orc'          => 'Voyetra Digital Orchestrator File',
    'orderedtest'  => 'Visual Studio Ordered Test File',
    'ore'          => 'Ore Executable File',
    'orf'          => 'Olympus RAW File',
    'org'          => 'Lotus Organizer File',
    'ori'          => 'Original File',
    'orig'         => 'Original File',
    'ort'          => 'Rich Text Editor Document',
    'orv'          => 'Oracom Video File',
    'orx'          => 'RadiantOne VDS Database Schema',
    'os'           => 'ObjectScript Source File',
    'osax'         => 'AppleScript Scripting Addition',
    'osb'          => 'Osu! Storyboard File',
    'osc'          => 'Obix Source Code File',
    'osdx'         => 'Search Connector Description File',
    'osk'          => 'Osu! Skin File',
    'osm'          => 'OpenStreetMap Map File',
    'osp'          => 'OpenShot Project File',
    'osr'          => 'Osu! Replay File',
    'oss'          => 'Microsoft Outlook Saved Search File',
    'ost'          => 'Outlook Offline Data File',
    'osu'          => 'Osu! Script',
    'osx'          => 'PowerPC Executable File',
    'osz'          => 'OpenLP Service File',
    'ot'           => 'theWord Old Testament Text Module',
    'ota'          => 'OTA Bitmap Image',
    'otb'          => 'Nokia Over The Air Bitmap Image',
    'otc'          => 'OpenDocument Chart Template',
    'otf'          => 'OpenTuft Tufting Design File',
    'otg'          => 'OpenDocument Graphic Template',
    'oth'          => 'Origin Graph Theme File',
    'oti'          => 'OpenDocument Image Template',
    'otl'          => 'NoteTab Outline File',
    'otln'         => 'Opal Outline File',
    'otm'          => 'Origin Matrix Template',
    'otmu'         => 'Origin Unicode Matrix Template',
    'otp'          => 'Origin Graph Template',
    'otpu'         => 'Origin Unicode Graph Template',
    'otrkey'       => 'OnlineTvRecorder Encoded Video File',
    'ots'          => 'OtsAV Album File',
    'ott'          => 'OpenDocument Document Template',
    'otw'          => 'Origin Workbook Template',
    'otwu'         => 'Origin Unicode Workbook Template',
    'otx'          => 'theWord Encrypted Old Testament Text Module',
    'otz'          => 'OpenLP Theme File',
    'out'          => 'Compiled Executable File',
    'ov2'          => 'TomTom Points of Interest Database',
    'ova'          => 'Octava Musical Score',
    'ove'          => 'Overture Musical Score',
    'ovf'          => 'Open Virtualization File',
    'ovh'          => 'OMSI Vehicle Configuration File',
    'ovl'          => 'Rollercoaster Tycoon 3 Data File',
    'ovolog'       => 'ooVoo Log File',
    'ovp'          => 'The Overlay Maker Package File',
    'ovpn'         => 'OpenVPN Configuration File',
    'ovr'          => 'The Overlay Maker Overlay File',
    'ovw'          => 'Cubase WAVE Overview File',
    'ovx'          => 'Object-based Visual Application Language File',
    'ow'           => 'Free Pascal 1.0.x Object File',
    'owc'          => 'OutWit Catch Database',
    'owg'          => 'OutWit Gear Database',
    'owl'          => 'OWL Source Code File',
    'owm'          => 'OutWit XML Mashup File',
    'owx'          => 'OutWit Hub Automator File',
    'oxps'         => 'OpenXPS File',
    'oxt'          => 'Apache OpenOffice Extension',
    'oxygene'      => 'Oxygene Project File',
    'oyx'          => 'Approach Alternate Database Index',
    'oz'           => 'Opera Job Management Compressed File',
    'ozb'          => 'MU Online Image File',
    'ozj'          => 'MU Online Image File',
    'ozt'          => 'MU Online Image File',
    'p'            => 'Python Pickle File',
    'p01'          => 'Parchive Recovery Volume',
    'p10'          => 'Certificate Request File',
    'p12'          => 'Personal Information Exchange File',
    'p19'          => 'Parchive Recovery Volume',
    'p21'          => 'Express STEP Data Model File',
    'p2c'          => 'Portal 2 Community Puzzle File',
    'p2g'          => 'Power2Go Project File',
    'p2i'          => 'Power2Go Disc Image',
    'p2m'          => 'Gameshark PlayStation 2 Cheats file',
    'p2p'          => 'FolderShare Placeholder File',
    'p2s'          => 'PCSX2 Saved State',
    'p2z'          => 'Compressed Poser Pose File',
    'p3'           => 'Primavera P3 Project File',
    'p3d'          => 'Panda3D Multifile',
    'p3e'          => 'Photoshop Repousse Settings File',
    'p3l'          => 'Adobe Photoshop Light Preset File',
    'p3m'          => 'Adobe Photoshop Material Preset File',
    'p3r'          => 'Adobe Photoshop Render Settings Preset File',
    'p3t'          => 'PlayStation 3 Theme File',
    'p4d'          => 'Pix4D Project',
    'p5d'          => 'Planner 5D Project',
    'p6'           => 'Perl 6 Source Code File',
    'p64'          => '64-bit Windows IDA Plugin Module',
    'p65'          => 'PageMaker 6.5 Document',
    'p7'           => 'PKCS #7 Digital Certificate File',
    'p7b'          => 'PKCS #7 Certificate File',
    'p7c'          => 'PKCS #7 Certificate File',
    'p7e'          => 'EQStitch 7 Project',
    'p7m'          => 'Digitally Encrypted Message',
    'p7r'          => 'Certificate Request Response File',
    'p7s'          => 'Digitally Signed Email Message',
    'p7x'          => 'Packed Digital Signature File',
    'p96'          => 'Win96 Database File',
    'p97'          => 'Win97 Database File',
    'pa'           => 'Print Artist Project',
    'pab'          => 'Personal Address Book',
    'pac'          => 'STAD Graphic File',
    'pack'         => 'CustoPack Tools Theme Pack',
    'pack.gz'      => 'Pack200 Compressed Archive',
    'package'      => 'Linux Autopackage File',
    'pad'          => 'ACT! Database Pointer File',
    'pae'          => 'PowerArchiver Encrypted Archive',
    'paf'          => 'PARIS Audio File',
    'paf.exe'      => 'PortableApps.com Program File',
    'page'         => 'S Note Page File',
    'pages'        => 'Pages Document',
    'pages-tef'    => 'Pages iCloud Document',
    'pak'          => 'Simutrans Object File',
    'pakm'         => 'PAKM Package File',
    'pal'          => 'Dr. Halo Color Palette File',
    'pamp'         => 'Poweramp Album Art File',
    'pan'          => 'Panorama Database File',
    'pando'        => 'Pando File',
    'pandora'      => 'Pandora Android App Executable',
    'panic'        => 'Kernel Panic File',
    'pano'         => 'Camera Panoramic Picture',
    'pap'          => 'Corel Painter Paper Texture',
    'papa'         => 'Game Save Backup File',
    'paperlibrary' => 'Painter Paper Library',
    'papers'       => 'Painter Paper Texture File',
    'paq'          => 'Hewlett-Packard Software Restore File',
    'paq6'         => 'PAQ6 Data Archive',
    'paq7'         => 'PAQ7 Data Archive',
    'paq8'         => 'PAQ8 Data Archive',
    'paq8f'        => 'PAQ8F Compressed Archive',
    'paq8l'        => 'PAQ8L Data Archive',
    'paq8p'        => 'PAQ8P Data Archive',
    'par'          => 'FMS Aircraft Parameters File',
    'par2'         => 'Parchive 2 Index File',
    'part'         => 'Partially Downloaded File',
    'part00000'    => 'WinOptimizer Split Archive Part 1',
    'partial'      => 'Internet Explorer Partially Downloaded File',
    'partimg'      => 'Partimage File',
    'pas'          => 'Delphi Unit Source File',
    'passwordwall' => 'T\'4      PasswordWallet 4 Data File',
    'pat'          => 'Kega Fusion Cheats File',
    'pat0'         => 'Wii Texture Pattern File',
    'patch'        => 'Patch File',
    'patran.hrd'   => 'Patran Hardcopy File',
    'patternlibra' => 'Y\'Painter Pattern Library',
    'patterns'     => 'Painter Pattern Library',
    'paw'          => 'Personal Ancestry Writer II File',
    'pax'          => 'PAX Archive',
    'pb'           => 'PureBasic Source File',
    'pb2map'       => 'Plazma Burst 2 Custom Map file',
    'pba'          => 'PowerBackup Archive',
    'pbb'          => 'AT&T Phonebook File',
    'pbd'          => 'ProBID+ Data File',
    'pbf'          => 'Paragon Backup File',
    'pbg'          => 'Pixel Bender Graph File',
    'pbi'          => 'PC BSD Installer Package',
    'pbit'         => 'Power BI Desktop Template',
    'pbix'         => 'Power BI Desktop File',
    'pbj'          => 'PowerBackup Job File',
    'pbk'          => 'Pixel Bender Kernel File',
    'pbm'          => 'Portable Bitmap Image',
    'pbn'          => 'Portable Bridge Notation File',
    'pbo'          => 'Packed Bohemia Object',
    'pbp'          => 'PulseBoy Project',
    'pbproj'       => 'Project Builder Project',
    'pbs'          => 'PaintShop Pro Brush Strokes',
    'pbw'          => 'Pebble Watchface File',
    'pbx5script'   => 'Personal Backup Script',
    'pbxbtree'     => 'Xcode Auto-Complete File',
    'pbxproj'      => 'Xcode Project Data File',
    'pbxscript'    => 'Personal Backup Script',
    'pbxuser'      => 'Xcode Project User Data File',
    'pc'           => 'Pro*C Source Code File',
    'pc1'          => 'Degas Elite Low Res Image File',
    'pc2'          => 'Degas Elite Medium Res Image File',
    'pc3'          => 'Degas Elite High Res Image File',
    'pc6'          => 'PowerCADD 6 Drawing File',
    'pc7'          => 'PowerCADD 7 Drawing File',
    'pca'          => 'Perfect Clarity Audio File',
    'pcap'         => 'Packet Capture Data',
    'pcapng'       => 'Pcap-NG Packet Capture File',
    'pcast'        => 'iTunes Podcast File',
    'pcb'          => 'Printed Circuit Board Design File',
    'pcc'          => 'Photocomposition Code File',
    'pcd'          => 'Pokémon Wonder Card File',
    'pce'          => 'TurboGrafx-16 ROM',
    'pcf'          => 'PaintCAD Font',
    'pcg'          => 'Korg Instrument Bank File',
    'pch'          => 'Nastran Punch Output File',
    'pck'          => 'Oracle Package Specification and Body File',
    'pcl'          => 'Printer Command Language Document',
    'pcm'          => 'Pulse Code Modulation',
    'pcp'          => 'Windows Installer Patch Creation Properties',
    'pcr'          => 'PCMark Vantage Benchmark File',
    'pcs'          => 'Microsoft Office ClipArt File',
    'pcsav'        => 'Mass Effect 2 Saved Game',
    'pcsxstate'    => 'PCSX Saved State File',
    'pct'          => 'Pure Compound Text File',
    'pctl'         => 'Kaspersky Parental Control Settings File',
    'pcv'          => 'MozBackup Profile Backup',
    'pcx'          => 'Paintbrush Bitmap Image File',
    'pd'           => 'Spore Audio Playback File',
    'pd4'          => 'Clone Manager Primer File',
    'pd5'          => 'Windows Live Photo Gallery Information File',
    'pda'          => 'SoftMax Pro Microplate Data Analysis File',
    'pdadj'        => 'PhotoDirector Preset File',
    'pdas'         => 'PDAStore Data Store File',
    'pdb'          => 'PowerDesigner Database Backup File',
    'pdc'          => 'Lizard Safeguard Secure PDF File',
    'pdd'          => 'Medtronic Programmer Data File',
    'pde'          => 'ProntoDoc for Excel Document Template',
    'pder'         => 'ProntoDoc for Excel Conventional Document',
    'pdex'         => 'Orient Computer Encrypted Data File',
    'pdf'          => 'Portable Document Format File',
    'pdfig'        => 'PDF Index Generator Project File',
    'pdfs'         => 'Adobe PDF Presets File',
    'pdfxml'       => 'Adobe PDFXML Document',
    'pdg'          => 'Print Shop Deluxe Design File',
    'pdh'          => 'ProntoDoc for Word Browser Display Document',
    'pdi'          => 'InstantCopy Disc Image',
    'pdl'          => 'Perl Data Language File',
    'pdlcp'        => 'PhotoDirector Lens Profile File',
    'pdm'          => 'ProntoDoc for Word Mobile Display Document',
    'pdmod'        => 'Payday Modification Archive',
    'pdn'          => 'paint.net Image File',
    'pdo'          => 'Pepakura Designer File',
    'pdp'          => 'Adobe Portable Document Format File',
    'pdpcmd'       => 'Pdplayer Command File',
    'pdpcomp'      => 'Pdplayer Composition File',
    'pdpd'         => 'Product Details Page DataObject File',
    'pdpl'         => 'Plaintext Data Processing Language File',
    'pdplx'        => 'Plaintext Data Processing Language Extensible',
    'pdr'          => 'ProntoDoc for Word Recovered Document',
    'pds'          => 'The Print Shop Project',
    'pdsprj'       => 'Proteus Project',
    'pdw'          => 'ProntoDoc for Word Conventional Document',
    'pdwr'         => 'ProntoDoc for Word Conventional Document',
    'pdx'          => 'Product Data eXchange File',
    'pdz'          => 'ProntoDoc for Word Structured Text Document',
    'pe4'          => 'PhotoImpact Image Archive',
    'pea'          => 'PEA File Archive',
    'peak'         => 'Steinberg Peak File',
    'peb'          => 'ProEST+ Buildings File',
    'pec'          => 'Brother Embroidery File',
    'pef'          => 'PEF Braille Book File',
    'peg'          => 'Peggle Replay File',
    'pegn'         => 'Peggle Nights Replay File',
    'pek'          => 'Adobe Peak Waveform File',
    'pekey'        => 'PhysicsEditor License Key File',
    'pem'          => 'Privacy Enhanced Mail Certificate',
    'pen'          => 'Paint Shop Pro Pen Preset File',
    'pep'          => 'TurboProject Project File',
    'per'          => 'Age of Empires Personality File',
    'perfmoncfg'   => 'Performance Monitor Configuration File',
    'perspective'  => 'Xcode Project Data File',
    'perspectivev' => ' \'Xcode Project Data File',
    'pes'          => 'PhysicsEditor Sheet File',
    'pet'          => 'WangReal Engine Game Model File',
    'pex'          => 'West Publisher Portable Exhibit File',
    'pez'          => 'Prezi Desktop Presentation',
    'pf'           => 'Windows Prefetcher File',
    'pfa'          => 'Printer Font ASCII File',
    'pfb'          => 'Printer Font Binary File',
    'pfc'          => 'AOL Personal File Cabinet',
    'pfd'          => 'Micrografx Optima! File',
    'pff'          => 'Formatta Portable Form File',
    'pfg'          => 'jEEPers Program Configuration File',
    'pfi'          => 'Paragon Backup Index File',
    'pfile'        => 'Rights Management Protected File',
    'pfl'          => 'PhotoFiltre Plugin',
    'pfm'          => 'Printer Font Metrics File',
    'pfo'          => 'Private Folder',
    'pfr'          => 'Paint Shop Pro Picture Frame File',
    'pfs'          => 'PhotoFiltre Studio Saved Selection File',
    'pfv'          => 'PhotoFiltre Studio Vectorial Path',
    'pfx'          => 'First Choice Word Processing Document',
    'pgal'         => 'Photo! 3D Album Gallery',
    'pgd'          => 'PGP Disk Image',
    'pgdata'       => 'Penguin George Data File',
    'pgf'          => 'Pokémon Mystery Gift for Black & White File',
    'pgi'          => 'Video Recording File',
    'pgm'          => 'Portable Gray Map Image',
    'pgn'          => 'Portable Game Notation File',
    'pgp'          => 'AutoCAD Program Parameters File',
    'pgpf'         => 'Password Generator Password File',
    'pgs'          => 'PageStream Document',
    'pgt'          => 'Pokémon Gift File',
    'pgx'          => 'Hopedot VOS Data File',
    'ph'           => 'AOL Phone Home Settings File',
    'phar'         => 'PHP Archive',
    'phb'          => 'PhtotoBase Album File',
    'phd'          => 'Portable Heap Dump File',
    'phj'          => 'PhCNC Project File',
    'phl'          => 'Kindle Popular Highlights File',
    'phm'          => 'Pro Home Manager Data File',
    'phn'          => 'Algodoo Phun Phunlet',
    'pho'          => 'MBROLA Phonetic Data File',
    'photolibrary' => 'iPhoto Photo Library',
    'photoshow'    => 'Roxio PhotoShow Project',
    'photoslibrar' => ' \'Photos Library',
    'php'          => 'PHP Source Code File',
    'php2'         => 'PHP 2 Web Page',
    'php3'         => 'PHP 3 Web Page',
    'php4'         => 'PHP 4 Web Page',
    'php5'         => 'PHP 5 Web Page',
    'phr'          => 'RoboHelp Phrase List',
    'phtm'         => 'PHP-Based Web Page',
    'phtml'        => 'PHP Web Page',
    'phy'          => 'PhyMod Physical Modeling Data',
    'phya'         => 'Aleph One Physics File',
    'phz'          => 'Algodoo Phun Compressed Phunlet',
    'pi'           => 'Pi Calculation Data File',
    'pi1'          => 'Degas Low Resolution Image File',
    'pi2'          => 'Degas Medium Resolution Image File',
    'pi3'          => 'Degas High Resolution Image File',
    'pi4'          => 'DEGAS Image',
    'pi5'          => 'DEGAS Bitmap Image',
    'pi6'          => 'DEGAS Bitmap Image File',
    'pic'          => 'QuickTime PICT Image',
    'pickle'       => 'Python Pickle File',
    'picnc'        => 'Houdini 3D Compositing Image',
    'pict'         => 'Picture File',
    'pictclipping' => 'Picture Clipping File',
    'pid'          => 'Creative Driver File',
    'pids'         => 'Snap-on Scan Data File',
    'pie'          => 'GlovePIE Controller Script',
    'pif'          => 'Program Information File',
    'pig'          => 'Pirates of the Burning Sea Data File',
    'pigm'         => 'Packaged Indigo Renderer Material File',
    'pigs'         => 'Packaged Indigo Renderer Scene File',
    'pika'         => 'Pika Software Builder Project File',
    'pim'          => 'PIM Archive',
    'pin'          => 'MNS Projection Information File',
    'pio'          => 'Pro Tools I/O Settings File',
    'pip'          => 'Office Personalized Settings File',
    'pipd'         => 'PIPE-FLO Demo Project File',
    'pipe'         => 'PIPE-FLO Project File',
    'pis'          => 'PS2DIS Project File',
    'piskel'       => 'Piskel Sprite',
    'pit'          => 'Samsung Phone Firmware File',
    'piv'          => 'Pivot Stickfigure Animation',
    'pix'          => 'Alias PIX Image',
    'pixadex'      => 'Pixadex Icon',
    'pixela'       => 'Pixela Project',
    'piz'          => 'Zipped File',
    'pj'           => 'Project64 Saved State File',
    'pj2'          => 'xPlan Document',
    'pjm'          => 'xPlan Model',
    'pjpeg'        => 'Progressive JPEG Image',
    'pjpg'         => 'Progressive JPEG Image',
    'pjs'          => 'Phoenix Subtitles File',
    'pjt'          => 'Didger Project File',
    'pjunoxl'      => 'Preset File',
    'pjx'          => 'FoxPro Project',
    'pk'           => 'Packed METAFONT File',
    'pk2'          => 'Silkroad Online Game Data File',
    'pk3'          => 'ZDoom Package',
    'pk4'          => 'Doom 3 Engine Game Data File',
    'pk6'          => 'Generation 6 Pokémon Save File',
    'pka'          => 'Packet Tracer Activity File',
    'pkb'          => 'Oracle Package Body File',
    'pkey'         => 'PowerKey Encrypted File',
    'pkf'          => 'Audition Peak File',
    'pkg'          => 'Midtown Madness 2 Model File',
    'pkg.tar.xz'   => 'Arch Linux Package File',
    'pkgdef'       => 'Visual Studio Shell File',
    'pkgundef'     => 'Visual Studio Shell File',
    'pkh'          => 'Oracle Package File',
    'pkl'          => 'Python Pickle File',
    'pkm'          => 'Pokémon Saved Game Data File',
    'pkpass'       => 'Passbook Pass File',
    'pkproj'       => 'Visual CCScript Project',
    'pks'          => 'Oracle Package Spec File',
    'pkt'          => 'Packet Tracer Network Simulation Model',
    'pkx'          => 'Decrypted 3DS Pokémon Save File',
    'pkz'          => 'Video Game Package',
    'pl'           => 'Unix Color Plot File',
    'pl0'          => '3D Home Architect Foundation Floor Plan',
    'pl1'          => 'Adventure Maker Plug-in',
    'pl2'          => '3D Home Architect Second Level Floor Plan',
    'pla'          => 'Sansa Playlist File',
    'plain'        => 'Plain Text File',
    'plan'         => 'Calligra Plan Document',
    'planner'      => 'Gnome Planner File',
    'plantuml'     => 'PlantUML File',
    'player'       => 'Starbound Player File',
    'playground'   => 'Xcode Playground File',
    'playlist'     => 'CyberLink PowerDVD Playlist',
    'playmission'  => 'MissionPlayer Game File',
    'playset'      => 'Souptoys Playset File',
    'plc'          => 'PL/B Source File',
    'ple'          => 'Messenger Plus! Live Encrypted Log File',
    'plf'          => 'Mr. Bean Game Data File',
    'plg'          => 'Visual Studio Build Log File',
    'pli'          => 'PL/I Source Code File',
    'plist'        => 'Mac OS X Property List File',
    'pln'          => 'Spaceman Planogram File',
    'plp'          => 'Photo Locker Picture',
    'plproj'       => 'Adobe Prelude Project File',
    'plr'          => 'Terraria Player File',
    'pls'          => 'PicoLog Settings File',
    'plsc'         => 'Messenger Plus! Live Script File',
    'plsk'         => 'Messenger Plus! Live Skin Pack',
    'plst'         => 'SmartMusic Playlist',
    'plt'          => 'Tecplot Binary Data File',
    'plt0'         => 'Wii Color Palette File',
    'pltsuite'     => 'Safari Page Load Test Suite File',
    'plugin'       => 'Adobe Photoshop Plug-in',
    'plw'          => '32-bit Windows IDA Plugin Module',
    'plx'          => '32-bit Linux IDA Plugin Module',
    'plx64'        => '64-bit Linux IDA Plugin Module',
    'ply'          => 'Finale Playback File',
    'pm'           => 'Unix XV Graphic File',
    'pm3'          => 'Crouzet Logic Software M3 File',
    'pm4'          => 'PageMaker 4 Document',
    'pm5'          => 'PageMaker 5.0 Document',
    'pm6'          => 'PageMaker 6.0 Document',
    'pmatrix'      => 'Priority Matrix Project File',
    'pmc'          => 'Performance Monitor Counter File',
    'pmd'          => 'PlanMaker Spreadsheet',
    'pmdx'         => 'PlanMaker Spreadsheet',
    'pmf'          => 'Partition Image File',
    'pmg'          => 'PageMaker Group File',
    'pmj'          => 'Pegasus Mail Configuration File',
    'pml'          => 'Palm Markup Language File',
    'pmlz'         => 'Zipped Palm Markup Language File',
    'pmm'          => 'MikuMikuDance PolygonMovieMaker File',
    'pmo'          => 'Pegasus Saved Message File',
    'pmp'          => 'AutoCAD Plot Model Parameter File',
    'pmpl'         => 'PSBMusic Playlist File',
    'pmq'          => 'Microsoft Target Analyzer File',
    'pmr'          => 'Performance Monitor Report',
    'pmsettings'   => 'PowerMate Settings File',
    'pmt'          => 'PageMaker Template File',
    'pmv'          => 'Return to Zork Video File',
    'pmvx'         => 'PlanMaker Spreadsheet Template',
    'pmx'          => 'PrintMaster Project File',
    'pn'           => 'Powernoodle File',
    'pna'          => 'PhatNoise Audio File',
    'pnach'        => 'PCSX2 Patch File',
    'pnc'          => 'Panasonic Network Camera Image',
    'pnf'          => 'Precompiled INF File',
    'png'          => 'Portable Network Graphic',
    'pnh'          => 'Project ROME Plug-in Archive',
    'pni'          => 'Popnoggin Image File',
    'pnm'          => 'Portable Any Map Image',
    'pno'          => 'Windows 8 Piano Song',
    'pnproj'       => 'Programmer\'s Notepad Project File',
    'pnpt'         => 'Programmer\'s Notepad Project Template',
    'pns'          => 'Pelco CCTV Video File',
    'pnt'          => 'Panther Project',
    'pntg'         => 'MacPaint Graphic File',
    'pnz'          => 'Panorama Database Set',
    'po'           => 'Portable Object',
    'pobi'         => 'Kindle Touch Periodical File',
    'pobj'         => 'Photo Pos Pro Vector Object File',
    'pod'          => 'Terminal Reality Game Data File',
    'pof'          => 'Descent Robot Definition File',
    'pog'          => 'Descent 2 Texture Modification',
    'poi'          => 'Magellan Maestro Point of Interest File',
    'pol'          => 'Windows Policy File',
    'policy'       => 'Java Policy Implementation File',
    'pom'          => 'Maven Build File',
    'pop'          => 'Samsung Popcon Character File',
    'popshape'     => 'PopChar Character Shape File',
    'por'          => 'SPSS Portable File',
    'pos'          => 'Trimble Position File',
    'posb'         => 'Poseidon Dive Log',
    'post'         => 'LIGHT File',
    'postal'       => 'TomTom Postal Code File',
    'pot'          => 'Portable Object File',
    'potm'         => 'PowerPoint Open XML Macro-Enabled Presentation',
    'potx'         => 'PowerPoint Open XML Presentation Template',
    'pov'          => 'Prolab Object File',
    'pp'           => 'Pocket Physics Sketch File',
    'pp2'          => 'PingPlotter Data File',
    'pp4'          => 'Picture Publisher Bitmap File',
    'pp5'          => 'Picture Publisher 5 Image File',
    'ppa'          => 'PowerPoint Add-in',
    'ppam'         => 'PowerPoint 2007 Add-In',
    'ppc'          => 'Adobe Presenter Audio File',
    'ppcx'         => 'Adobe Presenter Presentation Audio File',
    'ppd'          => 'PostScript Printer Description File',
    'ppdf'         => 'Rights Management Protected File',
    'ppf'          => 'PlayStation Patch Format File',
    'ppj'          => 'Premiere 6 Project File',
    'ppk'          => 'PuTTY Private Key File',
    'ppl'          => 'Free Pascal Dynamic Library',
    'ppm'          => 'Post Programmable Memory File',
    'ppm_b'        => 'Nokia PPM Flash File',
    'ppmod'        => 'Papers Please Mod File',
    'ppp'          => 'CyberLink PowerProducer Project',
    'ppr'          => 'ORF Report File',
    'pps'          => 'PowerPoint Slide Show',
    'ppsm'         => 'PowerPoint Open XML Macro-Enabled Slide Show',
    'ppsx'         => 'PowerPoint Open XML Slide Show',
    'ppt'          => 'PowerPoint Presentation',
    'ppthtml'      => 'PowerPoint HTML Presentation',
    'pptm'         => 'PowerPoint Open XML Macro-Enabled Presentation',
    'pptmhtml'     => 'Microsoft PowerPoint MIME HTML Presentation',
    'pptx'         => 'PowerPoint Open XML Presentation',
    'ppu'          => 'Free Pascal Unit File',
    'ppv'          => 'Pocket PowerPoint Presentation',
    'ppx'          => 'Serif PagePlus Template File',
    'ppz'          => 'Compressed Poser Prop File',
    'pq'           => 'Progress Quest Save File',
    'pqb'          => 'Pleco Chinese Dictionary Backup File',
    'pqb-backup'   => 'Pleco Chinese Dictionary Backup File',
    'pqhero'       => 'Puzzle Quest Saved Game',
    'pqi'          => 'PowerQuest Drive Image',
    'pr'           => 'Source Insight Project',
    'pra'          => 'Windows Media 9 Plug-in Profile File',
    'prb'          => 'xyAlgebra Probabilities File',
    'prc'          => 'Corel Presentation',
    'prd'          => 'Presentations Document',
    'prdx'         => 'Presentations Document',
    'pre'          => 'Lotus Freelance Graphics File',
    'pref'         => 'Macintosh Preferences File',
    'prefab'       => 'Unity Prefab File',
    'prefpane'     => 'Mac OS X System Preference Pane',
    'prefs'        => 'MMORPG Tycoon Preferences File',
    'prel'         => 'Premiere Elements Project File',
    'prf'          => 'Plot Station Plot Request File',
    'prfpset'      => 'Premiere Pro Effect Preset File',
    'prg'          => 'GEM Application',
    'pri'          => 'Package Resource Index File',
    'primitives'   => 'World of Tanks 3D Model File',
    'primitives_p' => 'O\'CESSED World of Tanks 3D Model File',
    'printcd2'     => 'EPSON Print CD File',
    'printerexpor' => ' \'Windows Printer Migration File',
    'prison'       => 'Prison Architect Saved Game',
    'prj'          => 'AIMMS Project File',
    'prk'          => 'Thrillville Park File',
    'prm'          => 'Re-Volt Model File',
    'prn'          => 'Lotus 1-2-3 Formatted Text File',
    'prnx'         => 'XtraReports PrintingSystem Document',
    'pro'          => 'IDL Source Code File',
    'pro4'         => 'ProPresenter 4 Document',
    'pro4dvd'      => 'ProPresenter DVD Clips Document',
    'pro4pl'       => 'ProPresenter Playlist File',
    'pro4plx'      => 'ProPresenter Playlist Bundle',
    'pro4x'        => 'ProPresenter 4 Bundle File',
    'pro5'         => 'ProPresenter 5 Document',
    'pro5dvd'      => 'ProPresenter DVD Clips Document',
    'pro5pl'       => 'ProPresenter Playlist File',
    'pro5plx'      => 'ProPresenter 5 Playlist Bundle',
    'pro5template' => 'U\'NDLE   ProPresenter 5 Template Bundle',
    'pro5x'        => 'ProPresenter 5 Bundle File',
    'prof'         => 'Super Smash Bros. Crusade Profile',
    'profile'      => 'Pandemic Studios Game Player Profile',
    'profimail'    => 'ProfiMail Settings File',
    'project'      => 'Eclipse Project Settings File',
    'projectprope' => 'T\'IES    Alpha Five Project Properties File',
    'prop'         => 'Android Build Properties File',
    'propdesc'     => 'Property Description',
    'properties'   => 'Minecraft Properties File',
    'props'        => 'Visual Studio Project Property File',
    'proqc'        => 'ProPresenter Quartz Composition',
    'proto'        => 'Protocol Buffer File',
    'provisionpro' => 'I\'LE     Apple Provision Profile',
    'prp'          => 'Rational Model Properties File',
    'prproj'       => 'Premiere Pro Project',
    'prs'          => 'PlayStation Radio Player Location',
    'prst'         => 'Adobe InDesign Printer Presets File',
    'prsx'         => 'Presentations Slide Show',
    'prt'          => 'Crypt Edit Protected Text Format File',
    'prtl'         => 'Premiere Pro Title File',
    'prv'          => 'SoftMaker Presentations Template',
    'prvx'         => 'Presentations Template',
    'prw'          => 'Artlantis Shader Preview File',
    'prx'          => 'PSP Plugin File',
    'prz'          => 'Freelance Graphics Presentation File',
    'ps'           => 'PostScript File',
    'ps1'          => 'Microsoft Indexing Service Data File',
    'ps1xml'       => 'Windows PowerShell Display Configuration File',
    'ps2'          => 'Sharkport Saved Game',
    'psa'          => 'Plesk Backup File',
    'psar'         => 'PSP Update File',
    'psb'          => 'PowerDivX Subtitles File',
    'psc'          => 'Papyrus Script',
    'psc1'         => 'Windows PowerShell Console File',
    'psd'          => 'Adobe Photoshop Document',
    'psd1'         => 'Windows PowerShell Data File',
    'psdl'         => 'Midtown Madness 2 City File',
    'psdx'         => 'Photoshop Touch Document',
    'pse'          => 'Photoshop Elements Photo Project',
    'psess'        => 'Visual Studio Performance Session File',
    'pset'         => 'Adobe InDesign Plug-in Set File',
    'psf'          => 'PID Script File',
    'psf1'         => 'PlayStation Sound Format File',
    'psf2'         => 'PlayStation Sound Format File',
    'psflib'       => 'Playstation Sound Format Library',
    'psflib2'      => 'Playstation Sound Format Library',
    'psg'          => 'Page Segment File',
    'psh'          => 'Photodex Slide Show',
    'psi'          => 'PrimalScript Online Help Shortcut',
    'psid'         => 'PostScript Image Data File',
    'psk'          => 'Unreal Engine Skeletal Mesh File',
    'psm'          => 'Prism Document',
    'psm1'         => 'Windows PowerShell Script Module File',
    'psp'          => 'Photoshop Preferences File',
    'pspbrush'     => 'PaintShop Pro Brush File',
    'pspd'         => 'PhotoSuite 5 Project File',
    'pspimage'     => 'PaintShop Pro Image',
    'psproj'       => 'The Print Shop Project File',
    'pspscript'    => 'PaintShop Pro Resource File',
    'psr'          => 'Powersoft Report File',
    'pss'          => 'Picture and Sound Show File',
    'pssd'         => 'PhotoSuite Slide Show File',
    'pssg'         => 'EGO Engine Textures File',
    'pst'          => 'Outlook Personal Information Store File',
    'psu'          => 'PSU Designer Document',
    'psv'          => 'Pluralsight Video File',
    'psw'          => 'Password Depot 3-5 File',
    'psw6'         => 'Password Depot 6 File',
    'pswx'         => 'Password Depot Portable File',
    'psx'          => 'PlayStation Save File',
    'psy'          => 'Psycle Song File',
    'psys'         => 'ZEQ2 Lite Particle Effects File',
    'psz'          => 'Compressed PostScript File',
    'pt'           => 'Panther Project File',
    'ptb'          => 'Power Tab File',
    'ptc'          => 'PANTONE Color File',
    'ptcop'        => 'PxTone Audio File',
    'ptd'          => 'PipeTech Data File',
    'ptex'         => 'Ptex Texture File',
    'ptf'          => 'Scrapbook Flair Template',
    'ptg'          => 'PowerTeacher Gradebook Configuration File',
    'pth'          => '4D Path Document',
    'ptk'          => 'Puntotek Embroidery Design File',
    'ptl'          => 'Rational Rose Petal File',
    'ptm'          => 'MapPoint Map File',
    'ptn'          => 'PaperPort Thumbnail File',
    'ptp'          => 'Pro Tools Preferences File',
    'ptr'          => 'Flash Intro Project File',
    'pts'          => 'PTGui Project File',
    'ptt'          => 'Pro Tools Session Template',
    'ptw'          => 'AutoCAD Publish To Web File',
    'ptx'          => 'Paint Shop Pro Texture File',
    'ptxt'         => 'Pro Tools Session Template',
    'pty'          => 'Rational Property Set',
    'ptz'          => 'E-Transcript Bundle File',
    'pu'           => 'PlantUML File',
    'pub'          => 'Public Key File',
    'publication'  => 'Twixl Publisher Publication',
    'puk'          => 'Pavuk Universal Kommand File',
    'pup'          => 'Puppy Linux DotPup Installer Package',
    'purblepairss' => 'V\'E-MS   Purble Pairs Saved Game',
    'purbleshopsa' => 'E\'-MS    Purble Place Shop Saved Game',
    'puz'          => 'Packed Publisher File',
    'pva'          => 'PVA Video File',
    'pvc'          => 'Parallels Desktop Copied Configuration File',
    'pvd'          => 'Instalit Script',
    'pvf'          => 'Portable Voice Format',
    'pvhd'         => 'Paragon Virtual Hard Drive',
    'pvj'          => 'ProofVision Job Ticket',
    'pvk'          => 'Private Key File',
    'pvl'          => 'Instalit Library',
    'pvm'          => 'Photo Video Manifest File',
    'pvmz'         => 'Parallels Compressed Virtual Machine',
    'pvpf'         => 'Pet ville Save File',
    'pvr'          => 'Wintal PVR Video File',
    'pvs'          => 'Parallels Desktop Configuration File',
    'pvw'          => 'Pronto for Windows Data View File',
    'pwa'          => 'Password Agent File',
    'pwc'          => 'PictureTaker File',
    'pwd'          => 'Solid Edge Weldment Document',
    'pwdp'         => 'Password Pad Document',
    'pwdpl'        => 'Password Pad Lite Document',
    'pwf'          => 'Counter-Strike PODBot Waypoint File',
    'pwi'          => 'Pocket Word Document',
    'pwl'          => 'Windows Password List',
    'pwn'          => 'Pawn Source Code File',
    'pwp'          => 'PhotoWorks Image File',
    'pwr'          => 'PowerWrite Document',
    'pwrep'        => 'Password Repository File',
    'pws'          => 'Print Workshop Image',
    'pwt'          => 'Pocket Word Template',
    'pwv'          => 'Password Vault Archive',
    'px'           => 'Pixel Image File',
    'px5'          => 'Clone Manager Primer Collection File',
    'pxa'          => 'XpressAccounts Data File',
    'pxb'          => 'Pixelmator Brush File',
    'pxc'          => 'Photodex Cache File',
    'pxd'          => 'Pixlr Layered Image',
    'pxf'          => 'Pendix Firmware File',
    'pxg'          => 'Pixelmator Gradient File',
    'pxi'          => 'Pyrex Include File',
    'pxicon'       => 'CandyBar Icon',
    'pxip'         => 'Pixelmator Image Preset',
    'pxj'          => 'RecordNow Project',
    'pxl'          => 'Pocket Excel File',
    'pxls'         => 'Pixelmator Style File',
    'pxm'          => 'Pixelmator Image File',
    'pxml'         => 'Pandora XML File',
    'pxp'          => 'Counter-Strike PODBot Experience File',
    'pxr'          => 'Pixar Image File',
    'pxs'          => 'Pixelmator Shape File',
    'pxv'          => 'Pixbend Media File',
    'pxx'          => 'Keyman Developer Encrypted Customization File',
    'py'           => 'Python Script',
    'pyc'          => 'Python Compiled File',
    'pyd'          => 'Python Dynamic Module',
    'pym'          => 'PYM Macro Preprocessor File',
    'pyo'          => 'Python Optimized Code',
    'pyw'          => 'Python GUI Source File',
    'pyx'          => 'Pyrex Source Code File',
    'pyxel'        => 'Pyxel Image Document',
    'pz'           => 'Panzoid Video Project',
    'pz2'          => 'Poser Pose File',
    'pz3'          => 'Poser Scene File',
    'pza'          => 'PhotoSuite Album File',
    'pzf'          => 'GraphPad Prism Project',
    'pzfx'         => 'GraphPad Prism XML Project',
    'pzl'          => 'Tibo Jigsaw Puzzle File',
    'pzp'          => 'Tibo Jigsaw Compressed Puzzle File',
    'pzs'          => 'PhotoSuite Slide Show File',
    'pzz'          => 'Compressed Poser Scene File',
    'q07'          => 'QuickTax 2007 Tax Return',
    'q08'          => 'QuickTax 2008 Tax Return',
    'q09'          => 'QuickTax 2009 Tax Return',
    'q1'           => 'Winamp Equalizer Presets File',
    'q1q'          => 'LunarCell Photoshop Plug-in',
    'q2'           => 'Winamp Equalizer Auto-Load Presets File',
    'q2d'          => 'Quick 3D Cover Design File',
    'q2q'          => 'Flexify Photoshop Plug-in',
    'q3c'          => 'Quick 3D Cover Project File',
    'q3d'          => 'Quest3D Project File',
    'q4q'          => 'Solar Cell Photoshop Plug-in',
    'q5q'          => 'SuperBladePro Presets File',
    'q5r'          => 'Melancholytron Photoshop Plug-in',
    'q7q'          => 'India Ink Photoshop Plug-in',
    'q8r'          => 'Flood Photoshop Plug-in',
    'q9q'          => 'BladePro Presets File',
    'q9r'          => 'Glitterato Photoshop Plug-In',
    'q9s'          => 'Mr. Contrast Photoshop Plug-In',
    'qar'          => 'QlikView Extension',
    'qat'          => 'Microsoft Office Quick Access Toolbar File',
    'qb'           => 'Diploma Question Bank File',
    'qb2005'       => 'QuickBooks 2005 File',
    'qb2006'       => 'QuickBooks 2006 File',
    'qb2007'       => 'QuickBooks 2007 File',
    'qb2009'       => 'QuickBooks 2009 File',
    'qb2010'       => 'QuickBooks 2010 File',
    'qb2011'       => 'QuickBooks 2011 File',
    'qb2012'       => 'QuickBooks 2012 File',
    'qb2013'       => 'QuickBooks 2013 File',
    'qb2014'       => 'QuickBooks 2014 File',
    'qb2015'       => 'QuickBooks 2015 for Mac Data File',
    'qb2016'       => 'QuickBooks 2016 for Mac Data File',
    'qb2017'       => 'QuickBooks 2017 for Mac Data File',
    'qba'          => 'QuickBooks Accountant\'s Copy Work File',
    'qba.tlg'      => 'QBA Transaction Log File',
    'qbb'          => 'QuickBooks Backup File',
    'qbj'          => 'QuickBooks General Journal Entry File',
    'qbk'          => 'QuickTax Backup File',
    'qbm'          => 'QuickBooks Portable Company File',
    'qbmb'         => 'QuickBooks Backup File',
    'qbmd'         => 'QuickBooks Backup File',
    'qbo'          => 'QuickBooks Online Bank Statement File',
    'qbr'          => 'QuickBooks Report Template',
    'qbw'          => 'QuickBooks Data File',
    'qbx'          => 'Blocks Landing Page File',
    'qbxml'        => 'QuickBooks XML Format File',
    'qby'          => 'QuickBooks Accountant\'s Copy Import File',
    'qc'           => 'QuakeC Source Code File',
    'qcc'          => 'Quilt Manager Pattern File',
    'qcow'         => 'QEMU Copy On Write Disk Image',
    'qcow2'        => 'QEMU Copy On Write Version 2 Disk Image',
    'qcp'          => 'PureVoice Audio File',
    'qda'          => 'Quadruple D Archive',
    'qdat'         => 'QuickTime Install Cache File',
    'qdb'          => 'Quicken 5 & 6 Data File',
    'qdf'          => 'Quadro Design File',
    'qdf-backup'   => 'Quicken Data Backup File',
    'qdfm'         => 'Quicken Data File (Macintosh)',
    'qdfx'         => 'Quicken Financial Exchange File',
    'qdl'          => 'QDL Program',
    'qdp'          => 'MPQDraft Plugin File',
    'qds'          => 'Windows Directory Query File',
    'qdt'          => 'Quicken 3 & 4 Data File',
    'qel'          => 'Quicken Electronic Library',
    'qf'           => 'Diploma Question Bank File',
    'qfilter'      => 'ColorSync Utility Quartz Filter',
    'qfx'          => 'Quicken Financial Exchange File',
    'qic'          => 'Windows Backup File',
    'qif'          => 'QuickTime Image File',
    'qit'          => 'QIT Trojan Horse File',
    'qiz'          => 'Exam Builder Quiz',
    'qky'          => 'Quirky Kernel',
    'qlgenerator'  => 'Quick Look Generator File',
    'qm'           => 'Qt Compiled Translation Source File',
    'qmbl'         => 'LabQuest Document',
    'qmg'          => 'Samsung Theme Graphics File',
    'qmk'          => 'YanCEyDesktop Quickmarks File',
    'qml'          => 'QT Meta Language File',
    'qmtf'         => 'Quicken Mac Transfer File',
    'qpb'          => 'QuickBooks Point of Sale Data File',
    'qpf'          => 'Quest3D Project',
    'qph'          => 'Qt Phrase Books File',
    'qpm'          => 'Quick Pallet Maker Input Data',
    'qpr'          => 'FoxPro Generated Query Program',
    'qpt'          => 'QuarkXPress Project Template',
    'qpw'          => 'Quattro Pro Spreadsheet',
    'qpx'          => 'QuickTime Player Extension',
    'qrc'          => 'QuarkXPress Required Component File',
    'qrm'          => 'Qworum Message File',
    'qrmx'         => 'Quick Risk Matrix File',
    'qrp'          => 'QuickReport File',
    'qry'          => 'Query File',
    'qs'           => 'Qt Install Script',
    'qsd'          => 'Quicken Data File',
    'qsf'          => 'Qualtrics Survey File',
    'qss'          => 'Qt Style Sheet',
    'qsv'          => 'Tibo Jigsaw Puzzle Save File',
    'qt'           => 'Apple QuickTime Movie',
    'qtch'         => 'QuickTime Cache File',
    'qti'          => 'QuickTime Image File',
    'qtif'         => 'QuickTime Image File',
    'qtindex'      => 'Adobe QTIndex File',
    'qtl'          => 'QuickTime Link File',
    'qtm'          => 'Apple QuickTime Movie File',
    'qtp'          => 'QuickTime Preferences File',
    'qtpxcomposit' => 'O\'N   QuickTime Composition File',
    'qtr'          => 'QuickTime Extension Resource',
    'qtx'          => 'QuickTime Extension',
    'qtz'          => 'Quartz Composer File',
    'qua'          => 'Avira AntiVir Quarantined File',
    'qualsoftcode' => 'J&ASoft Code Archive File',
    'quicken2015'  => 'Quicken 2015 Data File',
    'quicken2015b' => 'C\'KUP Quicken 2015 Backup File',
    'quicken2016'  => 'Quicken 2016 Data File',
    'quicken2016b' => 'C\'KUP Quicken 2016 Backup File',
    'quicken2017'  => 'Quicken 2017 Data File',
    'quicken2017b' => 'C\'KUP Quicken 2017 Backup File',
    'quickenbacku' => ' \'Quicken Essentials for Mac Backup File',
    'quickendata'  => 'Quicken Essentials for Mac Data File',
    'quiz'         => 'Quobject Quiz Package',
    'quox'         => 'Question Object File Format',
    'qvd'          => 'QlikView Data File',
    'qvf'          => 'Qlik Sense Desktop App File',
    'qvm'          => 'Q Virtual Machine',
    'qvp'          => 'ViewletBuilder Project File',
    'qvpp'         => 'QlikView Extension Properties Page File',
    'qvt'          => 'QlikView Theme File',
    'qvw'          => 'QlikView Document',
    'qv~'          => 'ViewletBuilder Project Backup File',
    'qwd'          => 'QuakeWorld Demo File',
    'qwq'          => 'OpenQwaq Auto-Launch File',
    'qx'           => 'Quexal Source Code',
    'qxb'          => 'QuarkXPress Book File',
    'qxd'          => 'QuarkXPress Document',
    'qxf'          => 'Quicken Essentials for Mac Exchange File',
    'qxl'          => 'QuarkXPress Library',
    'qxp'          => 'QuarkXPress Project File',
    'qxt'          => 'QuarkXPress Template',
    'qxw'          => 'Q Light Controller+ Workspace File',
    'r'            => 'Right Audio Channel File',
    'r0'           => 'WinRAR Compressed Archive',
    'r00'          => 'WinRAR Compressed Archive',
    'r01'          => 'WinRAR Split Archive Part 1',
    'r02'          => 'WinRAR Split Archive Part 2',
    'r03'          => 'WinRAR Split Archive Part 3',
    'r04'          => 'WinRAR Split Archive Part 4',
    'r1'           => 'WinRAR Multi-Volume Archive Part 1',
    'r1m'          => 'RealOne Streaming Media File',
    'r2'           => 'WinRAR Multi-Volume Archive Part 2',
    'r21'          => 'WinRAR Split Archive Part 21',
    'r30'          => 'WinRAR Split Archive Part 30',
    'r3d'          => 'RISA-3D Model File',
    'ra'           => 'Real Audio File',
    'rad'          => 'Radar ViewPoint Radar Data',
    'radiumkey2'   => 'Radium 2 License File',
    'radq'         => 'Need for Madness Game Archive',
    'raf'          => 'Fuji RAW Image File',
    'ral'          => 'WinRail Track Design File',
    'ram'          => 'Real Audio Metadata File',
    'rap'          => 'Raptor Flowchart File',
    'rar'          => 'WinRAR Compressed Archive',
    'ras'          => 'Remedy Archive System File',
    'raskinlicens' => ' \'Raskin License File',
    'raskinplace'  => 'Raskin Place Layout File',
    'rasunsoft'    => 'Rasunsoft Game Replay File',
    'rat'          => 'PICS Rating File',
    'ratdvd'       => 'RatDVD Disk Image',
    'rav'          => 'Rave Reports Project File',
    'raw'          => 'Raw Audio Data',
    'rax'          => 'Real Music Store Audio File',
    'ray'          => 'Rayshade Image',
    'rb'           => 'Rosebud Profile',
    'rb4'          => 'RobotWorks Parameters File',
    'rbc'          => 'Rembo-C Script',
    'rbf'          => 'LEGO MINDSTORMS EV3 Robot Brick File',
    'rbj'          => 'XRK Compiled Redcode Object File',
    'rbk'          => 'Windows 95 Registry Backup File',
    'rbm'          => 'Real Studio Menu File',
    'rbp'          => 'Real Studio Project File',
    'rbs'          => 'MP3 Ringtone File',
    'rbt'          => 'LEGO MINDSTORMS NXT Program',
    'rbvcp'        => 'Real Studio Version Controlled Project',
    'rbw'          => 'Real Studio Window File',
    'rbx'          => 'Rembo-C Compiled Script',
    'rbxl'         => 'ROBLOX Location File',
    'rbxlx'        => 'ROBLOX XML Place File',
    'rbxm'         => 'ROBLOX Model',
    'rbxmx'        => 'ROBLOX Model',
    'rbxs'         => 'ROBLOX Script',
    'rbz'          => 'SketchUp Plugin',
    'rc'           => 'Resource Script',
    'rc1'          => 'Samsung Mobile Device Firmware File',
    'rc2'          => 'Samsung Mobile Device Firmware File',
    'rcd'          => 'Arcade File',
    'rcf'          => 'SonicWALL VPN Configuration File',
    'rcg'          => 'Recog Character Recognition Set',
    'rcl'          => 'Recolored Project File',
    'rco'          => 'PlayStation Portable Resource File',
    'rcproject'    => 'iMovie \'08 Project',
    'rcrec'        => 'LogMeIn Remote Control Session Recording',
    'rcs'          => 'RandomControl Scene File',
    'rct'          => 'Visual Studio Resource Template',
    'rctd'         => 'RabbitCT Dataset',
    'rcu'          => 'RealWorld Layered Cursor Image',
    'rcut'         => 'Webinaria Recording Cut',
    'rcv'          => 'RoofCon Viewer Project File',
    'rcx'          => 'REDCINE-X Project File',
    'rcy'          => 'ReCycle 1.x Document',
    'rda'          => 'Anno 2070 Data File',
    'rdata'        => 'R Workspace File',
    'rdb'          => 'Wavelet Video Images File',
    'rdc'          => 'IDRISI Raster Documentation File',
    'rdf'          => 'ReDIF Template',
    'rdg'          => 'RDCman Config File',
    'rdi'          => 'Red Dragon ISecure Settings File',
    'rdl'          => 'MicroStation Redline File',
    'rdlc'         => 'Visual Studio Client Report Definition File',
    'rdlx'         => 'Power View Project File',
    'rdo'          => 'Xerox Rawster Document Object File',
    'rdoc'         => 'Ruby Document',
    'rdoc_options' => 'Ruby Document Options File',
    'rdp'          => 'Remote Desktop Configuration File',
    'rdr'          => 'Remote Desktop Manager Report Settings File',
    'rds'          => 'Ray Dream Studio Scene File',
    'rdw'          => 'Real-DRAW Project File',
    'rdx'          => 'Reflex Data File',
    'readme'       => 'Readme File',
    'reb'          => 'Reimbursement Tracker Data File',
    'rec'          => 'eJuice Me Up Recipe File',
    'record'       => 'GarageBand Records Audio File',
    'red'          => 'CADViewer Redline Markup File',
    'redif'        => 'ReDIF Template',
    'redir'        => 'Spotify Executable Redirect File',
    'ref'          => 'IDRISI Raster Image Reference File',
    'reference'    => 'Budget In Brief Reference File',
    'refresh'      => 'Visual Studio Refresh File',
    'reg'          => 'Registration Information File',
    'regtrans-ms'  => 'Registry Transaction Log File',
    'rel'          => 'Norton Internet Security Log File',
    'reloc'        => 'Windows EXE Relocation Section File',
    'rels'         => 'Open Office XML Relationships File',
    'rem'          => 'BlackBerry Encrypted Data File',
    'rep'          => 'X-Plane Replay File',
    'replay'       => 'Fortnite Replay File',
    'req'          => 'Canon SD Card Version Request File',
    'res'          => 'Star Wars KotOR Save Resources File',
    'resjson'      => 'Windows JavaScript Resources File',
    'resmoncfg'    => 'Resource Monitor Configuration File',
    'resources'    => 'Visual Studio Resource File',
    'ress'         => 'Unity 3D Model Archive',
    'resw'         => 'Windows Resources File',
    'resx'         => '.NET Managed Resources File',
    'ret'          => 'BusinessObjects Template',
    'rev'          => 'RAR Recovery Volume Set',
    'rex'          => 'Rexx Source File',
    'rexx'         => 'Rexx Source File',
    'rez'          => 'FirstClass Resource File',
    'rf1'          => 'Retirement Forecast File',
    'rfa'          => 'Battlefield 1942 Game Package',
    'rfb'          => 'RoboForm Bookmark File',
    'rfc'          => 'Ravenfield Content File',
    'rfd'          => 'Emperor: Battle for Dune Data File',
    'rfgs_pc'      => 'Red Faction: Guerilla Saved Game File',
    'rfl'          => 'Reason ReFill Sound Bank',
    'rflw'         => 'Edge Reflow Data File',
    'rfm'          => 'rFactor Modification File',
    'rfn'          => 'RoboForm Safenote File',
    'rfo'          => 'RoboForm Option File',
    'rfp'          => 'RoboForm Passcard File',
    'rfq'          => 'RoboForm SearchCard File',
    'rft'          => 'Revisable Form Text Document',
    'rfu'          => 'Remote Firmware Update',
    'rfw'          => 'Rockchip Firmware File',
    'rgb'          => 'Q0 Image File',
    'rgba'         => 'RGB Bitmap',
    'rgd'          => 'Raft Saved Game File',
    'rge'          => 'Entourage File Archive',
    'rgf'          => 'LEGO MINDSTORMS EV3 Robot Graphics File',
    'rgmb'         => 'RootsMagic Backup File',
    'rgmc'         => 'RootsMagic Genealogy Project File',
    'rgn'          => 'Garmin Regional Map File',
    'rgo'          => 'RepliGo File',
    'rgp'          => 'RealArcade Game Package',
    'rgrid'        => 'RepGrid File',
    'rgrp'         => 'Pro Tools Region Group File',
    'rgs'          => 'Registry Script',
    'rgss2a'       => 'RPG Maker VX RGSS Encrypted Archive',
    'rgss3a'       => 'RPG Maker VX Ace RGSS Encrypted Archive',
    'rgssad'       => 'RPG Maker VX RGSS Encrypted Archive',
    'rgt'          => 'Relic Entertainment Game Texture File',
    'rhistory'     => 'R History File',
    'rhp'          => 'Rhino Plug-in',
    'rhr'          => 'Script Rehearser Script File',
    'rhtml'        => 'Ruby HTML Web Page',
    'ric'          => 'NXT Image File',
    'rif'          => 'Painter Raster Image File',
    'riff'         => 'Painter Raster Image',
    'rig'          => 'Antibody Model Rig File',
    'rim'          => 'BioWare Resource Image File',
    'rip'          => 'Hit\'n\'Mix Audio Mashup File',
    'ris'          => 'Research Information Systems Citation File',
    'rise'         => 'RISE Editor Model File',
    'rix'          => 'ColoRIX Image',
    'rjs'          => 'RealJukebox Skin File',
    'rk'           => 'WinRK File Archive',
    'rkg'          => 'Mario Kart Wii Ghost Data File',
    'rkp'          => 'Rockchip MP4 Player Game',
    'rkt'          => 'Racket Source Code File',
    'rl'           => 'The 7th Guest Audio Data File',
    'rle'          => 'Golly Simulation Pattern File',
    'rle.gz'       => 'Golly Compressed Simulation Pattern File',
    'rlf'          => 'ArcGIS Report Layout File',
    'rli'          => 'RealWorld Graphics Layered Image',
    'rll'          => 'Microsoft Resource Library',
    'rls'          => 'Symbian Localization File',
    'rm'           => 'RealMedia File',
    'rmbak'        => 'Registry Mechanic Backup File',
    'rmd'          => 'RealPlayer Media File',
    'rmf'          => 'Rich Music Format Audio File',
    'rmh'          => 'Rights-Managed HTML Document',
    'rmi'          => 'RMID MIDI File',
    'rmj'          => 'Real Media Jukebox Audio File',
    'rml'          => 'FTG Configuration File',
    'rmm'          => 'RAM Meta File',
    'rmp'          => 'Magellan Raster Map File',
    'rmr'          => 'ResumeMaker File',
    'rms'          => 'Java Application Settings File',
    'rmskin'       => 'Rainmeter Skin File',
    'rmt'          => 'Router Firmware File',
    'rmuf'         => 'Alpha Five Runtime License File',
    'rmv'          => 'Radical Entertainment Video File',
    'rmvb'         => 'RealMedia Variable Bit Rate File',
    'rmx'          => 'Reference Manager Index File',
    'rnc'          => 'RNC ProPack Archive',
    'rnd'          => 'Random Hash Data File',
    'rng'          => 'RELAX NG File',
    'rnq'          => 'Renque Model File',
    'rns'          => 'Reason Song File',
    'rnx'          => 'RealPlayer Settings File',
    'roadtrip'     => 'Road Trip Planner File',
    'roca'         => 'RIB office Compressed Archive',
    'rock'         => 'Rockbox Plug-in',
    'rod'          => 'Ancestry Genealogical Database File',
    'rodl'         => 'RemObjects Definition Language File',
    'rodx'         => 'Ancestry Genealogical Database File',
    'rodz'         => 'Ancestry Genealogical Database File',
    'rofl'         => 'League of Legends Replay File',
    'rog'          => 'Roger 2 Input Data File',
    'roi'          => 'Shark Sales System Data File',
    'rol'          => 'Ad Lib Synthesized Instrument',
    'rom'          => 'Killing Floor Map File',
    'roq'          => 'Id Software Game Video',
    'ros'          => 'BattleScribe Roster Editor File',
    'rot'          => 'Homeworld 2 Graphics File',
    'rotest'       => 'RemObjects SDK Test File',
    'rotestresult' => 'RemObjects SDK Test Results File',
    'rou'          => 'Gerber Route File',
    'rov'          => 'Report Object Variable',
    'rox'          => 'Actuate Report Object Executable File',
    'roxio'        => 'Roxio Project',
    'roz'          => 'aSc TimeTables Schedule File',
    'rp'           => 'RealPix Clip',
    'rp2'          => 'RetroPlatform Player Program Archive',
    'rp9'          => 'RetroPlatform Disk Image Archive',
    'rpa'          => 'RIB Project Archive File',
    'rpb'          => 'Radmin Phonebook File',
    'rpc'          => 'Rich Page Content Document',
    'rpd'          => 'RIB Project Database File',
    'rpf'          => 'Grand Theft Auto Data File',
    'rpgproject'   => 'RPG Maker MV Project',
    'rpi'          => 'Render Plug-in',
    'rpj'          => 'Real Pac Batch Job File',
    'rpk'          => 'RadLight Media Player Skin',
    'rpkg'         => 'Hitman Game Patch Archive',
    'rpl'          => 'Special Force Replay',
    'rplib'        => 'Axure RP Widget Library File',
    'rpln'         => 'InDesign Required Plug-in File',
    'rpm'          => 'RealPlayer Plug-in',
    'rpmsg'        => 'Outlook Restricted Permission Message',
    'rpp'          => 'REAPER Project File',
    'rpprj'        => 'Axure RP Shared Project File',
    'rpres'        => 'R Presentation File',
    'rproj'        => 'R Project',
    'rps'          => '3ds Max Render Preset Settings',
    'rpt'          => 'AccountEdge Report',
    'rptr'         => 'Crystal Reports Read-Only File',
    'rpv'          => 'RealPlayer Visualization File',
    'rpx'          => 'Wii U Game',
    'rpy'          => 'Ren\'Py Script',
    'rpyb'         => 'Ren\'Py Bytecode File',
    'rpyc'         => 'Ren\'Py Compiled Script',
    'rra'          => 'vRigger Rigging Gear File',
    'rrd'          => 'Reduced Resolution Dataset File',
    'rri'          => 'RealWorld Image',
    'rrr'          => 'Rhapzodé Resource Repository',
    'rrt'          => 'Rhapzode Resource Template',
    'rs'           => 'Windows Rating System File',
    'rs2'          => 'RailSim2 Saved Layout File',
    'rsa'          => 'Minecraft JAR Codesign File',
    'rsb'          => 'Red Storm Bitmap File',
    'rsc'          => 'Symbian Application Compiled Resource File',
    'rsd'          => 'Rosetta Stone Data File',
    'rsdf'         => 'RapidShare Download File',
    'rsdk'         => 'Retro SDK Archive',
    'rsf'          => 'Riky\'s Soft Document',
    'rsg'          => 'RaySupreme Graph',
    'rsm'          => 'ARIS Report Script Model File',
    'rsn'          => 'Reason Project File',
    'rso'          => 'ARIS Report Script Object File',
    'rsp'          => 'RSLogix PLC Program File',
    'rsr'          => 'Poser Model Preview File',
    'rsrc'         => 'Macintosh Resource File',
    'rss'          => 'RAM Structural System Model File',
    'rst'          => 'IDRISI Raster Image',
    'rsv'          => 'RSView32 Project File',
    'rsw'          => 'R&R SQL Report Writer Report File',
    'rsx'          => 'RED Metadata XML File',
    'rt'           => 'RealText Streaming Text File',
    'rta'          => 'TrueRTA Project File',
    'rtc'          => 'Live Meeting Connection File',
    'rtd'          => 'RagTime Document',
    'rte'          => 'Revit Project Template',
    'rtf'          => 'Rich Text Format File',
    'rtfd'         => 'Rich Text Format Directory File',
    'rti'          => 'Real Tracker Instrument',
    'rtl'          => 'Raster Transfer Language File',
    'rtm'          => 'Real Tracker Module',
    'rton'         => 'Plants vs Zombies 2 Data File',
    'rtp'          => 'TurboTax Update File',
    'rts'          => 'QuickTime Real-Time Streaming Format',
    'rtstn'        => 'Audials Station File',
    'rttex'        => 'Robinson Technologies Texture File',
    'rtttl'        => 'Ring Tone Transfer Language File',
    'rtwsh'        => 'Radiotracker Wishlist File',
    'rtx'          => 'Rich Text Document',
    'ru'           => 'Java Russian Font Properties File',
    'ruel'         => 'Revo Uninstaller Pro Log',
    'ruf'          => 'Samsung DVD and Blu-ray Player Firmware File',
    'rul'          => 'InstallShield Rules File',
    'ruleset'      => 'Visual Studio Code Analysis Rule Set File',
    'rum'          => 'Bink Video Subtitle File',
    'run'          => 'Runscanner Scan File',
    'rupaf'        => 'Revo Uninstaller Pro Activation File',
    'rv'           => 'Real Video File',
    'rvdata'       => 'RPG Maker VX Data File',
    'rvdata2'      => 'RPG Maker VX Ace Data File',
    'rvf'          => 'RichView Format File',
    'rvg'          => 'RVG X-ray Image',
    'rvid'         => 'Snapz Pro X Recorded Video File',
    'rvl'          => 'Adobe Revel Library File',
    'rvp'          => 'Sharp Blu-ray Player Firmware File',
    'rvproj'       => 'RPG Maker VX Project File',
    'rvproj2'      => 'RPG Maker VX Ace Project File',
    'rvt'          => 'Revit Project File',
    'rvx'          => 'Real Protected Video File',
    'rw2'          => 'Panasonic RAW Image',
    'rw3'          => 'RapidWeaver 3 Site File',
    'rwd'          => 'Microsoft Flight Simulator Rewards File',
    'rwg'          => 'Random Word Generator Project File',
    'rwl'          => 'Leica RAW Image',
    'rwlibrary'    => 'Paperless Receipt Library',
    'rwp'          => 'RapidWeaver Package',
    'rwplugin'     => 'RapidWeaver Plugin',
    'rws'          => 'RimWorld Game Save File',
    'rwsnippet'    => 'RapidWeaver Snippet File',
    'rwstyle'      => 'RapidWeaver Style File',
    'rwsw'         => 'RapidWeaver Site File',
    'rwt'          => 'ReadWriteThink Timeline',
    'rwtheme'      => 'RapidWeaver Theme',
    'rwz'          => 'Rawzor Compressed Image',
    'rx2'          => 'REX2 Audio File',
    'rxc'          => 'Roxio Certificate File',
    'rxdata'       => 'RMXP Data File',
    'rxe'          => 'Lego Mindstorms NXT Executable Program',
    'rz'           => 'Rzip Compressed File',
    'rzb'          => 'Red Zion Book File',
    'rzk'          => 'Red Zion Key File',
    'rzn'          => 'Red Zion Notes File',
    'rzs'          => 'Red Zion Security File',
    'rzx'          => 'File Crypt Encrypted File',
    's'            => 'Microsoft Train Simulator Shape File',
    's00'          => 'ZipSplitter Part 1 Archive',
    's01'          => 'ZipSplitter Part 2 Archive',
    's02'          => 'ZipSplitter Part 3 Archive',
    's10'          => 'Brasfoot Saved Game File',
    's16'          => 'Digital Voice Recorder Audio File',
    's19'          => 'Motorola S19 File Record',
    's2a'          => 'SEAL2 Application',
    's2arr'        => 'SynthFont2 Arrangement File',
    's2e'          => 'SWF to EXE Converter Project File',
    's2m'          => 'The Settlers 2 Map File',
    's2mh'         => 'StarCraft 2 Map Header File',
    's2ml'         => 'StarCraft 2 Map Localization File',
    's2mv'         => 'StarCraft 2 Map Preview File',
    's2qh'         => 'StarCraft 2 Localization Header File',
    's2ql'         => 'StarCraft 2 Unit Localization File',
    's2z'          => 'Heroes of Newerth Game Data File',
    's3g'          => 'MakerBot 3D Print File',
    's3i'          => 'Scream Tracker 3 Instrument',
    's3m'          => 'ScreamTracker 3 Module',
    's3z'          => 'Compressed Scream Tracker 3 Module',
    's4m'          => 'SWAT 4 Map File',
    's5x'          => 'Heritage of Kings: The Settlers Map',
    's7z'          => 'Mac OS X 7-Zip File',
    's85'          => 'Sabre Airline Solutions Chart',
    'sa1'          => 'Game Boy Emulator Save File',
    'sa9'          => 'Hue and Cry Photoshop Plug-in',
    'sab'          => 'Saber File',
    'sabl'         => 'Call of Duty: Black Ops II Sound',
    'sad'          => 'Black & White Audio File',
    'saf'          => 'McAfee Fortress File',
    'safariextz'   => 'Apple Safari Extension Package',
    'safe'         => 'SIGLock Encrypted File',
    'safenoteback' => 'P\'Safe Note Backup File',
    'safetext'     => 'SafeText File',
    'sah'          => 'SETIathome Data File',
    'sai'          => 'PaintTool SAI Image',
    'sam'          => 'MOD Edit Sample File',
    'sam07'        => 'SAM 2007 Package',
    'sami'         => 'Grand Theft Auto San Andres Mod',
    'samp'         => 'Nintendo ADPCM Sound Sample File',
    'san'          => 'Smush Animation File',
    'sap'          => 'Atari SAP Music File',
    'sar'          => 'Saracen Paint Image',
    'sas'          => 'SAS Program File',
    'sas7bdat'     => 'SAS Data Set File',
    'sasbx'        => 'Space Agency Sandbox File',
    'sass'         => 'Syntactically Awesome StyleSheets File',
    'sat'          => 'ACIS SAT 3D Model File',
    'sav'          => 'Fallout 2 Map Archive',
    'save'         => 'Nano Temporary Save File',
    'saveddeck'    => 'Nokia Saved Web Page',
    'savedsearch'  => 'Spotlight Saved Search',
    'savedstate'   => 'Virtual Router Saved State File',
    'saver'        => 'Mac OS X Screen Saver',
    'sb'           => 'Signed Byte Audio File',
    'sb2'          => 'Scratch 2.0 Project File',
    'sb3'          => 'Scratch 3.0 Project File',
    'sbb'          => 'Office Accounting Company Backup File',
    'sbc'          => 'Space Engineers Data File',
    'sbd'          => 'DNASTAR SeqBuilder File',
    'sbf'          => 'SmartBroker Data',
    'sbg'          => 'SBaGen Binaural Beat File',
    'sbgf'         => 'Grapher Settings File',
    'sbi'          => 'Sound Blaster Instrument',
    'sbk'          => 'Multimedia ToolBook System Book',
    'sbm'          => 'Space Engineers Mod File',
    'sbn'          => 'GT-31 Binary Data File',
    'sbp'          => 'Sketchbook Express iCloud Image',
    'sbproj'       => 'OpenGL Shader Builder Project',
    'sbq'          => 'Superbase QuickReports File',
    'sbr'          => 'Visual Studio Source Browser',
    'sbs'          => 'Substance Package',
    'sbsar'        => 'Substance Archive',
    'sbt'          => 'Superbase Data Notes File',
    'sbu'          => 'Samsung Backup File',
    'sbv'          => 'Superbase Form Definition File',
    'sbw'          => 'US Treasury Savings Bonds Wizard File',
    'sbx'          => 'SeqBox Container File',
    'sbz'          => 'ShowBiz Project File',
    'sc'           => 'Space Engine Script',
    'sc2'          => 'World of Tanks Blitz Model File',
    'sc2archive'   => 'Blizzard StarCraft 2 Archive File',
    'sc2assets'    => 'Blizzard StarCraft 2 Assets File',
    'sc2bank'      => 'StarCraft 2 Bank File',
    'sc2data'      => 'Blizzard StarCraft 2 Data File',
    'sc2locale'    => 'Blizzard StarCraft 2 Localization File',
    'sc2ma'        => 'StarCraft 2 Map Data File',
    'sc2map'       => 'Blizzard StarCraft 2 Map File',
    'sc2mod'       => 'Blizzard StarCraft 2 Modification File',
    'sc2replay'    => 'Blizzard StarCraft 2 Replay File',
    'sc2save'      => 'Blizzard StarCraft 2 Saved Game',
    'sc2scene'     => 'StarCraft 2 Cut Scene File',
    'sc3'          => 'SimCity 3000 City File',
    'sc4'          => 'RollerCoaster Tycoon Scenario File',
    'sc45'         => 'SuperCard Project File',
    'sc4desc'      => 'SimCity 4 Description File',
    'sc4lot'       => 'SimCity 4 Lot File',
    'sc4model'     => 'SimCity 4 Model File',
    'sc5'          => 'Chris Sawyer\'s Locomotion Scenario File',
    'sc6'          => 'RollerCoaster Tycoon 2 Scenario File',
    'sca'          => 'Scala Script File',
    'scacfg'       => 'SuperCard Application Configuration',
    'scad'         => 'OpenSCAD Script',
    'scala'        => 'Scala Source Code File',
    'scap'         => 'EFI Firmware File',
    'scar'         => 'SCAR Script',
    'scb'          => 'Euro Truck Simulator 2 Product Key File',
    'scc'          => 'Scenarist Closed Caption File',
    'scd'          => 'Data Rescue Saved Scan File',
    'scdoc'        => 'SpaceClaim Document',
    'sce'          => 'Scilab Script',
    'scea'         => 'Aleph One Map File',
    'scene'        => 'Antibody Level File',
    'scexcludb'    => 'Spring Cleaning Exclusions File',
    'scf'          => 'SimTown Sounds File',
    'scg'          => 'ColoRIX Image File',
    'scgc'         => 'myPM SCG Classic Data File',
    'scgp'         => 'myPM SCG Pro Data File',
    'scgs'         => 'myPM SCG Starter Data File',
    'sch'          => 'KiCad Schematic File',
    'schemas'      => 'GConf Schema Definition File',
    'schematic'    => 'MCEdit Schematic File',
    'sci'          => 'ColoRIX Graphics Image',
    'scl'          => 'Sibelius Chord Diagram Library',
    'sclvl'        => 'Scritter\'s Nest Data File',
    'scm'          => 'Super Chain Media File',
    'scn'          => 'TD Scan Data File',
    'scn0'         => 'Wii Texture Animation File',
    'sco'          => 'OMSI Scenery Object Configuration File',
    'sconf'        => 'Script Settings File',
    'scp'          => 'ColoRIX Bitmap Graphic File',
    'scpcfg'       => 'SuperCard Project Configuration File',
    'scpresets'    => 'Snap Converter Presets File',
    'scpt'         => 'AppleScript Script File',
    'scptd'        => 'AppleScript Script Bundle',
    'scr'          => 'Script File',
    'scratch'      => 'Scratch Project File',
    'screenflow'   => 'ScreenFlow Document',
    'screstorelog' => 'Spring Cleaning Restore Log',
    'scresults'    => 'Spring Cleaning Results File',
    'scribe'       => 'VideoScribe Project',
    'script'       => 'Generic Script File',
    'scriptlibrar' => ' \'Painter Script Library',
    'scriptsuite'  => 'AppleScript Script Suite File',
    'scripttermin' => 'L\'OGY           AppleScript Script Terminology File',
    'scriv'        => 'Scrivener Document',
    'scrivx'       => 'Scrivener XML Document',
    'scs'          => 'Prism3D Game Data File',
    'scs11'        => 'Show Cue System Cue File',
    'scskin'       => 'Survivalcraft Skin File',
    'scss'         => 'Sass Cascading Style Sheet',
    'sct'          => 'Windows Scriptlet',
    'scu'          => 'ColoRIX Bitmap Image',
    'scut4'        => 'Easy Cut Studio Project',
    'scv'          => 'ScanVec CASmate Sign File',
    'scw'          => 'Score Writer Document',
    'scworld'      => 'Survivalcraft World File',
    'scx'          => 'SuperCard Help Project',
    'scz'          => 'SmartDraw Collection Package File',
    'sd'           => 'ESPS Sampled Data File',
    'sd2'          => 'Sound Designer II File',
    'sd2f'         => 'Sound Designer 2 File',
    'sd7'          => 'Spring Content Package',
    'sda'          => 'StarOffice Drawing',
    'sdat'         => 'Nintendo DS Sound Data File',
    'sdb'          => 'SocialDecks Blog File',
    'sdc'          => 'Paragon Dictionary Database File',
    'sdd'          => 'StarOffice Presentation',
    'sdef'         => 'AppleScript Dictionary Document',
    'sdf'          => 'World in Conflict Game Map',
    'sdg'          => 'Strater Project File',
    'sdi'          => 'Windows System Deployment Image',
    'sdii'         => 'Sound Designer 2 Audio File',
    'sdinstall'    => 'Speckie Dictionary Installation File',
    'sdl'          => 'Service Description Language File',
    'sdlppx'       => 'SDL Trados Studio Project Package',
    'sdlproj'      => 'SDL Trados Studio Project',
    'sdlrpx'       => 'SDL Trados Studio Return Package',
    'sdltpl'       => 'SDL Trados Studio Project Template',
    'sdlxliff'     => 'SDL Trados XLIFF Localization File',
    'sdm'          => 'Spatial Data Modeling Language File',
    'sdn'          => 'Shareware Distributors Network File',
    'sdo'          => 'Signed Document',
    'sdoc'         => 'Satra Khmer Document',
    'sdp'          => 'StarOffice Presentation File',
    'sdq'          => 'SAS Data File',
    'sdr'          => 'Dell Support File',
    'sds'          => 'SDS Apps Data File',
    'sdsk'         => 'SafeHouse Private Storage Volume',
    'sdt'          => 'Siemens Desktop Theme File',
    'sdtid'        => 'SecurID Soft Token File',
    'sdv'          => 'Studio DV Project File',
    'sdw'          => 'MrSID World File',
    'sdx'          => 'Sample MIDI Dump Exchange',
    'sdz'          => 'NCI Compressed Database',
    'se'           => 'Shuttle Document',
    'se1'          => 'Swiss Ephemeris Data File',
    'sea'          => 'Self-Extracting Archive',
    'seam'         => 'Seam Framework Java Servlet File',
    'search-ms'    => 'Windows Saved Search File',
    'searchconnec' => 'O\'R-MS          Windows Search Connector File',
    'seb'          => 'Safe Exam Browser Configuration File',
    'sec'          => 'GuinXell Video File',
    'secure'       => 'Septium Secure Document',
    'securitysett' => 'N\'GS            Alpha Five Security Settings File',
    'sed'          => 'Sed Script',
    'sedprj'       => 'Slideshow Studio Elements Project',
    'seed'         => 'SEED Data File',
    'seestyle'     => 'Coda Style Sheet File',
    'sef'          => 'Password Manager Container File',
    'seg'          => 'Eragon Audio File',
    'segy'         => 'SEG-Y Data File',
    'sel'          => 'LinkOne Selection List File',
    'selectionpor' => 'F\'OLIOLIBRARY   Painter Selection Portfolio Library',
    'sem'          => 'Alpha Five Set Data Dictionary Memo',
    'sen'          => 'Scifer Internal Header Archive',
    'seo'          => 'SEO Note File',
    'sep'          => 'Separated Image File',
    'seplugin'     => 'AppleScript Editor Plug-in',
    'seq'          => 'DNA Sequence Text File',
    'sequ'         => 'Adobe Acrobat Sequence File',
    'ser'          => 'Astronomical Capture Video File',
    'server'       => 'MySQL Server Script',
    'service'      => 'Systemd Service Unit File',
    'ses'          => 'Patran Session File',
    'session'      => 'Mozilla Firefox Session File',
    'sesx'         => 'Adobe Audition Session File',
    'set'          => 'Document Library Property Set File',
    'settingconte' => 'T\'-MS           Windows Settings File',
    'settings'     => 'Minecraft iConomy Plug-in Settings File',
    'setup'        => 'CryENGINE Character Setup File',
    'sew'          => 'Home Embroidery Format',
    'sex'          => 'Alpha Five Set Data Dictionary Index',
    'sf'           => 'IRCAM Sound File',
    'sf2'          => 'SoundFont 2 Sound Bank',
    'sfap0'        => 'Sound Forge Pro Audio Proxy File',
    'sfar'         => 'Mass Effect 3 DLC File',
    'sfb'          => 'PlayStation 3 Disc Data File',
    'sfc'          => 'Creatures Saved Game',
    'sfcache'      => 'ReadyBoost Cache File',
    'sfd'          => 'Sofdec Dreamcast Movie',
    'sfera'        => 'Sfera 360° File',
    'sff'          => 'Structured Fax File',
    'sfg'          => 'Synfig Studio Compressed Project',
    'sfi'          => 'SafeFolder Encrypted File',
    'sfk'          => 'Sound Forge Pro Audio Peak File',
    'sfl'          => 'Sound Forge Pro Sound Data File',
    'sfo'          => 'PSP Game Parameters File',
    'sfp'          => 'Soft Font Printer File',
    'sfpack'       => 'Packed SoundFont File',
    'sfs'          => 'Kerbal Space Program Save File',
    'sft'          => 'Microsoft App-V Sequencer File',
    'sfv'          => 'Simple File Verification File',
    'sfvidcap'     => 'Sonic Foundry Video Capture File',
    'sfw'          => 'Seattle FilmWorks Image',
    'sfx'          => 'SoundFX Audio File',
    'sfz'          => 'SFZ Sample Definition File',
    'sg'           => 'SG-1000 Game ROM File',
    'sg0'          => 'Humongous Entertainment Game Save File',
    'sga'          => 'Relic Entertainment Game Archive',
    'sgaa'         => 'Aleph One Saved Game',
    'sgb'          => 'Super Game Boy ROM File',
    'sgd'          => 'GeneSnap Image File',
    'sgf'          => 'Smart Game Format File',
    'sgi'          => 'Silicon Graphics Image File',
    'sgm'          => 'Starpoint Gemini 2 Mod Package',
    'sgml'         => 'Standard Generalized Markup Language',
    'sgn'          => 'Signet Bureau DRM File',
    'sgp'          => 'MP3 Audio Mixer Sound Group Project',
    'sgpbpr'       => 'Baltie Program',
    'sgpbprj'      => 'Baltie Project',
    'sgpsc'        => 'Baltie Scene',
    'sgr'          => 'SimCity 4 Graphics Rules File',
    'sgt'          => 'SPSS Chart Template',
    'sgy'          => 'SEG-Y Data File',
    'sgz'          => 'SigzaLock Encrypted File',
    'sh'           => 'Unix Shell Archive',
    'sh2'          => 'Stronghold 2 Saved Game',
    'sh3d'         => 'Sweet Home 3D Design File',
    'sh3f'         => 'Sweet Home 3D Model Library',
    'sha1'         => 'SHA-1 Hash File',
    'sha256'       => 'FileVerifier++ SHA-256 Hashes File',
    'sha512'       => 'SHA 512 Hash File',
    'shader'       => 'Quake 3 Engine Shader File',
    'shar'         => 'Unix Shar Archive',
    'shb'          => 'Windows Document Shortcut',
    'shc'          => 'Adobe Photoshop Contours File',
    'shd'          => 'Windows Print Job Shadow File',
    'shft'         => 'Shift Work Calendar Data File',
    'shg'          => 'Segmented Hyper-Graphic',
    'shh'          => 'Adobe Photoshop Shadow/Highlight',
    'shipworld'    => 'Starbound Player Ship File',
    'shk'          => 'ShrinkIt Archive',
    'shn'          => 'Shorten Compressed Audio File',
    'shortcut'     => 'Asutype Shortcut',
    'show'         => 'Thinkfree Office NEO Show Document',
    'shp'          => 'ESRI Shapefile',
    'shpa'         => 'Aleph One Shape File',
    'shproj'       => 'Visual Studio Code Sharing App Project',
    'shr'          => 'Unix Shell Archive File',
    'shs'          => 'Microsoft Scrap File',
    'shsh'         => 'iPhone/iPod Touch SHSH Blob File',
    'sht'          => 'HTML File with Server Side Includes',
    'shtm'         => 'HTML Server Side Include File',
    'shtml'        => 'Server Side Include HTML File',
    'shv'          => 'Husqvarna Viking Embroidery File',
    'shw'          => 'Corel Presentation',
    'shx'          => 'Motorola Flash Superfile',
    'shy'          => 'ShyFile Encrypted File',
    'si'           => 'Softimage Image File',
    'sia'          => 'Spin It Again Track Data File',
    'sib'          => 'Sibelius Score',
    'sid'          => 'SID Audio File',
    'sidb'         => 'iTunes Authorization Data File',
    'sidd'         => 'iTunes Authorization Data File',
    'sidn'         => 'iTunes Authorization Data File',
    'sidx'         => 'StuffIt Archive Index File',
    'sif'          => 'Synfig Studio Project',
    'sifz'         => 'Synfig Studio Compressed Project',
    'sig'          => 'Broderbund Sign File',
    'signature'    => 'e-Filing Digital Signature File',
    'sii'          => '18 Wheels of Steel: Haulin\' Truck',
    'sim'          => 'Aurora Image',
    'simg'         => 'Synclavier Disk Image File',
    'simp'         => 'Software Ideas Modeler Project',
    'sims2pack'    => 'Downloaded Sims 2 Package File',
    'sims3'        => 'The Sims 3 Game Save File',
    'sims3.backup' => 'The Sims 3 Game Save Backup File',
    'sims3.bad'    => 'The Sims 3 Failed Game Save File',
    'sims3pack'    => 'The Sims 3 Package File',
    'sin'          => 'Sony Xperia Firmware File',
    'sinf'         => 'iOS Application Archive File',
    'sis'          => 'arivis ImageCore File',
    'sis.dm'       => 'Ovi Store DRM-Protected Application',
    'sisx'         => 'Symbian OS Installation File',
    'sisx.dm'      => 'Nokia Ovi Store DRM-Protected',
    'sit'          => 'StuffIt Archive',
    'site'         => 'GoLive Website Project File',
    'sitemap'      => 'ASP.NET Site Map File',
    'sites'        => 'iWeb Site Design Project',
    'sites2'       => 'iWeb Site Design Project',
    'sitx'         => 'StuffIt X Archive',
    'siv'          => 'Silicon Imaging Video File',
    'sjava'        => 'Synchronous Java File',
    'sjd'          => 'Scrapbook Factory Journal File',
    'sjpg'         => 'Sealed JPG File',
    'sk'           => 'Safari History Index File',
    'sk1'          => 'sK1 Vector Graphic File',
    'sk2'          => 'ChemSketch Drawing',
    'skb'          => 'SketchUp Backup Document',
    'skba'         => 'SketchBook Pro Animation File',
    'skc'          => 'SideKick Card File',
    'skcard'       => 'Starfish Sidekick Card File',
    'skd'          => 'Max Payne Skin Data File',
    'skein'        => 'Skein XML File',
    'sketch'       => 'Sketch Drawing',
    'sketchpad'    => 'Sketchpad Drawing File',
    'skf'          => 'AutoSketch Drawing',
    'ski'          => 'Motorola Phone Skin File',
    'skim'         => 'Skim Notes File',
    'skin'         => 'InstallShield Skin File',
    'skindex'      => 'Mail Index File',
    'skitch'       => 'Skitch Image',
    'skl'          => 'Maya Skeleton File',
    'skm'          => 'SketchUp Materials File',
    'skn'          => 'Avant Browser Skin File',
    'skp'          => 'SketchUp Document',
    'skr'          => 'PGP Private Keyring',
    'skse'         => 'Skyrim Script Extender Save File',
    'skv'          => 'XLANG Schedule Drawing File',
    'skx'          => 'XLANG Schedule File',
    'skypechatsty' => 'E\'Chat Style File',
    'skypeemotico' => 'S\'ET            Skype Emoticon Set File',
    'skz'          => 'SuperKaramba Theme',
    'sl'           => 'Software License File',
    'sla'          => 'Scribus Document',
    'sla.gz'       => 'Scribus Compressed Document',
    'slb'          => 'AutoCAD Slide Library',
    'sld'          => 'AutoCAD Slide File',
    'sldasm'       => 'SolidWorks Assembly File',
    'slddrt'       => 'SolidWorks Sheet File',
    'slddrw'       => 'SolidWorks Drawing File',
    'sldprt'       => 'SolidWorks Part File',
    'sldtm'        => 'SDL Translation Memory File',
    'sle'          => 'Sisulizer Package File',
    'slf'          => 'Symantec License File',
    'sli'          => 'OMSI Spline Configuration File',
    'slk'          => 'Symbolic Link File',
    'sll'          => 'Static Link Library',
    'sln'          => 'Visual Studio Solution File',
    'slogo'        => 'StarLogo Project File',
    'slogt'        => 'StarLogo Project Template',
    'slp'          => 'Sisulizer Project File',
    'sls'          => 'Image Playlist',
    'slst'         => 'Game Data File',
    'slt'          => 'Mozilla User Profile Folder',
    'sltng'        => 'StarLogo TNG Project File',
    'slupkg-ms'    => 'XrML Digital License Package',
    'slx'          => 'SpectraLayers Pro Project',
    'sm'           => 'Space Engine 3D Mesh File',
    'sma'          => 'SmartPlant Enhanced Report',
    'smali'        => 'Android Smali Assembly Language File',
    'smc'          => 'Super Nintendo Game ROM',
    'smd'          => 'Sega Mega Drive ROM',
    'sme'          => 'SmartEncryptor Encrypted File',
    'sment'        => 'StarMade Entity File',
    'smf'          => 'SkinMagic Toolkit File',
    'smg'          => 'SolidWorks Composer File',
    'smi'          => 'Self-Mounting Disk Image',
    'smil'         => 'SMIL Presentation File',
    'smk'          => 'Smacker Compressed Movie File',
    'sml'          => 'ARC/INFO Simple Macro Language File',
    'smm'          => 'Map Manager Schema File',
    'smmstore'     => 'Local Mind Map Store File',
    'smmx'         => 'SimpleMind Mind Map File',
    'smo'          => 'Sumotori Dreams Arena File',
    'smod'         => 'Stonehearth Mod File',
    'smp'          => 'Xionics SMP Image',
    'smpd'         => 'Sc2gears Mouse Print Data File',
    'smpf'         => 'Sprite Monkey Project',
    'smpkg'        => 'SmartMusic Package File',
    'smpx'         => 'SmartMusic Accompaniment File',
    'smrailroadss' => 'V\'EDGAME        Sid Meier\'s Railroads! Saved Game',
    'smrd'         => 'Adobe InDesign Filter File',
    'sms'          => 'Sega Master System ROM',
    'smsec'        => 'StarMade Sector File',
    'smskin'       => 'StarMade Skin File',
    'smt'          => 'Samsung Theme File',
    'smv'          => 'Smokeview Simulation Data',
    'smwt'         => 'Adobe InDesign Filter',
    'smx'          => 'SmartMusic XML File',
    'smz'          => 'SMath Studio Compressed Document',
    'smzip'        => 'StepMania Package',
    'sn1'          => 'Drive Snapshot First Differential',
    'sn2'          => 'Drive Snapshot Second Differential',
    'sna'          => 'NOGBA Snapshot File',
    'snag'         => 'SnagIt Capture File',
    'snagitstamps' => 'Snagit Stamp Archive',
    'snagproj'     => 'Snagit Project File',
    'snagstyles'   => 'Snagit Style Archive',
    'snapfireshow' => 'Corel SnapfireShow File',
    'snappy'       => 'Snappy Compressed File',
    'snapshot'     => 'VMware ThinApp Snapshot File',
    'snb'          => 'Shanda Bambook eBook',
    'snd'          => 'Akai MPC Sample',
    'snda'         => 'Aleph One Sound File',
    'snf'          => 'Starry Night Pro Document',
    'sng'          => 'Korg Trinity Song File',
    'sngx'         => 'ChordWizard Song',
    'snippet'      => 'Visual Studio IntelliSense Code Snippet',
    'snk'          => 'Strong Name Key File',
    'snm'          => 'Netscape Mail Index',
    'sno'          => 'Starry Night Pro Data File',
    'snp'          => 'Access Report Snapshot',
    'sns'          => 'SNS Video Game Audio File',
    'snsf'         => 'Super NES Sound Format File',
    'snt'          => 'Sticky Notes File',
    'snx'          => 'PISnoop Workspace File',
    'so'           => 'Shared Library',
    'so-abi'       => 'Cocoa AbiWord Plug-in',
    'so.0'         => 'Unix Shared Library File',
    'sob'          => 'OpenOffice.org Impress Bimap Styles',
    'sod'          => 'Spear of Destiny Data File',
    'soe'          => 'Star Wars: Shadows of the Empire Save',
    'soepsx'       => 'Player Studio Viewer Item File',
    'sol'          => 'Flash Local Shared Object File',
    'solitairesav' => '-\'MS            Microsoft Solitaire Saved Game',
    'song'         => 'AudioSauna Song File',
    'sonic'        => 'DigitalMedia Project File',
    'sopt'         => 'Synclavier Optical Disk Image File',
    'sor'          => 'Standard OTDR Record File',
    'sou'          => 'SBStudio II Sound File',
    'soundpack'    => 'SoundPackager Sound Package',
    'sounds'       => 'Quake 3 Engine Sound Definition File',
    'soundscript'  => 'Rigs of Rods Sound Script File',
    'sow'          => 'Descent ARJ Archive',
    'sp'           => 'Simplexety Parameters File',
    'sp2'          => 'Super Ball 2 Level File',
    'sp3'          => 'Windows XP SP3 CD File',
    'sp4'          => 'SuperCard 4 Player Project',
    'sp45'         => 'SuperCard Player File',
    'spa'          => 'Nintendo DS Particle File',
    'spanisher'    => 'Spanisher Word File',
    'sparc'        => 'Skype Plugin Archive',
    'sparkle'      => 'Sparkle Website Project',
    'sparsebundle' => 'Mac OS X Sparse Bundle',
    'sparsefs'     => 'BlueStacks Data Folder',
    'sparseimage'  => 'Mac OS X Sparse Image',
    'spb'          => 'Samsung Kies Phonebook File',
    'spc'          => 'Spectrum 512 Compressed Image',
    'spd'          => 'Form·Z Suspended Render File',
    'spdf'         => 'Sealed PDF File',
    'spe'          => 'SPSS Extension',
    'spec'         => 'RPM Specification File',
    'speccy'       => 'Speccy Snapshot',
    'spf'          => 'ShadowProtect Full Backup File',
    'spfx'         => 'Squeeze Presets File',
    'spg'          => 'TCP Optimizer Backup File',
    'sph'          => 'NIST SPHERE Audio File',
    'spi'          => 'ShadowProtect Incremental Backup File',
    'spidersolita' => 'R\'ESAVE-MS      Microsoft Spider Solitaire Saved Game',
    'spiff'        => 'Still Picture Interchange File Format',
    'spj'          => 'SPSS Production Job File',
    'spk'          => 'Deer Hunter Map File',
    'spl'          => 'sPlan Schematic Diagram File',
    'spl7'         => 'sPlan 7 Schematic Diagram File',
    'splane'       => 'Simple Planes Plane File',
    'split'        => 'Archiver Split File',
    'spm'          => 'Salt Package Manager Formula Package',
    'spo'          => 'Spore Saved Game',
    'spp'          => 'Serif PhotoPlus Picture File',
    'sppack'       => 'SPPack Sound Sample',
    'spq'          => 'SPSS Database Query File',
    'spr'          => 'FoxPro Generated Screen File',
    'sprg'         => 'Synclavier Program File',
    'sprite'       => 'Scratch Sprite File',
    'sprite2'      => 'Scratch 2.0 Sprite File',
    'sps'          => 'Sharkport PS2 Save File',
    'spt'          => 'TM File Packer Compressed Archive',
    'spu'          => 'Spectrum 512 Image',
    'spub'         => 'Disc Cover File',
    'spv'          => 'SPSS Output Document',
    'spvchain'     => 'MultiCoin Wallet File',
    'spx'          => 'System Profiler XML Report',
    'sq'           => 'Sysquake Program',
    'sqb'          => 'SQL Backup SQL Server Backup File',
    'sqd'          => 'Configuration Settings File',
    'sqf'          => 'Sothink SWF Quicker File',
    'sqfs'         => 'Squash FS Bootable File',
    'sql'          => 'Structured Query Language Data File',
    'sqlite'       => 'SQLite Database File',
    'sqlite3'      => 'SQLite 3 Database File',
    'sqlitedb'     => 'SQLite Database',
    'sqlproj'      => 'Visual Studio SQL Server Project',
    'sqm'          => 'Operation Flashpoint Mission File',
    'sqr'          => 'SQL Program File',
    'squashfs'     => 'Squashfs File System File',
    'sqx'          => 'SQX Archive',
    'sqz'          => 'The Master Genealogist Backup Project',
    'sr'           => 'Sun Raster Image File',
    'sr0'          => 'SecuROM Analysis File',
    'sr2'          => 'Sony RAW Image',
    'srb'          => 'Sonic Robo Blast 2 Data File',
    'src'          => 'Source Code',
    'src.rpm'      => 'Red Hat Package Manager Source File',
    'srd'          => 'Sage Report Data File',
    'srep'         => 'SuperREP Compressed File',
    'srf'          => 'Samsung Smart TV Recording File',
    'srg'          => 'Ketron Single Registration File',
    'srk'          => 'Sub Rosa Client File',
    'srm'          => 'Super Nintendo ROM Save File',
    'srr'          => 'ReScene Metadata File',
    'srs'          => 'Outlook Send/Receive Settings File',
    'srt'          => 'SubRip Subtitle File',
    'srt0'         => 'Wii Texture Animation File',
    'srw'          => 'Samsung RAW Image',
    'ss'           => 'SilverStripe Source Code File',
    'ssa'          => 'Children of the Nile Campaign File',
    'ssc'          => 'Celestia Solar System Catalog File',
    'sscs'         => 'Saropa Smart Copy Script',
    'ssd'          => 'Starry Night Pro Data File',
    'sseq'         => 'Synclavier Sequence File',
    'ssf'          => 'Structured Subtitle Format File',
    'ssfsav'       => 'Super Smash Flash Saved Game File',
    'ssi'          => 'Adobe Dreamweaver Server Side Include',
    'ssii'         => 'ProReveal Data File',
    'ssis'         => 'ProReveal Settings File',
    'ssk'          => 'SmartSketch 95 Document',
    'ssl'          => 'Fallout Script',
    'ssl2'         => 'Sunlight ScanLibrary 2 File',
    'sslf'         => 'HLSW Shared Server List File',
    'ssm'          => 'Standard Streaming Metafile',
    'ssnd'         => 'Synclavier Sound File',
    'ssp'          => 'Scala Server Page',
    'sss'          => 'Coda Style Sheet File',
    'sst'          => 'Children of the Nile Textures File',
    'ssv'          => 'Seavus Secure Project File',
    'ssw'          => 'Sony Ericsson Firmware File',
    'st'           => 'Atari ST Disk Image',
    'st3'          => 'Star 3 MIDI Karaoke File',
    'st4'          => 'SuperCard Trial Project File',
    'st45'         => 'SuperCard Trial Project File',
    'sta'          => 'Adobe Photoshop Match Color Image',
    'stage'        => 'Pokémon Type Wild Stage Data File',
    'stap'         => 'Soundtrack Pro Audio Project File',
    'startupinfo'  => 'E-Prime 2.0 Startup Info File',
    'stats'        => 'FreeSurfer Statistics File',
    'stb'          => 'AutoCAD Plot Style Table File',
    'stc'          => 'Siemens Theme File',
    'std'          => 'CD/DVD Label Template',
    'stdl'         => 'Swift To-Do List Database',
    'ste'          => 'Samsung IPOLIS Image File',
    'steamstart'   => 'Valve Steam Start File',
    'stencyl'      => 'Stencyl Game File',
    'step'         => 'STEP 3D Model',
    'stf'          => 'Microsoft Setup Table File',
    'stfx'         => 'SampleTank Effects Settings File',
    'stg'          => 'ActiveSync Backup File',
    'sth'          => 'SampleTank User Preset Data File',
    'sti'          => 'SampleTank User Preset Data File',
    'stip'         => 'SampleTank User Preset Instrument',
    'stix'         => 'Structured Threat Information',
    'stk'          => 'Power Vision Stock File',
    'stl'          => 'SuperTux Level File',
    'stm'          => 'The Powder Toy Stamp File',
    'stmb'         => 'Synclavier Timbre File',
    'stml'         => 'SSI HTML File',
    'stn'          => 'Genuine Fractals Image',
    'sto'          => 'PRO100 3D Interior Design Project',
    'story'        => 'Storyist Document',
    'storyboard'   => 'Interface Builder Storyboard Document',
    'storyistthem' => ' \'Storyist Application Theme File',
    'storymill'    => 'StoryMill Project File',
    'stp'          => 'RoboHelp Stop List File',
    'stproj'       => 'iAd Producer Project',
    'str'          => 'BFME2 Strings File',
    'strings'      => 'Text Strings File',
    'strm'         => 'Stream File',
    'sts'          => 'DuoS DSEMU Saved State File',
    'stsg'         => 'SuperTux Saved Game',
    'stskin'       => 'Steam Skin File',
    'stt'          => 'SPSS Table Template',
    'sttpl'        => 'Samsung Theme Showcase File',
    'stu'          => 'Pinnacle Studio Project File',
    'studio'       => 'Silhouette Studio Document',
    'studio3'      => 'Silhouette Studio Version 3 Document',
    'stw'          => 'SampleTank User Preset Data File',
    'stwm'         => 'SuperTux World Map File',
    'stx'          => 'Scream Tracker Music Interface Kit File',
    'stxt'         => 'Sealed Text File',
    'sty'          => 'Aegisub Subtitle Styles File',
    'styk'         => 'Stykz Stick Figure',
    'stykz'        => 'Stykz Animation',
    'style'        => 'ArcGIS Style Manager File',
    'styx'         => 'ChordWizard Style',
    'sub'          => 'SubTerra Level File',
    'sublime-buil' => ' \'Sublime Text Build File',
    'sublime-keym' => 'P\'Sublime Text Keymap File',
    'sublime-menu' => 'Sublime Text Menu File',
    'sublime-opti' => 'N\'S             Sublime Text Options File',
    'sublime-pack' => 'G\'E             Sublime Text Package File',
    'sublime-proj' => 'C\'T             Sublime Text Project File',
    'sublime-sess' => 'O\'N             Sublime Text Session File',
    'sublime-sett' => 'N\'GS            Sublime Text Settings File',
    'sublime-snip' => 'E\'T             Sublime Text Snippet File',
    'sublime-them' => ' \'Sublime Text Theme File',
    'sublime-work' => 'P\'ACE           Sublime Text Workspace File',
    'suck'         => 'SiteSucker Website File',
    'sud'          => 'Sudoku Puzzle File',
    'suf'          => 'Ccrypt Encrypted File',
    'sugar'        => 'Espresso Plug-in',
    'sui'          => 'StarSplatter User Interface File',
    'suit'         => 'Macintosh Font Suitcase',
    'sum'          => 'Garmin Checksum File',
    'sumo'         => 'Sumo Paint Image',
    'sun'          => 'Sun Raster Graphic File',
    'suniff'       => 'Sun TAAC Image',
    'suo'          => 'Visual Studio Solution User Options',
    'sup'          => 'Super Project Definition File',
    'supp'         => 'iOS Application Archive File',
    'sv$'          => 'AutoCAD Automated Backup File',
    'sv'           => 'SystemVerilog Source Code File',
    'sv2i'         => 'Symantec System Index File',
    'sv4'          => 'RollerCoaster Tycoon Saved Game',
    'sv5'          => 'Chris Sawyer\'s Locomotion Saved Game',
    'sv6'          => 'RollerCoaster Tycoon 2 Saved Game',
    'sva'          => 'Manga Browser Comic File',
    'svc'          => 'WCF Web Service File',
    'svd'          => 'Scanning Vibrometer Data File',
    'sve'          => 'Carmageddon: TDR 2000 Saved Game',
    'svf'          => 'Simple Vector Format Graphic',
    'svg'          => 'Saved Game File',
    'svgz'         => 'Compressed SVG File',
    'svh'          => 'SystemVerilog Source Code Header File',
    'svi'          => 'Samsung Video File',
    'svm'          => 'StarView Metafile',
    'svn-base'     => 'Subversion Base File',
    'svn-work'     => 'Subversion Cache File',
    'svq'          => 'Roland Sequencer File',
    'svr'          => 'Compressed Virtual World',
    'svs'          => 'Game Boy Advance Saved State File',
    'svt'          => 'Torchlight Saved Game File',
    'svw'          => 'SpecView File',
    'svx'          => '8SVX Sound File',
    'sw'           => 'Signed Word Audio File',
    'sw2'          => 'Softwrap License File',
    'swa'          => 'Shockwave Audio',
    'swav'         => 'Nintendo DS Audio File',
    'swc'          => 'Super Nintendo Wild Card ROM File',
    'swd'          => 'Flash Debug File',
    'swf'          => 'Shockwave Flash Movie',
    'swi'          => 'SWiSH Project File',
    'swidtag'      => 'SWID Tag File',
    'swift'        => 'Swift Source Code File',
    'switch'       => 'Switch Package',
    'swj'          => 'SolidWorks Journal File',
    'swk'          => 'StudyWorks Save File',
    'swm'          => 'Split Windows Imaging Format File',
    'swp'          => 'Vi Swap File',
    'swt'          => 'Flash Generator Template',
    'swv'          => 'Microsoft Sidewinder Game Voice',
    'sww'          => 'Anno Saved Game',
    'swz'          => 'Adobe Flash Player Cache File',
    'sx'           => 'SimplexNumerica Data File',
    'sxc'          => 'StarOffice Calc Spreadsheet',
    'sxcu'         => 'ShareX Custom Uploader',
    'sxd'          => 'ArcScene Document',
    'sxg'          => 'Apache OpenOffice Master Document',
    'sxi'          => 'StarOffice Impress Presentation',
    'sxls'         => 'Sealed Excel Spreadsheet',
    'sxm'          => 'StarMath Formula',
    'sxml'         => 'Sealed XML File',
    'sxt'          => 'Propellerhead Reason NN-XT Patch File',
    'sxw'          => 'StarOffice Writer Document',
    'sy'           => 'Simplexety Data File',
    'sy3'          => 'Harvard Graphics Symbol File',
    'sy_'          => 'Compressed SYS File',
    'syb'          => 'Syberia Game Data File',
    'syh'          => 'Synchomatic Instrument',
    'sylk'         => 'Microsoft Symbolic Link File',
    'sym'          => 'TatukGIS Symbols File',
    'syn'          => 'Synergy On Air Audio File',
    'synw-proj'    => 'SynWrite Project',
    'sys'          => 'Motorola Driver File',
    'sys-reserved' => 'R\'W-BITMAP.GROW Pioneer DVD Recorder Dummy File',
    'system'       => 'Vega Strike Virtual System File',
    'syw'          => 'Yamaha SY99/SY85 Audio File',
    'syx'          => 'MIDI System Exclusive Message',
    'sz'           => 'Winamp Classic Skin Download',
    'szs'          => 'GameCube Data File',
    't$m'          => 'AVG Internet Security Temporary File',
    't'            => 'Turing Source Code File',
    't01'          => 'TaxCut 2001 File',
    't02'          => 'TaxCut 2002 File',
    't03'          => 'TaxCut 2003 File',
    't04'          => 'TaxCut 2004 File',
    't05'          => 'TaxCut 2005 Tax Return',
    't06'          => 'TaxCut 2006 Tax Return',
    't07'          => 'TaxCut 2007 Tax Return',
    't08'          => 'TaxCut 2008 Tax Return',
    't09'          => 'At Home 2009 Tax Return',
    't10'          => 'At Home 2010 Tax Return',
    't11'          => 'At Home 2011 Tax Return',
    't12'          => 'At Home 2012 Tax Return',
    't13'          => 'H&R Block 2013 Tax Return',
    't14'          => 'H&R Block 2014 Tax Return',
    't15'          => 'H&R Block 2015 Tax Return',
    't16'          => 'H&R Block 2016 Tax Return',
    't17'          => 'H&R Block 2017 Tax Return',
    't2'           => 'Textease 2000 File',
    't2b'          => 'CyBook Thumbnail Image',
    't2d'          => 'TouchDraw Document',
    't2k'          => 'Teach2000 Document',
    't2ks'         => 'Teach2000 Exam Results File',
    't2kt'         => 'Teach2000 Exam File',
    't3001'        => 'TARGET 3001! Circuit Design Project File',
    't3d'          => 'TicTacTi Advertisement Definition File',
    't3x'          => 'TYPO3 Compressed Extension',
    't64'          => 'Commodore 64 Tape Image File',
    't65'          => 'PageMaker Template File',
    'ta'           => 'Sony Firmware File',
    'ta4'          => 'TaxAct 2014 Tax Return File',
    'ta5'          => 'TaxAct 2015 Tax Return File',
    'ta6'          => 'TaxAct 2016 Tax Return File',
    'ta7'          => 'TaxAct 2017 Tax Return File',
    'taac'         => 'Sun TAAC Image File',
    'tab'          => 'Typinator Set File',
    'tablecontent' => 'SMART Table Activity Pack File',
    'tac'          => 'ActiCalc Data File',
    'taf'          => 'ADRIFT Text Adventure File',
    'tag'          => 'DataFlex Data File',
    'tak'          => 'TAK 2000 Thermal Model File',
    'tao'          => 'Track at Once CD/DVD Image',
    'tap'          => 'Tap Tap Revenge Tap File',
    'tar'          => 'Consolidated Unix File Archive',
    'tar.bz2'      => 'Compressed Tarball File',
    'tar.gz'       => 'Compressed Tarball File',
    'tar.gz2'      => 'Misnamed BZ2 Tarball',
    'tar.lz'       => 'Lzip Compressed Tarball',
    'tar.lzma'     => 'LZMA Compressed Tarball',
    'tar.md5'      => 'Android System File',
    'tar.xz'       => 'XZ Compressed Tar Archive',
    'tar.z'        => 'Zipped Tarball File',
    'tardist'      => 'TAR Distribution Archive',
    'targa'        => 'Targa Graphic',
    'targets'      => 'MSBuild Targets File',
    'tax'          => 'TurboTax Tax Return',
    'tax08'        => 'TurboTax 2008 Tax Return File',
    'tax09'        => 'TurboTax 2009 Tax Return File',
    'tax10'        => 'TurboTax 2010 Tax Return File',
    'tax11'        => 'TurboTax 2011 Tax Return File',
    'tax12'        => 'TurboTax 2012 Tax Return File',
    'tax13'        => 'TurboTax 2013 Tax Return File',
    'tax15'        => 'TurboTax 2015 Tax Return File',
    'tax16'        => 'TurboTax 2016 Tax Return File',
    'tax17'        => 'TurboTax 2017 Tax Return File',
    'tax2008'      => 'TurboTax 2008 Tax Return',
    'tax2009'      => 'TurboTax 2009 Tax Return',
    'tax2010'      => 'TurboTax 2010 Tax Return',
    'tax2011'      => 'TurboTax 2011 Tax Return',
    'tax2012'      => 'TurboTax 2012 Tax Return',
    'tax2013'      => 'TurboTax 2013 Tax Return',
    'tax2014'      => 'TurboTax 2014 Tax Return',
    'tax2015'      => 'TurboTax 2015 Tax Return',
    'tax2016'      => 'TurboTax 2016 Tax Return',
    'tax2017'      => 'TurboTax 2017 Tax Return',
    'taz'          => 'Tar Zipped File',
    'tb'           => 'Tabbery Tab File',
    'tb0'          => 'Adobe Photoshop Thumbnail Cache File',
    'tbd'          => 'Apple Xcode Text-based Definition File',
    'tbk'          => 'FoxPro Memo Backup',
    'tbl'          => 'StarCraft Information Table',
    'tbm'          => 'Toribash Mod File',
    'tbn'          => 'Kodi Thumbnail Image',
    'tbp'          => 'Autodesk Topobase File',
    'tbs'          => 'TuneUp Utilities Boot Screen',
    'tbx'          => 'TermBase eXchange File',
    'tbz'          => 'Bzip Compressed Tar Archive',
    'tbz2'         => 'Tar BZip 2 Compressed File',
    'tc'           => 'Tellico Collection File',
    'tc2'          => 'TurboCAD 2D Mac Drawing',
    'tc3'          => 'TurboCAD 2D/3D Mac Drawing',
    'tcc'          => 'C++ Source Code File',
    'tccfgextende' => ' \'TestComplete Project Suite Settings File',
    'tcd'          => 'Technobox CAD Drawing',
    'tcl'          => 'Tcl Script',
    'tclogs'       => 'TestComplete Log Configuration File',
    'tcls'         => 'TestComplete Configuration File',
    'tcm'          => 'TurboCAD Mac Drawing',
    'tcn'          => 'Techne Model File',
    'tcnet'        => 'TestComplete Configuration Reference File',
    'tcp'          => 'Tally Compiled Program File',
    'tcr'          => 'TouchMagix Creative Suite Published File',
    'tct'          => 'TurboCAD Drawing Template',
    'tcw'          => 'TurboCAD Drawing File',
    'tcx'          => 'TurboCAD 3D Model Text File',
    'tcz'          => 'Tiny Core File',
    'td'           => 'Thunder Incomplete Download File',
    'td0'          => 'Akai Teledisk Sound Library',
    'td4'          => 'RollerCoaster Tycoon Track File',
    'td6'          => 'RollerCoaster Tycoon Track Design File',
    'tda'          => 'Java Application Thread Dump',
    'tda3mt'       => 'DivX Author Template File',
    'tdb'          => 'Transcendence Game Data File',
    'tddd'         => '3D Data Description File',
    'tde'          => 'Tableau Data Extract File',
    'tdf'          => 'Title Definition Format File',
    'tdl'          => 'ToDoList Tasklist File',
    'tdm'          => 'LabVIEW Binary Measurement File',
    'tdms'         => 'Technical Data Management Streaming File',
    'tds'          => 'Turbo Debugger Symbols File',
    'tdt'          => 'AVCHD Thumbnail File',
    'tdx'          => 'D-TEG CCTV Video Information File',
    'tdz'          => 'Drobo Firmware File',
    'te'           => 'Textease CT Database File',
    'te3'          => 'WinTrack Object File',
    'teacher'      => 'SMART Response Teacher Database File',
    'tec'          => 'TECkit Compiled Mapping File',
    'ted'          => 'TouchMagix Editable Document Template',
    'tee'          => 'TeeChart Template',
    'tef'          => 'TablEdit Tablature',
    'temp'         => 'Temporary (Temp) File',
    'template'     => 'Apple Pages Template',
    'ter'          => 'Terragen Terrain File',
    'terminal'     => 'Terminal Settings File',
    'terrn'        => 'Rigs of Rods Terrain File',
    'terrn2'       => 'Rigs of Rods Terrain 2 File',
    'testrunconfi' => ' \'Visual Studio Test Run Configuration File',
    'testsettings' => 'Visual Studio Test Settings File',
    'tet'          => 'Textease CT Template',
    'tex'          => 'Texture File',
    'tex0'         => 'Wii Texture File',
    'text'         => 'Plain Text File',
    'textclipping' => 'Mac OS X Text Clipping File',
    'textexpander' => 'TextExpander Settings File',
    'textfactory'  => 'BBEdit Text Factory',
    'texture'      => 'Diesel Engine Game Texture File',
    'tfa'          => 'TreeSoft CashFlow Analysis Data File',
    'tfc'          => 'Unreal Engine 3 Texture File Cache',
    'tfd'          => 'Tape Format Requirements Document',
    'tfil'         => 'Blizzard Software Update File',
    'tfm'          => 'TeX Font Metric File',
    'tfmx'         => 'Final Music System Tracker Module',
    'tfr'          => 'TIE Fighter Pilot File',
    'tfrd'         => 'Tape Image Format Requirements Document',
    'tfw'          => 'World File for TIFF',
    'tfx'          => 'Pro Tools Eleven Rack Plugin Preset File',
    'tg'           => 'Gzip Compressed Tar Archive',
    'tg4'          => 'Tiled Group 4 Raster Image File',
    'tga'          => 'Targa Graphic',
    'tgc'          => 'Terragen Node Clip File',
    'tgd'          => 'Terragen Project File',
    'tgf'          => 'Trivial Graph Format File',
    'tgo'          => 'Terragen Object File',
    'tgp'          => 'Terragen Plugin',
    'tgw'          => 'Terragen World File',
    'tgz'          => 'Gzipped Tar File',
    'th'           => 'Therion Data File',
    'tha'          => 'Windows Thai Noise-Words List File',
    'the'          => 'Microsoft Plus! Theme File',
    'theater'      => 'iMovie Theater File',
    'theme'        => 'Comodo Theme File',
    'themepack'    => 'Windows 7 Theme Pack',
    'thing'        => 'MakerBot Thing File',
    'thl'          => 'Total 3D Home Design File',
    'thm'          => 'Thermwood Macro File',
    'thmx'         => 'Office 2007 Theme File',
    'thp'          => 'TurboTax Text String',
    'thumb'        => 'JAlbum Thumbnail File',
    'thumbdata3-1' => '6\'3508120 Thumbnail Index File',
    'thx'          => 'Amiga THX Tracker Music File',
    'tiapp'        => 'TiTanium App',
    'tib'          => 'Acronis True Image File',
    'tibkp'        => 'Titanium Backup File',
    'tid'          => 'AVCHD Thumbnail File',
    'tie'          => 'CrossTie Installer File',
    'tif'          => 'GeoTIFF Image',
    'tiff'         => 'Tagged Image File Format',
    'tig'          => 'TI Connect Backup File',
    'tiger'        => 'Tomb Raider Game Data Archive',
    'tim'          => 'Vixen Timed Sequence File',
    'time'         => 'LIGHT File',
    'timeline'     => 'Timeline Data File',
    'timer'        => 'Systemd Unit Configuration File',
    'timestamp'    => 'Geodatabase Timestamp File',
    'tip'          => 'TuneUp Utilities Icon Package',
    'tiprogram'    => 'TI-Basic Program File',
    'tis'          => 'True Image Script',
    'tivo'         => 'TiVo Video File',
    'tix'          => 'DivX Video Download Activation File',
    'tja'          => 'Taikojiro Song Map File',
    'tjc'          => 'Taikojiro Song Map Sequence File',
    'tjp'          => 'Tiled JPEG File',
    'tk'           => 'Tk Script',
    'tk3'          => 'TK3 Multimedia eBook',
    'tkfl'         => 'TKLinks Saver Favorite Links File',
    'tko'          => 'AMX Software Module File',
    'tkr'          => 'Tinker Custom Level File',
    'tl5'          => 'Timeliner 5 File',
    'tla'          => 'TuneUp Utilities Startup Logo',
    'tlb'          => 'VAX Text Library',
    'tlc'          => 'The Logo Creator File',
    'tld'          => 'Tag Library Descriptor File',
    'tlg'          => 'QuickBooks Transaction Log File',
    'tlh'          => 'Typelib Generated C/C++ Header File',
    'tli'          => 'Typelib Generated C/C++ Inline File',
    'tlk'          => 'BioWare Aurora Engine Talk Table File',
    'tll'          => 'LG TV Link-Loader File',
    'tlo'          => 'SPSS TableLooks File',
    'tlp'          => 'Tulip Software Graph Format File',
    'tls'          => 'TuneUp Utilities Logon Screen',
    'tlx'          => 'Standard Dictionary File',
    'tlz'          => 'Tar LZMA Compressed File',
    'tlzma'        => 'LZMA Compressed Tar Archive',
    'tm'           => 'TeXmacs Document',
    'tm2'          => 'Theta Music Composer 2.x Audio File',
    'tm8'          => 'Theta Music Composer 1.x Audio File',
    'tmb'          => 'Timbuktu Pro Connection Document',
    'tmbundle'     => 'TextMate Bundle File',
    'tmc'          => 'Theta Music Composer 1.x Audio File',
    'tmd'          => 'PlayStation Game Model File',
    'tmdx'         => 'TextMaker Document',
    'tme'          => 'Bryce Time File',
    'tmlanguage'   => 'TextMate Language Grammar File',
    'tmo'          => '3DCG Animation and Pose File',
    'tmod'         => 'Terraria Mod File',
    'tmp'          => 'Finale Temporary File',
    'tmpl'         => 'Xfire User Interface Template',
    'tmproj'       => 'TextMate Project File',
    'tmproject'    => 'TextMate Project',
    'tmr'          => 'Free Countdown Timer Backup File',
    'tms'          => 'Telemate Script',
    'tmtheme'      => 'TextMate Theme File',
    'tmv'          => 'TextMaker Template',
    'tmvt'         => 'TimeMap Template',
    'tmvx'         => 'TextMaker Document Template',
    'tmw'          => 'Translation Memory Data File',
    'tmx'          => 'Translation Memory Exchange File',
    'tmzip'        => 'Theme Manager Zip File',
    'tn'           => 'LG Phone Image',
    'tn1'          => 'Tiny Low Resolution Image',
    'tn2'          => 'Tiny Medium Resolution Image',
    'tn3'          => 'Tiny High Resolution Image',
    'tne'          => 'Manga Studio Tone File',
    'tnef'         => 'Transport Neutral Encapsulation Format',
    'tns'          => 'TI-Nspire Document',
    'tnsp'         => 'TI-Nspire PublishView Document',
    'tny'          => 'Atari Tiny Image',
    'toast'        => 'Toast Disc Image',
    'toc'          => 'Brasero Table of Contents File',
    'tod'          => 'JVC Everio Video Capture File',
    'tol'          => 'AOL Tool File',
    'top'          => 'Gromacs Topology File',
    'topc'         => 'TopicCrunch Project File',
    'topprj'       => 'TopSolid Project File',
    'topviw'       => 'TopSolid\'Viewer Document',
    'tor'          => 'Star Wars: The Old Republic Asset File',
    'torrent'      => 'BitTorrent File',
    'totalsbackup' => 'Totals Database Backup File',
    'totalsdb'     => 'Totals Database File',
    'totalslayout' => 'Totals Invoice Layout File',
    'totalssyncdb' => 'Totals Synchronized Database File',
    'tp'           => 'Beyond TV Transport Stream File',
    'tp0'          => 'Mascom PVR Video File',
    'tp3'          => 'Harvard Graphics DOS Template File',
    'tp4'          => 'RollerCoaster Tycoon Track Picture File',
    'tpark'        => 'ThemePark Project File',
    'tpb'          => 'GROMACS Binary Input File',
    'tpc'          => 'Topic Connection Placeholder',
    'tpd'          => 'TreePad 7 Database File',
    'tpf'          => 'TexMod Package File',
    'tpi'          => 'TrueVision Bitmap Image',
    'tpk'          => 'Gear Watchface Design Build File',
    'tpkey'        => 'TexturePacker License Key File',
    'tpl'          => 'TatukGIS Editor Print Template File',
    'tpm'          => 'Transformation Parameters Model File',
    'tpr'          => 'TMPGEnc Project File',
    'tps'          => 'Bryce Tree Shape File',
    'tpu'          => 'Turbo Pascal Unit',
    'tpx'          => 'Turbo Pascal 7 Unit',
    'tpz'          => 'Kindle Topaz eBook File',
    'tqs'          => 'Trivia Quiz Shell Program File',
    'tr'           => 'TomeRaider 2 eBook File',
    'tr3'          => 'TomeRaider eBook File',
    'tra'          => 'WinTrack Railroad Track File',
    'trace'        => 'VMware ThinApp Trace Log File',
    'trak'         => 'Traktor Content Pack File',
    'trashes'      => 'macOS USB Flash Drive Trash Folder',
    'tray'         => 'Corel CONNECT Tray File',
    'trc'          => 'SQL Server Trace File',
    'trd'          => 'TrID Definitions Package',
    'trec'         => 'TechSmith Recording File',
    'trelby'       => 'Trelby File',
    'trf'          => 'Smaart Transfer Function File',
    'tri'          => 'Triangle Mesh File',
    'trif'         => 'Tiled Raster Interchange Format',
    'trim.3ds'     => 'Trimmed 3DS ROM',
    'trim.cia'     => 'Trimmed CTR Importable Archive',
    'trk'          => 'Garmin Track File',
    'trm'          => 'Oracle Trace Map File',
    'trn'          => 'SQL Server Transaction Log Backup File',
    'trp'          => 'HD Video Transport Stream',
    'trs'          => 'Linear Saw Component Information Archive',
    'truck'        => 'Rigs of Rods Truck Definition File',
    'trx'          => 'WebAuthorize Batch File',
    'trx_dll'      => 'Windows Startup File',
    'ts'           => 'TypeScript File',
    'ts1'          => 'VirtualBus Texture Description File',
    'ts4script'    => 'The Sims 4 Script Archive',
    'tsc'          => 'Cave Story Script',
    'tscproj'      => 'TechSmith Camtasia Project File',
    'tsf'          => 'Strater Template File',
    'tsi'          => 'Traktor Settings File',
    'tsk'          => 'TTPod Skin',
    'tsl'          => 'Tracker Status Log',
    'tsm'          => 'TwinCAT System Manager Configuration File',
    'tsp'          => 'TrueSpeech Audio File',
    'tsr'          => 'TIFF Simple Rare File',
    'tst'          => 'TagScanner Text Transform Script',
    'tstream'      => 'SwarmPlayer Streaming Torrent',
    'tsv'          => 'Digital Receiver Video Recording File',
    'tsz'          => 'Trillian Skin File',
    'tt'           => 'Visual Studio Text Template',
    'tt10'         => 'TurboTax Canada 2010 Tax Return',
    'tt11'         => 'TurboTax Canada 2011 Tax Return',
    'tt12'         => 'TurboTax Canada 2012 Tax Return',
    'tt13'         => 'TurboTax Canada 2013 Tax Return',
    'tt14'         => 'TurboTax Canada 2014 Tax Return',
    'tt15'         => 'TurboTax Canada 2015 Tax Return',
    'tt16'         => 'TurboTax Canada 2016 Tax Return',
    'tt17'         => 'TurboTax Canada 2016 Tax Return',
    'tt2012state'  => 'TurboTax 2012 State Tax Form',
    'tt2013state'  => 'TurboTax 2013 State Tax Form',
    'tt2014state'  => 'TurboTax 2014 State Tax Form',
    'tt2015state'  => 'TurboTax 2015 State Tax Form',
    'tt2016state'  => 'TurboTax 2016 State Tax Form',
    'tt2017state'  => 'TurboTax 2017 State Tax Form',
    'tta'          => 'True Audio File',
    'ttarch'       => 'Telltale Games Archive',
    'ttbk'         => 'Canadian TurboTax 2010 Backup File',
    'ttc'          => 'TrueType Font Collection',
    'ttd'          => 'Tinytag Explorer Data File',
    'tte'          => 'Private Character Editor File',
    'ttf'          => 'TrueType Font',
    'ttk'          => 'Catalyst Translation Toolkit',
    'ttkgp'        => 'TatukGIS Project File',
    'ttl'          => 'AGT Game Title File',
    'ttm'          => 'Tower Toppler Mission File',
    'ttmd'         => 'Trail Tracker Trail Map',
    'tts'          => 'ToolBook Translation System File',
    'ttskey'       => 'Tech Tool Store License File',
    'ttx'          => 'Trados TagEditor File',
    'ttxt'         => 'MPEG-4 Timed Text Subtitles File',
    'tu'           => 'Turing Source File',
    'tub'          => 'PaintShop Pro Picture Tube',
    'tun'          => 'LEGO Racers Audio File',
    'tur'          => 'Turing Program Source File',
    'tut'          => 'Children of the Nile Tutorial File',
    'tvc'          => 'TeamViewer Configuration File',
    'tvdownload'   => 'TeamViewer Download File',
    'tvj'          => 'TrueView Job Ticket',
    'tvl'          => 'TurboTax File',
    'tvlayer'      => 'mimoLive TV Layer',
    'tvm'          => 'TV3D Model',
    'tvpi'         => 'TitanTV Television Listing File',
    'tvrecording'  => 'BoinxTV TV recording',
    'tvs'          => 'TeamViewer Video Session File',
    'tvshow'       => 'mimoLive Show',
    'tvtemplate'   => 'mimoLive Template',
    'tvvi'         => 'TitanTV Television Listing File',
    'twb'          => 'Tableau Workbook File',
    'twbx'         => 'Tableau Packaged Workbook',
    'twc'          => 'TTWin Configuration File',
    'twh'          => 'Task Wheel Project File',
    'twig'         => 'Twig Template',
    'twm'          => 'theWord Module',
    'twt'          => 'Carmageddon 2 Data File',
    'twz'          => 'theWord Compressed Archive Module',
    'twzip'        => 'theWord Compressed Archive Module',
    'tx_'          => 'Compressed Text File',
    'txa'          => 'Midas ViewPoint Text Array List',
    'txd'          => 'Game Texture Dictionary',
    'txf'          => 'Celestia Font Texture File',
    'txn'          => 'MySpaceIM Conversation Log File',
    'txt'          => 'Plain Text File',
    'txtrpt'       => 'CommScope Teletilt Control System Report',
    'txw'          => 'Yamaha TX16W Audio File',
    'txz'          => 'XZ Compressed Tar Archive',
    'tyimport'     => 'Typinator Set Import File',
    'typeit4me'    => 'TypeIt4Me Clippings File',
    'tyset'        => 'Typinator Set File',
    'tz'           => 'Zipped Tar Archive',
    'tzarc'        => 'Trainz Archive',
    'tzx'          => 'ZX Spectrum Tape Image File',
    'u'            => 'Subsampled Raw YUV Image',
    'u10'          => 'UFile 2010 Tax Return',
    'u11'          => 'UFile 2011 Tax Return',
    'u12'          => 'UFile 2012 Tax Return',
    'u3d'          => 'Universal 3D File',
    'u3i'          => 'U3 Application Information File',
    'u3p'          => 'U3 Smart Application',
    'u8'           => '3D Lemmings Audio File',
    'uasset'       => 'Unreal Asset File',
    'uax'          => 'Unreal Audio Package',
    'ub'           => 'Unsigned Byte Audio File',
    'ubj'          => 'Universal Binary JSON File',
    'ubox'         => 'Universe Sandbox Data File',
    'uc'           => 'UnrealScript Class',
    'uc2'          => 'UltraCompressor 2 Archive',
    'uccapilog'    => 'Microsoft UCC API Log File',
    'uce'          => 'Windows UCE System File',
    'ucf'          => 'WebEx Media File',
    'uci'          => 'UFS Explorer Backup File',
    'ucl'          => 'Killing Floor System File',
    'ucm'          => 'Crazy Machines Model File',
    'uct'          => 'UC Browser Theme File',
    'ud'           => 'OmniPage User Dictionary',
    'udb'          => 'Dynamics AX User Database File',
    'udc'          => 'Adobe InDesign User Dictionary',
    'udcx'         => 'Universal Data Connection File',
    'udeb'         => 'Debian Package File',
    'udf'          => 'Excel User Defined Function',
    'udk'          => 'Unreal Engine Map File',
    'udl'          => 'Microsoft Universal Data Link File',
    'uds'          => 'NetBackup UNIX Domain Socket File',
    'uea'          => 'Protector Suite QL Encrypted Archive',
    'ufo'          => 'Ulead File Object',
    'ufr'          => 'Ultra Fractal File',
    'ufs'          => 'FreeBSD Unix File System File',
    'ufs.uzip'     => 'Compressed Unix File System File',
    'uft'          => 'Torque Font Cache File',
    'uga'          => 'Ulead GIF Animator File',
    'ugoira'       => 'Ugoira Animated Image File',
    'ugr'          => 'Apophysis Ultra Fractal Gradient File',
    'uha'          => 'UHarc Compressed Archive',
    'uhtml'        => 'UC Browser Saved Webpage',
    'ui'           => 'User Interface File',
    'uibak'        => 'UltraISO Backup Disk Image',
    'uif'          => 'Universal Image Format Disc Image',
    'uis'          => 'WindowBlinds User Interface Specification',
    'ukx'          => 'Unreal Animation Package',
    'ulaw'         => 'Raw u-Law Audio File',
    'uld'          => 'Unified Luminaire Data File',
    'ulf'          => 'Universal List File',
    'ulp'          => 'EAGLE User Language Program',
    'uls'          => 'NetMeeting User Location Service File',
    'ult'          => 'UltraTracker Module',
    'ulw'          => 'u-Law Audio File',
    'ulx'          => 'Glulx Game File',
    'ulz'          => 'USBlyzer Data Capture File',
    'umap'         => 'Unreal Engine Map File',
    'umd'          => 'Splinter Cell Blacklist Game Data File',
    'umf'          => 'MediaHolder Universal Media Format File',
    'uml'          => 'UML Data Object Model',
    'umlclass'     => 'UML Class Model',
    'umod'         => 'Unreal Tournament Module File',
    'ums'          => 'Rune 3D Mesh File',
    'umx'          => 'Unreal Music Package',
    'unauth'       => 'SiteMinder Unauthorized Message File',
    'unf'          => 'UNIF ROM File',
    'uni'          => 'MikMod UniMOD Module',
    'unif'         => 'UNIF ROM File',
    'unity'        => 'Unity Scene File',
    'unity3d'      => 'Unity Web Player File',
    'unitypackage' => 'Unity Package File',
    'unityproj'    => 'Unity 3D Project',
    'unk'          => 'Unknown File',
    'unknown'      => 'Unknown File Type',
    'unl'          => 'Garmin Unlock File',
    'unr'          => 'Unreal Level Map',
    'unt'          => 'AutoCAD Unit Definition File',
    'unx'          => 'Unix Text File',
    'uof'          => 'Uniform Office Document',
    'uop'          => 'Ultima Online Patch File',
    'uos'          => 'Uniform Office Spreadsheet',
    'uot'          => 'Uniform Office Document',
    'upd'          => 'Program Update Information',
    'update'       => 'ISAPI Update File',
    'updatr'       => 'iConomy Update File',
    'upf'          => 'Panono Unstitched Panorama Format',
    'upg'          => 'Upgrade File',
    'upk'          => 'Unreal Engine 3 Package',
    'upoi'         => 'iGO Points of Interest File',
    'upr'          => 'FileMaker User Dictionary',
    'ups'          => 'UPS Patch File',
    'upx'          => 'Ultimate Packer for eXecutables File',
    'uqm'          => 'The Ur-Quan Masters Game Data File',
    'url'          => 'Internet Shortcut',
    'urr'          => 'Uniface Signatures File',
    'urt'          => 'Utah Raster Toolkit File',
    'usa'          => 'Unreal Saved Game File',
    'useq'         => 'USeq Genome Data File',
    'user'         => 'Visual Studio Project User Options File',
    'userprofile'  => 'Norton AntiVirus User Profile File',
    'usertile-ms'  => 'Windows 8 User Tile File',
    'usf'          => 'EVGA Precision X Skin File',
    'usflib'       => 'Nintendo 64 Song Library',
    'usm'          => 'USM Game Video File',
    'usr'          => 'Lowrance GPS Data File',
    'ust'          => 'UTAU Sequence Text File',
    'ustar'        => 'Uniform Standard Tape Archive Format File',
    'usx'          => 'Unreal Static Meshes',
    'ut2'          => 'Unreal Tournament Map',
    'ut2mod'       => 'Unreal Tournament 2003/2004 Module File',
    'ut3'          => 'Unreal Tournament 3 Map File',
    'ut4mod'       => 'Unreal Tournament 2004 Module',
    'ut8'          => 'Ghost Master Language File',
    'utc'          => 'Bioware Creature File',
    'utf8'         => 'Unicode UTF8-Encoded Text Document',
    'utw'          => 'Unity Whirld File',
    'utx'          => 'Unreal Texture Package',
    'utxt'         => 'Unicode Text File',
    'utz'          => 'UIQ Theme Package',
    'uu'           => 'Uuencoded File',
    'uud'          => 'UUDecoded File',
    'uue'          => 'Uuencoded File',
    'uvf'          => 'Uncertain Value Format',
    'uvw'          => 'UVW Coordinates File',
    'uvx'          => 'Unreal Tournament 2003 Saved Game',
    'uw'           => 'Unsigned Word Audio File',
    'uwf'          => 'UltraTracker Wave File',
    'uwl'          => 'User Word List File',
    'uwrf'         => 'Universal Web Radio File',
    'uxf'          => 'UML eXchange Format',
    'uxx'          => 'Unreal Tournament Cache',
    'uzip'         => 'FreeBSD Compressed Disk Image',
    'v'            => 'Subsampled Raw YUV Image',
    'v11.suo'      => 'Visual Studio 2012 Solution User Options File',
    'v12'          => 'All The Right Type Database File',
    'v12.suo'      => 'Visual Studio 2013 Solution User Options File',
    'v264'         => 'v264 IPROBOT3 Video File',
    'v2i'          => 'Norton Ghost Virtual Volume Image',
    'v2m'          => 'V2 Synthesizer Audio File',
    'v3d'          => 'Visual3D.NET Data File',
    'v3o'          => 'Emergency 3 and 4 Model File',
    'v3v'          => 'Vector Art 3D Model File',
    'v64'          => 'Nintendo 64 ROM Dump',
    'vac'          => 'Oc2.316s Cakit File',
    'vag'          => 'PlayStation Compressed Sound File',
    'val'          => 'Olympus Voice Recording',
    'vala'         => 'Vala Source Code File',
    'vap'          => 'Dialogic Indexed Voice Audio File',
    'vaporcd'      => 'Norum Vapor CD',
    'var'          => 'Variable Data',
    'vault'        => 'Fontcase Vault File',
    'vb'           => 'Grand Theft Auto Audio File',
    'vbc'          => 'VodBurner Crude Video File',
    'vbd'          => 'Visual Basic ActiveX Document',
    'vbe'          => 'VBScript Encoded Script File',
    'vbf'          => 'City Interactive Game Data File',
    'vbg'          => 'Visual Basic Project Group File',
    'vbhtml'       => 'ASP.NET Razor Web Page',
    'vbk'          => 'Veeam Backup File',
    'vbm'          => 'Veeam Backup Metadata File',
    'vbox'         => 'Oracle VM VirtualBox Settings File',
    'vbox-extpack' => 'Oracle VM VirtualBox Extension Pack',
    'vbox-prev'    => 'Oracle VM VirtualBox Settings Backup File',
    'vbp'          => 'Visual Basic Project File',
    'vbpf1'        => 'Virtual Business - Personal Finance Data File',
    'vbproj'       => 'Visual Studio Visual Basic Project',
    'vbr'          => 'GIMP Parametric Brush File',
    'vbs'          => 'VBScript File',
    'vbscript'     => 'Visual Basic Script',
    'vbt'          => 'iAntiVirus Temporary Scan File',
    'vbw'          => 'Visual Basic Workspace File',
    'vbx'          => 'Visual Basic Custom Control',
    'vbx6settings' => 'VirusBarrier X6 Settings File',
    'vbz'          => 'Visual Basic Project Template',
    'vc'           => 'Verge Code File',
    'vc1'          => 'VC-1 Video File',
    'vc3'          => 'VSampler Soundbank File',
    'vc4'          => 'Visual C++ 4 File',
    'vc6'          => 'Virtual CD 6 CD Image',
    'vc8'          => 'Virtual CD 8 Disc Image',
    'vcd'          => 'Valve Choreography Data File',
    'vce'          => 'Yamaha Voice File',
    'vcf'          => 'vCard File',
    'vcm'          => 'Vice City Mod Manager File',
    'vco'          => 'Virtual CD Collection File',
    'vcomps'       => 'V-Comp Setup File',
    'vcp'          => 'eMbedded Visual C++ Project File',
    'vcpf'         => 'VideoConvert Project File',
    'vcpref'       => 'Norton Antivirus Preferences File',
    'vcproj'       => 'Visual C++ Project File',
    'vcr'          => 'ATI Video Card Recording',
    'vcrd'         => 'Windows Vault Credentials File',
    'vcs'          => 'vCalendar Event File',
    'vct'          => 'VISE Installer Project',
    'vcv'          => 'ViewCave Video File',
    'vcw'          => 'eMbedded Visual C++ Workspace File',
    'vcx'          => 'Visual Fox Pro Class Library',
    'vcxitems'     => 'VC++ Project Items File',
    'vcxproj'      => 'Visual C++ Project',
    'vda'          => 'Targa Bitmap Image File',
    'vdata'        => 'Vaulty Vault File',
    'vdb'          => 'OpenVDB Volume Database File',
    'vdc'          => 'IDRISI Vector Documentation File',
    'vdf'          => 'Gothic Game Data File',
    'vdi'          => 'StepMania Debug Resource File',
    'vdj'          => 'VirtualDJ Audio Sample File',
    'vdjsend'      => 'VirtualDJ Send File',
    'vdm'          => 'VEDIT Macro File',
    'vdo'          => 'Heathen Virus File',
    'vdp'          => 'Visual Studio Deployment Project',
    'vdproj'       => 'Visual Studio Setup and Deployment Project',
    'vdr'          => 'VirtualDub Signpost File',
    'vdw'          => 'Visio Web Drawing',
    'vdx'          => 'The 7th Guest Video File',
    'vec'          => 'Orbiter Vector Map File',
    'veg'          => 'Vue Vegetation file',
    'vegaswindowl' => 'Y\'OUT MAGIX VEGAS Window Layout File',
    'veh'          => 'Vehicle File',
    'vem'          => 'Meta Media Video E-Mail File',
    'vep'          => 'AVS Video Editor Project File',
    'ver'          => 'Version Record',
    'vert'         => 'Vertex Shader File',
    'vet'          => 'Lectra Cutter\'s Must File',
    'vexe'         => 'Virus Executable File',
    'vf'           => 'VEGAS Movie Studio Project File',
    'vfb'          => 'FontLab Studio Font File',
    'vfc'          => 'VentaFax Cover Page File',
    'vfd'          => 'Virtual Floppy Disk',
    'vff'          => 'Sun TAAC Graphic File',
    'vfs'          => 'VentaFax Schedule File',
    'vfs0'         => 'Metro 2033 Sound File',
    'vft'          => 'VideoStudio Filter File',
    'vfw'          => 'Video for Windows',
    'vfz'          => 'Creative Webcam Video Effects File',
    'vga'          => 'VGA Display Driver',
    'vgc'          => 'ViziGen Code Generation Template',
    'vgd'          => 'Generic CADD VGA Driver',
    'vgi'          => 'Vista Game Explorer Editor Game File',
    'vgm'          => 'Video Game Music File',
    'vgz'          => 'Video Game Music Compressed File',
    'vhd'          => 'VHDL Source File',
    'vhdl'         => 'VHDL Source File',
    'vhdx'         => 'Windows 8 Virtual Hard Drive File',
    'vhv'          => 'Valve Source Lighting File',
    'vi'           => 'LabVIEW Virtual Instrument File',
    'vibe'         => 'VibePlayer Haptic File',
    'vic'          => 'ViziGen Code Import Mappings File',
    'vicar'        => 'VICAR Image File',
    'vid'          => 'Generic Video File',
    'video'        => 'aTube Catcher Video File',
    'viewlet'      => 'Qarbon Viewlet',
    'viff'         => 'Visualization Image File Format',
    'viivo'        => 'Viivo Encrypted File',
    'vim'          => 'Vim Settings File',
    'vimrc'        => 'Vim Runtime Configuration File',
    'vip'          => 'Stitch Pattern File',
    'vir'          => 'Virus-Infected File',
    'vis'          => 'Visibility Image File',
    'visual'       => 'World of Tanks 3D Model Surface File',
    'visual_proce' => 'S\'ED  World of Tanks 3D Model Surface File',
    'viv'          => 'PlayStation Video File',
    'vivo'         => 'VivoActive Video File',
    'vix'          => 'Lightworks Video Index File',
    'vjp'          => 'Visual Studio J++ Project',
    'vjsproj'      => 'Visual Studio J# Project',
    'vlab'         => 'VisionLab Studio Project File',
    'vlc'          => 'VLC Playlist',
    'vlcl'         => 'VMware Localization File',
    'vle'          => 'Virtual Labs Electricity Circuit File',
    'vlg'          => 'VentaFax Logbook File',
    'vlp'          => 'LiveSite Project',
    'vlt'          => 'WinVault File Archive',
    'vlw'          => 'Processing Font File',
    'vlx'          => 'Compiled AutoLISP File',
    'vm'           => 'Velocity Template',
    'vmac'         => 'VMware Configuration File',
    'vmap'         => 'Valve Source 2 Uncompiled Map File',
    'vmap_c'       => 'Valve Source 2 Compiled Map File',
    'vmba'         => 'VMware Configuration File',
    'vmc'          => 'Windows Virtual Machine Configuration File',
    'vmcx'         => 'Virtual Machine Shell Information File',
    'vmd'          => 'Vocaloid Motion Data File',
    'vmdk'         => 'Virtual Machine Disk File',
    'vmdk-convert' => 'M\'P   VMWare Fusion Temporary File',
    'vmdl'         => 'Valve Source 2 Model File',
    'vmf'          => 'Covox Speech Thing Sample',
    'vmf_autosave' => 'Valve Hammer Editor Autosave File',
    'vmg'          => 'Nokia Text Message',
    'vmhf'         => 'VMware Hot Fix File',
    'vmhr'         => 'VMware Hot Fix Request File',
    'vml'          => 'Vector Markup Language File',
    'vmlf'         => 'VAIO Video File',
    'vmlt'         => 'VAIO Video File',
    'vmo'          => 'Virtools Media Object File',
    'vmpl'         => 'VMware Policy File',
    'vmsd'         => 'VMware Snapshot Metadata File',
    'vmsg'         => 'VMware Application Message File',
    'vmsn'         => 'VMware Snapshot State File',
    'vmss'         => 'VMware Suspended State File',
    'vmt'          => 'VMware Configuration File',
    'vmtm'         => 'VMware Team Data File',
    'vmv'          => 'VisualBoyAdvance Recording',
    'vmwarevm'     => 'VMware Fusion Virtual Machine',
    'vmx'          => 'Valve Map Backup File',
    'vmxf'         => 'VMware Team Member File',
    'vna'          => 'JVC JLIP Image',
    'vnc'          => 'VNC Configuration File',
    'vncloc'       => 'Screen Sharing VNC Internet Location',
    'vnd'          => 'Type3 Design File',
    'vnf'          => 'Vision Numeric Font',
    'vni'          => 'Dell Webcam Central Application Configuration',
    'vnt'          => 'Mobile Phone vNote File',
    'vob'          => 'Vue Objects File',
    'voc'          => 'RCA Voice Recorder File',
    'voca'         => 'PhotoVOCA Communication Board File',
    'voi'          => 'Voyetra Voice File',
    'vok'          => 'PocketVok Vocabulary File',
    'vol'          => 'Volfs File System Directory',
    'volarchive'   => 'CopyCatX Volume Archive',
    'vor'          => 'StarOffice Template',
    'vox'          => 'Voxlap Voxel Model File',
    'voxal'        => 'Voxal Project File',
    'voxb'         => 'Voxler Network File',
    'vp'           => 'Volition Package File',
    'vp3'          => 'On2 Streaming Video File',
    'vp6'          => 'TrueMotion VP6 Video File',
    'vp7'          => 'TrueMotion VP7 Video File',
    'vpa'          => 'VPchat Chat Gestures File',
    'vpc'          => 'ViziGen Configuration File',
    'vpc6'         => 'Virtual Machine Package',
    'vpc7'         => 'Virtual Machine Package',
    'vpcbackup'    => 'Windows Virtual PC Backup File',
    'vpd'          => 'VoxPro Database File',
    'vpe'          => 'Photoshop Vanishing Point Export File',
    'vph'          => 'VirtualPhotographer Custom Settings',
    'vpj'          => 'VideoPad Video Editor Project File',
    'vpk'          => 'Valve Pak',
    'vpl'          => 'Karaoke Player Playlist',
    'vpm'          => 'Vox Proxy Macro File',
    'vpol'         => 'Windows Vault Policy File',
    'vpp'          => 'VisionPro Job File',
    'vps'          => 'Virtual CD Copy Template',
    'vpw'          => 'VoxPro Wave File',
    'vpx'          => 'Avast! Virus Update File',
    'vqc'          => 'Virtual CD Quick Copy File',
    'vqf'          => 'TwinVQ Audio File',
    'vr'           => 'VR Studio Project File',
    'vrb'          => 'Veeam Incremental Backup File',
    'vrd'          => 'Visio Report Definition File',
    'vrf'          => 'Ventrilo Audio Recording',
    'vrimg'        => 'V-Ray Image File',
    'vrl'          => 'VRML Virtual World',
    'vrml'         => 'VRML File',
    'vro'          => 'DVD Video Recording Format',
    'vrphoto'      => 'VR Photo Image',
    'vrt'          => 'Virtual World',
    'vs'           => 'Vivid Include File',
    'vs4'          => 'AVTECH CCTV Video Surveillance File',
    'vsch'         => 'Windows Vault Schema File',
    'vscontent'    => 'Visual Studio Content File',
    'vsct'         => 'Visual Studio Command Table',
    'vsd'          => 'Visio Drawing File',
    'vsdisco'      => 'DISCO Dynamic Discovery Document',
    'vsdm'         => 'Visio Macro-Enabled Drawing',
    'vsdx'         => 'Visio Drawing',
    'vse'          => 'AVTECH CCTV Video',
    'vsh'          => 'Vertex Shader File',
    'vshost.exe'   => 'Visual Studio Hosting Process File',
    'vsi'          => 'Visual Studio Content Installer File',
    'vsix'         => 'Visual Studio Extension',
    'vsixmanifest' => 'VSIX Manifest',
    'vsl'          => 'Velocity Template File',
    'vsmacros'     => 'Visual Studio Binary Macro Project',
    'vsmdi'        => 'Visual Studio Test Metadata File',
    'vsmproj'      => 'Visual Studio Text Macro Project',
    'vso'          => 'Compiled Vertex Shader File',
    'vsp'          => 'Visual Studio Performance Report File',
    'vspf'         => 'Visual Studio Performance Filter File',
    'vsprops'      => 'Visual Studio Project Property File',
    'vsps'         => 'Visual Studio Serialized Performance Report',
    'vspscc'       => 'Visual Studio Project Source Control File',
    'vspx'         => 'Visual Studio Performance Report Data File',
    'vsq'          => 'VOCALOID2 Project File',
    'vsqx'         => 'VOCALOID3 Project File',
    'vss'          => 'Visio Stencil File',
    'vssettings'   => 'Visual Studio Settings File',
    'vssm'         => 'Visio Macro-Enabled Stencil File',
    'vssscc'       => 'Visual Studio Solution Source Control File',
    'vssx'         => 'Visio Stencil File',
    'vst'          => 'Targa Bitmap Image',
    'vstm'         => 'Visio Macro-Enabled Drawing Template',
    'vstpreset'    => 'VST Preset File',
    'vstx'         => 'Visio Drawing Template',
    'vsv'          => 'Virtual Machine Saved State File',
    'vsw'          => 'Visio Workspace File',
    'vsx'          => 'Visio Stencil XML File',
    'vsz'          => 'Visual Studio Wizard File',
    'vtf'          => '3DESIGN CAD File',
    'vtm'          => 'Visual Tool Markup Language Document',
    'vtml'         => 'Visual Tool Markup Language File',
    'vtpr'         => 'Studio Store Visualizer Project',
    'vtt'          => 'Web Video Text Tracks File',
    'vtv'          => 'Adobe Dreamweaver Validator Configuration File',
    'vtx'          => 'VTX Chiptune File',
    'vud'          => 'Virtual Machine Undo Drive File',
    'vue'          => 'FoxPro 2.x View Settings',
    'vvd'          => 'Vivid 3D Scanner Element File',
    'vvf'          => 'Voc Vocabulary File',
    'vvv'          => 'Virtual Volumes View Catalog',
    'vvvvvv'       => 'VVVVVV Game Level File',
    'vw'           => 'Volkswriter Text File',
    'vwl'          => 'Vuforia Word List',
    'vwp'          => 'Vehicle Weapon File',
    'vwx'          => 'Vectorworks Design File',
    'vx2'          => 'Space Engineers Voxel Object Data File',
    'vx_'          => 'Compressed Virtual Device Driver File',
    'vxd'          => 'Virtual Device Driver',
    'vxml'         => 'VoiceXML File',
    'vxp'          => 'Mobile Application File',
    'vyf'          => 'Samsung Digital Voice Recorder File',
    'vym'          => 'VYM Mind Map File',
    'vzm'          => 'Verizon Message File',
    'w'            => 'Google Toolbar Search History File',
    'w01'          => 'Samsung Recovery File',
    'w02'          => 'Split Archive File',
    'w32'          => 'WinCAPs Subtitle File',
    'w3d'          => 'Adobe Shockwave 3D File',
    'w3g'          => 'Warcraft 3 Replay File',
    'w3m'          => 'Warcraft 3 Map File',
    'w3n'          => 'Warcraft 3 Expansion Campaign Map File',
    'w3x'          => 'Warcraft 3 Expansion Map FIle',
    'w3z'          => 'Warcraft 3 Saved Game File',
    'w64'          => 'Sony Wave64 Audio File',
    'wa'           => 'Windows Addon Archive',
    'wa2'          => 'Wonderland Adventures Custom Adventure File',
    'wab'          => 'Windows Address Book',
    'wac'          => 'Inkling Sketch XML File',
    'wad'          => 'Nintendo Wii Game Data File',
    'waff'         => 'Internet Explorer for Mac Web Archive',
    'wagame'       => 'Worms Armageddon Game Recording',
    'wal'          => 'Winamp Modern Skin',
    'wallet'       => 'MultiDoge Wallet File',
    'walletx'      => 'Enpass Data File',
    'wam'          => 'Worms Armageddon Mission File',
    'wand'         => 'GarageBand Magic Template',
    'wapproj'      => 'Windows Application Packaging Project File',
    'war'          => 'Java Web Archive',
    'wasm'         => 'WebAssembly Binary File',
    'wav'          => 'DTS-WAV File',
    'wave'         => 'WAVE Sound File',
    'wax'          => 'Windows Media Audio Redirect',
    'wb0'          => 'Webshots Picture File',
    'wb1'          => 'Corel Quattro Pro File',
    'wb2'          => 'Corel Quattro Pro File',
    'wb3'          => 'Corel Quattro Pro 7 and 8 File',
    'wba'          => 'WindowBlinds Compressed Skin',
    'wbb'          => 'WinBackup Archive',
    'wbc'          => 'Webshots Collection File',
    'wbcat'        => 'Windows Backup Catalog File',
    'wbd'          => 'Webshots Picture File',
    'wbfs'         => 'Wii Backup File System File',
    'wbi'          => 'Compact ISO File',
    'wbk'          => 'WordPerfect Workbook',
    'wbm'          => 'Wireless Bitmap Image',
    'wbmp'         => 'Wireless Bitmap Image File',
    'wbp'          => 'Webshots Collection File',
    'wbs'          => 'WebBlender Project File',
    'wbt'          => 'Toribash Help File',
    'wbxml'        => 'WAP Binary XML File',
    'wbz'          => 'Webshots Download Picture File',
    'wc'           => 'Valve Hammer Configuration File',
    'wcat'         => 'WinCatalog Collection File',
    'wcd'          => 'Works Calendar File',
    'wcf'          => 'WebEx Saved Chat Session',
    'wcinv'        => 'Windows Meeting Space Invitation File',
    'wcm'          => 'Microsoft Works Communications Script',
    'wcp'          => 'WinDVD Creator Project File',
    'wcp_settings' => 'Alpha Five Settings File',
    'wcry'         => 'WannaCry Virus Encrypted File',
    'wcx'          => 'RemoteApp and Desktop Connections Configuration',
    'wcz'          => 'Chameleon Clock Wallpaper File',
    'wd3'          => 'Offline Explorer Data File',
    'wdb'          => 'Blizzard World of Warcraft Database File',
    'wdf'          => 'Wonderland Adventures Media File',
    'wdgt'         => 'Adobe Captivate Widget File',
    'wdgtproj'     => 'Dashcode Widget Project',
    'wdl'          => 'World Definition Language Script',
    'wdp'          => 'Windows Media Photo File',
    'wdq'          => 'Offline Explorer Queue File',
    'wdseml'       => 'Thunderbird Searchable Email File',
    'wdw'          => 'WinDev Window File',
    'wdz'          => 'WDZip Compressed Archive',
    'wea'          => 'Ecotect Weather File',
    'weap'         => 'Quake 3 Engine Weapon File',
    'weavelibrary' => 'Painter Weave Library',
    'web'          => 'Xara Web Document',
    'webapp'       => 'Firefox Web App Manifest File',
    'webarchive'   => 'Safari Web Archive',
    'webarchivexm' => ' \'Android Web Browser Archive',
    'webbookmark'  => 'Safari Web Bookmark File',
    'webdoc'       => 'Box.net Web Document',
    'webhistory'   => 'Safari Web History File',
    'webloc'       => 'Mac OS X Website Location',
    'webm'         => 'WebM Video File',
    'webp'         => 'WebP Image',
    'webpnp'       => 'Web Point and Print File',
    'webpublishhi' => 'T\'ORY  Alpha Five Web Publish History File',
    'website'      => 'Internet Explorer Pinned Site Shortcut',
    'webtemplate'  => 'iWeb Template',
    'webtest'      => 'Visual Studio Web Test File',
    'webtheme'     => 'iWeb Theme Template',
    'webz'         => 'WEBZ Compressed eBook File',
    'wem'          => 'Wwise Encoded Media File',
    'wer'          => 'Windows Error Report',
    'wfb'          => 'WaveFront Sound Bank',
    'wfc'          => 'Windows Wireless Network Settings File',
    'wfd'          => 'Wayfinder Map File',
    'wfm'          => 'dBASE Form',
    'wfp'          => 'WaveFront Program File',
    'wfsp'         => 'Wondershare Fantashow Project',
    'wft'          => 'GTA 4 Car Model File',
    'wfw'          => 'Windows Firewall Policy File',
    'wgf'          => 'Widelands Game File',
    'wgi'          => 'Wildgame Innovations Video File',
    'wgp'          => 'Web Gallery Project',
    'wgs'          => 'Walk-Graph Segment File',
    'wgt'          => 'IMPS Data File',
    'wgz'          => 'S60 Web Runtime Widget Package',
    'whf'          => 'Wing Helper File',
    'whirld'       => 'Unity Whirld Package',
    'whl'          => 'Python Wheel Package',
    'whtt'         => 'HTTrack Website Copier File',
    'wi'           => 'Wavelet Image',
    'wic'          => 'J Wavelet Image',
    'wid'          => 'Visual Studio Widget File',
    'widget'       => 'HybridJava Widget',
    'wie'          => 'WordPress Widget Export File',
    'wif'          => 'Weaving Interchange Format File',
    'wii'          => 'Scrambled Wii Disc Image',
    'wil'          => 'WinImage Disk Image List',
    'wim'          => 'Windows Imaging Format File',
    'win'          => 'FoxPro Window Settings',
    'winclone'     => 'Winclone Image',
    'windowslivec' => 'N\'TACT Windows Live Contacts File',
    'winmd'        => 'Windows Metadata File',
    'wiq'          => 'Visual Studio Work Item Query File',
    'wixlib'       => 'WiX Library File',
    'wixmsp'       => 'WiX XML Patch File',
    'wixmst'       => 'WiX Transform File',
    'wixobj'       => 'WiX Object File',
    'wixout'       => 'WiX XML Output File',
    'wixpdb'       => 'WiX Debug File',
    'wixproj'      => 'WiX Project File',
    'wiz'          => 'Microsoft Wizard File',
    'wje'          => 'WinJournal Entry',
    'wjf'          => 'WinJournal Journal File',
    'wjr'          => 'ReGet Deluxe Data File',
    'wk1'          => 'Lotus Worksheet',
    'wk2'          => 'Lotus 2 Worksheet',
    'wk3'          => 'Lotus 3 Worksheet',
    'wk4'          => 'Lotus 4 Worksheet',
    'wk5'          => 'Lotus 5 Worksheet',
    'wke'          => 'Lotus 1-2-3 Educational Version Worksheet',
    'wki'          => 'Lotus 2 Worksheet',
    'wkq'          => 'Quattro Pro for DOS Spreadsheet File',
    'wks'          => 'Lotus 1-2-3 Spreadsheet',
    'wku'          => 'Lotus 1-2-3 Spreadsheet',
    'wl1'          => 'Wolfenstein 3D Data File',
    'wl6'          => 'Wolfenstein 3D Data File',
    'wlb'          => 'WinList Protocol Bundle',
    'wld'          => 'SMBX World File',
    'wldx'         => 'World Map File',
    'wll'          => 'Microsoft Word Add-in',
    'wlmp'         => 'Windows Live Movie Maker Project File',
    'wlp'          => 'Worldlabel.com Label Designer File',
    'wls'          => 'R-Link Update File',
    'wlu'          => 'Jaff Ransomware Encrypted File',
    'wlvs'         => 'Windows Movie Maker Video Settings File',
    'wlx'          => 'WinList Analysis Protocol File',
    'wlz'          => 'WinImage Compressed Disk Image Set',
    'wm'           => 'Windows Media File',
    'wma'          => 'Windows Media Audio File',
    'wmd'          => 'Windows Media Download Package',
    'wmdb'         => 'Windows Media Database File',
    'wme'          => 'Windows Media Encoder Session File',
    'wmf'          => 'Widelands Map File',
    'wmga'         => 'Web Manga Document',
    'wml'          => 'Wireless Markup Language File',
    'wmmp'         => 'Windows Movie Maker Project File',
    'wmo'          => 'World of Warcraft World Map Object',
    'wmp'          => 'Windows Media Photo File',
    'wms'          => 'Windows Media Skin',
    'wmt'          => 'WinMount Virtual Disk File',
    'wmv'          => 'Windows Media Video File',
    'wmx'          => 'Windows Media Redirector File',
    'wmz'          => 'Compressed Windows Metafile',
    'wn'           => 'WriteNow Text Document',
    'wncry'        => 'Wana Decrypt0r 2.0 Encrypted File',
    'wnk'          => 'Wink Presentation',
    'woa'          => 'WebObjects Application',
    'woff'         => 'Web Open Font Format File',
    'woff2'        => 'Web Open Font Format 2.0 File',
    'wolfquest'    => 'WolfQuest Saved Game',
    'wop'          => 'Wonderland Object Preset',
    'wor'          => 'MapInfo Workspace File',
    'wordlist'     => 'Desktop Poet Word List File',
    'work'         => 'Bibble Work Queue File',
    'workflow'     => 'Automator Workflow',
    'worksheet'    => 'BBEdit Shell Worksheet File',
    'workspace'    => 'Adobe Bridge Workspace File',
    'world'        => 'Starbound World File',
    'wot'          => 'Web Of Trust File',
    'wotmod'       => 'World of Tanks Modification File',
    'wotreplay'    => 'World of Tanks Replay File',
    'wow'          => 'Grave Composer Music Module',
    'wowproj'      => 'AddOn Studio Project File',
    'wowsl'        => 'WOW Slider',
    'wowsreplay'   => 'World of Warships Replay File',
    'wp'           => 'WordPerfect Document',
    'wp3'          => 'Microsoft Photo Story Project File',
    'wp4'          => 'WordPerfect 4 Document',
    'wp5'          => 'WordPerfect 5 Document',
    'wp6'          => 'WordPerfect 6 Document',
    'wp7'          => 'WordPerfect 7 Document',
    'wpa'          => 'ACT! Word Processing Document',
    'wpb'          => 'Windows Phone Device Manager Backup File',
    'wpc'          => 'Pazzles Cutting File',
    'wpd'          => '602Text Word Processing Document',
    'wpe'          => 'WordPerfect Entrust Document',
    'wpf'          => 'WordPerfect Form',
    'wpg'          => 'Ironsight Game Data File',
    'wph'          => 'Phoenix BIOS File',
    'wpi'          => 'Inkling Sketch Binary File',
    'wpk'          => 'GuinXell Package File',
    'wpl'          => 'DEC WPS Plus Text Document',
    'wpm'          => 'Warcraft 3 Path Map File',
    'wpo'          => 'Technopress Waypoint 2D File',
    'wpost'        => 'Windows Live Writer Post File',
    'wpp'          => 'WordPerfect Color Palette',
    'wproj'        => 'Wwise Project File',
    'wps'          => 'Translator\'s Workbench Project File',
    'wpt'          => 'Cube 2 Waypoint File',
    'wpw'          => 'WP Works Word Processor File',
    'wpx'          => 'Printer Description File',
    'wq1'          => 'Quattro Pro for DOS Spreadsheet File',
    'wq2'          => 'Quattro Pro for DOS Spreadsheet File',
    'wr1'          => 'Lotus Symphony Worksheet File',
    'wrf'          => 'WebEx Recording',
    'wri'          => 'Microsoft Write Document',
    'wrk'          => 'SQL Server Log Shipping File',
    'wrl'          => 'VRML World',
    'wrp'          => 'Geomagic 3D Wrap File',
    'wrpl'         => 'Widelands Saved Game File',
    'wrpl.wgf'     => 'Widelands Initial Saved Game File',
    'wrts'         => 'Wrts File',
    'wrypt'        => 'Panwrypter Depleted Storage Volume File',
    'wrz'          => 'Compressed VRML World File',
    'ws'           => 'WonderSwan Game ROM File',
    'wsc'          => 'WonderSwan Color Game ROM',
    'wsd'          => 'WordStar Document',
    'wsdl'         => 'Web Services Description Language File',
    'wsf'          => 'Windows Script File',
    'wsh'          => 'Windows Script Host Settings',
    'wsi'          => 'Wise Package Studio Installer Package',
    'wsm'          => 'Wise Package Studio Merge Module',
    'wsp'          => 'SharePoint Solution Package',
    'wspak'        => 'WebsitePanel Backup File',
    'wsve'         => 'Wondershare Filmora for Mac Project File',
    'wsz'          => 'Winamp Classic Skin',
    'wtb'          => 'Win-Test Binary Log File',
    'wtc'          => 'Logitech Webcam File',
    'wtd'          => 'Grand Theft Auto IV Textures File',
    'wtf'          => 'World of Warcraft Text File',
    'wtml'         => 'WorldWide Telescope Data File',
    'wtpl'         => 'WireTap Studio Library',
    'wtpt'         => 'WireTap Studio Packaged Track',
    'wtr'          => 'Encarta File',
    'wtt'          => 'Write! Document',
    'wtv'          => 'Windows Recorded TV Show File',
    'wtx'          => 'Text Document',
    'wu8'          => 'Wiimm U8 Mario Kart Wii Archive',
    'wud'          => 'Wii U Disk Image File',
    'wul'          => 'WinUHA Language File',
    'wus'          => 'WUTG Tagged Audio File',
    'wut'          => 'WUTG Tag File',
    'wux'          => 'Compressed Wii U Disk Image File',
    'wv'           => 'WavPack Audio File',
    'wvc'          => 'WavPack Correction File',
    'wve'          => 'Wondershare Filmora Project File',
    'wvl'          => 'Wavelet Image',
    'wvm'          => 'Google Play Video File',
    'wvp'          => 'MagicHTML Web Video Player Project',
    'wvx'          => 'Windows Media Video Redirector',
    'wwd'          => 'Works Wizard File',
    'wwf'          => 'World Wide Fund Non-Printable Document',
    'wwu'          => 'Wwise Work Unit',
    'wx'           => 'Wanam Xposed Backup File',
    'wxi'          => 'WiX Include File',
    'wxl'          => 'WiX Localization File',
    'wxn'          => 'Waixing Famicom Game ROM',
    'wxp'          => 'Wax 2.0 Project',
    'wxs'          => 'WiX Source File',
    'wyz'          => 'WYZTracker File',
    'wz'           => 'Warzone 2100 Data File',
    'wzconfig'     => 'WinZip Configuration File',
    'wzmul'        => 'WinZip Registration File',
    'x'            => 'Lex Source Code File',
    'x32'          => 'Adobe Xtra File',
    'x3d'          => 'Xara3D Project',
    'x3f'          => 'SIGMA X3F Camera RAW File',
    'x3g'          => '3D Print File',
    'x4k'          => 'XML4King Configuration File',
    'x64'          => 'Commodore 64 Disk Image',
    'x86'          => 'Linux Executable File',
    'x_b'          => 'Parasolid Model Part File',
    'x_t'          => 'Parasolid Model Part File',
    'xa'           => 'GEAR CD/DVD Disc Image',
    'xadd'         => 'Expression Web Add-in',
    'xaf'          => 'Affirm Deposition Transcript',
    'xaiml'        => 'XAIML Chatterbot Database File',
    'xaml'         => 'XAML File',
    'xamlx'        => 'Visual Studio Workflow Service File',
    'xan'          => 'Worms Map File',
    'xap'          => 'XACT Project',
    'xapk'         => 'Compressed Android Package File',
    'xappl'        => 'Spoon XML Application Configuration File',
    'xar'          => 'Extensible Archive Format File',
    'xas'          => 'Pro/ENGINEER Assembly Instance Accelerator File',
    'xba'          => 'OpenOffice.org Basic Module File',
    'xbap'         => 'XAML Browser Application File',
    'xbc'          => 'SMART Notebook File',
    'xbd'          => 'DocuWorks Binder File',
    'xbdoc'        => 'Xiosis Scribe Document',
    'xbe'          => 'Xbox Executable File',
    'xbel'         => 'XBEL Bookmarks File',
    'xbf'          => 'XAML Binary File',
    'xbk'          => 'SMART Notebook File',
    'xbl'          => 'Extensible Binding Language File',
    'xbm'          => 'X11 Bitmap Graphic',
    'xbmml'        => 'Braille Music Markup Language File',
    'xbplate'      => 'Xiosis Scribe Template',
    'xbrl'         => 'XBRL Document',
    'xbsav'        => 'Mass Effect 2 Xbox Saved Game',
    'xbt'          => 'SMART Notebook Template File',
    'xcappdata'    => 'Xcode App Data File',
    'xcarchive'    => 'Xcode Archive',
    'xccolortheme' => 'Xcode Color Theme File',
    'xcconfig'     => 'Xcode Configuration Settings File',
    'xccrashpoint' => 'Xcode Crash Point File',
    'xcdatamodel'  => 'Xcode Core Data Model File',
    'xcdatamodeld' => 'Xcode Core Data Model File',
    'xcf'          => 'GIMP Image File',
    'xci'          => 'Nintendo Switch Game Backup File',
    'xcode'        => 'Xcode Project',
    'xcodeplugin'  => 'Xcode Plug-in',
    'xcodeproj'    => 'Xcode Project',
    'xcplugin'     => 'Xcode Plug-in',
    'xcplugindata' => 'Xcode Plug-in Data File',
    'xcscheme'     => 'Xcode Scheme File',
    'xcsl'         => 'CineStyle Color Correction File',
    'xcsnapshots'  => 'Xcode Snapshot',
    'xct'          => 'XVI32 Character Conversion Table File',
    'xcu'          => 'OpenOffice.org Configuration File',
    'xcworkspace'  => 'Xcode Workspace File',
    'xdb'          => 'PowerDesigner Database Definition File',
    'xdi'          => 'WinArchiver Extended Disc Image File',
    'xdl'          => 'Oracle Expert Definition Language File',
    'xdna'         => 'DNA Strider Sequence File',
    'xdp'          => 'XML Data Package',
    'xdr'          => 'XML-Data Reduced File',
    'xds'          => 'LcdStudio Design File',
    'xdw'          => 'Fuji Xerox DocuWorks File',
    'xef'          => 'eManager Form Data',
    'xej'          => 'Expression Encoder Job File',
    'xel'          => 'Expression Encoder Live Encoding File',
    'xem'          => 'eManager Metered Units',
    'xen'          => 'Guitar Hero III Data File',
    'xensearch'    => 'XenCenter Saved Search File',
    'xep'          => 'eManager File Packaging Information',
    'xer'          => 'Primavera P6 Project File',
    'xes'          => 'eManager Skins Definition',
    'xesc'         => 'Expression Encoder Screen Capture File',
    'xet'          => 'eManager Process Definition',
    'xev'          => 'eManager Auto-Update File',
    'xex'          => 'Xbox 360 Executable File',
    'xez'          => 'eManager Template Package',
    'xfb'          => 'Xserve RAID Firmware Binary File',
    'xfd'          => 'FormFlow 99 Form Data File',
    'xfdf'         => 'Adobe Acrobat XFDF File',
    'xfdl'         => 'XFDL File',
    'xfl'          => 'Animate Movie Archive',
    'xflow'        => 'FlowExchange Data File',
    'xfn'          => 'Ventura Printer Font',
    'xfo'          => 'XSL-FO Formatted Form',
    'xfr'          => 'iProcess Process Definition File',
    'xfs'          => 'eRacer Sound File',
    'xft'          => 'ChiWriter Printer Font',
    'xgdw'         => 'GDevelop Extension File',
    'xgml'         => 'Graph Modeling Language XML File',
    'xgmml'        => 'XGMML Graph File',
    'xgp'          => 'Xfire Game Patcher File',
    'xgs'          => 'XACT Global Settings File',
    'xht'          => 'XHTML File',
    'xhtm'         => 'Extensible Hypertext Markup Language Document',
    'xhtml'        => 'Extensible Hypertext Markup Language File',
    'xi'           => 'Fasttracker 2 Extended Instrument File',
    'xib'          => 'Interface Builder File',
    'xif'          => 'ScanSoft Pagis File',
    'xip'          => 'macOS Signed Archive',
    'xise'         => 'Xilinx ISE Project File',
    'xl'           => 'Excel Spreadsheet',
    'xla'          => 'Excel Add-In File',
    'xlam'         => 'Excel Open XML Macro-Enabled Add-In',
    'xlb'          => 'OpenOffice.org Module Information File',
    'xlc'          => 'Excel Chart',
    'xld'          => 'Excel Database File',
    'xle'          => 'Levelogger Software XML Data File',
    'xlf'          => 'XLIFF Document',
    'xlgc'         => 'ExpressK Database File',
    'xliff'        => 'XLIFF Localization File',
    'xlk'          => 'Excel Backup File',
    'xll'          => 'Excel Add-In File',
    'xlm'          => 'Excel Macro',
    'xlmv'         => 'Xunlei Movie File',
    'xlnk'         => 'XML Shortcut File',
    'xlr'          => 'Works Spreadsheet',
    'xls'          => 'Excel Spreadsheet',
    'xlsb'         => 'Excel Binary Spreadsheet',
    'xlshtml'      => 'Microsoft Excel HTML Spreadsheet',
    'xlsm'         => 'Excel Open XML Macro-Enabled Spreadsheet',
    'xlsmhtml'     => 'Microsoft Excel MIME HTML Spreadsheet',
    'xlsx'         => 'Microsoft Excel Open XML Spreadsheet',
    'xlt'          => 'Excel Template',
    'xlthtml'      => 'Microsoft Excel HTML Spreadsheet Template',
    'xltm'         => 'Excel Open XML Macro-Enabled Spreadsheet',
    'xltx'         => 'Excel Open XML Spreadsheet Template',
    'xlv'          => 'Excel Visual Basic Module',
    'xlw'          => 'Excel Workbook',
    'xm'           => 'Fasttracker 2 Extended Module',
    'xmap'         => 'XMind 2007/2008 Workbook',
    'xmb'          => 'X-Wing Mission Briefing File',
    'xmcd'         => 'Mathcad Worksheet File',
    'xmcdz'        => 'Mathcad Compressed Worksheet File',
    'xmct'         => 'Mathcad XML Worksheet Template',
    'xmd'          => 'ExamSoft Answer File',
    'xmdx'         => 'ExamSoft Answer File',
    'xmf'          => 'GameJack Disc Image File',
    'xmi'          => 'Extended MIDI File',
    'xmind'        => 'XMind Workbook File',
    'xml'          => 'Cinelerra Video Project',
    'xmlff'        => 'XML Flat File',
    'xmlper'       => 'LeCroy Binary Waveform File',
    'xmm'          => '3ds Max XML Animation Map File',
    'xmmap'        => 'MindManager XML Map File',
    'xmp'          => 'XMind Markers Package',
    'xmpz'         => 'Miradi XML Project File',
    'xms'          => 'XMS-Tracker Music Module',
    'xmt'          => 'XMind Template',
    'xmu'          => 'Expressive Music Container File',
    'xmv'          => 'Xbox Media Video File',
    'xmwx'         => 'ExamSoft Working File',
    'xmz'          => 'FastTracker 2 Extended Module',
    'xmzx'         => 'ExamSoft Exam File',
    'xnb'          => 'XNA Game Studio Binary Package',
    'xnk'          => 'Exchange Shortcut',
    'xnt'          => 'QuarkXPress Extension File',
    'xof'          => 'Reality Lab 3D Image File',
    'xol'          => 'PowerDesigner Object Language File',
    'xom'          => 'Worms 3D Object File',
    'xoml'         => 'Windows Workflow File',
    'xp'           => 'XPilot Map',
    'xp2'          => 'XPilot NG',
    'xp3'          => 'KiriKiri Package File',
    'xp4'          => 'KiriKiri Package',
    'xpaddercontr' => 'L\'LER   Xpadder Controller Profile',
    'xpd'          => 'PlayStation Store PSP License File',
    'xpdl'         => 'XPDL Module',
    'xpf'          => 'LMMS Preset File',
    'xpg'          => 'Autoplay Media Studio Exported Page',
    'xpi'          => 'Cross-platform Installer Package',
    'xpj'          => 'Micro Planner X-Pert Project File',
    'xpk'          => 'WWE RAW Model File',
    'xpl'          => 'LcdStudio Playlist File',
    'xpll'         => 'Pull-Planner Data File',
    'xpm'          => 'Micro Planner Manager File',
    'xpp'          => 'X++ Source Code File',
    'xpr'          => 'Microsoft Expression Design Graphic',
    'xps'          => 'XML Paper Specification File',
    'xpt'          => 'SAS Transport File',
    'xq'           => 'XQuery File',
    'xql'          => 'XML Query Language File',
    'xqm'          => 'XQuery Module',
    'xqt'          => 'SuperCalc Macro File',
    'xquery'       => 'XQuery Source Code File',
    'xqy'          => 'XQuery Source File',
    'xrb'          => 'XMind Resource Bundle',
    'xrdml'        => 'XRDML Data File',
    'xrf'          => 'Cal3D XML Materials File',
    'xrff'         => 'Extensible Attribute-Relation File Format',
    'xrm-ms'       => 'Microsoft Security Certificate',
    'xrns'         => 'Renoise Song File',
    'xrp'          => 'RationalPlan Project File',
    'xry'          => 'XRY Data File',
    'xs'           => 'Age of Empires 3 Map AI Generator',
    'xsb'          => 'XACT Sound Bank',
    'xsc'          => 'Visual Studio Dataset Internal Info File',
    'xsd'          => 'XML Schema Definition',
    'xsf'          => 'Cal3D XML Skeleton File',
    'xsi'          => 'Softimage XSI 3D Image',
    'xsiaddon'     => 'Softimage Add-on File',
    'xsl'          => 'XML Style Sheet',
    'xslic'        => 'XenServer License File',
    'xslt'         => 'XSL Transformation File',
    'xsn'          => 'InfoPath Form Template File',
    'xsp'          => 'Kodi Smart Playlist File',
    'xspf'         => 'XSPF Playlist File',
    'xss'          => 'XML Style Sheet',
    'xst'          => 'WebSphere Query Template',
    'xsvf'         => 'Xilinx Serial Vector Format File',
    'xsx'          => 'Visual Studio XML Schema Layout File',
    'xt'           => 'Fastracker 2 Track',
    'xtb'          => 'Angular Translation File',
    'xtbl'         => 'XTBL Ransomware Encrypted File',
    'xtg'          => 'Extensible TreeGraph File',
    'xtl'          => 'Vietcong Data File',
    'xtm'          => 'Xtremsplit Data File',
    'xtodvd'       => 'ConvertXtoDVD Project File',
    'xtp'          => 'XTree Data File',
    'xtreme'       => 'Winstep Xtreme Theme Pack',
    'xui'          => 'Xbox 360 User Interface File',
    'xul'          => 'XML User Interface Language File',
    'xum'          => 'Excel Unit Operation Model File',
    'xur'          => 'Xbox 360 Binary User Interface File',
    'xv0'          => 'Lattice XVL Structure File',
    'xv3'          => 'Lattice XVL Geometry File',
    'xva'          => 'XenServer Virtual Appliance File',
    'xvct'         => 'VISE XML Project File',
    'xvd'          => 'Xbox Virtual Disk',
    'xvid'         => 'Xvid-Encoded Video File',
    'xvm'          => 'VMware Console Configuration File',
    'xvmconf'      => 'World of Tanks XVM Configuration File',
    'xwb'          => 'XACT Wave Bank',
    'xwd'          => 'X Windows Dump Image',
    'xwf'          => 'OmniPage Workflow File',
    'xwk'          => 'Crosstalk Communicator Keyboard Mapping File',
    'xwp'          => 'Crosstalk Session File',
    'xws'          => 'Xara Web Designer Graphic',
    'xx'           => 'XXEncoded File',
    'xxd'          => 'Brixx Planner Calendar',
    'xxe'          => 'XXEncoded File',
    'xxx'          => 'Compucon Singer Embroidery File',
    'xy'           => 'XYWrite Document',
    'xy3'          => 'XYWrite III Document',
    'xyp'          => 'XYWrite Plus Document',
    'xys'          => 'XYplorer Script File',
    'xyw'          => 'XYWrite for Windows Document',
    'xyz'          => 'Celestia Sampled Trajectory Data File',
    'xyzv'         => 'Celestia Sampled Trajectory File',
    'xz'           => 'XZ Compressed Archive',
    'xzfx'         => 'ZipLogix ZipForm File',
    'xzm'          => 'Porteus Module',
    'y'            => 'Subsampled Raw YUV Image',
    'y3a'          => 'Yu-Gi-Oh! ONLINE 3 Avatar File',
    'y3d'          => 'Yu-Gi-Oh! ONLINE 3 Deck File',
    'y4m'          => 'YUV4MPEG2 Video File',
    'yab'          => 'Yabasic Source Code',
    'yal'          => 'Arts & Letters Clipart Library',
    'yam'          => 'Yahoo! Auctions Data',
    'yaml'         => 'YAML Document',
    'yaodl'        => 'PowerFlip 3D Image File',
    'ybd'          => 'YobiDrive Link File',
    'ybk'          => 'Microsoft Encarta Yearbook File',
    'ychat'        => 'Yahoo! Messenger Chat Log',
    'ycm'          => 'Yugioh Card Maker File',
    'ydc'          => 'Yu-Gi-Oh! Card Deck File',
    'ydk'          => 'Yu-Gi-Oh! Deck File',
    'ydl'          => 'PowerFlip YAODL 3D Image File',
    'ydr'          => 'Yu-Gi-Oh! Power of Chaos Replay File',
    'ydt'          => 'Yu-Gi-Oh! Power of Chaos Data File',
    'yenc'         => 'yEnc File',
    'yfs'          => 'YSFLIGHT Mission File',
    'ygf'          => 'Y Graph Format File',
    'yka'          => 'Yenka Model File',
    'ykcol'        => 'Locky Ransomware Encrypted File',
    'ym'           => 'Atari ST Audio File',
    'ymg'          => 'Yahoo! Messenger File',
    'yml'          => 'YAML Document',
    'yml2'         => 'YML Script',
    'ymp'          => 'YaST Metapackage File',
    'ync'          => 'yEnc Encoded File',
    'yog'          => 'Outerra Captured Video File',
    'yookoo'       => 'Yookoo Player Playlist File',
    'ypr'          => 'BYOB Project File',
    'yps'          => 'Yahoo! Messenger Data File',
    'yrcbck'       => 'YRC Backup Archive',
    'yrcbkm'       => 'YRC Bookmarks Archive',
    'yrcdat'       => 'YRC Software Data Script',
    'ysp'          => 'BYOB Sprite File',
    'ytd'          => 'Grand Theft Auto 5 Texture File',
    'ytf'          => 'Google Picasa Font Cache',
    'yumtx'        => 'YUM Transaction File',
    'yuv'          => 'YUV Video File',
    'yz'           => 'YAC Compressed File',
    'yz1'          => 'Yamazaki ZIPPER File',
    'z'            => 'Unix Compressed File',
    'z01'          => 'WinZip First Split Zip File',
    'z02'          => 'WinZip Second Split Zip File',
    'z03'          => 'WinZip Third Split Zip File',
    'z04'          => 'WinZip Fourth Split Zip File',
    'z1'           => 'Z-machine Z-code File',
    'z2'           => 'Z-machine Z-code Version 2 File',
    'z2f'          => 'Zoo Tycoon 2 Object File',
    'z2s'          => 'Zoo Tycoon 2 Saved Game',
    'z3'           => 'Z-machine Z-code Version 3 File',
    'z3d'          => 'ZModeler 3D File',
    'z4'           => 'Z-machine Z-code Version 4 File',
    'z5'           => 'Z-machine Z-code Version 5 File',
    'z6'           => 'Z-machine Z-code Version 6 File',
    'z64'          => 'Nintendo 64 Game ROM',
    'z7'           => 'Z-machine Z-code Version 7 File',
    'z8'           => 'Z-machine Z-code Version 8 File',
    'z80'          => 'TI-83 and 84 Plus Calculator File',
    'zab'          => 'Zipped Audio Book',
    'zabw'         => 'Compressed AbiWord Document File',
    'zad'          => 'Carmageddon Game Data File',
    'zap'          => 'FileWrangler Archive',
    'zbfx'         => 'zebNet Backup File Extended',
    'zblorb'       => 'Z-machine Package Game File',
    'zdb'          => 'EPSQ Database',
    'zdc'          => 'CD Catalog Expert Database File',
    'zdct'         => 'Adobe Language File',
    'zdl'          => 'Avery DesignPro Label File',
    'zdp'          => 'Avery DesignPro Label File',
    'zds'          => 'DesignPro Label File',
    'zeg'          => 'ZeroG Subtitles File',
    'zepto'        => 'Zepto Virus File',
    'zfo'          => 'XSL-FO Online Form',
    'zfsendtotarg' => 'T\'Compressed Folder',
    'zfx'          => 'ZipForm File',
    'zgm'          => 'Zenographics Image File',
    'zgr'          => 'BeatSlicer Groove File',
    'zhtml'        => 'RabbitWeb Webpage',
    'zi'           => 'Renamed Zip File',
    'zi_'          => 'Renamed Zip File',
    'zif'          => 'Zooming Image Format File',
    'zim'          => 'OpenZIM Wiki Archive',
    'zip'          => 'MAME Game ROM',
    'zipx'         => 'Extended Zip File',
    'zix'          => 'Quicken Online File',
    'zl'           => 'Zlib Compressed File',
    'zl9'          => 'ZoneAlarm Quarantined EXE File',
    'zlb'          => 'Z-machine Package Game File',
    'zm1'          => 'ZoneAlarm Renamed MDA File',
    'zm2'          => 'ZoneAlarm Renamed MDZ File',
    'zm3'          => 'ZoneAlarm Renamed NCH File',
    'zm9'          => 'ZoneAlarm MailSafe Renamed Zip File',
    'zma'          => 'Impedance File',
    'zmap'         => 'Zombies Ate My Neighbors Map File',
    'zmc'          => 'ZoneAlarm Quarantine File',
    'zml'          => 'Zooming Markup Language File',
    'zmv'          => 'ZSNES Movie File',
    'zno'          => 'Zinio Electronic Magazine File',
    'zon'          => 'Collection Building Custom Zone File',
    'zone.identif' => 'E\'Windows Zone Identifier File',
    'zoo'          => 'Zoo Tycoon Saved Game',
    'zpa'          => 'Vielklang Audio Metadata File',
    'zpf'          => 'Form•Z Preferences File',
    'zpi'          => 'Zipped File',
    'zpl'          => 'Zoom Player Play List',
    'zps'          => 'Zebra Portable Safe File',
    'zrtf'         => 'Nisus Compressed Rich Text File',
    'zs0'          => 'ZSNES Slot 0 Saved State File',
    'zs1'          => 'ZSNES Slot 1 Saved State File',
    'zs2'          => 'ZSNES Slot 2 Saved State File',
    'zs3'          => 'ZSNES Slot 3 Saved State File',
    'zs4'          => 'ZSNES Slot 4 Saved State File',
    'zs5'          => 'ZSNES Slot 5 Saved State File',
    'zs6'          => 'ZSNES Slot 6 Saved State File',
    'zs7'          => 'ZSNES Slot 7 Saved State File',
    'zs8'          => 'ZSNES Slot 8 Saved State File',
    'zs9'          => 'ZSNES Slot 9 Saved State File',
    'zsd'          => 'Dave Mirra Freestyle BMX Data File',
    'zsm'          => 'Raven Software Game Sound Archive',
    'zsplit'       => 'Archiver Compressed Split File',
    'zst'          => 'ZSNES Save File',
    'zt'           => 'Mental Ray Image Depth File',
    'ztd'          => 'Zoo Tycoon Data Archive',
    'ztf'          => 'DVD Label Template File',
    'ztmp'         => 'Steam Compressed Game Resource File',
    'ztr'          => 'DVD Label Template Media File',
    'zul'          => 'ZK User Interface File',
    'zvd'          => 'ZyXEL Voice File',
    'zvi'          => 'Zeiss Vision Image',
    'zvpl'         => 'Visual Paradigm License File',
    'zvr'          => 'SAFA Media Audio File',
    'zvt'          => 'Photoshop Zoomify Preset File',
    'zvz'          => 'Possible Virus File',
    'zw'           => 'Chinese Text File',
    'zxp'          => 'Extension Manager Package',
    'zz'           => 'Zzip Compressed Archive',
    'zzz'          => 'Black & White Game Data File',
    'zzzzz'        => 'Ransomware Encrypted File',
    '{pb'          => 'Corel WordPerfect Document Index File',
    '~cw'          => 'Circuit Wizard Backup File',
    '~hm'          => 'HostMonitor TestList Backup File',
  );
}
#>



=pod

=head1 NAME

File::Extension - explain file extensions

=head1 SYNOPSIS

      use File::Extension qw(extplain);

      my @filetypes = qw(nes pl pm gb p6);

      for my $what(@filetypes) {
        printf("%s is a %s\n", $what, extplain($what));
      }

=head1 DESCRIPTION

File::Extension exposes functionality for getting information on
filetypes based solely on their file extension.

This is useful in cases where libmagic doesn't work, i.e on empty or
corrupted files.

The extensions and descriptions are taken from L<http://fileinfo.com>.

=head1 EXPORTS

None by default.

=head1 FUNCTIONS

=head2 extplain()

Parameters: $file_extension

Returns:    $explanation

  my $explanation = extplain('nes'); # Nintendo (NES) ROM File

=head1 HISTORY

This module was initially crafted while exploring ideas for generating
the world's largest LS_COLORS file:

L</https://github.com/trapd00r/LS_COLORS/issues/112>


=head1 SEE ALSO

L<https://github.com/trapd00r/LS_COLORS>

=head1 AUTHOR

  Magnus Woldrich
  CPAN ID: WOLDRICH
  m@japh.se
  http://japh.se

=head1 CONTRIBUTORS

None required yet.

=head1 COPYRIGHT

Copyright 2018 the B<File::Extension>s L</AUTHOR> and
L</CONTRIBUTORS> as listed above.

=head1 LICENSE

This library is free software; you may redistribute it and/or modify it under
the same terms as Perl itself.

=cut
