/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockSet;

public class LockControl
implements Control {
    private final Lockable ref;
    private Lock firstGrant;
    private List granted;
    private List waiting;
    private Lock lastPossibleSkip;

    protected LockControl(Lock lock, Lockable lockable) {
        this.ref = lockable;
        this.firstGrant = lock;
    }

    private LockControl(LockControl lockControl) {
        this.ref = lockControl.ref;
        this.firstGrant = lockControl.firstGrant;
        if (lockControl.granted != null) {
            this.granted = new LinkedList(lockControl.granted);
        }
        if (lockControl.waiting != null) {
            this.waiting = new LinkedList(lockControl.waiting);
        }
        this.lastPossibleSkip = lockControl.lastPossibleSkip;
    }

    public LockControl getLockControl() {
        return this;
    }

    public boolean isEmpty() {
        if (!this.isUnlocked()) {
            return false;
        }
        return this.waiting == null || this.waiting.isEmpty();
    }

    void grant(Lock lock) {
        lock.grant();
        LinkedList<Lock> linkedList = this.granted;
        if (linkedList == null) {
            if (this.firstGrant == null) {
                this.firstGrant = lock;
            } else {
                linkedList = this.granted = new LinkedList<Lock>();
                linkedList.add(this.firstGrant);
                linkedList.add(lock);
                this.firstGrant = null;
            }
        } else {
            linkedList.add(lock);
        }
    }

    public boolean unlock(Latch latch, int n) {
        if (n == 0) {
            n = latch.getCount();
        }
        List list = this.granted;
        int n2 = 0;
        while (n > 0) {
            Lock lock;
            if (this.firstGrant != null) {
                lock = this.firstGrant;
            } else {
                n2 = list.indexOf(latch);
                lock = (Lock)list.get(n2);
            }
            n -= lock.unlock(n);
            if (lock.getCount() != 0) continue;
            if (this.firstGrant == lock) {
                this.firstGrant = null;
                continue;
            }
            list.remove(n2);
        }
        return true;
    }

    public boolean isGrantable(boolean bl, Object object, Object object2) {
        if (this.isUnlocked()) {
            return true;
        }
        boolean bl2 = false;
        Lockable lockable = this.ref;
        List list = this.granted;
        boolean bl3 = lockable.lockerAlwaysCompatible();
        int n = 0;
        int n2 = this.firstGrant == null ? list.size() : 0;
        do {
            Lock lock;
            boolean bl4;
            if ((bl4 = (lock = this.firstGrant == null ? (Lock)list.get(n) : this.firstGrant).getCompatabilitySpace().equals(object)) && bl3) {
                bl2 = true;
                continue;
            }
            if (!lockable.requestCompatible(object2, lock.getQualifier())) {
                bl2 = false;
                break;
            }
            if (!bl4 && !bl) continue;
            bl2 = true;
        } while (++n < n2);
        return bl2;
    }

    public Lock addLock(LockSet lockSet, Object object, Object object2) {
        boolean bl = false;
        boolean bl2 = this.firstWaiter() != null;
        Lock lock = null;
        Lockable lockable = this.ref;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl && !this.isUnlocked()) {
            boolean bl5 = lockable.lockerAlwaysCompatible();
            int n = 0;
            int n2 = this.firstGrant == null ? this.granted.size() : 0;
            do {
                Lock lock2;
                boolean bl6;
                if ((bl6 = (lock2 = this.firstGrant == null ? (Lock)this.granted.get(n) : this.firstGrant).getCompatabilitySpace().equals(object)) && bl5) {
                    bl3 = true;
                    if (bl4) break;
                    if (object2 == lock2.getQualifier()) {
                        lock = lock2;
                    }
                    bl = true;
                    continue;
                }
                if (!lockable.requestCompatible(object2, lock2.getQualifier())) {
                    bl = false;
                    lock = null;
                    if (bl3) break;
                    bl4 = true;
                }
                if (bl4 || !bl6 && bl2) continue;
                bl = true;
            } while (++n < n2);
        }
        if (lock != null) {
            ++lock.count;
            return lock;
        }
        if (bl) {
            lock = new Lock(object, lockable, object2);
            this.grant(lock);
            return lock;
        }
        ActiveLock activeLock = new ActiveLock(object, lockable, object2);
        if (bl3) {
            activeLock.canSkip = true;
        }
        if (this.waiting == null) {
            this.waiting = new LinkedList();
        }
        this.addWaiter(this.waiting, activeLock, lockSet);
        if (activeLock.canSkip) {
            this.lastPossibleSkip = activeLock;
        }
        return activeLock;
    }

    protected boolean isUnlocked() {
        if (this.firstGrant != null) {
            return false;
        }
        List list = this.granted;
        return list == null || list.isEmpty();
    }

    public ActiveLock firstWaiter() {
        if (this.waiting == null || this.waiting.isEmpty()) {
            return null;
        }
        return (ActiveLock)this.waiting.get(0);
    }

    ActiveLock getNextWaiter(ActiveLock activeLock, boolean bl, LockSet lockSet) {
        ActiveLock activeLock2 = null;
        if (bl && this.waiting.get(0) == activeLock) {
            this.popFrontWaiter(this.waiting, lockSet);
            activeLock2 = this.firstWaiter();
        } else if (this.lastPossibleSkip != null && this.lastPossibleSkip != activeLock) {
            int n;
            int n2 = this.waiting.indexOf(activeLock);
            int n3 = n = bl ? n2 : -1;
            if (n2 != this.waiting.size() - 1) {
                ListIterator listIterator = this.waiting.listIterator(n2 + 1);
                while (listIterator.hasNext()) {
                    ActiveLock activeLock3 = (ActiveLock)listIterator.next();
                    if (!activeLock3.canSkip) continue;
                    activeLock2 = activeLock3;
                    break;
                }
            }
            if (bl) {
                this.removeWaiter(this.waiting, n, lockSet);
            }
        } else if (bl) {
            int n = this.removeWaiter(this.waiting, activeLock, lockSet);
        }
        if (bl && activeLock == this.lastPossibleSkip) {
            this.lastPossibleSkip = null;
        }
        if (activeLock2 != null && !activeLock2.setPotentiallyGranted()) {
            activeLock2 = null;
        }
        return activeLock2;
    }

    public Lockable getLockable() {
        return this.ref;
    }

    public Lock getFirstGrant() {
        return this.firstGrant;
    }

    public List getGranted() {
        return this.granted;
    }

    public List getWaiting() {
        return this.waiting;
    }

    protected void giveUpWait(Object object, LockSet lockSet) {
        int n = this.removeWaiter(this.waiting, object, lockSet);
        if (object == this.lastPossibleSkip) {
            this.lastPossibleSkip = null;
        }
    }

    public void addWaiters(Dictionary dictionary) {
        if (this.waiting == null || this.waiting.isEmpty()) {
            return;
        }
        Control control = this;
        ListIterator listIterator = this.waiting.listIterator();
        while (listIterator.hasNext()) {
            ActiveLock activeLock = (ActiveLock)listIterator.next();
            Object object = activeLock.getCompatabilitySpace();
            dictionary.put(object, activeLock);
            dictionary.put(activeLock, control);
            control = activeLock;
        }
    }

    List getGrants() {
        LinkedList<Lock> linkedList;
        if (this.firstGrant != null) {
            linkedList = new LinkedList<Lock>();
            linkedList.add(this.firstGrant);
        } else {
            linkedList = new LinkedList(this.granted);
        }
        return linkedList;
    }

    public final Lock getLock(Object object, Object object2) {
        if (this.isUnlocked()) {
            return null;
        }
        List list = this.granted;
        int n = 0;
        int n2 = this.firstGrant == null ? list.size() : 0;
        do {
            Lock lock;
            Lock lock2 = lock = this.firstGrant == null ? (Lock)list.get(n) : this.firstGrant;
            if (!lock.getCompatabilitySpace().equals(object) || lock.getQualifier() != object2) continue;
            return lock;
        } while (++n < n2);
        return null;
    }

    public Control shallowClone() {
        return new LockControl(this);
    }

    private void addWaiter(List list, Lock lock, LockSet lockSet) {
        list.add(lock);
        lockSet.oneMoreWaiter();
    }

    private Object popFrontWaiter(List list, LockSet lockSet) {
        lockSet.oneLessWaiter();
        return list.remove(0);
    }

    private Object removeWaiter(List list, int n, LockSet lockSet) {
        lockSet.oneLessWaiter();
        return list.remove(n);
    }

    private int removeWaiter(List list, Object object, LockSet lockSet) {
        lockSet.oneLessWaiter();
        return list.remove(object) ? 1 : 0;
    }
}

