#!/usr/bin/perl

package eBay::API::XML::DataType::ApplicationDeliveryPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ApplicationDeliveryPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ApplicationDeliveryPreferencesType

=head1 DESCRIPTION

Specifies preferences describing how notifications are
delivered to an application. Note that notifications are subject
to Anti-Spam rules. See Anti-Spam Rules in the eBay Web Services Guide for more information about these rules.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ApplicationDeliveryPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::DeliveryURLDetailType;
use eBay::API::XML::DataType::Enum::DeviceTypeCodeType;
use eBay::API::XML::DataType::Enum::EnableCodeType;
use eBay::API::XML::DataType::Enum::NotificationPayloadTypeCodeType;


my @gaProperties = ( [ 'AlertEmail', 'xs:anyURI', '', '', '' ]
	, [ 'AlertEnable', 'ns:EnableCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::EnableCodeType', '' ]
	, [ 'ApplicationEnable', 'ns:EnableCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::EnableCodeType', '' ]
	, [ 'ApplicationURL', 'xs:anyURI', '', '', '' ]
	, [ 'DeliveryURLDetails', 'ns:DeliveryURLDetailType', '1'
	     ,'eBay::API::XML::DataType::DeliveryURLDetailType', '1' ]
	, [ 'DeviceType', 'ns:DeviceTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DeviceTypeCodeType', '' ]
	, [ 'NotificationPayloadType', 'ns:NotificationPayloadTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::NotificationPayloadTypeCodeType', '' ]
	, [ 'PayloadVersion', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAlertEmail()

The email address where eBay sends all application
markup and markdown event notifications. When setting the
email address, input must be in the format
mailto://youremailaddress@yoursite.com (with the mailto://
prefix). The application has to subscribe to recieve these
events using the AlertEnable field.

MaxLength: Length of valid email ids

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'xs:anyURI'

=cut

sub setAlertEmail {
  my $self = shift;
  $self->{'AlertEmail'} = shift
}

=head2 getAlertEmail()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getAlertEmail {
  my $self = shift;
  return $self->{'AlertEmail'};
}


=head2 setAlertEnable()

A token indicating whether markup and markdown alerts are enabled or disabled.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:EnableCodeType'

=cut

sub setAlertEnable {
  my $self = shift;
  $self->{'AlertEnable'} = shift
}

=head2 getAlertEnable()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:EnableCodeType'

=cut

sub getAlertEnable {
  my $self = shift;
  return $self->{'AlertEnable'};
}


=head2 setApplicationEnable()

Indicates whether notifications and alerts are
enabled or disabled. If you disable notifications,
the application does not receive them, but notification
preferences are not erased.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:EnableCodeType'

=cut

sub setApplicationEnable {
  my $self = shift;
  $self->{'ApplicationEnable'} = shift
}

=head2 getApplicationEnable()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:EnableCodeType'

=cut

sub getApplicationEnable {
  my $self = shift;
  return $self->{'ApplicationEnable'};
}


=head2 setApplicationURL()

The URL where eBay delivers all notifications sent
to the application. For delivery to a server, the URL
begins with http:// or https:// and must be well
formed. Use a URL that is functional at the time of the
call. For delivery to an email address, the URL begins
with mailto: and specifies a valid email address.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'xs:anyURI'

=cut

sub setApplicationURL {
  my $self = shift;
  $self->{'ApplicationURL'} = shift
}

=head2 getApplicationURL()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getApplicationURL {
  my $self = shift;
  return $self->{'ApplicationURL'};
}


=head2 setDeliveryURLDetails()

Defines settings for a notification URL (including the URL name in DeliveryURLName).
You define settings for a notification URL (including the URL name in DeliveryURLName) in the
DeliveryURLDetails container. You associate a user token with a notification URL by using the token
in a SetNotificationPreferences request that specifies the URL name in
SetNotificationPreferencesRequest.DeliveryURLName.
If you associate a single user token to multiple URL names, each URL name overwrites
the previous name associated with the token. You can specify up to 10 notification URLs for an application.
Note that Notifications will not be sent to any URL(s) if
ApplicationDeliveryPreferencesType.ApplicationEnable is set to Disable.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:DeliveryURLDetailType'

=cut

sub setDeliveryURLDetails {
  my $self = shift;
  $self->{'DeliveryURLDetails'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDeliveryURLDetails()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:DeliveryURLDetailType'

=cut

sub getDeliveryURLDetails {
  my $self = shift;
  return $self->_getDataTypeArray('DeliveryURLDetails');
}


=head2 setDeviceType()

Do not test Client Alerts in production if you are currently using Platform Notifications.
The means of receipt of notification. In most cases, it is
Platform (typical API calls and web interaction), so this is the
default, if not specified. For wireless applications, use SMS.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:DeviceTypeCodeType'

=cut

sub setDeviceType {
  my $self = shift;
  $self->{'DeviceType'} = shift
}

=head2 getDeviceType()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:DeviceTypeCodeType'

=cut

sub getDeviceType {
  my $self = shift;
  return $self->{'DeviceType'};
}


=head2 setNotificationPayloadType()

If this field is specified, the value must be eBLSchemaSOAP.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:NotificationPayloadTypeCodeType'

=cut

sub setNotificationPayloadType {
  my $self = shift;
  $self->{'NotificationPayloadType'} = shift
}

=head2 getNotificationPayloadType()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:NotificationPayloadTypeCodeType'

=cut

sub getNotificationPayloadType {
  my $self = shift;
  return $self->{'NotificationPayloadType'};
}


=head2 setPayloadVersion()

If you are using SetNotificationPreferences, you can use the PayloadVersion
field to specify the API version for all notifications for the calling
application. If you are using GetNotificationPreferences, this field contains
the API version for all notifications for the calling application. If you do
not specify PayloadVersion in SetNotificationPreferences, the behavior of
notifications is the same as it was before the PayloadVersion field was added
to the schema. Before the PayloadVersion field was added to the schema, the
API version for notifications was based on the API version specified as part
of your SetNotificationPreferences call. Now, you can use PayloadVersion to
override the API version specified as part of your SetNotificationPreferences
call.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPayloadVersion {
  my $self = shift;
  $self->{'PayloadVersion'} = shift
}

=head2 getPayloadVersion()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getPayloadVersion {
  my $self = shift;
  return $self->{'PayloadVersion'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
