use strict;
use warnings;

use Test::More;
use Test::Exception;

use GDPR::IAB::TCFv2;

subtest
  "BUG index out of bounds on offset, see: https://github.com/peczenyj/GDPR-IAB-TCFv2/issues/20"
  => sub {
    my $consent;

    my $tc_string =
      'CP00b0AP00b0AAHABBENAbEsAP_AAH_AAAAAg1NX_G__bW9r8Xr3aft0eY1P99i77uQxBBXJE-4FyDvW_JwXx2EwJA26tqIKmRIEszZBIQFlHJHURVigSogVryHsYkGMgTNKJ6BkgFMRI2dYCExvmYtjeQKY5fp9d3fx2D-o_Nv83dzzz8lHn3d5P2UkcKCdQ58tDfntTRKb-5IOd-bcn4t08l_rk2fWRVn_pMtj7Beudl073XU61_AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEQaoZgACIAFAAXAA4AD4AKAAqABcADkAHgAgABIAC6AGAAZQA0ADUAHgAPwAiABHACYAFCAKQApgBVgC4ALoAYgAzABoADeAHoAPwAhABDQCIAIkARwAlgBNACcAFGAKUAYAAw4BlAGWANEAbIA5ABzwDuAO8AewA-IB9gH7AP8BAICDgIQAREAikBFgEYAI1ARwBHQCRAElAJSATsAn4BQYCoAKiAVcAsQBcwC6wF5AXoAvoBigDRAGvANoAbgA4gBxwDpAHUAO2Ae0A-wB_wETAIvAR7AkQCRQEqAJWATFAmQCZQE2gJ2AUPAo8CkQFJwKaApsBT4CoYFSAVKAqoBVgCuQFdgLCgWIBYoCygFogLUAWxAtwC3QFwALkAXQAu0Bd8C8gLzAX0Av8BggDBgGGgMQAYsAx4BkMDIwMkgZMBk4DKgGWAMzAZyAzwBokDRgNHAaaA1MBqsDVwNZAa8A2iBtwG3gNygboBuoDgAHBAOLAceA5OBywHLgOfAeKA8eB5IHlAPigfIB8oD6QH1wPtA-6B-wH7gQBAgIBAwCB4EEQIJgQYAg2BCECFAEK4IWghcBDECGcEOQQ6gh4CHoEPwIpgRgAjSBGsCN4EcQI6AR2Aj2BH0CP4EhAJFASNgkgCScEmASZglQCVIEsAJZwS3BLiCXQJdgS-AmABMMCYsEzATOAmoBNiCbYJuATeCDUAUSAAwABEGoMABgACINQoADAAEQaigAGAAIg1DgAMAARBqCAAYAAiDUQAAwABEGoQABgACINQwADAAEQaiwAGAAIg1AAA.f_gAD_gAAAAA';
    lives_ok {
        $consent = GDPR::IAB::TCFv2->Parse($tc_string);
    }
    'should not throw exception';

    isa_ok $consent, 'GDPR::IAB::TCFv2', 'gdpr iab tcf v2 consent';

    done_testing;
  };

done_testing;
