/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.views;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.couchbase.mock.JsonUtils;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class Configuration {
    final Map<String, String> optMap = new HashMap<String, String>();
    public static final String PARAM_ENDKEY = "endkey";
    public static final String PARAM_STARTKEY = "startkey";
    public static final String PARAM_ENDKEY_DOCID = "endkey_docid";
    public static final String PARAM_STARTKEY_DOCID = "startkey_docid";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_SKIP = "skip";
    public static final String PARAM_REDUCE = "reduce";
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_GROUP_LEVEL = "group_level";
    public static final String PARAM_KEY_SINGLE = "key";
    public static final String PARAM_KEY_MULTI = "keys";
    public static final String PARAM_INCLUSIVE_END = "inclusive_end";
    public static final String PARAM_INCLUSIVE_START = "inclusive_start";
    public static final String PARAM_DESCENDING = "descending";

    public Configuration() {
    }

    public Configuration(Map<String, String> params) {
        this.optMap.putAll(params);
    }

    public void setJson(String key, int number) {
        this.optMap.put(key, Integer.toString(number));
    }

    public void setJson(String key, String value) {
        this.optMap.put(key, new JsonPrimitive(value).toString());
    }

    public void setJson(String key, boolean value) {
        this.optMap.put(key, value ? "true" : "false");
    }

    public void setRaw(String key, String value) {
        this.optMap.put(key, value);
    }

    public void setDescending(boolean descending) {
        this.setJson(PARAM_DESCENDING, descending);
    }

    public void setEndKey(String endkey) {
        this.setJson(PARAM_ENDKEY, endkey);
    }

    public void setStartKey(String startkey) {
        this.setJson(PARAM_STARTKEY, startkey);
    }

    public void setStartKey(int startKey) {
        this.setJson(PARAM_STARTKEY, startKey);
    }

    public void setEndKey(int endKey) {
        this.setJson(PARAM_ENDKEY, endKey);
    }

    public void setGroup(boolean group) {
        this.setJson(PARAM_GROUP, group);
    }

    public void setGroupLevel(int group_level) {
        this.setJson(PARAM_GROUP_LEVEL, group_level);
    }

    public void setInclusiveEnd(boolean inclusive_end) {
        this.setJson(PARAM_INCLUSIVE_END, inclusive_end);
    }

    public void setKey(String key) {
        this.setJson(PARAM_KEY_SINGLE, key);
    }

    public void setEncodedKey(String key) {
        this.setRaw(PARAM_KEY_SINGLE, key);
    }

    public void setLimit(int limit) {
        this.setJson(PARAM_LIMIT, limit);
    }

    public void setReduce(boolean reduce) {
        this.setJson(PARAM_REDUCE, reduce);
    }

    public void setSkip(int skip) {
        this.setJson(PARAM_SKIP, skip);
    }

    public void setEncodedKeys(List<String> keys) {
        JsonArray decKeys = new JsonArray();
        for (String encKey : keys) {
            JsonElement decKey = JsonUtils.GSON.fromJson(encKey, JsonElement.class);
            decKeys.add(decKey);
        }
        this.setRaw(PARAM_KEY_MULTI, decKeys.toString());
    }

    NativeObject toNativeObject() {
        NativeObject obj = new NativeObject();
        for (Map.Entry<String, String> ent : this.optMap.entrySet()) {
            obj.put(ent.getKey(), (Scriptable)obj, (Object)ent.getValue());
        }
        return obj;
    }
}

