package Task::Map::Tube::Metro;

use strict;
use warnings;

our $VERSION = 0.13;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Map::Tube - Install the Map::Tube concrete metro modules.

=head1 SYNOPSIS

 cpanm Task::Map::Tube::Metro

=head1 SEE ALSO

=over

=item L<Map::Tube::Athens>

Map::Tube interface to the Athens Metro

=item L<Map::Tube::Barcelona>

Interface to the Barcelona Metro Map.

=item L<Map::Tube::Beijing>

Interface to the Beijing tube map

=item L<Map::Tube::Berlin>

Interface to the Berlin S- and U-Bahn map.

=item L<Map::Tube::Bielefeld>

interface to the Bielefeld Stadtbahn

=item L<Map::Tube::Bucharest>

Interface to the Bucharest Metro Map.

=item L<Map::Tube::Budapest>

Interface to the Budapest Metro Map.

=item L<Map::Tube::Copenhagen>

Interface to the Copenhagen Metro map

=item L<Map::Tube::Delhi>

Interface to the Delhi Metro Map.

=item L<Map::Tube::Dnipropetrovsk>

Interface to the Dnipropetrovsk Metro Map.

=item L<Map::Tube::Frankfurt>

interface to the Frankfurt S- and U-Bahn map

=item L<Map::Tube::Glasgow>

Interface to the Glasgow tube map

=item L<Map::Tube::Kazan>

Interface to the Kazan Metro Map.

=item L<Map::Tube::Kharkiv>

Interface to the Kharkiv Metro Map.

=item L<Map::Tube::Kiev>

Interface to the Kiev Metro Map.

=item L<Map::Tube::KoelnBonn>

Interface to the Koeln-Bonn U- and S-Bahn and tram maps.

=item L<Map::Tube::Kolkatta>

Interface to the Kolkatta Metro Map.

=item L<Map::Tube::KualaLumpur>

Interface to the KualaLumpur urban monorail system map.

=item L<Map::Tube::London>

Interface to the London Tube Map.

=item L<Map::Tube::Lyon>

Interface to the Lyon metro map.

=item L<Map::Tube::Madrid>

Interface to the Madrid Metro Map.

=item L<Map::Tube::Malaga>

Interface to the Málaga Metro Map.

=item L<Map::Tube::Milan>

Interface to the Milan tube map.

=item L<Map::Tube::Minsk>

Interface to the Minsk Metro Map.

=item L<Map::Tube::Moscow>

Interface to the Moscow Metro Map.

=item L<Map::Tube::NYC>

Interface to the NYC Subway Map.

=item L<Map::Tube::Nanjing>

Interface to the Nanjing Metro Map.

=item L<Map::Tube::Novosibirsk>

Interface to the Novosibirsk Metro Map.

=item L<Map::Tube::Nuremberg>

interface to the Nuremberg U-Bahn map

=item L<Map::Tube::Prague>

Interface to the Prague Metro Map.

=item L<Map::Tube::SaintPetersburg>

Interface to the Saint Petersburg Metro Map.

=item L<Map::Tube::Samara>

Interface to the Samara Metro Map.

=item L<Map::Tube::Singapore>

Interface to the Singapore Metro Map.

=item L<Map::Tube::Sofia>

Interface to the Sofia Metro Map.

=item L<Map::Tube::Tbilisi>

Interface to the Tbilisi Metro Map.

=item L<Map::Tube::Tokyo>

Interface to the Tokyo Subway Map.

=item L<Map::Tube::Vienna>

Interface to the Vienna U-Bahn Map.

=item L<Map::Tube::Warsaw>

Interface to the Warsaw Tube Map.

=item L<Map::Tube::Yekaterinburg>

Interface to the Yekaterinburg Metro Map.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Task-Map-Tube-Metro>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2015-2020 Michal Josef Špaček

Artistic License

BSD 2-Clause License

=head1 VERSION

0.13

=cut
