#!/usr/bin/perl -w

use strict;

use Test::More tests => 10;

BEGIN { use_ok("MPEG::Audio::Frame") }

{
	isa_ok(my $frame = MPEG::Audio::Frame->read(\*DATA), "MPEG::Audio::Frame");
	ok($frame->crc, "frame has CRC");
	ok(!$frame->broken, "CRC is good");
}

{
	isa_ok(my $frame = MPEG::Audio::Frame->read(\*DATA), "MPEG::Audio::Frame");
	ok($frame->crc, "same frame with garbled innards has CRC");
	ok($frame->broken, "CRC is bad");
}

{
	isa_ok(my $frame = MPEG::Audio::Frame->read(\*DATA), "MPEG::Audio::Frame");
	ok($frame->crc, "same frame with garbled innards has CRC");
	ok($frame->broken, "CRC is bad");
}

__DATA__
this data is the second frame from basic.t.

the first copy was left intact
the second has a garbled header
the third has garbled content

  ɊH&N  HH e"= 
jK    c :#f;+\o >5gbqO
P(%1s?&.A"69O'ly+a*r.W"S"PhOfPr.nE|n\.x
Si*oG@0 <No | Y8 	L\1da8ȟ,"9  ,"c0A
@Șx6Arό7 Pо_7p00
D=1sA%YhROA0=AE$afbI%EM$ffkRUUzUj[<L)}JU}ko<ԳZC#3[G2.lӠ55TseC4VUokhY4u0L<
(Fh"̰TB8ӵT4SS3C̔5Egh&ٗ.
|pюu-:[^RߨMme$MTP
y
:~]9&oRLPFP6]A>etMC#=3LsBphq\`YF
	0Ѐsh>!hBYt4b`Y(nQ&<

  aH&N  HH e"= 
jK    c :#f;+\o >5gbqO
P(%1s?&.A"69O'ly+a*r.W"S"PhOfPr.nE|n\.x
Si*oG@0 <No | Y8 	L\1da8ȟ,"9  ,"c0A
@Șx6Arό7 Pо_7p00
D=1sA%YhROA0=AE$afbI%EM$ffkRUUzUj[<L)}JU}ko<ԳZC#3[G2.lӠ55TseC4VUokhY4u0L<
(Fh"̰TB8ӵT4SS3C̔5Egh&ٗ.
|pюu-:[^RߨMme$MTP
y
:~]9&oRLPFP6]A>etMC#=3LsBphq\`YF
	0Ѐsh>!hBYt4b`Y(nQ&<

dgkuwj more ʬĩϫgarbage&&$Y n4bnoet


  ɊH&N  HH e"= 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
