# Generated by default/object.tt
package Paws::IoT::MetricToRetain;
  use Moose;
  has Metric => (is => 'ro', isa => 'Str', request_name => 'metric', traits => ['NameInRequest'], required => 1);
  has MetricDimension => (is => 'ro', isa => 'Paws::IoT::MetricDimension', request_name => 'metricDimension', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::MetricToRetain

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::MetricToRetain object:

  $service_obj->Method(Att1 => { Metric => $value, ..., MetricDimension => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::MetricToRetain object:

  $result = $service_obj->Method(...);
  $result->Att1->Metric

=head1 DESCRIPTION

The metric you want to retain. Dimensions are optional.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Metric => Str

What is measured by the behavior.


=head2 MetricDimension => L<Paws::IoT::MetricDimension>

The dimension of a metric. This can't be used with custom metrics.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

