.rn '' }`
''' $Header: a2p.man,v 1.0 87/12/18 17:23:56 root Exp $
''' 
''' $Log:	a2p.man,v $
''' Revision 1.0  87/12/18  17:23:56  root
''' Initial revision
''' 
''' 
.de Sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.tr \(bs-|\(bv\*(Tr
.ie n \{\
.ds -- \(bs-
.if (\n(.H=4u)&(1m=24u) .ds -- \(bs\h'-12u'\(bs\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(bs\h'-12u'\(bs\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
'br\}
.TH A2P 1 LOCAL
.SH NAME
a2p - Awk to Perl translator
.SH SYNOPSIS
.B a2p [options] filename
.SH DESCRIPTION
.I A2p
takes an awk script specified on the command line (or from standard input)
and produces a comparable
.I perl
script on the standard output.
.Sh "Options"
Options include:
.TP 5
.B \-D<number>
sets debugging flags.
.TP 5
.B \-F<character>
tells a2p that this awk script is always invoked with this -F switch.
.TP 5
.B \-n<fieldlist>
specifies the names of the input fields if input does not have to be split into
an array.
If you were translating an awk script that processes the password file, you
might say:
.sp
	a2p -7 -nlogin.password.uid.gid.gcos.shell.home
.sp
Any delimiter will do to separate the field names.
.TP 5
.B \-<number>
causes a2p to assume that input will always have that many fields.
.Sh "Considerations"
A2p cannot do as good a job translating as a human would, but it usually
does pretty well.
There are some areas where you may want to examine the perl script produced
and tweak it some.
Here are some of them, in no particular order.
.PP
The split operator in perl always strips off all null fields from the end.
Awk does NOT do this, if you've set FS.
If the perl script splits to an array, the field count may not reflect
what you expect.
Ordinarily this isn't a problem, since nonexistent array elements have a null
value, but if you rely on NF in awk, you could be in for trouble.
Either force the number of fields with \-<number>, or count the number of
delimiters another way, e.g. with y/:/:/.
Or add something non-null to the end before you split, and then pop it off
the resulting array.
.PP
There is an awk idiom of putting int() around a string expression to force
numeric interpretation, even though the argument is always integer anyway.
This is generally unneeded in perl, but a2p can't tell if the argument
is always going to be integer, so it leaves it in.
You may wish to remove it.
.PP
Perl differentiates numeric comparison from string comparison.
Awk has one operator for both that decides at run time which comparison
to do.
A2p does not try to do a complete job of awk emulation at this point.
Instead it guesses which one you want.
It's almost always right, but it can be spoofed.
All such guesses are marked with the comment \*(L"#???\*(R".
You should go through and check them.
.PP
Perl does not attempt to emulate the behavior of awk in which nonexistent
array elements spring into existence simply by being referenced.
If somehow you are relying on this mechanism to create null entries for
a subsequent for...in, they won't be there in perl.
.PP
If a2p makes a split line that assigns to a list of variables that looks
like (Fld1, Fld2, Fld3...) you may want
to rerun a2p using the \-n option mentioned above.
This will let you name the fields throughout the script.
If it splits to an array instead, the script is probably referring to the number
of fields somewhere.
.PP
The exit statement in awk doesn't necessarily exit; it goes to the END
block if there is one.
Awk scripts that do contortions within the END block to bypass the block under
such circumstances can be simplified by removing the conditional
in the END block and just exiting directly from the perl script.
.PP
Perl has two kinds of array, numerically-indexed and associative.
Awk arrays are usually translated to associative arrays, but if you happen
to know that the index is always going to be numeric you could change
the {...} to [...].
Iteration over an associative array is done with each(), but
iteration over a numeric array is NOT.
You need a for loop, or while loop with a pop() or shift(), so you might
need to modify any loop that is iterating over the array in question.
.PP
Arrays which have been split into are assumed to be numerically indexed.
The usual perl idiom for iterating over such arrays is to use pop() or shift()
and assign the resulting value to a variable inside the conditional of the
while loop.
This is destructive to the array, however, so a2p can't assume this is
reasonable.
A2p will write a standard for loop with a scratch variable.
You may wish to change it to a pop() loop for more efficiency, presuming
you don't want to keep the array around.
.PP
Awk starts by assuming OFMT has the value %.6g.
Perl starts by assuming its equivalent, $#, to have the value %.20g.
You'll want to set $# explicitly if you use the default value of OFMT.
.PP
Near the top of the line loop will be the split operation that is implicit in
the awk script.
There are times when you can move this down past some conditionals that
test the entire record so that the split is not done as often.
.PP
There may occasionally be extra parentheses that you can remove.
.PP
For aesthetic reasons you may wish to change the array base $[ from 1 back
to the default of 0, but remember to change all array subscripts AND
all substr() and index() operations to match.
.PP
Cute comments that say "# Here is a workaround because awk is dumb" are not
translated.
.PP
Awk scripts are often embedded in a shell script that pipes stuff into and
out of awk.
Often the shell script wrapper can be incorporated into the perl script, since
perl can start up pipes into and out of itself, and can do other things that
awk can't do by itself.
.SH ENVIRONMENT
A2p uses no environment variables.
.SH AUTHOR
Larry Wall <lwall@devvax.Jpl.Nasa.Gov>
.SH FILES
.SH SEE ALSO
perl	The perl compiler/interpreter
.br
s2p	sed to perl translator
.SH DIAGNOSTICS
.SH BUGS
It would be possible to emulate awk's behavior in selecting string versus
numeric operations at run time by inspection of the operands, but it would
be gross and inefficient.
Besides, a2p almost always guesses right.
.PP
Storage for the awk syntax tree is currently static, and can run out.
.rn }` ''
