/* ------------------------------------------------------------------------
@NAME       : traversal.c
@DESCRIPTION: Routines for traversing the AST for a single entry.
@GLOBALS    : 
@CALLS      : 
@CREATED    : 1997/01/21, Greg Ward
@MODIFIED   : 
@VERSION    : $Id: traversal.c,v 1.2 1997/02/16 18:00:04 greg Exp $
-------------------------------------------------------------------------- */
#include <stdlib.h>
#include "btparse.h"
#include "prototypes.h"

#define DEBUG 0


char *nodetype_names[] = 
{
   "entry", "macrodef", "text", "key", "field", "string", "number", "macro"
};


char *bt_get_type (AST *top, nodetype_t *nodetype)
{
   if (!top) return NULL;

   if (nodetype) *nodetype = top->nodetype;
   return top->text;
}


char *bt_get_key (AST *top)
{
   if (!top || !top->down || top->down->nodetype != AST_KEY)
      return NULL;

   return top->down->text;
}


AST  *bt_first_field (AST *top, char **name, AST **vals)
{
   AST  *field;

   if (!top || !top->down) return NULL; /* protect against empty entry */

   field = top->down;
   if (field->nodetype == AST_KEY) field = field->right;
   if (!field) return NULL;             /* protect against field-less entry */

#if DEBUG > 1
   dump_ast ("bt_first_field: field =\n", field);
#endif

   if (name) *name = field->text;
   if (vals) *vals = field->down;
   return field;
}


AST  *bt_next_field (AST *prev, char **name, AST **vals) 
{
   AST  *field;

   if (!prev) return NULL;
   field = prev->right;
   if (!field) return NULL;

   if (name) *name = field->text;
   if (vals) *vals = field->down;
   return field;
}


AST  *bt_first_item (AST *head, nodetype_t *nodetype, char **text)
{
   if (!head) return NULL;

#if DEBUG > 1
   dump_ast ("bt_first_item: head =\n", head);
#endif

   if (nodetype) *nodetype = head->nodetype;
   if (text) *text = head->text;
   return head;
}


AST  *bt_next_item  (AST *prev, nodetype_t *nodetype, char **text)
{
   AST  *item;

   if (!prev) return NULL;
   item = prev->right;
   if (!item) return NULL;

   if (nodetype) *nodetype = item->nodetype;
   if (text) *text = item->text;
   return item;
}


char *bt_value (AST *field)
{
                                        /* options for full processing: */
                                        /* delete quotes, expand macros, */
                                        /* past strings, collapse whitespace */
   static bt_options_t pp_options = { 0, 1, 1, 1, 1 };
#if DEBUG
   char   *value;

   dump_ast ("bt_value (pre): field =\n", field);
   value = postprocess_field (field, &pp_options, 0);
   dump_ast ("bt_value (post): field =\n", field);
   return value;
#else
   return postprocess_field (field, &pp_options, 0);
#endif
}


static void dump (AST *root, int depth)
{
   AST  *cur;

   if (root == NULL)
   {
      printf ("[empty]\n");
      return;
   }

   cur = root;
   while (cur != NULL)
   {
      printf ("%*s[%s]", 2*depth, "", nodetype_names[cur->nodetype]);
      if (cur->text != NULL)
         printf (": %p (%s)", cur->text, cur->text);
      printf ("\n");
      if (cur->down != NULL)
         dump (cur->down, depth+1);
      cur = cur->right;   
   }
}      


void dump_ast (char *msg, AST *root)
{
   if (msg != NULL)
      printf (msg);
   dump (root, 0);
   printf ("\n");
}
