# Generated by default/object.tt
package Paws::FMS::ProtocolsListDataSummary;
  use Moose;
  has ListArn => (is => 'ro', isa => 'Str');
  has ListId => (is => 'ro', isa => 'Str');
  has ListName => (is => 'ro', isa => 'Str');
  has ProtocolsList => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::ProtocolsListDataSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::ProtocolsListDataSummary object:

  $service_obj->Method(Att1 => { ListArn => $value, ..., ProtocolsList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::ProtocolsListDataSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ListArn

=head1 DESCRIPTION

Details of the AWS Firewall Manager protocols list.

=head1 ATTRIBUTES


=head2 ListArn => Str

The Amazon Resource Name (ARN) of the specified protocols list.


=head2 ListId => Str

The ID of the specified protocols list.


=head2 ListName => Str

The name of the specified protocols list.


=head2 ProtocolsList => ArrayRef[Str|Undef]

An array of protocols in the AWS Firewall Manager protocols list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

