use 5.008001;
use strict;
use warnings;
use Test::More 0.96;
use Test::Fatal;

use File::pushd qw/tempd/;
use Path::Tiny;

use Test::DZil;

my $corpus = path('corpus/DZ1')->absolute;
my $wd     = tempd;

subtest 'defaults' => sub {
    my $tzil = Builder->from_config(
        { dist_root => $corpus },
        {
            add_files => {
                'source/dist.ini' =>
                  simple_ini(qw(GatherDir MakeMaker CopyFilesFromBuild::Filtered)),
            },
        },
    );

    ok( $tzil->build,                                   "dist built" );
    ok( !-e $tzil->tempdir->file('source/Makefile.PL'), "no Makefile.PL copied" );
};

subtest 'copy Makefile.PL' => sub {
    my $tzil = Builder->from_config(
        { dist_root => $corpus },
        {
            add_files => {
                'source/dist.ini' => simple_ini(
                    qw(GatherDir MakeMaker),
                    [ 'CopyFilesFromBuild::Filtered', { copy => 'Makefile.PL' } ]
                ),
            },
        },
    );

    ok( $tzil->build,                                  "dist built" );
    ok( -e $tzil->tempdir->file('source/Makefile.PL'), "Makefile.PL copied" );
    my $guts = $tzil->slurp_file('source/Makefile.PL');
    unlike( $guts, qr/^#.*(generated by).*$/m, "no 'generated by' line found" );
};

subtest 'copy README and Makefile.PL' => sub {
    my $tzil = Builder->from_config(
        { dist_root => $corpus },
        {
            add_files => {
                'source/dist.ini' => simple_ini(
                    qw(GatherDir MakeMaker Readme),
                    [ 'CopyFilesFromBuild::Filtered', { copy => [ 'Makefile.PL', 'README' ] } ]
                ),
            },
        },
    );

    ok( $tzil->build,                                  "dist built" );
    ok( -e $tzil->tempdir->file('source/Makefile.PL'), "Makefile.PL copied" );
    ok( -e $tzil->tempdir->file('source/README'),      "README copied" );
};

done_testing;
#
# This file is part of Dist-Zilla-Plugin-CopyFilesFromBuild-Filtered
#
# This software is Copyright (c) 2015 by David Golden.
#
# This is free software, licensed under:
#
#   The Apache License, Version 2.0, January 2004
#
# vim: set ts=4 sts=4 sw=4 et tw=75:
