use Test::More;

{
	package Have::Fun;

	use Moo;
	use Coerce::Types::Standard qw/ArrayToHash/;
	use MooX::LazierAttributes;

	attributes (
		[qw/thing/] => [ArrayToHash, { coerce => 1 }],
		[qw/another/] => [ArrayToHash, { coerce => 1 }],
		[qw/test/] => [ArrayToHash, { coerce => 1 }]
	);
}

use Have::Fun;
my $thing = Have::Fun->new( thing => [qw/red bull/], another => [qw/new day/], test => [qw/one two three four/]);
is_deeply($thing->thing, {red => 'bull'});

is_deeply($thing->another, {new => 'day'});

is_deeply($thing->test, {one => 'two', three => 'four'});

done_testing();
