#ifndef MARPAESLIF_JSONTESTERNOTSTRICTEXTERNAL_H
#define MARPAESLIF_JSONTESTERNOTSTRICTEXTERNAL_H

static const char *grammars =
  "# --------------------------------------------------\n"
  "# Meta settings\n"
  "# --------------------------------------------------\n"
  ":desc              ::= 'Strict JSON Grammar'\n"
  ":default           ::= action => ::shift fallback-encoding => UTF-8 discard-is-fallback => 1\n"
  "\n"
  "# -----------------------------------------------------------\n"
  "# Discard unsignificant whitespaces, Perl comment C++ comment\n"
  "# -----------------------------------------------------------\n"
  ":discard           ::= /[\\x{9}\\x{A}\\x{D}\\x{20}]+|#[^\\n]*|\\/\\/[^\\n]*|\\/\\*(?:(?:[^\\*]+|\\*(?!\\/))*)\\*\\//u\n"
  "\n"
  "#\n"
  "# ---------------\n"
  "# Terminal events\n"
  "# ---------------\n"
  ":symbol ::= '\"' pause => after event => :discard[switch]\n"
  "\n"
  "# ----------\n"
  "# JSON value\n"
  "# ----------\n"
  "value               ::= object\n"
  "                      | array\n"
  "                      | string\n"
  "                      | constant\n"
  "                      | number\n"
  "\n"
  "# ---------\n"
  "# Separator\n"
  "# ---------\n"
  "comma              ::= ','\n"
  "commas             ::= comma+\n"
  "# -----------\n"
  "# JSON object\n"
  "# -----------\n"
  "object              ::= (-'{'-) members (-'}'-)\n"
  "members             ::= member*                      action         => ::lua->members\n"
  "                                                     separator      => commas\n"
  "                                                     proper         => 0\n"
  "                                                     hide-separator => 1\n"
  "member              ::= string (-':'-) value         action         => ::row\n"
  "\n"
  "# ----------\n"
  "# JSON Array\n"
  "# ----------\n"
  "array               ::= (-'['-) elements (-']'-)\n"
  "elements            ::= value*                       action         => ::row\n"
  "                                                     separator      => commas\n"
  "                                                     proper         => 0\n"
  "                                                     hide-separator => 1\n"
  "\n"
  "# -----------\n"
  "# JSON String\n"
  "# -----------\n"
  "string              ::= (-'\"'-) string_parts (-'\"'-)\n"
  "string_parts        ::= string_part*                 action         => ::concat\n"
  "string_part         ::= string_ascii_part\n"
  "                      | string_escape_part           \n"
  "                      | string_unicode_part          \n"
  "string_ascii_part   ::= /[^\"\\\\]+/u\n"
  "string_escape_part  ::= /(?:\\\\[\"\\\\\\/bfnrt])+/u action         => ::lua->string_escape_part\n"
  "string_unicode_part ::= /(?:\\\\u[[:xdigit:]]{4})+/u action         => ::lua->string_unicode_part\n"
  "\n"
  "\n"
  "# -------------\n"
  "# JSON constant\n"
  "# -------------\n"
  "constant ::= 'true':i                                action         => ::true\n"
  "           | 'false':i                               action         => ::false\n"
  "           | 'null':i                                action         => ::undef\n"
  "                     \n"
  "\n"
  "# -----------\n"
  "# JSON number\n"
  "# -----------\n"
  "number ::= /(?:[+-]?(?:[0-9]+)(?:\\.[0-9]+)?(?:E[+-]?[0-9]+)?)|(?:\\+?Inf(?:inity)?)|(?:-?Inf(?:inity)?)|(?:\\+?NaN)|(?:-?NaN)/i action => ::lua->number\n"
  "\n"
  "<luascript>\n"
  "local NAN  =  0.0 / 0.0\n"
  "local NINF = -math.huge\n"
  "local PINF =  math.huge\n"
  "function members(...)\n"
  "  local output = niledtablekv()\n"
  "  if arg ~= nil then\n"
  "    for n=1,select('#',...) do\n"
  "      local member = select(n, ...)\n"
  "      output[member[1]] = member[2]\n"
  "    end\n"
  "  end\n"
  "  return output\n"
  "end\n"
  "\n"
  "function string_escape_part(input)\n"
  "  local c = input:sub(2, 2) -- get second character\n"
  "  if     c == '\"'  then return c\n"
  "  elseif c == '\\\\' then return c\n"
  "  elseif c == '/'  then return c\n"
  "  elseif c == 'b'  then return '\\b'\n"
  "  elseif c == 'f'  then return '\\f'\n"
  "  elseif c == 'n'  then return '\\n'\n"
  "  elseif c == 'r'  then return '\\r'\n"
  "  elseif c == 't'  then return '\\t'\n"
  "  else   error('Unsupported escaped character '..c)\n"
  "  end\n"
  "end\n"
  "\n"
  "function string_unicode_part(input)\n"
  "  local stringtable = {}\n"
  "  local uint32 = {}\n"
  "  local p = 1\n"
  "  local pmax = input:len()\n"
  "  while p <= pmax do\n"
  "    local u = input:sub(p+2, p + 5)\n"
  "    uint32[#uint32+1] = tonumber('0x'..u)\n"
  "    p = p + 6\n"
  "  end\n"
  "  local j = 2\n"
  "  for i = 1, #uint32 do\n"
  "    local u = uint32[i]\n"
  "    if ((j <= #uint32) and (u >= 0xD800) and (u <= 0xDBFF) and (uint32[j] >= 0xDC00) and (uint32[j] <= 0xDFFF)) then\n"
  "      -- Surrogate UTF-16 pair\n"
  "      u = 0x10000 + ((u & 0x3FF) << 10) + (uint32[j] & 0x3FF)\n"
  "      i = i + 1\n"
  "      j = j + 1\n"
  "    end\n"
  "    if ((u >= 0xD800) and (u <= 0xDFFF)) then\n"
  "      u = 0xFFFD -- Replacement character\n"
  "    end\n"
  "    c = utf8.char(u)\n"
  "    stringtable[#stringtable + 1] = c\n"
  "  end\n"
  "  return table.concat(stringtable)\n"
  "end\n"
  "function number(input)\n"
  "  local neg = false\n"
  "  local c = input:sub(1, 1) -- get first character\n"
  "  if c == '-' then\n"
  "    neg = true\n"
  "    c = input:sub(2, 2) -- get second character\n"
  "  end\n"
  "  if     c == 'i' or c == 'I' then\n"
  "    if neg then\n"
  "      output = NINF\n"
  "    else\n"
  "      output = PINF\n"
  "    end\n"
  "  elseif c == 'n' or c == 'N' then output = NAN\n"
  "  else output = tonumber(input)\n"
  "  end\n"
  "  return output\n"
  "end\n"
  "\n"
  "</luascript>\n"
  ;

#endif /* MARPAESLIF_JSONTESTERNOTSTRICTEXTERNAL_H */
