# Generated by default/object.tt
package Paws::Macie2::BucketCountBySharedAccessType;
  use Moose;
  has External => (is => 'ro', isa => 'Int', request_name => 'external', traits => ['NameInRequest']);
  has Internal => (is => 'ro', isa => 'Int', request_name => 'internal', traits => ['NameInRequest']);
  has NotShared => (is => 'ro', isa => 'Int', request_name => 'notShared', traits => ['NameInRequest']);
  has Unknown => (is => 'ro', isa => 'Int', request_name => 'unknown', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::BucketCountBySharedAccessType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::BucketCountBySharedAccessType object:

  $service_obj->Method(Att1 => { External => $value, ..., Unknown => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::BucketCountBySharedAccessType object:

  $result = $service_obj->Method(...);
  $result->Att1->External

=head1 DESCRIPTION

Provides information about the number of S3 buckets that are or aren't
shared with other Amazon Web Services accounts.

=head1 ATTRIBUTES


=head2 External => Int

The total number of buckets that are shared with an Amazon Web Services
account that isn't part of the same Amazon Macie organization.


=head2 Internal => Int

The total number of buckets that are shared with an Amazon Web Services
account that's part of the same Amazon Macie organization.


=head2 NotShared => Int

The total number of buckets that aren't shared with other Amazon Web
Services accounts.


=head2 Unknown => Int

The total number of buckets that Amazon Macie wasn't able to evaluate
shared access settings for. Macie can't determine whether these buckets
are shared with other Amazon Web Services accounts.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

