/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.EquivalenceClassEval;
import edu.stanford.nlp.stats.EquivalenceClasser;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Sets;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceClassEval<IN, OUT> {
    protected boolean bagEval = false;
    public static final EquivalenceClasser NULL_EQUIVALENCE_CLASSER = new EquivalenceClasser(){

        public Object equivalenceClass(Object o) {
            return null;
        }
    };
    private boolean verbose = false;
    EquivalenceClasser<IN, OUT> eq;
    Eval.CollectionContainsChecker<IN> checker;
    String summaryName;
    ClassicCounter<OUT> guessed = new ClassicCounter();
    ClassicCounter<OUT> guessedCorrect = new ClassicCounter();
    ClassicCounter<OUT> gold = new ClassicCounter();
    ClassicCounter<OUT> goldCorrect = new ClassicCounter();
    private ClassicCounter<OUT> lastPrecision = new ClassicCounter();
    private ClassicCounter<OUT> lastRecall = new ClassicCounter();
    private ClassicCounter<OUT> lastF1 = new ClassicCounter();
    private ClassicCounter<OUT> previousGuessed;
    private ClassicCounter<OUT> previousGuessedCorrect;
    private ClassicCounter<OUT> previousGold;
    private ClassicCounter<OUT> previousGoldCorrect;
    private static NumberFormat numberFormat = NumberFormat.getNumberInstance();
    public static final EqualityChecker DEFAULT_CHECKER = new EqualityChecker(){

        public boolean areEqual(Object o1, Object o2) {
            return o1.equals(o2);
        }
    };

    public void setBagEval(boolean bagEval) {
        this.bagEval = bagEval;
    }

    public static final <T, U> EquivalenceClasser<T, U> nullEquivalenceClasser() {
        return (EquivalenceClasser)ErasureUtils.uncheckedCast(NULL_EQUIVALENCE_CLASSER);
    }

    public EquivalenceClassEval() {
        this(EquivalenceClassEval.nullEquivalenceClasser());
    }

    public EquivalenceClassEval(EquivalenceClasser<IN, OUT> eq) {
        this(eq, "");
    }

    public EquivalenceClassEval(EqualityChecker<IN> e) {
        this(EquivalenceClassEval.nullEquivalenceClasser(), e);
    }

    public EquivalenceClassEval(EquivalenceClasser<IN, OUT> eq, String name) {
        this(eq, EquivalenceClassEval.defaultChecker(), name);
    }

    public EquivalenceClassEval(EquivalenceClasser<IN, OUT> eq, EqualityChecker<IN> e) {
        this(eq, e, "");
    }

    public EquivalenceClassEval(EquivalenceClasser<IN, OUT> eq, EqualityChecker<IN> e, String summaryName) {
        this(eq, new Eval.CollectionContainsChecker<IN>(e), summaryName);
    }

    EquivalenceClassEval(EquivalenceClasser<IN, OUT> eq, Eval.CollectionContainsChecker<IN> checker, String summaryName) {
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setMinimumFractionDigits(4);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(1);
        this.eq = eq;
        this.checker = checker;
        this.summaryName = summaryName;
    }

    public void eval(Collection<IN> guesses, Collection<IN> golds) {
        this.eval(guesses, golds, new PrintWriter(System.out, true));
    }

    public void eval(Collection<IN> guesses, Collection<IN> golds, PrintWriter pw) {
        if (this.verbose) {
            System.out.println("evaluating precision...");
        }
        Pair<ClassicCounter<OUT>, ClassicCounter<OUT>> precision = this.evalPrecision(guesses, golds);
        this.previousGuessed = precision.first();
        Counters.addInPlace(this.guessed, this.previousGuessed);
        this.previousGuessedCorrect = precision.second();
        Counters.addInPlace(this.guessedCorrect, this.previousGuessedCorrect);
        if (this.verbose) {
            System.out.println("evaluating recall...");
        }
        Pair<ClassicCounter<OUT>, ClassicCounter<OUT>> recall = this.evalPrecision(golds, guesses);
        this.previousGold = recall.first();
        Counters.addInPlace(this.gold, this.previousGold);
        this.previousGoldCorrect = recall.second();
        Counters.addInPlace(this.goldCorrect, this.previousGoldCorrect);
    }

    Pair<ClassicCounter<OUT>, ClassicCounter<OUT>> evalPrecision(Collection<IN> guesses, Collection<IN> golds) {
        AbstractCollection internalGuesses = null;
        AbstractCollection internalGolds = null;
        if (this.bagEval) {
            internalGuesses = new ArrayList(guesses.size());
            internalGolds = new ArrayList(golds.size());
        } else {
            internalGuesses = new HashSet(guesses.size());
            internalGolds = new HashSet(golds.size());
        }
        internalGuesses.addAll(guesses);
        internalGolds.addAll(golds);
        ClassicCounter<OUT> thisGuessed = new ClassicCounter<OUT>();
        ClassicCounter<OUT> thisCorrect = new ClassicCounter<OUT>();
        for (Object o : internalGuesses) {
            OUT equivalenceClass = this.eq.equivalenceClass(o);
            thisGuessed.incrementCount(equivalenceClass);
            if (this.checker.contained(o, internalGolds)) {
                thisCorrect.incrementCount(equivalenceClass);
                EquivalenceClassEval.removeItem(o, internalGolds, this.checker);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("Eval missed " + o);
        }
        return Generics.newPair(thisGuessed, thisCorrect);
    }

    protected static <T> void removeItem(T o, Collection<T> c, Eval.CollectionContainsChecker<T> checker) {
        for (T o1 : c) {
            if (!checker.contained(o, Collections.singleton(o1))) continue;
            c.remove(o1);
            return;
        }
    }

    public void display() {
        this.display(new PrintWriter(System.out, true));
    }

    public void display(PrintWriter pw) {
        pw.println("*********Final " + this.summaryName + " eval stats by antecedent category***********");
        HashSet<OUT> keys = new HashSet<OUT>();
        keys.addAll(this.guessed.keySet());
        keys.addAll(this.gold.keySet());
        this.displayHelper(keys, pw, this.guessed, this.guessedCorrect, this.gold, this.goldCorrect);
        pw.println("Finished final " + this.summaryName + " eval stats.");
    }

    public void displayLast() {
        this.displayLast(new PrintWriter(System.out, true));
    }

    public void displayLast(PrintWriter pw) {
        HashSet<OUT> keys = new HashSet<OUT>();
        keys.addAll(this.previousGuessed.keySet());
        keys.addAll(this.previousGold.keySet());
        this.displayHelper(keys, pw, this.previousGuessed, this.previousGuessedCorrect, this.previousGold, this.previousGoldCorrect);
    }

    public double precision(OUT key) {
        return this.percentage(key, this.guessed, this.guessedCorrect);
    }

    public double recall(OUT key) {
        return this.percentage(key, this.gold, this.goldCorrect);
    }

    public double lastPrecision(OUT key) {
        return this.percentage(key, this.previousGuessed, this.previousGuessedCorrect);
    }

    public ClassicCounter<OUT> lastPrecision() {
        ClassicCounter result = new ClassicCounter();
        Counters.addInPlace(result, this.previousGuessedCorrect);
        Counters.divideInPlace(result, this.previousGuessed);
        return result;
    }

    public double lastRecall(OUT key) {
        return this.percentage(key, this.previousGold, this.previousGoldCorrect);
    }

    public ClassicCounter<OUT> lastRecall() {
        ClassicCounter result = new ClassicCounter();
        Counters.addInPlace(result, this.previousGoldCorrect);
        Counters.divideInPlace(result, this.previousGold);
        return result;
    }

    public double lastNumGuessed(OUT key) {
        return this.previousGuessed.getCount(key);
    }

    public ClassicCounter<OUT> lastNumGuessed() {
        return this.previousGuessed;
    }

    public ClassicCounter<OUT> lastNumGuessedCorrect() {
        return this.previousGuessedCorrect;
    }

    public double lastNumGolds(OUT key) {
        return this.previousGold.getCount(key);
    }

    public ClassicCounter<OUT> lastNumGolds() {
        return this.previousGold;
    }

    public ClassicCounter<OUT> lastNumGoldsCorrect() {
        return this.previousGoldCorrect;
    }

    public double f1(OUT key) {
        return EquivalenceClassEval.f1(this.precision(key), this.recall(key));
    }

    public double lastF1(OUT key) {
        return EquivalenceClassEval.f1(this.lastPrecision(key), this.lastRecall(key));
    }

    public ClassicCounter<OUT> lastF1() {
        ClassicCounter<OUT> result = new ClassicCounter<OUT>();
        Set<OUT> keys = Sets.union(this.previousGuessed.keySet(), this.previousGold.keySet());
        for (OUT key : keys) {
            result.setCount(key, this.lastF1(key));
        }
        return result;
    }

    public static double f1(double precision, double recall) {
        return precision == 0.0 || recall == 0.0 ? 0.0 : 2.0 * precision * recall / (precision + recall);
    }

    public static <E> Counter<E> f1(Counter<E> precision, Counter<E> recall) {
        Counter<E> result = precision.getFactory().create();
        for (E key : Sets.intersection(precision.keySet(), recall.keySet())) {
            result.setCount(key, EquivalenceClassEval.f1(precision.getCount(key), recall.getCount(key)));
        }
        return result;
    }

    private double percentage(OUT key, ClassicCounter<OUT> guessed, ClassicCounter<OUT> guessedCorrect) {
        double thisGuessed = guessed.getCount(key);
        double thisGuessedCorrect = guessedCorrect.getCount(key);
        return thisGuessed == 0.0 ? 0.0 : thisGuessedCorrect / thisGuessed;
    }

    private void displayHelper(Set<OUT> keys, PrintWriter pw, ClassicCounter<OUT> guessed, ClassicCounter<OUT> guessedCorrect, ClassicCounter<OUT> gold, ClassicCounter<OUT> goldCorrect) {
        Map<OUT, String> pads = EquivalenceClassEval.getPads(keys);
        for (OUT key : keys) {
            double thisGuessed = guessed.getCount(key);
            double thisGuessedCorrect = guessedCorrect.getCount(key);
            double precision = thisGuessed == 0.0 ? 0.0 : thisGuessedCorrect / thisGuessed;
            this.lastPrecision.setCount(key, precision);
            double thisGold = gold.getCount(key);
            double thisGoldCorrect = goldCorrect.getCount(key);
            double recall = thisGold == 0.0 ? 0.0 : thisGoldCorrect / thisGold;
            this.lastRecall.setCount(key, recall);
            double f1 = EquivalenceClassEval.f1(precision, recall);
            this.lastF1.setCount(key, f1);
            String pad = pads.get(key);
            pw.println(key + pad + "\t" + "P: " + EquivalenceClassEval.formatNumber(precision) + "\ton " + EquivalenceClassEval.formatCount(thisGuessed) + " objects\tR: " + EquivalenceClassEval.formatNumber(recall) + "\ton " + EquivalenceClassEval.formatCount(thisGold) + " objects\tF1: " + EquivalenceClassEval.formatNumber(f1));
        }
    }

    private static String formatNumber(double d) {
        return numberFormat.format(d);
    }

    private static int formatCount(double d) {
        return (int)Math.round(d);
    }

    private static <OUT> Map<OUT, String> getPads(Set<OUT> keys) {
        String keyString;
        HashMap<OUT, String> pads = new HashMap<OUT, String>();
        int max = 0;
        for (OUT key : keys) {
            keyString = key == null ? "null" : key.toString();
            if (keyString.length() <= max) continue;
            max = keyString.length();
        }
        for (OUT key : keys) {
            keyString = key == null ? "null" : key.toString();
            int diff = max - keyString.length();
            String pad = "";
            for (int j = 0; j < diff; ++j) {
                pad = pad + " ";
            }
            pads.put(key, pad);
        }
        return pads;
    }

    public static void main(String[] args) {
        final Pattern p = Pattern.compile("^([^:]*):(.*)$");
        List<String> guesses = Arrays.asList("S:a", "S:b", "VP:c", "VP:d", "S:a");
        List<String> golds = Arrays.asList("S:a", "S:b", "S:b", "VP:d", "VP:a");
        EqualityChecker<String> e = new EqualityChecker<String>(){

            @Override
            public boolean areEqual(String o1, String o2) {
                Matcher m1 = p.matcher(o1);
                m1.find();
                String s1 = m1.group(2);
                System.out.println(s1);
                Matcher m2 = p.matcher(o2);
                m2.find();
                String s2 = m2.group(2);
                System.out.println(s2);
                return s1.equals(s2);
            }
        };
        EquivalenceClasser<String, String> eq = new EquivalenceClasser<String, String>(){

            @Override
            public String equivalenceClass(String o) {
                Matcher m = p.matcher(o);
                m.find();
                return m.group(1);
            }
        };
        EquivalenceClassEval<String, String> eval = new EquivalenceClassEval<String, String>(eq, e, "testing");
        eval.setBagEval(false);
        eval.eval(guesses, golds);
        eval.displayLast();
        eval.display();
    }

    public static final <T> EqualityChecker<T> defaultChecker() {
        return DEFAULT_CHECKER;
    }

    public Factory<IN, OUT> factory() {
        return new Factory<IN, OUT>(){
            boolean bagEval1;
            EquivalenceClasser<IN, OUT> eq1;
            Eval.CollectionContainsChecker<IN> checker1;
            String summaryName1;
            {
                this.bagEval1 = EquivalenceClassEval.this.bagEval;
                this.eq1 = EquivalenceClassEval.this.eq;
                this.checker1 = EquivalenceClassEval.this.checker;
                this.summaryName1 = EquivalenceClassEval.this.summaryName;
            }

            @Override
            public EquivalenceClassEval<IN, OUT> equivalenceClassEval() {
                EquivalenceClassEval e = new EquivalenceClassEval(this.eq1, this.checker1, this.summaryName1);
                e.setBagEval(this.bagEval1);
                return e;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<IN, OUT> {
        public EquivalenceClassEval<IN, OUT> equivalenceClassEval();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EqualityChecker<T> {
        public boolean areEqual(T var1, T var2);
    }
}

