###############################################################################
#
# Tests the output of Excel::Writer::XLSX against Excel generated files.
#
# Copyright 2000-2021, John McNamara, jmcnamara@cpan.org
#

use lib 't/lib';
use TestFunctions qw(_compare_xlsx_files _is_deep_diff);
use strict;
use warnings;

use Test::More tests => 1;

###############################################################################
#
# Tests setup.
#
my $filename     = 'cond_format04.xlsx';
my $dir          = 't/regression/';
my $got_filename = $dir . "ewx13_$filename";
my $exp_filename = $dir . 'xlsx_files/' . $filename;

my $ignore_members  = [];
my $ignore_elements = { 'xl/workbook.xml' => ['<workbookView'], };


###############################################################################
#
# Test the creation of a simple Excel::Writer::XLSX file with conditional
# formatting.
#
use Excel::Writer::XLSX;

my $workbook  = Excel::Writer::XLSX->new( $got_filename );
my $worksheet = $workbook->add_worksheet();

# We manually set the indices to get the same order as the target file.
my $format1 = $workbook->add_format( num_format => 2,       dxf_index => 1 );
my $format2 = $workbook->add_format( num_format => '0.000', dxf_index => 0 );

$worksheet->write( 'A1', 10 );
$worksheet->write( 'A2', 20 );
$worksheet->write( 'A3', 30 );
$worksheet->write( 'A4', 40 );

my $options = {
    type     => 'cell',
    format   => $format1,
    criteria => '>',
    value    => 2,
};

$worksheet->conditional_formatting( 'A1', $options );

# Test re-using options, issue #79.
$options->{criteria} = '<';
$options->{value}    = 8;
$options->{format}   = $format2;

$worksheet->conditional_formatting( 'A2', $options);


$workbook->close();


###############################################################################
#
# Compare the generated and existing Excel files.
#

my ( $got, $expected, $caption ) = _compare_xlsx_files(

    $got_filename,
    $exp_filename,
    $ignore_members,
    $ignore_elements,
);

_is_deep_diff( $got, $expected, $caption );


###############################################################################
#
# Cleanup.
#
unlink $got_filename;

__END__



