/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* psets.c
**/


#include "pfile.h"

static Value *VAcce (ParamFile pfile,
		     Parameter * p, VType type, Value * value);

static Converter Converters[] = {
  {StringType, PSetType, (ConverterType) StringCopy},
  {0, 0, NULL}
};


vtype psetRec = {
  "pset", Converters, SSSize, VAcce, (vtype_compar_func) SSComp
};


static Value *
VAcce (ParamFile pfile, Parameter *p, VType type, Value *value)
{
  void *converted;

  if (type == 0)
    return NULL;
  if (value == NULL)
    return NULL;

  VDirect (pfile, p, value);

  if (value->value == NULL || *((char *) value->value) == '\0')
    {
      if (value == &p->pmin || value == &p->pmax)
	return NULL;
      else
	converted = p->pname;
    }
  else
    {
      if (value->type == type)
	return value;
      else if ((converted = VConvert (value, NULL, type)) == NULL)
	return NULL;
    }

  return VNewValue (value, converted, type);
}
