#include "test.h"

#define TEST(name) TEST_CASE("bugs: " name, "[.bugs]")

TEST("SRV-1608") {
    EstablishedServerParser p(true);
    REQUIRE(p.is_deflate_active());
    string sample = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    size_t cnt = 500000;
    std::vector<string_view> v = {"bla-bladddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd"};
    v.reserve(cnt+1);
    for (size_t i = 0; i < cnt; ++i) v.push_back(sample);
    auto bin = p.start_message(DeflateFlag::YES).send(v.begin(), v.end(), IsFinal::YES);
    CHECK(bin.length());
    SUCCEED("no crash occur");
}
