#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patching types in uuid_time.c.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
diff -aurN usrcP/uuid/uuid_time.c usrcP.targ/uuid/uuid_time.c
--- usrcP/uuid/uuid_time.c	2023-12-02 17:58:13.895133000 +0200
+++ usrcP.targ/uuid/uuid_time.c	2023-12-02 15:29:46.632099000 +0200
@@ -53,15 +53,15 @@
 {
 	struct timeval		tv;
 	struct uuid		uuid;
-	uint32_t		high;
-	uint64_t		clock_reg;
+	myuint32_t		high;
+	myuint64_t		clock_reg;
 
 	uuid_unpack(uu, &uuid);
 
 	high = uuid.time_mid | ((uuid.time_hi_and_version & 0xFFF) << 16);
-	clock_reg = uuid.time_low | ((uint64_t) high << 32);
+	clock_reg = uuid.time_low | ((myuint64_t) high << 32);
 
-	clock_reg -= (((uint64_t) 0x01B21DD2) << 32) + 0x13814000;
+	clock_reg -= (((myuint64_t) 0x01B21DD2) << 32) + 0x13814000;
 	tv.tv_sec = clock_reg / 10000000;
 	tv.tv_usec = (clock_reg % 10000000) / 10;
 
