/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class Splitter {
    protected PDDocument pdfDocument;
    protected PDDocument currentDocument = null;
    private int splitAtPage = 1;
    private List newDocuments = null;
    protected int pageNumber = 0;

    public List split(PDDocument document) throws IOException {
        this.newDocuments = new ArrayList();
        this.pdfDocument = document;
        List pages = this.pdfDocument.getDocumentCatalog().getAllPages();
        this.processPages(pages);
        return this.newDocuments;
    }

    public void setSplitAtPage(int split) {
        if (split <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.splitAtPage = split;
    }

    public int getSplitAtPage() {
        return this.splitAtPage;
    }

    protected void processPages(List pages) throws IOException {
        for (PDPage page : pages) {
            this.processNextPage(page);
        }
    }

    protected void createNewDocumentIfNecessary() throws IOException {
        if (this.isNewDocNecessary()) {
            this.createNewDocument();
        }
    }

    protected boolean isNewDocNecessary() {
        return this.pageNumber % this.splitAtPage == 0 || this.currentDocument == null;
    }

    protected void createNewDocument() throws IOException {
        this.currentDocument = new PDDocument();
        this.currentDocument.setDocumentInformation(this.pdfDocument.getDocumentInformation());
        this.currentDocument.getDocumentCatalog().setViewerPreferences(this.pdfDocument.getDocumentCatalog().getViewerPreferences());
        this.newDocuments.add(this.currentDocument);
    }

    protected void processNextPage(PDPage page) throws IOException {
        this.createNewDocumentIfNecessary();
        PDPage imported = this.currentDocument.importPage(page);
        imported.setCropBox(page.findCropBox());
        imported.setMediaBox(page.findMediaBox());
        imported.setResources(page.findResources());
        imported.setRotation(page.findRotation());
        ++this.pageNumber;
    }
}

