/* KOTB.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

static __inline struct kotb* allocNKOTB(void) {
  extern int oflag;
  extern char str16[], format5[];
  extern struct kotb *nkotbstart, *nkotbend;
  extern u_int nkotbcount;
  struct kotb *p;

  /* allocate a chunk o' memory */
  p = malloc(sizeof(struct kotb));
  /* check that we really got some */
  if(p == NULL) {
    if(oflag)
      printf(format5, str16);
    else
      syslog(LOGTYPE, str16);
    CleanExit(0);
  }
  /* set the "next" pointer to null */
  p->next = NULL;
  /* if this is the first on the list... */
  if(nkotbstart == NULL) {
    /* set the list start ptr to this block */
    nkotbstart = p;
    /* set the end ptr to this block too... */
    nkotbend = p;
    /* no previous block */
    p->prev = NULL;
  } else {
    /* if it isn't the first one... set prev */
    /* to the last one on the list */
    p->prev = nkotbend;
    /* and plug this in as the last one */
    nkotbend = p;
  }
  /* bump our count */
  nkotbcount++;
  return p;
}

static __inline void killNKOTB(struct kotb *t) {
  extern struct kotb *nkotbstart, *nkotbend;
  extern u_int nkotbcount;

  nkotbcount--;
  /* if we have a prev pointer */
  if(t->prev != NULL)
    /* snap our prev's next to our next */
    t->prev->next = t->next;
  else
    nkotbstart = t->next;
  /* if we have a next pointer */
  if(t->next != NULL)
    /* snap our next's prev to our prev */
    t->next->prev = t->prev;
  else
    nkotbend = t->prev;
  MYFREE(t);
}


