#include <kwm.h>

namespace KWM {
    enum { noDecoration, normalDecoration, tinyDecoration,
           noFocus, standaloneMenuBar, desktopIcon, staysOnTop };
    enum { horizontal, vertical, fullscreen };

    static void activate(Window);
    static void activateInternal(Window);
    static Window activeWindow();
    static void close(Window);
    static void configureWm();
    static bool containsUnsavedData(Window);
    static int currentDesktop();
    static void darkenScreen();
    static int desktop(Window);
    static void doMaximize(Window, bool);
    static void doMaximize(Window, bool, int);
    static int doMaximizeMode(Window);
    static void doNotManage(const QString &);
    static void enableSessionManagement(Window);
    static bool fixedSize(Window);
    static QRect geometry(Window, bool = FALSE);
    static QRect geometryRestore(Window);
    static QString getCloseString();
    static long getDecoration(Window);
    static QString getDesktopName(int);
    static QString getIconifyString();
    static QString getMaximizeString();
    static QString getMoveString();
    static QString getOntoCurrentDesktopString();
    static QString getProperties(Window);
    static QString getResizeString();
    static QString getStickyString();
    static QString getToDesktopString();
    static QString getUnIconifyString();
    static QString getUnMaximizeString();
    static QString getUnStickyString();
    static QRect getWindowRegion(int);
    static int getWindowState(Window);
    static QPixmap icon(Window, int = 0, int = 0);
    static QRect iconGeometry(Window);
    static bool isActive(Window);
    static bool isDockWindow(Window);
    static bool isDoMaximize(Window);
    static bool isIconified(Window);
    static bool isMaximized(Window);
    static bool isKWMDockModule(Window);
    static bool isKWMInitialized();
    static bool isKWMModule(Window);
    static bool isSticky(Window);
    static void logout();
    static void lower(Window);
    static int maximizeMode(Window);
    static QPixmap miniIcon(Window, int = 0, int = 0);
    static void move(Window, const QPoint &);
    static void moveToDesktop(Window, int);
    static int numberOfDesktops();
    static void prepareForSwallowing(Window);
    static void raise(Window);
    static void raiseSoundEvent(const QString &);
    static void refreshScreen();
    static void registerSoundEvent(const QString &);
    static void sendKWMCommand(const QString &);
    static void setDecoration(Window, long);
    static void setDesktopName(int, const QString &);
    static void setDockWindow(Window);
    static void setGeometry(Window, const QRect &);
    static void setGeometryRestore(Window, const QRect &);
    static void setIcon(Window, const QPixmap &);
    static void setIconGeometry(Window, const QRect &);
    static void setIconify(Window, bool);
    static void setKWMDockModule(Window);
    static void setKWMModule(Window);
    static void setMaximize(Window, bool);
    static void setMaximize(Window, bool, int);
    static void setMiniIcon(Window, const QPixmap &);
    static void setNumberOfDesktops(int);
    static QRect setProperties(Window, const QString &);
    static void setSticky(Window, bool);
    static void setUnsavedDataHint(Window, bool);
    static void setWindowRegion(int, const QRect &);
    static void setWmCommand(Window, const QString &);
    static void switchToDesktop(int);
    static QString title(Window);
    static QString titleWithState(Window);
    static void unregisterSoundEvent(const QString &);
    static bool unsavedDataHintDefined(Window);
} KDE::WM;
