#!/usr/bin/perl

package eBay::API::XML::DataType::ItemPolicyViolationType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemPolicyViolationType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemPolicyViolationType

=head1 DESCRIPTION

Specifies the details of policy violations if the item was administratively canceled.
The details are the policy ID and the policy text.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemPolicyViolationType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'PolicyID', 'xs:long', '', '', '' ]
	, [ 'PolicyText', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPolicyID()

Policy ID of the violated policy which resulted in item being administratively canceled.

#    Argument: 'xs:long'

=cut

sub setPolicyID {
  my $self = shift;
  $self->{'PolicyID'} = shift
}

=head2 getPolicyID()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:long'

=cut

sub getPolicyID {
  my $self = shift;
  return $self->{'PolicyID'};
}


=head2 setPolicyText()

Brief information of the violated policy which resulted in item being administratively canceled.

#    Argument: 'xs:string'

=cut

sub setPolicyText {
  my $self = shift;
  $self->{'PolicyText'} = shift
}

=head2 getPolicyText()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPolicyText {
  my $self = shift;
  return $self->{'PolicyText'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
