#!/usr/bin/perl

package eBay::API::XML::Call::GetPictureManagerDetails;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPictureManagerDetails.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPictureManagerDetails

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPictureManagerDetails inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsRequestType;
use eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetPictureManagerDetails';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsResponseType';
}

#
# input properties
#

=head2 setFolderID()

The ID of a folder in the user's Picture Manager album for which you want information.
If you specify both FolderID and PictureURL, the picture must exist
in the folder.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setFolderID {
   my $self   = shift;
   my $sFolderID = shift;
   $self->getRequestDataType()->setFolderID($sFolderID);
}

=head2 setPictureManagerDetailLevel()

The type of information you want returned, about pictures and folders,
the account subscription, or both. Use this element rather than the generic DetailLevel element defined in AbstractRequestType. You can use the following values: ReturnAll, ReturnSubscription, or ReturnPicture.

PresentDetails: Yes

  RequiredInput: No
#    Argument: 'ns:PictureManagerDetailLevelCodeType'

=cut
       
sub setPictureManagerDetailLevel {
   my $self   = shift;
   my $sPictureManagerDetailLevel = shift;
   $self->getRequestDataType()->setPictureManagerDetailLevel($sPictureManagerDetailLevel);
}

=head2 setPictureURL()

The URL of a picture in the user's Picture Manager album.
If you specify both FolderID and PictureURL, the picture must
exist in the folder.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setPictureURL {
   my $self   = shift;
   my $sPictureURL = shift;
   $self->getRequestDataType()->setPictureURL($sPictureURL);
}



#
# output properties
#

=head2 getPictureManagerDetails()

Contains details of the account settings, folders or
pictures in the user's album, or both.

  Returned: Always
  Details: PictureManagerDetailLevel: none, ReturnSubscription, ReturnPicture, ReturnAll
#    Returns: 'ns:PictureManagerDetailsType'

=cut
       
sub getPictureManagerDetails {
   my $self = shift;
   return $self->getResponseDataType()->getPictureManagerDetails();
}





1;   
